/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.text.SimpleDateFormat;
import org.jrobin.graph.TimeAxisUnit;
import org.jrobin.graph.TimeMarker;

class TimeGrid {
    private long startTime;
    private long endTime;
    private TimeAxisUnit tAxis;

    TimeGrid(long l, long l2, TimeAxisUnit timeAxisUnit, int n) {
        this.startTime = l;
        this.endTime = l2;
        this.tAxis = timeAxisUnit;
        this.setTimeAxis(n);
    }

    long getStartTime() {
        return this.startTime;
    }

    long getEndTime() {
        return this.endTime;
    }

    TimeMarker[] getTimeMarkers() {
        return this.tAxis.getTimeMarkers(this.startTime, this.endTime);
    }

    long getMajorGridWidth() {
        return this.tAxis.getMajorGridWidth();
    }

    boolean centerLabels() {
        return this.tAxis.getCenterLabels();
    }

    private void setTimeAxis(int n) {
        if (this.tAxis != null) {
            return;
        }
        double d = (double)(this.endTime - this.startTime) / 86400.0;
        this.tAxis = d <= 0.03125 ? new TimeAxisUnit(1, 1, 1, 5, new SimpleDateFormat("HH:mm"), false, n) : (d <= 0.08333333333333333 ? new TimeAxisUnit(1, 5, 1, 10, new SimpleDateFormat("HH:mm"), false, n) : (d <= 0.125 ? new TimeAxisUnit(1, 5, 1, 20, new SimpleDateFormat("HH:mm"), false, n) : (d <= 0.20833333333333334 ? new TimeAxisUnit(1, 10, 1, 30, new SimpleDateFormat("HH:mm"), false, n) : (d <= 0.4166666666666667 ? new TimeAxisUnit(1, 15, 2, 1, new SimpleDateFormat("HH:mm"), false, n) : (d <= 0.625 ? new TimeAxisUnit(1, 30, 2, 2, new SimpleDateFormat("HH:mm"), false, n) : (d <= 0.8333333333333334 ? new TimeAxisUnit(2, 1, 2, 1, new SimpleDateFormat("HH"), true, n) : (d <= 1.5 ? new TimeAxisUnit(2, 1, 2, 4, new SimpleDateFormat("HH:mm"), false, n) : (d <= 2.0 ? new TimeAxisUnit(2, 2, 2, 6, new SimpleDateFormat("HH:mm"), false, n) : (d <= 3.0 ? new TimeAxisUnit(2, 3, 2, 12, new SimpleDateFormat("HH:mm"), false, n) : (d < 8.0 ? new TimeAxisUnit(2, 6, 3, 1, new SimpleDateFormat("EEE dd"), true, n) : (d <= 14.0 ? new TimeAxisUnit(2, 12, 3, 1, new SimpleDateFormat("dd"), true, n) : (d <= 43.0 ? new TimeAxisUnit(3, 1, 4, 1, new SimpleDateFormat("'week' ww"), true, n) : (d <= 157.0 ? new TimeAxisUnit(4, 1, 4, 1, new SimpleDateFormat("ww"), true, n) : new TimeAxisUnit(5, 1, 5, 1, new SimpleDateFormat("MMM"), true, n))))))))))))));
    }
}

