/*
 * Decompiled with CFR 0.152.
 */
package snmp;

import java.io.ByteArrayOutputStream;
import snmp.SNMPBadValueException;
import snmp.SNMPBitString;
import snmp.SNMPCounter32;
import snmp.SNMPCounter64;
import snmp.SNMPGauge32;
import snmp.SNMPIPAddress;
import snmp.SNMPInteger;
import snmp.SNMPNSAPAddress;
import snmp.SNMPNull;
import snmp.SNMPObject;
import snmp.SNMPObjectIdentifier;
import snmp.SNMPOctetString;
import snmp.SNMPPDU;
import snmp.SNMPSequence;
import snmp.SNMPTLV;
import snmp.SNMPTimeTicks;
import snmp.SNMPTrapPDU;
import snmp.SNMPUInteger32;
import snmp.SNMPUnknownObject;

public class SNMPBERCodec {
    public static final byte SNMPINTEGER = 2;
    public static final byte SNMPBITSTRING = 3;
    public static final byte SNMPOCTETSTRING = 4;
    public static final byte SNMPNULL = 5;
    public static final byte SNMPOBJECTIDENTIFIER = 6;
    public static final byte SNMPSEQUENCE = 48;
    public static final byte SNMPIPADDRESS = 64;
    public static final byte SNMPCOUNTER32 = 65;
    public static final byte SNMPGAUGE32 = 66;
    public static final byte SNMPTIMETICKS = 67;
    public static final byte SNMPOPAQUE = 68;
    public static final byte SNMPNSAPADDRESS = 69;
    public static final byte SNMPCOUNTER64 = 70;
    public static final byte SNMPUINTEGER32 = 71;
    public static final byte SNMPGETREQUEST = -96;
    public static final byte SNMPGETNEXTREQUEST = -95;
    public static final byte SNMPGETRESPONSE = -94;
    public static final byte SNMPSETREQUEST = -93;
    public static final byte SNMPTRAP = -92;
    public static final byte SNMPv2pCOMMUNICATION = -94;
    public static final byte SNMPv2pAUTHORIZEDMESSAGE = -95;
    public static final byte SNMPv2pENCRYPTEDMESSAGE = -95;
    public static final byte SNMPv2TRAP = -89;
    public static final byte SNMPv2pENCRYPTEDDATA = -95;
    public static final byte SNMPUNKNOWNOBJECT = 0;

    public static SNMPObject extractEncoding(SNMPTLV sNMPTLV) throws SNMPBadValueException {
        switch (sNMPTLV.tag) {
            case 2: {
                return new SNMPInteger(sNMPTLV.value);
            }
            case 48: {
                return new SNMPSequence(sNMPTLV.value);
            }
            case 6: {
                return new SNMPObjectIdentifier(sNMPTLV.value);
            }
            case 4: {
                return new SNMPOctetString(sNMPTLV.value);
            }
            case 3: {
                return new SNMPBitString(sNMPTLV.value);
            }
            case 64: {
                return new SNMPIPAddress(sNMPTLV.value);
            }
            case 65: {
                return new SNMPCounter32(sNMPTLV.value);
            }
            case 66: {
                return new SNMPGauge32(sNMPTLV.value);
            }
            case 67: {
                return new SNMPTimeTicks(sNMPTLV.value);
            }
            case 69: {
                return new SNMPNSAPAddress(sNMPTLV.value);
            }
            case 70: {
                return new SNMPCounter64(sNMPTLV.value);
            }
            case 71: {
                return new SNMPUInteger32(sNMPTLV.value);
            }
            case -96: 
            case -95: 
            case -94: 
            case -93: {
                return new SNMPPDU(sNMPTLV.value, sNMPTLV.tag);
            }
            case -92: {
                return new SNMPTrapPDU(sNMPTLV.value);
            }
            case 5: 
            case 68: {
                return new SNMPNull();
            }
        }
        System.out.println("Unrecognized tag");
        return new SNMPUnknownObject(sNMPTLV.value);
    }

    public static SNMPTLV extractNextTLV(byte[] byArray, int n) {
        int n2;
        int n3;
        SNMPTLV sNMPTLV = new SNMPTLV();
        int n4 = n;
        sNMPTLV.tag = byArray[n4];
        if ((n3 = byArray[++n4]) < 0) {
            n3 += 256;
        }
        if (n3 / 128 < 1) {
            n2 = n3;
        } else {
            int n5 = n3 % 128;
            n2 = 0;
            for (int i = 0; i < n5; ++i) {
                if ((n3 = byArray[++n4]) < 0) {
                    n3 += 256;
                }
                n2 = n2 * 256 + n3;
            }
        }
        sNMPTLV.totalLength = ++n4 - n + n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(byArray, n4, n2);
        sNMPTLV.value = byteArrayOutputStream.toByteArray();
        return sNMPTLV;
    }

    public static byte[] encodeLength(int n) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (n < 128) {
            byte[] byArray = new byte[]{(byte)n};
            byteArrayOutputStream.write(byArray, 0, 1);
        } else {
            int n2 = 0;
            int n3 = n;
            while (n3 > 0) {
                ++n2;
                n3 = (int)Math.floor(n3 / 256);
            }
            byte by = (byte)n2;
            by = (byte)(by + 128);
            byteArrayOutputStream.write(by);
            byte[] byArray = new byte[n2];
            for (int i = n2 - 1; i >= 0; --i) {
                byArray[i] = (byte)(n % 256);
                n = (int)Math.floor(n / 256);
            }
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

