/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.vlma.retriever;

import java.net.SocketException;
import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;
import org.videolan.vlma.model.Server;
import org.videolan.vlma.retriever.Data;
import org.videolan.vlma.retriever.DataRetriever;
import snmp.SNMPSequence;
import snmp.SNMPVarBindList;
import snmp.SNMPv1CommunicationInterface;

public class SnmpDataRetriever
implements DataRetriever {
    private static final Logger logger = Logger.getLogger(SnmpDataRetriever.class);
    private Configuration configuration;

    public String retrieve(Server server, Data data) {
        SNMPv1CommunicationInterface comm;
        try {
            comm = new SNMPv1CommunicationInterface(0, server.getIp(), this.configuration.getString("vlc.snmp.community"));
        }
        catch (SocketException e) {
            logger.error((Object)("Cannot contact SNMP server of " + server));
            return null;
        }
        String[] oid = new String[]{this.configuration.getString("vlc.snmp.oid." + data.name().toLowerCase())};
        try {
            SNMPVarBindList varList = comm.getMIBEntry(oid);
            SNMPSequence pair = (SNMPSequence)varList.getSNMPObjectAt(0);
            return pair.getSNMPObjectAt(1).toString().trim();
        }
        catch (Exception e) {
            logger.error((Object)("Cannot retrieve data. OID: " + oid[0] + ", server: " + server.getName()), (Throwable)e);
            return null;
        }
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }
}

