/*
 * Decompiled with CFR 0.152.
 */
package snmp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import snmp.SNMPBERCodec;
import snmp.SNMPBadValueException;
import snmp.SNMPGetException;
import snmp.SNMPInteger;
import snmp.SNMPMessage;
import snmp.SNMPObject;
import snmp.SNMPObjectIdentifier;
import snmp.SNMPPDU;
import snmp.SNMPSequence;
import snmp.SNMPSetException;
import snmp.SNMPVarBindList;
import snmp.SNMPVariablePair;

public class SNMPv1CommunicationInterface {
    public static final int DEFAULT_SNMPPORT = 161;
    public static final int MAXSIZE = 512;
    private int version;
    private InetAddress hostAddress;
    private String community;
    private int snmpPort;
    DatagramSocket dSocket;
    public int requestID = 1;

    public SNMPv1CommunicationInterface(int n, InetAddress inetAddress, String string) throws SocketException {
        this.version = n;
        this.hostAddress = inetAddress;
        this.community = string;
        this.snmpPort = 161;
        this.dSocket = new DatagramSocket();
        this.dSocket.setSoTimeout(15000);
    }

    public SNMPv1CommunicationInterface(int n, InetAddress inetAddress, String string, int n2) throws SocketException {
        this.version = n;
        this.hostAddress = inetAddress;
        this.community = string;
        this.snmpPort = n2;
        this.dSocket = new DatagramSocket();
        this.dSocket.setSoTimeout(15000);
    }

    public void setSocketTimeout(int n) throws SocketException {
        this.dSocket.setSoTimeout(n);
    }

    public void closeConnection() throws SocketException {
        this.dSocket.close();
    }

    public SNMPVarBindList retrieveAllMIBInfo(String string) throws IOException, SNMPBadValueException {
        SNMPVarBindList sNMPVarBindList = new SNMPVarBindList();
        int n = 0;
        int n2 = 0;
        SNMPObjectIdentifier sNMPObjectIdentifier = new SNMPObjectIdentifier(string);
        SNMPVariablePair sNMPVariablePair = new SNMPVariablePair(sNMPObjectIdentifier, new SNMPInteger(0L));
        SNMPSequence sNMPSequence = new SNMPSequence();
        sNMPSequence.addSNMPObject(sNMPVariablePair);
        SNMPPDU sNMPPDU = new SNMPPDU(-95, this.requestID, n, n2, sNMPSequence);
        SNMPMessage sNMPMessage = new SNMPMessage(this.version, this.community, sNMPPDU);
        byte[] byArray = sNMPMessage.getBEREncoding();
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, this.hostAddress, this.snmpPort);
        this.dSocket.send(datagramPacket);
        while (n == 0) {
            DatagramPacket datagramPacket2 = new DatagramPacket(new byte[512], 512);
            this.dSocket.receive(datagramPacket2);
            byte[] byArray2 = datagramPacket2.getData();
            SNMPMessage sNMPMessage2 = new SNMPMessage(SNMPBERCodec.extractNextTLV((byte[])byArray2, (int)0).value);
            sNMPSequence = sNMPMessage2.getPDU().getVarBindList();
            SNMPSequence sNMPSequence2 = (SNMPSequence)sNMPSequence.getSNMPObjectAt(0);
            SNMPObjectIdentifier sNMPObjectIdentifier2 = (SNMPObjectIdentifier)sNMPSequence2.getSNMPObjectAt(0);
            SNMPObject sNMPObject = sNMPSequence2.getSNMPObjectAt(1);
            sNMPVarBindList.addSNMPObject(sNMPSequence2);
            if (sNMPObjectIdentifier.equals(sNMPObjectIdentifier2)) break;
            sNMPObjectIdentifier = sNMPObjectIdentifier2;
            ++this.requestID;
            sNMPPDU = new SNMPPDU(-95, this.requestID, n, n2, sNMPSequence);
            sNMPMessage = new SNMPMessage(this.version, this.community, sNMPPDU);
            byArray = sNMPMessage.getBEREncoding();
            datagramPacket = new DatagramPacket(byArray, byArray.length, this.hostAddress, this.snmpPort);
            this.dSocket.send(datagramPacket);
        }
        return sNMPVarBindList;
    }

    private String hexByte(byte n) {
        int n2 = n;
        if (n2 < 0) {
            n2 += 256;
        }
        String string = new String();
        string = string + Integer.toHexString(n2 / 16);
        string = string + Integer.toHexString(n2 % 16);
        return string;
    }

    public SNMPVarBindList getMIBEntry(String string) throws IOException, SNMPBadValueException, SNMPGetException {
        SNMPSequence sNMPSequence;
        SNMPVarBindList sNMPVarBindList = new SNMPVarBindList();
        int n = 0;
        int n2 = 0;
        SNMPObjectIdentifier sNMPObjectIdentifier = new SNMPObjectIdentifier(string);
        SNMPVariablePair sNMPVariablePair = new SNMPVariablePair(sNMPObjectIdentifier, new SNMPInteger(0L));
        SNMPSequence sNMPSequence2 = new SNMPSequence();
        sNMPSequence2.addSNMPObject(sNMPVariablePair);
        SNMPPDU sNMPPDU = new SNMPPDU(-96, this.requestID, n, n2, sNMPSequence2);
        SNMPMessage sNMPMessage = new SNMPMessage(this.version, this.community, sNMPPDU);
        byte[] byArray = sNMPMessage.getBEREncoding();
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, this.hostAddress, this.snmpPort);
        this.dSocket.send(datagramPacket);
        while (true) {
            DatagramPacket datagramPacket2 = new DatagramPacket(new byte[512], 512);
            this.dSocket.receive(datagramPacket2);
            byte[] byArray2 = datagramPacket2.getData();
            SNMPMessage sNMPMessage2 = new SNMPMessage(SNMPBERCodec.extractNextTLV((byte[])byArray2, (int)0).value);
            SNMPPDU sNMPPDU2 = sNMPMessage2.getPDU();
            if (sNMPPDU2.getRequestID() != this.requestID) continue;
            if (sNMPPDU2.getErrorStatus() != 0) {
                throw new SNMPGetException("OID " + string + " not available for retrieval", sNMPPDU2.getErrorIndex(), sNMPPDU2.getErrorStatus());
            }
            sNMPSequence2 = sNMPPDU2.getVarBindList();
            sNMPSequence = (SNMPSequence)sNMPSequence2.getSNMPObjectAt(0);
            SNMPObjectIdentifier sNMPObjectIdentifier2 = (SNMPObjectIdentifier)sNMPSequence.getSNMPObjectAt(0);
            SNMPObject sNMPObject = sNMPSequence.getSNMPObjectAt(1);
            if (sNMPObjectIdentifier2.toString().equals(string)) break;
        }
        sNMPVarBindList.addSNMPObject(sNMPSequence);
        ++this.requestID;
        return sNMPVarBindList;
    }

    public SNMPVarBindList getMIBEntry(String[] stringArray) throws IOException, SNMPBadValueException, SNMPGetException {
        byte[] byArray;
        SNMPMessage sNMPMessage;
        SNMPPDU sNMPPDU;
        Object object;
        SNMPObject sNMPObject;
        SNMPVarBindList sNMPVarBindList = new SNMPVarBindList();
        SNMPSequence sNMPSequence = new SNMPSequence();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            sNMPObject = new SNMPObjectIdentifier(stringArray[i]);
            object = new SNMPVariablePair((SNMPObjectIdentifier)sNMPObject, new SNMPInteger(0L));
            sNMPSequence.addSNMPObject((SNMPObject)object);
        }
        SNMPPDU sNMPPDU2 = new SNMPPDU(-96, this.requestID, n, n2, sNMPSequence);
        sNMPObject = new SNMPMessage(this.version, this.community, sNMPPDU2);
        object = ((SNMPSequence)sNMPObject).getBEREncoding();
        DatagramPacket datagramPacket = new DatagramPacket((byte[])object, ((Object)object).length, this.hostAddress, this.snmpPort);
        this.dSocket.send(datagramPacket);
        do {
            DatagramPacket datagramPacket2 = new DatagramPacket(new byte[512], 512);
            this.dSocket.receive(datagramPacket2);
            byArray = datagramPacket2.getData();
        } while ((sNMPPDU = (sNMPMessage = new SNMPMessage(SNMPBERCodec.extractNextTLV((byte[])byArray, (int)0).value)).getPDU()).getRequestID() != this.requestID);
        if (sNMPPDU.getErrorStatus() != 0) {
            n2 = sNMPPDU.getErrorIndex();
            throw new SNMPGetException("OID " + stringArray[n2 - 1] + " not available for retrieval", n2, sNMPPDU.getErrorStatus());
        }
        sNMPSequence = sNMPPDU.getVarBindList();
        for (int i = 0; i < sNMPSequence.size(); ++i) {
            SNMPSequence sNMPSequence2 = (SNMPSequence)sNMPSequence.getSNMPObjectAt(i);
            SNMPObjectIdentifier sNMPObjectIdentifier = (SNMPObjectIdentifier)sNMPSequence2.getSNMPObjectAt(0);
            SNMPObject sNMPObject2 = sNMPSequence2.getSNMPObjectAt(1);
            if (!sNMPObjectIdentifier.toString().equals(stringArray[i])) {
                throw new SNMPGetException("OID " + stringArray[i] + " expected at index " + i + ", OID " + sNMPObjectIdentifier + " received", i + 1, 5);
            }
            sNMPVarBindList.addSNMPObject(sNMPSequence2);
        }
        ++this.requestID;
        return sNMPVarBindList;
    }

    public SNMPVarBindList getNextMIBEntry(String string) throws IOException, SNMPBadValueException, SNMPGetException {
        byte[] byArray;
        SNMPMessage sNMPMessage;
        SNMPPDU sNMPPDU;
        SNMPVarBindList sNMPVarBindList = new SNMPVarBindList();
        int n = 0;
        int n2 = 0;
        SNMPObjectIdentifier sNMPObjectIdentifier = new SNMPObjectIdentifier(string);
        SNMPVariablePair sNMPVariablePair = new SNMPVariablePair(sNMPObjectIdentifier, new SNMPInteger(0L));
        SNMPSequence sNMPSequence = new SNMPSequence();
        sNMPSequence.addSNMPObject(sNMPVariablePair);
        SNMPPDU sNMPPDU2 = new SNMPPDU(-95, this.requestID, n, n2, sNMPSequence);
        SNMPMessage sNMPMessage2 = new SNMPMessage(this.version, this.community, sNMPPDU2);
        byte[] byArray2 = sNMPMessage2.getBEREncoding();
        DatagramPacket datagramPacket = new DatagramPacket(byArray2, byArray2.length, this.hostAddress, this.snmpPort);
        this.dSocket.send(datagramPacket);
        do {
            DatagramPacket datagramPacket2 = new DatagramPacket(new byte[512], 512);
            this.dSocket.receive(datagramPacket2);
            byArray = datagramPacket2.getData();
        } while ((sNMPPDU = (sNMPMessage = new SNMPMessage(SNMPBERCodec.extractNextTLV((byte[])byArray, (int)0).value)).getPDU()).getRequestID() != this.requestID);
        if (sNMPPDU.getErrorStatus() != 0) {
            throw new SNMPGetException("OID " + string + " not available for retrieval", sNMPPDU.getErrorIndex(), sNMPPDU.getErrorStatus());
        }
        sNMPSequence = sNMPPDU.getVarBindList();
        SNMPSequence sNMPSequence2 = (SNMPSequence)sNMPSequence.getSNMPObjectAt(0);
        SNMPObjectIdentifier sNMPObjectIdentifier2 = (SNMPObjectIdentifier)sNMPSequence2.getSNMPObjectAt(0);
        SNMPObject sNMPObject = sNMPSequence2.getSNMPObjectAt(1);
        sNMPVarBindList.addSNMPObject(sNMPSequence2);
        ++this.requestID;
        return sNMPVarBindList;
    }

    public SNMPVarBindList getNextMIBEntry(String[] stringArray) throws IOException, SNMPBadValueException, SNMPGetException {
        byte[] byArray;
        SNMPMessage sNMPMessage;
        SNMPPDU sNMPPDU;
        Object object;
        SNMPObject sNMPObject;
        SNMPVarBindList sNMPVarBindList = new SNMPVarBindList();
        SNMPSequence sNMPSequence = new SNMPSequence();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            sNMPObject = new SNMPObjectIdentifier(stringArray[i]);
            object = new SNMPVariablePair((SNMPObjectIdentifier)sNMPObject, new SNMPInteger(0L));
            sNMPSequence.addSNMPObject((SNMPObject)object);
        }
        SNMPPDU sNMPPDU2 = new SNMPPDU(-95, this.requestID, n, n2, sNMPSequence);
        sNMPObject = new SNMPMessage(this.version, this.community, sNMPPDU2);
        object = ((SNMPSequence)sNMPObject).getBEREncoding();
        DatagramPacket datagramPacket = new DatagramPacket((byte[])object, ((Object)object).length, this.hostAddress, this.snmpPort);
        this.dSocket.send(datagramPacket);
        do {
            DatagramPacket datagramPacket2 = new DatagramPacket(new byte[512], 512);
            this.dSocket.receive(datagramPacket2);
            byArray = datagramPacket2.getData();
        } while ((sNMPPDU = (sNMPMessage = new SNMPMessage(SNMPBERCodec.extractNextTLV((byte[])byArray, (int)0).value)).getPDU()).getRequestID() != this.requestID);
        if (sNMPPDU.getErrorStatus() != 0) {
            n2 = sNMPPDU.getErrorIndex();
            throw new SNMPGetException("OID following " + stringArray[n2 - 1] + " not available for retrieval", n2, sNMPPDU.getErrorStatus());
        }
        sNMPSequence = sNMPPDU.getVarBindList();
        for (int i = 0; i < sNMPSequence.size(); ++i) {
            SNMPSequence sNMPSequence2 = (SNMPSequence)sNMPSequence.getSNMPObjectAt(i);
            SNMPObjectIdentifier sNMPObjectIdentifier = (SNMPObjectIdentifier)sNMPSequence2.getSNMPObjectAt(0);
            SNMPObject sNMPObject2 = sNMPSequence2.getSNMPObjectAt(1);
            sNMPVarBindList.addSNMPObject(sNMPSequence2);
        }
        ++this.requestID;
        return sNMPVarBindList;
    }

    public SNMPVarBindList setMIBEntry(String string, SNMPObject sNMPObject) throws IOException, SNMPBadValueException, SNMPSetException {
        SNMPSequence sNMPSequence;
        SNMPVarBindList sNMPVarBindList = new SNMPVarBindList();
        int n = 0;
        int n2 = 0;
        SNMPObjectIdentifier sNMPObjectIdentifier = new SNMPObjectIdentifier(string);
        SNMPVariablePair sNMPVariablePair = new SNMPVariablePair(sNMPObjectIdentifier, sNMPObject);
        SNMPSequence sNMPSequence2 = new SNMPSequence();
        sNMPSequence2.addSNMPObject(sNMPVariablePair);
        SNMPPDU sNMPPDU = new SNMPPDU(-93, this.requestID, n, n2, sNMPSequence2);
        SNMPMessage sNMPMessage = new SNMPMessage(this.version, this.community, sNMPPDU);
        byte[] byArray = sNMPMessage.getBEREncoding();
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, this.hostAddress, this.snmpPort);
        this.dSocket.send(datagramPacket);
        while (true) {
            DatagramPacket datagramPacket2 = new DatagramPacket(new byte[512], 512);
            this.dSocket.receive(datagramPacket2);
            byte[] byArray2 = datagramPacket2.getData();
            SNMPMessage sNMPMessage2 = new SNMPMessage(SNMPBERCodec.extractNextTLV((byte[])byArray2, (int)0).value);
            SNMPPDU sNMPPDU2 = sNMPMessage2.getPDU();
            if (sNMPPDU2.getRequestID() != this.requestID) continue;
            if (sNMPPDU2.getErrorStatus() != 0) {
                switch (sNMPPDU2.getErrorStatus()) {
                    case 1: {
                        throw new SNMPSetException("Value supplied for OID " + string + " too big.", sNMPPDU2.getErrorIndex(), sNMPPDU2.getErrorStatus());
                    }
                    case 2: {
                        throw new SNMPSetException("OID " + string + " not available for setting.", sNMPPDU2.getErrorIndex(), sNMPPDU2.getErrorStatus());
                    }
                    case 3: {
                        throw new SNMPSetException("Bad value supplied for OID " + string + ".", sNMPPDU2.getErrorIndex(), sNMPPDU2.getErrorStatus());
                    }
                    case 4: {
                        throw new SNMPSetException("OID " + string + " read-only.", sNMPPDU2.getErrorIndex(), sNMPPDU2.getErrorStatus());
                    }
                }
                throw new SNMPSetException("Error setting OID " + string + ".", sNMPPDU2.getErrorIndex(), sNMPPDU2.getErrorStatus());
            }
            sNMPSequence2 = sNMPPDU2.getVarBindList();
            sNMPSequence = (SNMPSequence)sNMPSequence2.getSNMPObjectAt(0);
            if (((SNMPObjectIdentifier)sNMPSequence.getSNMPObjectAt(0)).toString().equals(string)) break;
        }
        sNMPVarBindList.addSNMPObject(sNMPSequence);
        ++this.requestID;
        return sNMPVarBindList;
    }

    public SNMPVarBindList setMIBEntry(String[] stringArray, SNMPObject[] sNMPObjectArray) throws IOException, SNMPBadValueException, SNMPSetException {
        byte[] byArray;
        SNMPMessage sNMPMessage;
        SNMPPDU sNMPPDU;
        Object object;
        SNMPObject sNMPObject;
        if (stringArray.length != sNMPObjectArray.length) {
            throw new SNMPSetException("OID and value arrays must have same size", 0, 5);
        }
        SNMPVarBindList sNMPVarBindList = new SNMPVarBindList();
        SNMPSequence sNMPSequence = new SNMPSequence();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            sNMPObject = new SNMPObjectIdentifier(stringArray[i]);
            object = new SNMPVariablePair((SNMPObjectIdentifier)sNMPObject, sNMPObjectArray[i]);
            sNMPSequence.addSNMPObject((SNMPObject)object);
        }
        SNMPPDU sNMPPDU2 = new SNMPPDU(-93, this.requestID, n, n2, sNMPSequence);
        sNMPObject = new SNMPMessage(this.version, this.community, sNMPPDU2);
        object = ((SNMPSequence)sNMPObject).getBEREncoding();
        DatagramPacket datagramPacket = new DatagramPacket((byte[])object, ((Object)object).length, this.hostAddress, this.snmpPort);
        this.dSocket.send(datagramPacket);
        do {
            DatagramPacket datagramPacket2 = new DatagramPacket(new byte[512], 512);
            this.dSocket.receive(datagramPacket2);
            byArray = datagramPacket2.getData();
        } while ((sNMPPDU = (sNMPMessage = new SNMPMessage(SNMPBERCodec.extractNextTLV((byte[])byArray, (int)0).value)).getPDU()).getRequestID() != this.requestID);
        if (sNMPPDU.getErrorStatus() != 0) {
            n2 = sNMPPDU.getErrorIndex();
            switch (sNMPPDU.getErrorStatus()) {
                case 1: {
                    throw new SNMPSetException("Value supplied for OID " + stringArray[n2 - 1] + " too big.", sNMPPDU.getErrorIndex(), sNMPPDU.getErrorStatus());
                }
                case 2: {
                    throw new SNMPSetException("OID " + stringArray[n2 - 1] + " not available for setting.", sNMPPDU.getErrorIndex(), sNMPPDU.getErrorStatus());
                }
                case 3: {
                    throw new SNMPSetException("Bad value supplied for OID " + stringArray[n2 - 1] + ".", sNMPPDU.getErrorIndex(), sNMPPDU.getErrorStatus());
                }
                case 4: {
                    throw new SNMPSetException("OID " + stringArray[n2 - 1] + " read-only.", sNMPPDU.getErrorIndex(), sNMPPDU.getErrorStatus());
                }
            }
            throw new SNMPSetException("Error setting OID " + stringArray[n2 - 1] + ".", sNMPPDU.getErrorIndex(), sNMPPDU.getErrorStatus());
        }
        sNMPSequence = sNMPPDU.getVarBindList();
        for (int i = 0; i < sNMPSequence.size(); ++i) {
            SNMPSequence sNMPSequence2 = (SNMPSequence)sNMPSequence.getSNMPObjectAt(i);
            SNMPObjectIdentifier sNMPObjectIdentifier = (SNMPObjectIdentifier)sNMPSequence2.getSNMPObjectAt(0);
            if (!sNMPObjectIdentifier.toString().equals(stringArray[i])) {
                throw new SNMPSetException("OID " + stringArray[i] + " expected at index " + i + ", OID " + sNMPObjectIdentifier + " received", i + 1, 5);
            }
            sNMPVarBindList.addSNMPObject(sNMPSequence2);
        }
        ++this.requestID;
        return sNMPVarBindList;
    }

    public SNMPVarBindList retrieveMIBTable(String string) throws IOException, SNMPBadValueException, SNMPGetException {
        SNMPVarBindList sNMPVarBindList = new SNMPVarBindList();
        int n = 0;
        int n2 = 0;
        String string2 = string;
        SNMPObjectIdentifier sNMPObjectIdentifier = new SNMPObjectIdentifier(string2);
        while (n == 0) {
            SNMPVariablePair sNMPVariablePair = new SNMPVariablePair(sNMPObjectIdentifier, new SNMPInteger(0L));
            SNMPSequence sNMPSequence = new SNMPSequence();
            sNMPSequence.addSNMPObject(sNMPVariablePair);
            SNMPPDU sNMPPDU = new SNMPPDU(-95, this.requestID, n, n2, sNMPSequence);
            SNMPMessage sNMPMessage = new SNMPMessage(this.version, this.community, sNMPPDU);
            byte[] byArray = sNMPMessage.getBEREncoding();
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, this.hostAddress, this.snmpPort);
            this.dSocket.send(datagramPacket);
            DatagramPacket datagramPacket2 = new DatagramPacket(new byte[512], 512);
            this.dSocket.receive(datagramPacket2);
            byte[] byArray2 = datagramPacket2.getData();
            SNMPMessage sNMPMessage2 = new SNMPMessage(SNMPBERCodec.extractNextTLV((byte[])byArray2, (int)0).value);
            SNMPPDU sNMPPDU2 = sNMPMessage2.getPDU();
            if (sNMPPDU2.getRequestID() != this.requestID) continue;
            if (sNMPPDU2.getErrorStatus() != 0) break;
            sNMPSequence = sNMPPDU2.getVarBindList();
            SNMPSequence sNMPSequence2 = (SNMPSequence)sNMPSequence.getSNMPObjectAt(0);
            SNMPObjectIdentifier sNMPObjectIdentifier2 = (SNMPObjectIdentifier)sNMPSequence2.getSNMPObjectAt(0);
            SNMPObject sNMPObject = sNMPSequence2.getSNMPObjectAt(1);
            String string3 = sNMPObjectIdentifier2.toString();
            if (!string3.startsWith(string)) break;
            sNMPVarBindList.addSNMPObject(sNMPSequence2);
            sNMPObjectIdentifier = sNMPObjectIdentifier2;
            ++this.requestID;
        }
        return sNMPVarBindList;
    }

    public SNMPVarBindList retrieveMIBTable(String[] stringArray) throws IOException, SNMPBadValueException, SNMPGetException {
        SNMPVarBindList sNMPVarBindList = new SNMPVarBindList();
        int n = 0;
        int n2 = 0;
        SNMPObjectIdentifier[] sNMPObjectIdentifierArray = new SNMPObjectIdentifier[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            sNMPObjectIdentifierArray[i] = new SNMPObjectIdentifier(stringArray[i]);
        }
        block1: while (n == 0) {
            int n3;
            SNMPSequence sNMPSequence;
            SNMPSequence sNMPSequence2 = new SNMPSequence();
            for (int i = 0; i < sNMPObjectIdentifierArray.length; ++i) {
                sNMPSequence = new SNMPVariablePair(sNMPObjectIdentifierArray[i], new SNMPInteger(0L));
                sNMPSequence2.addSNMPObject(sNMPSequence);
            }
            SNMPPDU sNMPPDU = new SNMPPDU(-95, this.requestID, n, n2, sNMPSequence2);
            sNMPSequence = new SNMPMessage(this.version, this.community, sNMPPDU);
            byte[] byArray = sNMPSequence.getBEREncoding();
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, this.hostAddress, this.snmpPort);
            this.dSocket.send(datagramPacket);
            DatagramPacket datagramPacket2 = new DatagramPacket(new byte[512], 512);
            this.dSocket.receive(datagramPacket2);
            byte[] byArray2 = datagramPacket2.getData();
            SNMPMessage sNMPMessage = new SNMPMessage(SNMPBERCodec.extractNextTLV((byte[])byArray2, (int)0).value);
            SNMPPDU sNMPPDU2 = sNMPMessage.getPDU();
            if (sNMPPDU2.getRequestID() != this.requestID) continue;
            if (sNMPPDU2.getErrorStatus() != 0) {
                n3 = sNMPPDU2.getErrorIndex();
                if (n3 == 1) break;
                throw new SNMPGetException("OID following " + sNMPObjectIdentifierArray[n3 - 1] + " not available for retrieval", n3, sNMPPDU2.getErrorStatus());
            }
            sNMPSequence2 = sNMPPDU2.getVarBindList();
            if (sNMPSequence2.size() != sNMPObjectIdentifierArray.length) {
                throw new SNMPGetException("Incomplete row of table received", 0, 5);
            }
            for (n3 = 0; n3 < sNMPSequence2.size(); ++n3) {
                SNMPSequence sNMPSequence3 = (SNMPSequence)sNMPSequence2.getSNMPObjectAt(n3);
                SNMPObjectIdentifier sNMPObjectIdentifier = (SNMPObjectIdentifier)sNMPSequence3.getSNMPObjectAt(0);
                SNMPObject sNMPObject = sNMPSequence3.getSNMPObjectAt(1);
                String string = sNMPObjectIdentifier.toString();
                if (!string.startsWith(stringArray[n3])) {
                    if (n3 == 0) break block1;
                    throw new SNMPGetException("Incomplete row of table received", n3 + 1, 5);
                }
                sNMPVarBindList.addSNMPObject(sNMPSequence3);
                sNMPObjectIdentifierArray[n3] = sNMPObjectIdentifier;
            }
            ++this.requestID;
        }
        return sNMPVarBindList;
    }
}

