/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.vlma.daemon;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.videolan.vlma.common.IVlData;
import org.videolan.vlma.common.medias.IVlMedia;
import org.videolan.vlma.daemon.IVlStreamWatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VlDirectMulticastWatcher
implements IVlStreamWatcher {
    private IVlData data;
    private static final Logger logger = Logger.getLogger(VlDirectMulticastWatcher.class);
    private Thread waitThread;
    private static int SOCKET_RECEIVE_TIMEOUT = 500;
    private static int BUF_LENGHT_MIN = 300;
    private static int WAIT_SPAN = 500;
    private boolean isReceivingData = false;
    Runnable waiter = new Runnable(){

        public void run() {
            try {
                Thread.sleep(WAIT_SPAN);
                VlDirectMulticastWatcher.this.isReceivingData = false;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    };

    @Override
    public Map<InetAddress, InetAddress> getStreams() {
        HashMap<InetAddress, InetAddress> retour = new HashMap<InetAddress, InetAddress>();
        try {
            for (IVlMedia media : this.data.getMedias()) {
                if (media.getProgram() == null || media.getProgram().getIp() == null) continue;
                logger.log(Level.DEBUG, "Joining the multicast group " + media.getProgram().getIp() + " of " + media.getName() + ".");
                MulticastSocket s = new MulticastSocket(1234);
                s.setSoTimeout(SOCKET_RECEIVE_TIMEOUT);
                s.joinGroup(media.getProgram().getIp());
                byte[] buf = new byte[1024];
                DatagramPacket recv = new DatagramPacket(buf, buf.length);
                try {
                    this.isReceivingData = true;
                    this.startWaitingForTheSocket();
                    long bufLenght = 0L;
                    while (this.isReceivingData) {
                        s.receive(recv);
                        if ((bufLenght += (long)recv.getLength()) < (long)BUF_LENGHT_MIN) continue;
                        this.isReceivingData = false;
                        this.waitThread.interrupt();
                    }
                    if (bufLenght >= (long)BUF_LENGHT_MIN) {
                        retour.put(media.getProgram().getIp(), media.getProgram().getPlayer());
                        logger.log(Level.DEBUG, "Some data has been received : " + bufLenght + " bytes.");
                    } else {
                        logger.log(Level.DEBUG, "Not enough data received (" + bufLenght + " bytes) verifying the channel " + media.getName() + ".");
                    }
                }
                catch (InterruptedIOException e) {
                    logger.log(Level.DEBUG, "Socket TimeOut verifying the channel " + media.getName() + ".");
                }
                s.leaveGroup(media.getProgram().getIp());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return retour;
    }

    private synchronized void startWaitingForTheSocket() {
        this.waitThread = new Thread(this.waiter);
        this.waitThread.setName("waitThread");
        this.waitThread.start();
    }

    public void setData(IVlData data) {
        this.data = data;
    }
}

