/*****************************************************************************
 * config.c: mini-VideoLAN Channel Server, configuration system
 *****************************************************************************
 * Copyright (C) 2001 VideoLAN
 * $Id: config.h,v 1.5 2002/10/12 19:45:31 marcari Exp $
 *
 * Authors: Christophe Massiot <massiot@via.ecp.fr>
 *          Marc Ariberti <marcari@via.ecp.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************/


typedef struct channel_s
{
    char psz_vlc_config[256];
    struct channel_s * next;
} channel_t;

class C_Config
{
public:
    C_Config(C_Logger &logger);
    ~C_Config();
    void DestroyList( void );
    void AddList( char * psz_item );
    time_t GetModificationTime( void );
    void ReadFile( void );
    channel_t * GetChannel( int i_channel );
    void CheckUpdate( void );
    int GetChannelNumber( void );

    void SetConfigFile(char * psz_config_file);
    
    static char * RemoveLF( char * str );
    
protected:
    int i_channel_max;
    C_Logger &logger;
    char * m_pszConfigFile;
    time_t st_mtime; /* last modification time of the config file */
    channel_t * p_channels;
};
