/*****************************************************************************
 * cmd_update_item.hpp
 *****************************************************************************
 * Copyright (C) 2003-2009 the VideoLAN team
 * $Id: 80c25c1f1ac564aac7cec64efdf8dbd2ba129b67 $
 *
 * Authors: Cyril Deguet     <asmax@via.ecp.fr>
 *          Olivier Teulière <ipkiss@via.ecp.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston MA 02110-1301, USA.
 *****************************************************************************/

#ifndef CMD_UPDATE_ITEM_HPP
#define CMD_UPDATE_ITEM_HPP

#include "cmd_generic.hpp"
#include <string>

/// Udate item command
class CmdUpdateItem: public CmdGeneric
{
    public:
        CmdUpdateItem( intf_thread_t *pIntf, VarText &rStreamName, VarText &rStreamURI ) :
            CmdGeneric( pIntf ), m_rStreamName(rStreamName), m_rStreamURI(rStreamURI) {}
        virtual ~CmdUpdateItem() {}

        /// This method does the real job of the command
        virtual void execute();

        /// Return the type of the command
        virtual string getType() const { return "update item"; }

    private:
        VarText &m_rStreamName;
        VarText &m_rStreamURI;
};
#endif
