/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIResProtocolHandler.idl
 */

#ifndef __gen_nsIResProtocolHandler_h__
#define __gen_nsIResProtocolHandler_h__


#ifndef __gen_nsIProtocolHandler_h__
#include "nsIProtocolHandler.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
#include "nsAString.h"

/* starting interface:    nsIResProtocolHandler */
#define NS_IRESPROTOCOLHANDLER_IID_STR "d12c08c6-9ef6-11d3-8cda-0060b0fc14a3"

#define NS_IRESPROTOCOLHANDLER_IID \
  {0xd12c08c6, 0x9ef6, 0x11d3, \
    { 0x8c, 0xda, 0x00, 0x60, 0xb0, 0xfc, 0x14, 0xa3 }}

class NS_NO_VTABLE nsIResProtocolHandler : public nsIProtocolHandler {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IRESPROTOCOLHANDLER_IID)

  /**
     * Sets the substitution for the root key:
     *   resource://root/path ==> baseURI.resolve(path)
     *
     * A null baseURI removes the specified substitution.
     *
     * A root key should always be lowercase; however, this may not be
     * enforced.
     */
  /* void setSubstitution (in string root, in nsIURI baseURI); */
  NS_IMETHOD SetSubstitution(const char *root, nsIURI *baseURI) = 0;

  /**
     * Gets the substitution for the root key.
     *
     * @throws NS_ERROR_NOT_AVAILABLE if none exists.
     */
  /* nsIURI getSubstitution (in string root); */
  NS_IMETHOD GetSubstitution(const char *root, nsIURI **_retval) = 0;

  /**
     * Returns TRUE if the substitution exists and FALSE otherwise.
     */
  /* boolean hasSubstitution (in string root); */
  NS_IMETHOD HasSubstitution(const char *root, PRBool *_retval) = 0;

  /**
     * Utility function to resolve a resource URI.  A resolved URI is not 
     * guaranteed to reference a resource that exists (ie. opening a channel to
     * the resolved URI may fail).
     *
     * @throws NS_ERROR_NOT_AVAILABLE if resURI.host() is an unknown root key.
     */
  /* AUTF8String resolveURI (in nsIURI resURI); */
  NS_IMETHOD ResolveURI(nsIURI *resURI, nsACString & _retval) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIRESPROTOCOLHANDLER \
  NS_IMETHOD SetSubstitution(const char *root, nsIURI *baseURI); \
  NS_IMETHOD GetSubstitution(const char *root, nsIURI **_retval); \
  NS_IMETHOD HasSubstitution(const char *root, PRBool *_retval); \
  NS_IMETHOD ResolveURI(nsIURI *resURI, nsACString & _retval); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIRESPROTOCOLHANDLER(_to) \
  NS_IMETHOD SetSubstitution(const char *root, nsIURI *baseURI) { return _to SetSubstitution(root, baseURI); } \
  NS_IMETHOD GetSubstitution(const char *root, nsIURI **_retval) { return _to GetSubstitution(root, _retval); } \
  NS_IMETHOD HasSubstitution(const char *root, PRBool *_retval) { return _to HasSubstitution(root, _retval); } \
  NS_IMETHOD ResolveURI(nsIURI *resURI, nsACString & _retval) { return _to ResolveURI(resURI, _retval); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIRESPROTOCOLHANDLER(_to) \
  NS_IMETHOD SetSubstitution(const char *root, nsIURI *baseURI) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetSubstitution(root, baseURI); } \
  NS_IMETHOD GetSubstitution(const char *root, nsIURI **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetSubstitution(root, _retval); } \
  NS_IMETHOD HasSubstitution(const char *root, PRBool *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->HasSubstitution(root, _retval); } \
  NS_IMETHOD ResolveURI(nsIURI *resURI, nsACString & _retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->ResolveURI(resURI, _retval); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsResProtocolHandler : public nsIResProtocolHandler
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIRESPROTOCOLHANDLER

  nsResProtocolHandler();
  virtual ~nsResProtocolHandler();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsResProtocolHandler, nsIResProtocolHandler)

nsResProtocolHandler::nsResProtocolHandler()
{
  /* member initializers and constructor code */
}

nsResProtocolHandler::~nsResProtocolHandler()
{
  /* destructor code */
}

/* void setSubstitution (in string root, in nsIURI baseURI); */
NS_IMETHODIMP nsResProtocolHandler::SetSubstitution(const char *root, nsIURI *baseURI)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIURI getSubstitution (in string root); */
NS_IMETHODIMP nsResProtocolHandler::GetSubstitution(const char *root, nsIURI **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean hasSubstitution (in string root); */
NS_IMETHODIMP nsResProtocolHandler::HasSubstitution(const char *root, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* AUTF8String resolveURI (in nsIURI resURI); */
NS_IMETHODIMP nsResProtocolHandler::ResolveURI(nsIURI *resURI, nsACString & _retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIResProtocolHandler_h__ */
