/*
 * Decompiled with CFR 0.152.
 */
package vlcskineditor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SpringLayout;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import vlcskineditor.GlobalVariables;
import vlcskineditor.Helper;
import vlcskineditor.Item;
import vlcskineditor.Language;
import vlcskineditor.Layout;
import vlcskineditor.Main;
import vlcskineditor.NumbersOnlyDocument;
import vlcskineditor.Resource;
import vlcskineditor.Window;
import vlcskineditor.history.ThemeEditEvent;
import vlcskineditor.items.Group;
import vlcskineditor.items.Panel;
import vlcskineditor.resources.Bitmap;
import vlcskineditor.resources.Font;
import vlcskineditor.resources.ImageResource;
import vlcskineditor.resources.SubBitmap;

public class Skin
implements ActionListener {
    public List<Resource> resources = new LinkedList<Resource>();
    public List<Window> windows = new LinkedList<Window>();
    final String HEADER = "<!DOCTYPE Theme PUBLIC \"-//VideoLAN//DTD VLC Skins V2.0//EN\" \"skin.dtd\">";
    final String THEME_VERSION_DEFAULT = "2.0";
    final String THEME_TOOLTIPFONT_DEFAULT = "defaultfont";
    final int THEME_MAGNET_DEFAULT = 15;
    final int THEME_ALPHA_DEFAULT = 255;
    final int THEME_MOVEALPHA_DEFAULT = 255;
    String theme_version = "2.0";
    String theme_tooltipfont = "defaultfont";
    public int theme_magnet = 15;
    public int theme_alpha = 255;
    public int theme_movealpha = 255;
    final String THEMEINFO_NAME_DEFAULT = Language.get("THEMEINFO_NAME_DEFAULT");
    final String THEMEINFO_AUTHOR_DEFAULT = Language.get("THEMEINFO_AUTHOR_DEFAULT");
    final String THEMEINFO_EMAIL_DEFAULT = Language.get("THEMEINFO_EMAIL_DEFAULT");
    final String THEMEINFO_WEBPAGE_DEFAULT = "http://www.videolan.org/vlc/";
    public String themeinfo_name = this.THEMEINFO_NAME_DEFAULT;
    public String themeinfo_author = this.THEMEINFO_AUTHOR_DEFAULT;
    public String themeinfo_email = this.THEMEINFO_EMAIL_DEFAULT;
    public String themeinfo_webpage = "http://www.videolan.org/vlc/";
    File skinfile;
    public String skinfolder;
    public Main m;
    Window active_window = null;
    Layout active_layout = null;
    int unnamed_ids = 0;
    JFrame theme_frame;
    JTextField themeinfo_name_tf;
    JTextField themeinfo_author_tf;
    JTextField themeinfo_email_tf;
    JTextField themeinfo_webpage_tf;
    JTextField theme_magnet_tf;
    JTextField theme_alpha_tf;
    JTextField theme_movealpha_tf;
    JButton theme_ok_btn;
    JButton theme_cancel_btn;
    JButton theme_help_btn;
    public GlobalVariables gvars = new GlobalVariables(this);
    public static String indentation = "  ";

    public Skin(Main main) {
        this.m = main;
    }

    public void createNew(File file) {
        this.skinfile = file;
        this.skinfolder = file.getParentFile().getAbsolutePath() + File.separator;
        try {
            this.skinfile.createNewFile();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, Language.get("ERROR_NEWSKIN_TITLE") + "\n\n" + exception.toString(), Language.get("ERROR_NEWSKIN_TITLE"), 0);
        }
        this.themeinfo_author = System.getProperty("user.name");
    }

    public void open(File file) {
        this.resources.clear();
        this.windows.clear();
        this.skinfile = file;
        this.skinfolder = file.getParentFile().getAbsolutePath() + File.separator;
        try {
            this.parseXML(file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(null, exception.toString(), exception.getMessage(), 0);
            this.update();
            this.m.showWelcomeDialog();
        }
        this.update();
        for (Window window : this.windows) {
            for (Layout layout : window.layouts) {
                for (Item item : layout.items) {
                    item.updateToGlobalVariables();
                }
            }
        }
    }

    private void parseXML(File file) throws Exception {
        Object object;
        File file2 = new File(file.getParent(), "skin.dtd");
        if (!file2.exists() && ((File)(object = new File("skin.dtd"))).exists()) {
            Helper.copyFile((File)object, file2);
            file2.deleteOnExit();
        }
        object = DocumentBuilderFactory.newInstance();
        ((DocumentBuilderFactory)object).setIgnoringComments(true);
        DocumentBuilder documentBuilder = ((DocumentBuilderFactory)object).newDocumentBuilder();
        Document document = documentBuilder.parse(file);
        NodeList nodeList = document.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            this.parseNode(nodeList.item(i));
        }
    }

    private void parseNodeChildren(Node node) throws Exception {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            this.parseNode(nodeList.item(i));
        }
    }

    private void parseNode(Node node) throws Exception {
        if (node.getNodeType() == 10) {
            if (!node.getNodeName().equals("Theme")) {
                throw new Exception(Language.get("ERROR_SKIN_INVALID"));
            }
        } else if (node.getNodeType() == 1) {
            if (node.getNodeName().equals("Theme")) {
                if (node.getAttributes().getNamedItem("version") != null) {
                    this.theme_version = node.getAttributes().getNamedItem("version").getNodeValue();
                    if (Double.parseDouble(this.theme_version) != 2.0) {
                        throw new Exception(Language.get("ERROR_VERSION_UNSUPPORTED"));
                    }
                    this.parseNodeChildren(node);
                }
            } else if (node.getNodeName().equals("ThemeInfo")) {
                if (node.getAttributes().getNamedItem("author") != null) {
                    this.themeinfo_author = node.getAttributes().getNamedItem("author").getNodeValue();
                }
                if (node.getAttributes().getNamedItem("name") != null) {
                    this.themeinfo_name = node.getAttributes().getNamedItem("name").getNodeValue();
                }
                if (node.getAttributes().getNamedItem("email") != null) {
                    this.themeinfo_email = node.getAttributes().getNamedItem("email").getNodeValue();
                }
                if (node.getAttributes().getNamedItem("webpage") != null) {
                    this.themeinfo_webpage = node.getAttributes().getNamedItem("webpage").getNodeValue();
                }
            } else if (node.getNodeName().equals("Bitmap")) {
                this.resources.add(new Bitmap(node, this));
            } else if (node.getNodeName().equals("Font")) {
                this.resources.add(new Font((Element)node, this));
            } else if (node.getNodeName().equals("Window")) {
                this.windows.add(new Window(node, this));
            }
        }
    }

    public void save() {
        try {
            FileWriter fileWriter = new FileWriter(this.skinfile);
            fileWriter.write(this.returnCode());
            fileWriter.flush();
            fileWriter.close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, Language.get("ERROR_SAVE_MSG") + "\n\n" + exception.toString(), Language.get("ERROR_SAVE_TITLE"), 0);
        }
    }

    public void showThemeOptions() {
        if (this.theme_frame == null) {
            this.theme_frame = new JFrame(Language.get("WIN_THEME_TITLE"));
            this.theme_frame.setResizable(false);
            this.theme_frame.setLayout(new FlowLayout());
            this.theme_frame.setDefaultCloseOperation(2);
            JLabel jLabel = new JLabel(Language.get("WIN_THEME_NAME"));
            this.themeinfo_name_tf = new JTextField();
            JLabel jLabel2 = new JLabel(Language.get("WIN_THEME_AUTHOR"));
            this.themeinfo_author_tf = new JTextField();
            JLabel jLabel3 = new JLabel(Language.get("WIN_THEME_EMAIL"));
            this.themeinfo_email_tf = new JTextField();
            JLabel jLabel4 = new JLabel(Language.get("WIN_THEME_WEB"));
            this.themeinfo_webpage_tf = new JTextField();
            JLabel jLabel5 = new JLabel(Language.get("WIN_THEME_MAGNET"));
            this.theme_magnet_tf = new JTextField();
            this.theme_magnet_tf.setDocument(new NumbersOnlyDocument(false));
            this.theme_magnet_tf.setToolTipText(Language.get("WIN_THEME_MAGNET_TIP"));
            JLabel jLabel6 = new JLabel(Language.get("WIN_THEME_ALPHA"));
            this.theme_alpha_tf = new JTextField();
            this.theme_alpha_tf.setDocument(new NumbersOnlyDocument(false));
            this.theme_alpha_tf.setToolTipText(Language.get("WIN_THEME_ALPHA_TIP"));
            JLabel jLabel7 = new JLabel(Language.get("WIN_THEME_MOVEALPHA"));
            this.theme_movealpha_tf = new JTextField();
            this.theme_alpha_tf.setDocument(new NumbersOnlyDocument(false));
            this.theme_alpha_tf.setToolTipText(Language.get("WIN_THEME_MOVEALPHA_TIP"));
            this.theme_ok_btn = new JButton(Language.get("BUTTON_OK"));
            this.theme_ok_btn.addActionListener(this);
            this.theme_cancel_btn = new JButton(Language.get("BUTTON_CANCEL"));
            this.theme_cancel_btn.addActionListener(this);
            this.theme_help_btn = new JButton(Language.get("BUTTON_HELP"));
            this.theme_help_btn.addActionListener(this);
            Component[] componentArray = new Component[]{jLabel, jLabel2, jLabel3, jLabel4, jLabel5, jLabel6, jLabel7};
            int n = Helper.maxWidth(componentArray) + 10;
            int n2 = 200;
            JPanel jPanel = new JPanel(null);
            jPanel.add(jLabel);
            jPanel.add(this.themeinfo_name_tf);
            this.themeinfo_name_tf.setPreferredSize(new Dimension(n2, this.themeinfo_name_tf.getPreferredSize().height));
            jPanel.add(jLabel2);
            jPanel.add(this.themeinfo_author_tf);
            jPanel.add(jLabel3);
            jPanel.add(this.themeinfo_email_tf);
            jPanel.add(jLabel4);
            jPanel.add(this.themeinfo_webpage_tf);
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Language.get("WIN_THEME_INFO_TITLE")));
            SpringLayout springLayout = new SpringLayout();
            jPanel.setLayout(springLayout);
            springLayout.putConstraint("North", (Component)jLabel, 5, "North", (Component)jPanel);
            springLayout.putConstraint("West", (Component)jLabel, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.themeinfo_name_tf, 0, "VerticalCenter", (Component)jLabel);
            springLayout.putConstraint("West", (Component)this.themeinfo_name_tf, n, "West", (Component)jPanel);
            springLayout.putConstraint("North", (Component)jLabel2, 10, "South", (Component)this.themeinfo_name_tf);
            springLayout.putConstraint("West", (Component)jLabel2, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.themeinfo_author_tf, 0, "VerticalCenter", (Component)jLabel2);
            springLayout.putConstraint("West", (Component)this.themeinfo_author_tf, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.themeinfo_author_tf, 0, "East", (Component)this.themeinfo_name_tf);
            springLayout.putConstraint("North", (Component)jLabel3, 10, "South", (Component)this.themeinfo_author_tf);
            springLayout.putConstraint("West", (Component)jLabel3, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.themeinfo_email_tf, 0, "VerticalCenter", (Component)jLabel3);
            springLayout.putConstraint("West", (Component)this.themeinfo_email_tf, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.themeinfo_email_tf, 0, "East", (Component)this.themeinfo_name_tf);
            springLayout.putConstraint("North", (Component)jLabel4, 10, "South", (Component)this.themeinfo_email_tf);
            springLayout.putConstraint("West", (Component)jLabel4, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.themeinfo_webpage_tf, 0, "VerticalCenter", (Component)jLabel4);
            springLayout.putConstraint("West", (Component)this.themeinfo_webpage_tf, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.themeinfo_webpage_tf, 0, "East", (Component)this.themeinfo_name_tf);
            springLayout.putConstraint("East", (Component)jPanel, 5, "East", (Component)this.themeinfo_name_tf);
            springLayout.putConstraint("South", (Component)jPanel, 10, "South", (Component)this.themeinfo_webpage_tf);
            this.theme_frame.add(jPanel);
            JPanel jPanel2 = new JPanel(null);
            jPanel2.add(jLabel5);
            jPanel2.add(this.theme_magnet_tf);
            this.theme_magnet_tf.setPreferredSize(new Dimension(n2, this.theme_magnet_tf.getPreferredSize().height));
            jPanel2.add(jLabel6);
            jPanel2.add(this.theme_alpha_tf);
            jPanel2.add(jLabel7);
            jPanel2.add(this.theme_movealpha_tf);
            jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Language.get("WIN_THEME_ATTR_TITLE")));
            SpringLayout springLayout2 = new SpringLayout();
            jPanel2.setLayout(springLayout2);
            springLayout2.putConstraint("North", (Component)jLabel5, 5, "North", (Component)jPanel2);
            springLayout2.putConstraint("West", (Component)jLabel5, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.theme_magnet_tf, 0, "VerticalCenter", (Component)jLabel5);
            springLayout2.putConstraint("West", (Component)this.theme_magnet_tf, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("North", (Component)jLabel6, 10, "South", (Component)this.theme_magnet_tf);
            springLayout2.putConstraint("West", (Component)jLabel6, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.theme_alpha_tf, 0, "VerticalCenter", (Component)jLabel6);
            springLayout2.putConstraint("West", (Component)this.theme_alpha_tf, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("East", (Component)this.theme_alpha_tf, 0, "East", (Component)this.theme_magnet_tf);
            springLayout2.putConstraint("North", (Component)jLabel7, 10, "South", (Component)this.theme_alpha_tf);
            springLayout2.putConstraint("West", (Component)jLabel7, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.theme_movealpha_tf, 0, "VerticalCenter", (Component)jLabel7);
            springLayout2.putConstraint("West", (Component)this.theme_movealpha_tf, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("East", (Component)this.theme_movealpha_tf, 0, "East", (Component)this.theme_magnet_tf);
            springLayout2.putConstraint("East", (Component)jPanel2, 5, "East", (Component)this.theme_magnet_tf);
            springLayout2.putConstraint("South", (Component)jPanel2, 10, "South", (Component)this.theme_movealpha_tf);
            this.theme_frame.add(jPanel2);
            this.theme_frame.add(this.theme_ok_btn);
            this.theme_frame.add(this.theme_cancel_btn);
            this.theme_frame.add(this.theme_help_btn);
            SpringLayout springLayout3 = new SpringLayout();
            springLayout3.putConstraint("North", (Component)jPanel, 5, "North", (Component)this.theme_frame.getContentPane());
            springLayout3.putConstraint("West", (Component)jPanel, 5, "West", (Component)this.theme_frame.getContentPane());
            springLayout3.putConstraint("North", (Component)jPanel2, 10, "South", (Component)jPanel);
            springLayout3.putConstraint("West", (Component)jPanel2, 5, "West", (Component)this.theme_frame.getContentPane());
            springLayout3.putConstraint("North", (Component)this.theme_ok_btn, 10, "South", (Component)jPanel2);
            springLayout3.putConstraint("West", (Component)this.theme_ok_btn, 5, "West", (Component)this.theme_frame.getContentPane());
            springLayout3.putConstraint("North", (Component)this.theme_cancel_btn, 0, "North", (Component)this.theme_ok_btn);
            springLayout3.putConstraint("West", (Component)this.theme_cancel_btn, 5, "East", (Component)this.theme_ok_btn);
            springLayout3.putConstraint("North", (Component)this.theme_help_btn, 0, "North", (Component)this.theme_cancel_btn);
            springLayout3.putConstraint("West", (Component)this.theme_help_btn, 5, "East", (Component)this.theme_cancel_btn);
            springLayout3.putConstraint("South", (Component)this.theme_frame.getContentPane(), 10, "South", (Component)this.theme_ok_btn);
            springLayout3.putConstraint("East", (Component)this.theme_frame.getContentPane(), 5, "East", (Component)jPanel);
            this.theme_frame.setLayout(springLayout3);
            this.theme_frame.pack();
        }
        this.themeinfo_name_tf.setText(this.themeinfo_name);
        this.themeinfo_author_tf.setText(this.themeinfo_author);
        this.themeinfo_email_tf.setText(this.themeinfo_email);
        this.themeinfo_webpage_tf.setText(this.themeinfo_webpage);
        this.theme_magnet_tf.setText(String.valueOf(this.theme_magnet));
        this.theme_alpha_tf.setText(String.valueOf(this.theme_alpha));
        this.theme_movealpha_tf.setText(String.valueOf(this.theme_movealpha));
        this.theme_frame.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.theme_ok_btn)) {
            if (Integer.parseInt(this.theme_alpha_tf.getText()) > 255 || Integer.parseInt(this.theme_alpha_tf.getText()) < 1) {
                JOptionPane.showMessageDialog(this.theme_frame, Language.get("ERROR_ALPHA_MSG"), Language.get("ERROR_ALPHA_TITLE"), 1);
                return;
            }
            if (Integer.parseInt(this.theme_movealpha_tf.getText()) > 255 || Integer.parseInt(this.theme_movealpha_tf.getText()) < 1) {
                JOptionPane.showMessageDialog(this.theme_frame, Language.get("ERROR_ALPHA_MSG"), Language.get("ERROR_ALPHA_TITLE"), 1);
                return;
            }
            ThemeEditEvent themeEditEvent = new ThemeEditEvent(this);
            this.themeinfo_name = this.themeinfo_name_tf.getText();
            this.themeinfo_author = this.themeinfo_author_tf.getText();
            this.themeinfo_email = this.themeinfo_email_tf.getText();
            this.themeinfo_webpage = this.themeinfo_webpage_tf.getText();
            this.theme_magnet = Integer.parseInt(this.theme_magnet_tf.getText());
            this.theme_alpha = Integer.parseInt(this.theme_alpha_tf.getText());
            this.theme_movealpha = Integer.parseInt(this.theme_movealpha_tf.getText());
            this.theme_frame.setVisible(false);
            this.theme_frame.dispose();
            this.theme_frame = null;
            themeEditEvent.setNew();
            this.m.hist.addEvent(themeEditEvent);
        } else if (actionEvent.getSource().equals(this.theme_help_btn)) {
            Helper.browse("http://www.videolan.org/vlc/skinedhlp/theme.html");
        } else if (actionEvent.getSource().equals(this.theme_cancel_btn)) {
            this.theme_frame.setVisible(false);
            this.theme_frame.dispose();
            this.theme_frame = null;
        }
    }

    public int getNewId() {
        ++this.unnamed_ids;
        return this.unnamed_ids;
    }

    public boolean idExists(String string) {
        if (this.getResource(string) != null) {
            return true;
        }
        for (Window window : this.windows) {
            if (window.id.equals(string)) {
                return true;
            }
            for (Layout layout : window.layouts) {
                if (layout.id.equals(string)) {
                    return true;
                }
                if (layout.getItem(string) == null) continue;
                return true;
            }
        }
        return false;
    }

    public ImageResource getImageResource(String string) {
        if (string == null) {
            return null;
        }
        for (Resource resource : this.resources) {
            if (resource.getClass() != Bitmap.class) continue;
            if (resource.id.equals(string)) {
                return (ImageResource)resource;
            }
            Bitmap bitmap = (Bitmap)resource;
            for (SubBitmap subBitmap : bitmap.SubBitmaps) {
                if (!subBitmap.id.equals(string)) continue;
                return subBitmap;
            }
        }
        return null;
    }

    public Resource getResource(String string) {
        for (Resource resource : this.resources) {
            if (resource.id.equals(string)) {
                return resource;
            }
            if (resource.getClass() != Bitmap.class) continue;
            Bitmap bitmap = (Bitmap)resource;
            for (SubBitmap subBitmap : bitmap.SubBitmaps) {
                if (!subBitmap.id.equals(string)) continue;
                return subBitmap;
            }
        }
        return null;
    }

    public java.awt.Font getFont(String string) {
        if (string.equals("defaultfont")) {
            return new java.awt.Font("SansSerif", 0, 12);
        }
        Resource resource = this.getResource(string);
        if (resource == null) {
            return new java.awt.Font("SansSerif", 0, 12);
        }
        try {
            if (resource.getClass() == Font.class) {
                Font font = (Font)resource;
                return font.f;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new java.awt.Font("SansSerif", 0, 12);
        }
        return new java.awt.Font("SansSerif", 0, 12);
    }

    public Window getWindow(String string) {
        Window window = null;
        for (int i = 0; i < this.windows.size(); ++i) {
            if (!this.windows.get((int)i).id.equals(string)) continue;
            window = this.windows.get(i);
        }
        return window;
    }

    public boolean isUsed(String string) {
        for (Window window : this.windows) {
            for (Layout layout : window.layouts) {
                if (!layout.uses(string)) continue;
                return true;
            }
        }
        return false;
    }

    public List<Item> getParentListOf(String string) {
        return this.active_layout.getParentListOf(string);
    }

    public List<Item> getListOf(String string) {
        Item item = this.getItem(string);
        List<Item> list = null;
        try {
            Panel panel = (Panel)item;
            list = panel.items;
        }
        catch (Exception exception) {
            try {
                Group group = (Group)item;
                list = group.items;
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
        }
        return list;
    }

    public Item getItem(String string) {
        this.active_window = null;
        this.active_layout = null;
        if (this.m.getSelectedWindow() != null && this.m.getSelectedLayout() != null) {
            this.active_window = this.getWindow(this.m.getSelectedWindow());
            if (this.active_window != null) {
                this.active_layout = this.active_window.getLayout(this.m.getSelectedLayout());
            }
        }
        if (this.active_layout != null) {
            return this.active_layout.getItem(string);
        }
        return null;
    }

    public DefaultMutableTreeNode getResourcesTree() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Root: Resources");
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Root: " + Language.get("WIN_RES_BITMAPS"));
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Root: " + Language.get("WIN_RES_FONTS"));
        for (Resource resource : this.resources) {
            if (resource.getClass() != Bitmap.class) continue;
            defaultMutableTreeNode2.add(resource.getTreeNode());
        }
        for (Resource resource : this.resources) {
            if (resource.getClass() != Font.class) continue;
            DefaultMutableTreeNode defaultMutableTreeNode4 = resource.getTreeNode();
            defaultMutableTreeNode3.add(defaultMutableTreeNode4);
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        return defaultMutableTreeNode;
    }

    public DefaultMutableTreeNode getWindowsTree() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Root: Windows");
        for (int i = 0; i < this.windows.size(); ++i) {
            defaultMutableTreeNode.add(this.windows.get(i).getTreeNode());
        }
        return defaultMutableTreeNode;
    }

    public DefaultMutableTreeNode getItemsTree() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Root: Items");
        if (this.m.getSelectedWindow() != null && this.m.getSelectedLayout() != null) {
            this.active_window = this.getWindow(this.m.getSelectedWindow());
            if (this.active_window != null) {
                this.active_layout = this.active_window.getLayout(this.m.getSelectedLayout());
            }
        }
        if (this.active_layout != null) {
            for (int i = 0; i < this.active_layout.items.size(); ++i) {
                defaultMutableTreeNode.add(this.active_layout.items.get(i).getTreeNode());
            }
        }
        return defaultMutableTreeNode;
    }

    public String returnCode() {
        int n;
        String string = "";
        string = string + "<!DOCTYPE Theme PUBLIC \"-//VideoLAN//DTD VLC Skins V2.0//EN\" \"skin.dtd\">\n";
        string = string + "<Theme version=\"" + this.theme_version + "\"";
        if (!this.theme_tooltipfont.equals("defaultfont")) {
            string = string + " tooltipfont=\"" + this.theme_tooltipfont + "\"";
        }
        if (this.theme_magnet != 15) {
            string = string + " magnet=\"" + String.valueOf(this.theme_magnet) + "\"";
        }
        if (this.theme_alpha != 255) {
            string = string + " alpha=\"" + String.valueOf(this.theme_alpha) + "\"";
        }
        if (this.theme_movealpha != 255) {
            string = string + " movealpha=\"" + String.valueOf(this.theme_movealpha) + "\"";
        }
        string = string + ">\n";
        string = string + indentation + "<ThemeInfo";
        string = string + " name=\"" + this.themeinfo_name + "\"";
        string = string + " author=\"" + this.themeinfo_author + "\"";
        string = string + " email=\"" + this.themeinfo_email + "\"";
        string = string + " webpage=\"" + this.themeinfo_webpage + "\"";
        string = string + "/>\n\n";
        string = string + indentation + "<!-- Created using the VLC Skin Editor " + "0.8.5.dev" + " (http://www.videolan.org/vlc/skineditor.html)-->\n\n";
        for (n = 0; n < this.resources.size(); ++n) {
            string = string + this.resources.get(n).returnCode(indentation);
        }
        string = string + "\n";
        for (n = 0; n < this.windows.size(); ++n) {
            string = string + this.windows.get(n).returnCode(indentation);
        }
        string = string + "\n</Theme>";
        return string;
    }

    public void updateResources() {
        this.m.res_tree_model.setRoot(this.getResourcesTree());
        this.m.saved = false;
    }

    public void updateWindows() {
        this.m.win_tree_model.setRoot(this.getWindowsTree());
        this.m.saved = false;
    }

    public void updateItems() {
        this.m.items_tree_model.setRoot(this.getItemsTree());
        this.m.saved = false;
    }

    public void update() {
        this.updateResources();
        this.updateWindows();
        this.updateItems();
        this.m.saved = false;
    }

    public void expandResource(String string) {
        Object object;
        Resource resource = this.getResource(string);
        if (resource == null) {
            return;
        }
        if (ImageResource.class.isAssignableFrom(resource.getClass())) {
            object = this.findInTree(this.m.res_tree, "Root: " + Language.get("WIN_RES_BITMAPS"));
            this.m.res_tree.expandPath((TreePath)object);
        } else if (resource.getClass().equals(Font.class)) {
            object = this.findInTree(this.m.res_tree, "Root: " + Language.get("WIN_RES_FONTS"));
            this.m.res_tree.expandPath((TreePath)object);
        } else {
            System.err.println("Error encountered while trying to expand a resource:");
            System.err.println("  Resource of the given id is neither a Font nor a Bitmap its a " + resource.type);
            return;
        }
        object = resource;
        for (Resource resource2 : this.resources) {
            if (resource2.getParentOf(string) == null) continue;
            TreePath treePath = this.findInTree(this.m.res_tree, resource2.id);
            if (treePath == null) {
                System.err.println("Could not find Parent: " + resource2.id);
                return;
            }
            this.m.res_tree.expandPath(treePath);
            TreePath treePath2 = this.findInTree(this.m.res_tree, string);
            if (treePath2 == null) {
                return;
            }
            this.m.res_tree.setSelectionPath(treePath2);
            break;
        }
    }

    public void expandLayout(String string) {
        TreePath treePath = null;
        treePath = this.active_window != null ? this.findInTree(this.m.win_tree, this.active_window.id) : this.findInTree(this.m.win_tree, this.m.getSelectedLayout());
        if (treePath == null) {
            return;
        }
        this.m.win_tree.expandPath(treePath);
        TreePath treePath2 = this.findInTree(this.m.win_tree, string);
        if (treePath2 == null) {
            return;
        }
        this.m.win_tree.setSelectionPath(treePath2);
    }

    public void expandItem(String string) {
        LinkedList<String> linkedList = new LinkedList<String>();
        Item item = this.getItem(string);
        if (item == null) {
            return;
        }
        while ((item = this.active_layout.getParentOf(item.id)) != null) {
            linkedList.add(item.id);
        }
        for (int i = linkedList.size() - 1; i >= 0; --i) {
            TreePath treePath = this.findInTree(this.m.items_tree, (String)linkedList.get(i));
            if (treePath == null) {
                System.err.println("Could not find Parent: " + (String)linkedList.get(i));
                return;
            }
            this.m.items_tree.expandPath(treePath);
        }
        TreePath treePath = this.findInTree(this.m.items_tree, string);
        if (treePath == null) {
            return;
        }
        this.m.items_tree.setSelectionPath(treePath);
    }

    public TreePath findInTree(JTree jTree, String string) {
        int n = jTree.getRowCount();
        int n2 = 0;
        do {
            TreePath treePath;
            String string2;
            if ((string2 = (treePath = jTree.getPathForRow(n2)).getLastPathComponent().toString()).toUpperCase().indexOf(string.toUpperCase()) == -1) continue;
            return treePath;
        } while ((n2 = (n2 + 1 + n) % n) != 0);
        return null;
    }
}

