/*
 * This file is part of libbluray
 * Copyright (C) 2010  William Hahne
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 */

#ifndef BDJ_COMMON_H_
#define BDJ_COMMON_H_

#define BDJ_CLASSPATH "libbluray.jar"
#define BDJ_BDJO_PATH "/BDMV/BDJO"
#define BDJ_JAR_PATH "/BDMV/JAR"

#define BDJ_ERROR -1
#define BDJ_SUCCESS 0

#include "util/logging.h"

// input events
#define BDJ_KEY_PRESSED 401
#define BDJ_KEY_RELEASED 402

// key codes
#define BDJ_VK_COLORED_KEY_0 403
#define BDJ_VK_COLORED_KEY_1 404
#define BDJ_VK_COLORED_KEY_2 405
#define BDJ_VK_COLORED_KEY_3 406
#define BDJ_VK_COLORED_KEY_4 407
#define BDJ_VK_COLORED_KEY_5 408

#define BDJ_VK_LEFT 37
#define BDJ_VK_UP 38
#define BDJ_VK_RIGHT 39
#define BDJ_VK_DOWN 40

#define BDJ_VK_0 48
#define BDJ_VK_1 49
#define BDJ_VK_2 50
#define BDJ_VK_3 51
#define BDJ_VK_4 52
#define BDJ_VK_5 53
#define BDJ_VK_6 54
#define BDJ_VK_7 55
#define BDJ_VK_8 56
#define BDJ_VK_9 57

#define BDJ_VK_A 65
#define BDJ_VK_B 66
#define BDJ_VK_C 67
#define BDJ_VK_D 68
#define BDJ_VK_E 69
#define BDJ_VK_F 70
#define BDJ_VK_G 71
#define BDJ_VK_H 72
#define BDJ_VK_I 73
#define BDJ_VK_J 74
#define BDJ_VK_K 75
#define BDJ_VK_L 76
#define BDJ_VK_M 77
#define BDJ_VK_N 78
#define BDJ_VK_O 79
#define BDJ_VK_P 80
#define BDJ_VK_Q 81
#define BDJ_VK_R 82
#define BDJ_VK_S 83
#define BDJ_VK_T 84
#define BDJ_VK_U 85
#define BDJ_VK_V 86
#define BDJ_VK_W 87
#define BDJ_VK_X 88
#define BDJ_VK_Y 89
#define BDJ_VK_Z 90

#endif /* BDJ_COMMON_H_ */
