package org.jboss.cache.loader;

import org.jboss.cache.config.CacheLoaderConfig.IndividualCacheLoaderConfig;
import org.jboss.cache.config.Dynamic;

import java.util.Properties;

public class ClusteredCacheLoaderConfig extends IndividualCacheLoaderConfig
{
   /**
    * The serialVersionUID
    */
   private static final long serialVersionUID = -3425487656984237468L;

   @Dynamic
   private long timeout = 10000;

   public ClusteredCacheLoaderConfig()
   {
      setClassName(ClusteredCacheLoader.class.getName());
   }

   /**
    * For use by {@link ClusteredCacheLoader}.
    *
    * @param base generic config object created by XML parsing.
    */
   ClusteredCacheLoaderConfig(IndividualCacheLoaderConfig base)
   {
      setClassName(ClusteredCacheLoader.class.getName());
      populateFromBaseConfig(base);
   }

   public long getTimeout()
   {
      return timeout;
   }

   public void setTimeout(long timeout)
   {
      testImmutability("timeout");
      this.timeout = timeout;
   }

   @Override
   public void setProperties(Properties props)
   {
      super.setProperties(props);
      try
      {
         timeout = Long.valueOf(props.getProperty("timeout"));
      }
      catch (Exception e)
      {
         log.info("Using default value for config property 'timeout' - " + timeout);
      }
   }

   @Override
   public boolean equals(Object obj)
   {
      if (obj instanceof ClusteredCacheLoaderConfig && equalsExcludingProperties(obj))
      {
         ClusteredCacheLoaderConfig other = (ClusteredCacheLoaderConfig) obj;
         return (this.timeout == other.timeout);
      }
      return false;
   }

   @Override
   public int hashCode()
   {
      return 31 * hashCodeExcludingProperties() + (int) timeout;
   }

   @Override
   public ClusteredCacheLoaderConfig clone() throws CloneNotSupportedException
   {
      return (ClusteredCacheLoaderConfig) super.clone();
   }

}