/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.filters;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;

public class StringInputStream
extends InputStream {
    private StringReader in;
    private String encoding;
    private byte[] slack;
    private int begin;

    public StringInputStream(String source) {
        this.in = new StringReader(source);
    }

    public StringInputStream(String source, String encoding) {
        this.in = new StringReader(source);
        this.encoding = encoding;
    }

    public synchronized int read() throws IOException {
        byte result;
        if (this.in == null) {
            throw new IOException("Stream Closed");
        }
        if (this.slack != null && this.begin < this.slack.length) {
            result = this.slack[this.begin];
            if (++this.begin == this.slack.length) {
                this.slack = null;
            }
        } else {
            byte[] buf = new byte[1];
            if (this.read(buf, 0, 1) <= 0) {
                return -1;
            }
            result = buf[0];
        }
        if (result < 0) {
            return 256 + result;
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (this.in != null) ** GOTO lbl11
        throw new IOException("Stream Closed");
lbl-1000:
        // 1 sources

        {
            buf = new char[len];
            n = this.in.read(buf);
            if (n == -1) {
                return -1;
            }
            if (n <= 0) continue;
            s = new String(buf, 0, n);
            this.slack = this.encoding == null ? s.getBytes() : s.getBytes(this.encoding);
            this.begin = 0;
lbl11:
            // 3 sources

            ** while (this.slack == null)
        }
lbl12:
        // 1 sources

        if (len > this.slack.length - this.begin) {
            len = this.slack.length - this.begin;
        }
        System.arraycopy(this.slack, this.begin, b, off, len);
        if ((this.begin += len) >= this.slack.length) {
            this.slack = null;
        }
        return len;
    }

    public synchronized void mark(int limit) {
        try {
            this.in.mark(limit);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe.getMessage());
        }
    }

    public synchronized int available() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream Closed");
        }
        if (this.slack != null) {
            return this.slack.length - this.begin;
        }
        if (this.in.ready()) {
            return 1;
        }
        return 0;
    }

    public boolean markSupported() {
        return false;
    }

    public synchronized void reset() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream Closed");
        }
        this.slack = null;
        this.in.reset();
    }

    public synchronized void close() throws IOException {
        this.in.close();
        this.slack = null;
        this.in = null;
    }
}

