use Unicode::Collate::CJK::JISX0208;
+{
   locale_version => 0.93,
   overrideCJK => \&Unicode::Collate::CJK::JISX0208::weightJISX0208,
   entry => <<'ENTRY', # for DUCET v6.2.0
3041      ; [.32BB.0020.000F.3041] # HIRAGANA LETTER SMALL A
3042      ; [.32BB.0020.0011.3042] # HIRAGANA LETTER A
3043      ; [.32BC.0020.000F.3043] # HIRAGANA LETTER SMALL I
3044      ; [.32BC.0020.0011.3044] # HIRAGANA LETTER I
3045      ; [.32BD.0020.000F.3045] # HIRAGANA LETTER SMALL U
3046      ; [.32BD.0020.0011.3046] # HIRAGANA LETTER U
3047      ; [.32BF.0020.000F.3047] # HIRAGANA LETTER SMALL E
3048      ; [.32BF.0020.0011.3048] # HIRAGANA LETTER E
3049      ; [.32C0.0020.000F.3049] # HIRAGANA LETTER SMALL O
304A      ; [.32C0.0020.0011.304A] # HIRAGANA LETTER O
304B      ; [.32C1.0020.0011.304B] # HIRAGANA LETTER KA
304C      ; [.32C1.0020.0011.304B][.0000.0128.0002.3099] # HIRAGANA LETTER GA
304D      ; [.32C2.0020.0011.304D] # HIRAGANA LETTER KI
304E      ; [.32C2.0020.0011.304D][.0000.0128.0002.3099] # HIRAGANA LETTER GI
304F      ; [.32C3.0020.0011.304F] # HIRAGANA LETTER KU
3050      ; [.32C3.0020.0011.304F][.0000.0128.0002.3099] # HIRAGANA LETTER GU
3051      ; [.32C4.0020.0011.3051] # HIRAGANA LETTER KE
3052      ; [.32C4.0020.0011.3051][.0000.0128.0002.3099] # HIRAGANA LETTER GE
3053      ; [.32C5.0020.0011.3053] # HIRAGANA LETTER KO
3054      ; [.32C5.0020.0011.3053][.0000.0128.0002.3099] # HIRAGANA LETTER GO
3055      ; [.32C6.0020.0011.3055] # HIRAGANA LETTER SA
3056      ; [.32C6.0020.0011.3055][.0000.0128.0002.3099] # HIRAGANA LETTER ZA
3057      ; [.32C7.0020.0011.3057] # HIRAGANA LETTER SI
3058      ; [.32C7.0020.0011.3057][.0000.0128.0002.3099] # HIRAGANA LETTER ZI
3059      ; [.32C8.0020.0011.3059] # HIRAGANA LETTER SU
305A      ; [.32C8.0020.0011.3059][.0000.0128.0002.3099] # HIRAGANA LETTER ZU
305B      ; [.32C9.0020.0011.305B] # HIRAGANA LETTER SE
305C      ; [.32C9.0020.0011.305B][.0000.0128.0002.3099] # HIRAGANA LETTER ZE
305D      ; [.32CA.0020.0011.305D] # HIRAGANA LETTER SO
305E      ; [.32CA.0020.0011.305D][.0000.0128.0002.3099] # HIRAGANA LETTER ZO
305F      ; [.32CB.0020.0011.305F] # HIRAGANA LETTER TA
3060      ; [.32CB.0020.0011.305F][.0000.0128.0002.3099] # HIRAGANA LETTER DA
3061      ; [.32CC.0020.0011.3061] # HIRAGANA LETTER TI
3062      ; [.32CC.0020.0011.3061][.0000.0128.0002.3099] # HIRAGANA LETTER DI
3063      ; [.32CD.0020.000F.3063] # HIRAGANA LETTER SMALL TU
3064      ; [.32CD.0020.0011.3064] # HIRAGANA LETTER TU
3065      ; [.32CD.0020.0011.3064][.0000.0128.0002.3099] # HIRAGANA LETTER DU
3066      ; [.32CE.0020.0011.3066] # HIRAGANA LETTER TE
3067      ; [.32CE.0020.0011.3066][.0000.0128.0002.3099] # HIRAGANA LETTER DE
3068      ; [.32CF.0020.0011.3068] # HIRAGANA LETTER TO
3069      ; [.32CF.0020.0011.3068][.0000.0128.0002.3099] # HIRAGANA LETTER DO
306A      ; [.32D0.0020.0011.306A] # HIRAGANA LETTER NA
306B      ; [.32D1.0020.0011.306B] # HIRAGANA LETTER NI
306C      ; [.32D2.0020.0011.306C] # HIRAGANA LETTER NU
306D      ; [.32D3.0020.0011.306D] # HIRAGANA LETTER NE
306E      ; [.32D4.0020.0011.306E] # HIRAGANA LETTER NO
306F      ; [.32D5.0020.0011.306F] # HIRAGANA LETTER HA
3070      ; [.32D5.0020.0011.306F][.0000.0128.0002.3099] # HIRAGANA LETTER BA
3071      ; [.32D5.0020.0011.306F][.0000.0129.0002.309A] # HIRAGANA LETTER PA
3072      ; [.32D6.0020.0011.3072] # HIRAGANA LETTER HI
3073      ; [.32D6.0020.0011.3072][.0000.0128.0002.3099] # HIRAGANA LETTER BI
3074      ; [.32D6.0020.0011.3072][.0000.0129.0002.309A] # HIRAGANA LETTER PI
3075      ; [.32D7.0020.0011.3075] # HIRAGANA LETTER HU
3076      ; [.32D7.0020.0011.3075][.0000.0128.0002.3099] # HIRAGANA LETTER BU
3077      ; [.32D7.0020.0011.3075][.0000.0129.0002.309A] # HIRAGANA LETTER PU
3078      ; [.32D8.0020.0011.3078] # HIRAGANA LETTER HE
3079      ; [.32D8.0020.0011.3078][.0000.0128.0002.3099] # HIRAGANA LETTER BE
307A      ; [.32D8.0020.0011.3078][.0000.0129.0002.309A] # HIRAGANA LETTER PE
307B      ; [.32D9.0020.0011.307B] # HIRAGANA LETTER HO
307C      ; [.32D9.0020.0011.307B][.0000.0128.0002.3099] # HIRAGANA LETTER BO
307D      ; [.32D9.0020.0011.307B][.0000.0129.0002.309A] # HIRAGANA LETTER PO
307E      ; [.32DA.0020.0011.307E] # HIRAGANA LETTER MA
307F      ; [.32DB.0020.0011.307F] # HIRAGANA LETTER MI
3080      ; [.32DC.0020.0011.3080] # HIRAGANA LETTER MU
3081      ; [.32DD.0020.0011.3081] # HIRAGANA LETTER ME
3082      ; [.32DE.0020.0011.3082] # HIRAGANA LETTER MO
3083      ; [.32DF.0020.000F.3083] # HIRAGANA LETTER SMALL YA
3084      ; [.32DF.0020.0011.3084] # HIRAGANA LETTER YA
3085      ; [.32E0.0020.000F.3085] # HIRAGANA LETTER SMALL YU
3086      ; [.32E0.0020.0011.3086] # HIRAGANA LETTER YU
3087      ; [.32E2.0020.000F.3087] # HIRAGANA LETTER SMALL YO
3088      ; [.32E2.0020.0011.3088] # HIRAGANA LETTER YO
3089      ; [.32E3.0020.0011.3089] # HIRAGANA LETTER RA
308A      ; [.32E4.0020.0011.308A] # HIRAGANA LETTER RI
308B      ; [.32E5.0020.0011.308B] # HIRAGANA LETTER RU
308C      ; [.32E6.0020.0011.308C] # HIRAGANA LETTER RE
308D      ; [.32E7.0020.0011.308D] # HIRAGANA LETTER RO
308E      ; [.32E8.0020.000F.308E] # HIRAGANA LETTER SMALL WA
308F      ; [.32E8.0020.0011.308F] # HIRAGANA LETTER WA
3090      ; [.32E9.0020.0011.3090] # HIRAGANA LETTER WI
3091      ; [.32EA.0020.0011.3091] # HIRAGANA LETTER WE
3092      ; [.32EB.0020.0011.3092] # HIRAGANA LETTER WO
3093      ; [.32EC.0020.0011.3093] # HIRAGANA LETTER N
3094      ; [.32BD.0020.0011.3046][.0000.0128.0002.3099] # HIRAGANA LETTER VU
3095      ; [.32C1.0020.000F.3095] # HIRAGANA LETTER SMALL KA
3096      ; [.32C4.0020.000F.3096] # HIRAGANA LETTER SMALL KE
309D      ; [.15BB.0020.0002.309D] # HIRAGANA ITERATION MARK
309E      ; [.15BB.0020.0002.309D][.0000.0128.0002.3099] # HIRAGANA VOICED ITERATION MARK
3000      ; [*020A.0020.0002.0020] # IDEOGRAPHIC SPACE
FF01      ; [*025E.0020.0002.0021] # FULLWIDTH EXCLAMATION MARK
FF02      ; [*02F1.0020.0002.0022] # FULLWIDTH QUOTATION MARK
FF03      ; [*0376.0020.0002.0023] # FULLWIDTH NUMBER SIGN
FF04      ; [.15BE.0020.0002.0024] # FULLWIDTH DOLLAR SIGN
FF05      ; [*0377.0020.0002.0025] # FULLWIDTH PERCENT SIGN
FF06      ; [*0374.0020.0002.0026] # FULLWIDTH AMPERSAND
FF07      ; [*02EA.0020.0002.0027] # FULLWIDTH APOSTROPHE
FF08      ; [*02FB.0020.0002.0028] # FULLWIDTH LEFT PARENTHESIS
FF09      ; [*02FC.0020.0002.0029] # FULLWIDTH RIGHT PARENTHESIS
FF0A      ; [*036D.0020.0002.002A] # FULLWIDTH ASTERISK
FF0B      ; [*059C.0020.0002.002B] # FULLWIDTH PLUS SIGN
FF0C      ; [*0221.0020.0002.002C] # FULLWIDTH COMMA
FF0D      ; [*020E.0020.0002.002D] # FULLWIDTH HYPHEN-MINUS
FF0E      ; [*0273.0020.0002.002E] # FULLWIDTH FULL STOP
FF0F      ; [*0372.0020.0002.002F] # FULLWIDTH SOLIDUS
FF10      ; [.15E5.0020.0002.0030] # FULLWIDTH DIGIT ZERO
FF11      ; [.15E6.0020.0002.0031] # FULLWIDTH DIGIT ONE
FF12      ; [.15E7.0020.0002.0032] # FULLWIDTH DIGIT TWO
FF13      ; [.15E8.0020.0002.0033] # FULLWIDTH DIGIT THREE
FF14      ; [.15E9.0020.0002.0034] # FULLWIDTH DIGIT FOUR
FF15      ; [.15EA.0020.0002.0035] # FULLWIDTH DIGIT FIVE
FF16      ; [.15EB.0020.0002.0036] # FULLWIDTH DIGIT SIX
FF17      ; [.15EC.0020.0002.0037] # FULLWIDTH DIGIT SEVEN
FF18      ; [.15ED.0020.0002.0038] # FULLWIDTH DIGIT EIGHT
FF19      ; [.15EE.0020.0002.0039] # FULLWIDTH DIGIT NINE
FF1A      ; [*0237.0020.0002.003A] # FULLWIDTH COLON
FF1B      ; [*0232.0020.0002.003B] # FULLWIDTH SEMICOLON
FF1C      ; [*05A0.0020.0002.003C] # FULLWIDTH LESS-THAN SIGN
FF1D      ; [*05A1.0020.0002.003D] # FULLWIDTH EQUALS SIGN
FF1E      ; [*05A2.0020.0002.003E] # FULLWIDTH GREATER-THAN SIGN
FF1F      ; [*0263.0020.0002.003F] # FULLWIDTH QUESTION MARK
FF20      ; [*036C.0020.0002.0040] # FULLWIDTH COMMERCIAL AT
FF21      ; [.15EF.0020.0008.0041] # FULLWIDTH LATIN CAPITAL LETTER A
FF22      ; [.1605.0020.0008.0042] # FULLWIDTH LATIN CAPITAL LETTER B
FF23      ; [.161D.0020.0008.0043] # FULLWIDTH LATIN CAPITAL LETTER C
FF24      ; [.1631.0020.0008.0044] # FULLWIDTH LATIN CAPITAL LETTER D
FF25      ; [.164C.0020.0008.0045] # FULLWIDTH LATIN CAPITAL LETTER E
FF26      ; [.1684.0020.0008.0046] # FULLWIDTH LATIN CAPITAL LETTER F
FF27      ; [.1691.0020.0008.0047] # FULLWIDTH LATIN CAPITAL LETTER G
FF28      ; [.16B4.0020.0008.0048] # FULLWIDTH LATIN CAPITAL LETTER H
FF29      ; [.16CD.0020.0008.0049] # FULLWIDTH LATIN CAPITAL LETTER I
FF2A      ; [.16E6.0020.0008.004A] # FULLWIDTH LATIN CAPITAL LETTER J
FF2B      ; [.16FF.0020.0008.004B] # FULLWIDTH LATIN CAPITAL LETTER K
FF2C      ; [.1711.0020.0008.004C] # FULLWIDTH LATIN CAPITAL LETTER L
FF2D      ; [.1741.0020.0008.004D] # FULLWIDTH LATIN CAPITAL LETTER M
FF2E      ; [.174F.0020.0008.004E] # FULLWIDTH LATIN CAPITAL LETTER N
FF2F      ; [.1771.0020.0008.004F] # FULLWIDTH LATIN CAPITAL LETTER O
FF30      ; [.1796.0020.0008.0050] # FULLWIDTH LATIN CAPITAL LETTER P
FF31      ; [.17AB.0020.0008.0051] # FULLWIDTH LATIN CAPITAL LETTER Q
FF32      ; [.17BD.0020.0008.0052] # FULLWIDTH LATIN CAPITAL LETTER R
FF33      ; [.17F3.0020.0008.0053] # FULLWIDTH LATIN CAPITAL LETTER S
FF34      ; [.1816.0020.0008.0054] # FULLWIDTH LATIN CAPITAL LETTER T
FF35      ; [.1836.0020.0008.0055] # FULLWIDTH LATIN CAPITAL LETTER U
FF36      ; [.185F.0020.0008.0056] # FULLWIDTH LATIN CAPITAL LETTER V
FF37      ; [.1871.0020.0008.0057] # FULLWIDTH LATIN CAPITAL LETTER W
FF38      ; [.187B.0020.0008.0058] # FULLWIDTH LATIN CAPITAL LETTER X
FF39      ; [.1880.0020.0008.0059] # FULLWIDTH LATIN CAPITAL LETTER Y
FF3A      ; [.1895.0020.0008.005A] # FULLWIDTH LATIN CAPITAL LETTER Z
FF3B      ; [*02FD.0020.0002.005B] # FULLWIDTH LEFT SQUARE BRACKET
FF3C      ; [*02EA.0020.0002.0027] # FULLWIDTH REVERSE SOLIDUS
FF3D      ; [*02FE.0020.0002.005D] # FULLWIDTH RIGHT SQUARE BRACKET
FF3E      ; [*0412.0020.0002.005E] # FULLWIDTH CIRCUMFLEX ACCENT
FF3F      ; [*020C.0020.0002.005F] # FULLWIDTH LOW LINE
FF40      ; [*040F.0020.0002.0060] # FULLWIDTH GRAVE ACCENT
FF41      ; [.15EF.0020.0002.0061] # FULLWIDTH LATIN SMALL LETTER A
FF42      ; [.1605.0020.0002.0062] # FULLWIDTH LATIN SMALL LETTER B
FF43      ; [.161D.0020.0002.0063] # FULLWIDTH LATIN SMALL LETTER C
FF44      ; [.1631.0020.0002.0064] # FULLWIDTH LATIN SMALL LETTER D
FF45      ; [.164C.0020.0002.0065] # FULLWIDTH LATIN SMALL LETTER E
FF46      ; [.1684.0020.0002.0066] # FULLWIDTH LATIN SMALL LETTER F
FF47      ; [.1691.0020.0002.0067] # FULLWIDTH LATIN SMALL LETTER G
FF48      ; [.16B4.0020.0002.0068] # FULLWIDTH LATIN SMALL LETTER H
FF49      ; [.16CD.0020.0002.0069] # FULLWIDTH LATIN SMALL LETTER I
FF4A      ; [.16E6.0020.0002.006A] # FULLWIDTH LATIN SMALL LETTER J
FF4B      ; [.16FF.0020.0002.006B] # FULLWIDTH LATIN SMALL LETTER K
FF4C      ; [.1711.0020.0002.006C] # FULLWIDTH LATIN SMALL LETTER L
FF4D      ; [.1741.0020.0002.006D] # FULLWIDTH LATIN SMALL LETTER M
FF4E      ; [.174F.0020.0002.006E] # FULLWIDTH LATIN SMALL LETTER N
FF4F      ; [.1771.0020.0002.006F] # FULLWIDTH LATIN SMALL LETTER O
FF50      ; [.1796.0020.0002.0070] # FULLWIDTH LATIN SMALL LETTER P
FF51      ; [.17AB.0020.0002.0071] # FULLWIDTH LATIN SMALL LETTER Q
FF52      ; [.17BD.0020.0002.0072] # FULLWIDTH LATIN SMALL LETTER R
FF53      ; [.17F3.0020.0002.0073] # FULLWIDTH LATIN SMALL LETTER S
FF54      ; [.1816.0020.0002.0074] # FULLWIDTH LATIN SMALL LETTER T
FF55      ; [.1836.0020.0002.0075] # FULLWIDTH LATIN SMALL LETTER U
FF56      ; [.185F.0020.0002.0076] # FULLWIDTH LATIN SMALL LETTER V
FF57      ; [.1871.0020.0002.0077] # FULLWIDTH LATIN SMALL LETTER W
FF58      ; [.187B.0020.0002.0078] # FULLWIDTH LATIN SMALL LETTER X
FF59      ; [.1880.0020.0002.0079] # FULLWIDTH LATIN SMALL LETTER Y
FF5A      ; [.1895.0020.0002.007A] # FULLWIDTH LATIN SMALL LETTER Z
FF5B      ; [*02FF.0020.0002.007B] # FULLWIDTH LEFT CURLY BRACKET
FF5C      ; [*05A4.0020.0002.007C] # FULLWIDTH VERTICAL LINE
FF5D      ; [*0300.0020.0002.007D] # FULLWIDTH RIGHT CURLY BRACKET
FF5E      ; [*05A6.0020.0002.007E] # FULLWIDTH TILDE
FF5F      ; [*030D.0020.0002.2985] # FULLWIDTH LEFT WHITE PARENTHESIS
FF60      ; [*030E.0020.0002.2986] # FULLWIDTH RIGHT WHITE PARENTHESIS
FF61      ; [*0283.0020.0002.3002] # HALFWIDTH IDEOGRAPHIC FULL STOP
FF62      ; [*0353.0020.0002.300C] # HALFWIDTH LEFT CORNER BRACKET
FF63      ; [*0354.0020.0002.300D] # HALFWIDTH RIGHT CORNER BRACKET
FF64      ; [*022F.0020.0002.3001] # HALFWIDTH IDEOGRAPHIC COMMA
FF65      ; [*0220.0020.0002.30FB] # HALFWIDTH KATAKANA MIDDLE DOT
FF66      ; [.32EB.0020.0011.30F2] # HALFWIDTH KATAKANA LETTER WO
FF67      ; [.32BB.0020.000F.30A1] # HALFWIDTH KATAKANA LETTER SMALL A
FF68      ; [.32BC.0020.000F.30A3] # HALFWIDTH KATAKANA LETTER SMALL I
FF69      ; [.32BD.0020.000F.30A5] # HALFWIDTH KATAKANA LETTER SMALL U
FF6A      ; [.32BF.0020.000F.30A7] # HALFWIDTH KATAKANA LETTER SMALL E
FF6B      ; [.32C0.0020.000F.30A9] # HALFWIDTH KATAKANA LETTER SMALL O
FF6C      ; [.32DF.0020.000F.30E3] # HALFWIDTH KATAKANA LETTER SMALL YA
FF6D      ; [.32E0.0020.000F.30E5] # HALFWIDTH KATAKANA LETTER SMALL YU
FF6E      ; [.32E2.0020.000F.30E7] # HALFWIDTH KATAKANA LETTER SMALL YO
FF6F      ; [.32CD.0020.000F.30C3] # HALFWIDTH KATAKANA LETTER SMALL TU
FF70      ; [.15BA.0020.0002.30FC] # HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK
FF71      ; [.32BB.0020.0011.30A2] # HALFWIDTH KATAKANA LETTER A
FF72      ; [.32BC.0020.0011.30A4] # HALFWIDTH KATAKANA LETTER I
FF73      ; [.32BD.0020.0011.30A6] # HALFWIDTH KATAKANA LETTER U
FF74      ; [.32BF.0020.0011.30A8] # HALFWIDTH KATAKANA LETTER E
FF75      ; [.32C0.0020.0011.30AA] # HALFWIDTH KATAKANA LETTER O
FF76      ; [.32C1.0020.0011.30AB] # HALFWIDTH KATAKANA LETTER KA
FF77      ; [.32C2.0020.0011.30AD] # HALFWIDTH KATAKANA LETTER KI
FF78      ; [.32C3.0020.0011.30AF] # HALFWIDTH KATAKANA LETTER KU
FF79      ; [.32C4.0020.0011.30B1] # HALFWIDTH KATAKANA LETTER KE
FF7A      ; [.32C5.0020.0011.30B3] # HALFWIDTH KATAKANA LETTER KO
FF7B      ; [.32C6.0020.0011.30B5] # HALFWIDTH KATAKANA LETTER SA
FF7C      ; [.32C7.0020.0011.30B7] # HALFWIDTH KATAKANA LETTER SI
FF7D      ; [.32C8.0020.0011.30B9] # HALFWIDTH KATAKANA LETTER SU
FF7E      ; [.32C9.0020.0011.30BB] # HALFWIDTH KATAKANA LETTER SE
FF7F      ; [.32CA.0020.0011.30BD] # HALFWIDTH KATAKANA LETTER SO
FF80      ; [.32CB.0020.0011.30BF] # HALFWIDTH KATAKANA LETTER TA
FF81      ; [.32CC.0020.0011.30C1] # HALFWIDTH KATAKANA LETTER TI
FF82      ; [.32CD.0020.0011.30C4] # HALFWIDTH KATAKANA LETTER TU
FF83      ; [.32CE.0020.0011.30C6] # HALFWIDTH KATAKANA LETTER TE
FF84      ; [.32CF.0020.0011.30C8] # HALFWIDTH KATAKANA LETTER TO
FF85      ; [.32D0.0020.0011.30CA] # HALFWIDTH KATAKANA LETTER NA
FF86      ; [.32D1.0020.0011.30CB] # HALFWIDTH KATAKANA LETTER NI
FF87      ; [.32D2.0020.0011.30CC] # HALFWIDTH KATAKANA LETTER NU
FF88      ; [.32D3.0020.0011.30CD] # HALFWIDTH KATAKANA LETTER NE
FF89      ; [.32D4.0020.0011.30CE] # HALFWIDTH KATAKANA LETTER NO
FF8A      ; [.32D5.0020.0011.30CF] # HALFWIDTH KATAKANA LETTER HA
FF8B      ; [.32D6.0020.0011.30D2] # HALFWIDTH KATAKANA LETTER HI
FF8C      ; [.32D7.0020.0011.30D5] # HALFWIDTH KATAKANA LETTER HU
FF8D      ; [.32D8.0020.0011.30D8] # HALFWIDTH KATAKANA LETTER HE
FF8E      ; [.32D9.0020.0011.30DB] # HALFWIDTH KATAKANA LETTER HO
FF8F      ; [.32DA.0020.0011.30DE] # HALFWIDTH KATAKANA LETTER MA
FF90      ; [.32DB.0020.0011.30DF] # HALFWIDTH KATAKANA LETTER MI
FF91      ; [.32DC.0020.0011.30E0] # HALFWIDTH KATAKANA LETTER MU
FF92      ; [.32DD.0020.0011.30E1] # HALFWIDTH KATAKANA LETTER ME
FF93      ; [.32DE.0020.0011.30E2] # HALFWIDTH KATAKANA LETTER MO
FF94      ; [.32DF.0020.0011.30E4] # HALFWIDTH KATAKANA LETTER YA
FF95      ; [.32E0.0020.0011.30E6] # HALFWIDTH KATAKANA LETTER YU
FF96      ; [.32E2.0020.0011.30E8] # HALFWIDTH KATAKANA LETTER YO
FF97      ; [.32E3.0020.0011.30E9] # HALFWIDTH KATAKANA LETTER RA
FF98      ; [.32E4.0020.0011.30EA] # HALFWIDTH KATAKANA LETTER RI
FF99      ; [.32E5.0020.0011.30EB] # HALFWIDTH KATAKANA LETTER RU
FF9A      ; [.32E6.0020.0011.30EC] # HALFWIDTH KATAKANA LETTER RE
FF9B      ; [.32E7.0020.0011.30ED] # HALFWIDTH KATAKANA LETTER RO
FF9C      ; [.32E8.0020.0011.30EF] # HALFWIDTH KATAKANA LETTER WA
FF9D      ; [.32EC.0020.0011.30F3] # HALFWIDTH KATAKANA LETTER N
FF9E      ; [.0000.0128.0002.3099] # HALFWIDTH KATAKANA VOICED SOUND MARK
FF9F      ; [.0000.0129.0002.309A] # HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK
FFE0      ; [.15BD.0020.0002.00A2] # FULLWIDTH CENT SIGN
FFE1      ; [.15BF.0020.0002.00A3] # FULLWIDTH POUND SIGN
FFE2      ; [*05A3.0020.0002.00AC] # FULLWIDTH NOT SIGN
FFE3      ; [*020A.0020.0002.0020] # FULLWIDTH MACRON
FFE4      ; [*05A5.0020.0002.00A6] # FULLWIDTH BROKEN BAR
FFE5      ; [.15C0.0020.0002.00A5] # FULLWIDTH YEN SIGN
FFE6      ; [.15D3.0020.0002.20A9] # FULLWIDTH WON SIGN
FFE8      ; [*0799.0020.0002.2502] # HALFWIDTH FORMS LIGHT VERTICAL
FFE9      ; [*0522.0020.0002.2190] # HALFWIDTH LEFTWARDS ARROW
FFEA      ; [*0524.0020.0002.2191] # HALFWIDTH UPWARDS ARROW
FFEB      ; [*0523.0020.0002.2192] # HALFWIDTH RIGHTWARDS ARROW
FFEC      ; [*0525.0020.0002.2193] # HALFWIDTH DOWNWARDS ARROW
FFED      ; [*0837.0020.0002.25A0] # HALFWIDTH BLACK SQUARE
FFEE      ; [*0862.0020.0002.25CB] # HALFWIDTH WHITE CIRCLE
30A1 30FC ; [.32BB.0020.000F.30A1][.32BB.0020.0007.30A1] # <KATAKANA LETTER SMALL A, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF67 30FC ; [.32BB.0020.000F.30A1][.32BB.0020.0007.30A1] # <HALFWIDTH KATAKANA LETTER SMALL A, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF67 FF70 ; [.32BB.0020.000F.30A1][.32BB.0020.0007.30A1] # <HALFWIDTH KATAKANA LETTER SMALL A, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3041 30FC ; [.32BB.0020.000F.3041][.32BB.0020.0007.3041] # <HIRAGANA LETTER SMALL A, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30A2 30FC ; [.32BB.0020.0011.30A2][.32BB.0020.0007.30A2] # <KATAKANA LETTER A, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF71 30FC ; [.32BB.0020.0011.30A2][.32BB.0020.0007.30A2] # <HALFWIDTH KATAKANA LETTER A, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF71 FF70 ; [.32BB.0020.0011.30A2][.32BB.0020.0007.30A2] # <HALFWIDTH KATAKANA LETTER A, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3042 30FC ; [.32BB.0020.0011.3042][.32BB.0020.0007.3042] # <HIRAGANA LETTER A, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30AB 30FC ; [.32C1.0020.0011.30AB][.32BB.0020.0007.30AB] # <KATAKANA LETTER KA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF76 30FC ; [.32C1.0020.0011.30AB][.32BB.0020.0007.30AB] # <HALFWIDTH KATAKANA LETTER KA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF76 FF70 ; [.32C1.0020.0011.30AB][.32BB.0020.0007.30AB] # <HALFWIDTH KATAKANA LETTER KA, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
304B 30FC ; [.32C1.0020.0011.304B][.32BB.0020.0007.304B] # <HIRAGANA LETTER KA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30AC 30FC ; [.32C1.0020.0011.30AB][.0000.0128.0002.3099][.32BB.0020.0007.30AC] # <KATAKANA LETTER GA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30AB 3099 30FC ; [.32C1.0020.0011.30AB][.0000.0128.0002.3099][.32BB.0020.0007.30AC] # <KATAKANA LETTER KA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF76 FF9E 30FC ; [.32C1.0020.0011.30AB][.0000.0128.0002.3099][.32BB.0020.0007.30AC] # <HALFWIDTH KATAKANA LETTER KA, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF76 FF9E FF70 ; [.32C1.0020.0011.30AB][.0000.0128.0002.3099][.32BB.0020.0007.30AC] # <HALFWIDTH KATAKANA LETTER KA, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
304C 30FC ; [.32C1.0020.0011.304B][.0000.0128.0002.3099][.32BB.0020.0007.304C] # <HIRAGANA LETTER GA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
304B 3099 30FC ; [.32C1.0020.0011.304B][.0000.0128.0002.3099][.32BB.0020.0007.304C] # <HIRAGANA LETTER KA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30B5 30FC ; [.32C6.0020.0011.30B5][.32BB.0020.0007.30B5] # <KATAKANA LETTER SA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7B 30FC ; [.32C6.0020.0011.30B5][.32BB.0020.0007.30B5] # <HALFWIDTH KATAKANA LETTER SA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7B FF70 ; [.32C6.0020.0011.30B5][.32BB.0020.0007.30B5] # <HALFWIDTH KATAKANA LETTER SA, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3055 30FC ; [.32C6.0020.0011.3055][.32BB.0020.0007.3055] # <HIRAGANA LETTER SA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30B6 30FC ; [.32C6.0020.0011.30B5][.0000.0128.0002.3099][.32BB.0020.0007.30B6] # <KATAKANA LETTER ZA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30B5 3099 30FC ; [.32C6.0020.0011.30B5][.0000.0128.0002.3099][.32BB.0020.0007.30B6] # <KATAKANA LETTER SA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7B FF9E 30FC ; [.32C6.0020.0011.30B5][.0000.0128.0002.3099][.32BB.0020.0007.30B6] # <HALFWIDTH KATAKANA LETTER SA, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7B FF9E FF70 ; [.32C6.0020.0011.30B5][.0000.0128.0002.3099][.32BB.0020.0007.30B6] # <HALFWIDTH KATAKANA LETTER SA, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3056 30FC ; [.32C6.0020.0011.3055][.0000.0128.0002.3099][.32BB.0020.0007.3056] # <HIRAGANA LETTER ZA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3055 3099 30FC ; [.32C6.0020.0011.3055][.0000.0128.0002.3099][.32BB.0020.0007.3056] # <HIRAGANA LETTER SA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30BF 30FC ; [.32CB.0020.0011.30BF][.32BB.0020.0007.30BF] # <KATAKANA LETTER TA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF80 30FC ; [.32CB.0020.0011.30BF][.32BB.0020.0007.30BF] # <HALFWIDTH KATAKANA LETTER TA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF80 FF70 ; [.32CB.0020.0011.30BF][.32BB.0020.0007.30BF] # <HALFWIDTH KATAKANA LETTER TA, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
305F 30FC ; [.32CB.0020.0011.305F][.32BB.0020.0007.305F] # <HIRAGANA LETTER TA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30C0 30FC ; [.32CB.0020.0011.30BF][.0000.0128.0002.3099][.32BB.0020.0007.30C0] # <KATAKANA LETTER DA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30BF 3099 30FC ; [.32CB.0020.0011.30BF][.0000.0128.0002.3099][.32BB.0020.0007.30C0] # <KATAKANA LETTER TA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF80 FF9E 30FC ; [.32CB.0020.0011.30BF][.0000.0128.0002.3099][.32BB.0020.0007.30C0] # <HALFWIDTH KATAKANA LETTER TA, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF80 FF9E FF70 ; [.32CB.0020.0011.30BF][.0000.0128.0002.3099][.32BB.0020.0007.30C0] # <HALFWIDTH KATAKANA LETTER TA, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3060 30FC ; [.32CB.0020.0011.305F][.0000.0128.0002.3099][.32BB.0020.0007.3060] # <HIRAGANA LETTER DA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
305F 3099 30FC ; [.32CB.0020.0011.305F][.0000.0128.0002.3099][.32BB.0020.0007.3060] # <HIRAGANA LETTER TA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30CA 30FC ; [.32D0.0020.0011.30CA][.32BB.0020.0007.30CA] # <KATAKANA LETTER NA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF85 30FC ; [.32D0.0020.0011.30CA][.32BB.0020.0007.30CA] # <HALFWIDTH KATAKANA LETTER NA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF85 FF70 ; [.32D0.0020.0011.30CA][.32BB.0020.0007.30CA] # <HALFWIDTH KATAKANA LETTER NA, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
306A 30FC ; [.32D0.0020.0011.306A][.32BB.0020.0007.306A] # <HIRAGANA LETTER NA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30CF 30FC ; [.32D5.0020.0011.30CF][.32BB.0020.0007.30CF] # <KATAKANA LETTER HA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8A 30FC ; [.32D5.0020.0011.30CF][.32BB.0020.0007.30CF] # <HALFWIDTH KATAKANA LETTER HA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8A FF70 ; [.32D5.0020.0011.30CF][.32BB.0020.0007.30CF] # <HALFWIDTH KATAKANA LETTER HA, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
306F 30FC ; [.32D5.0020.0011.306F][.32BB.0020.0007.306F] # <HIRAGANA LETTER HA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30D0 30FC ; [.32D5.0020.0011.30CF][.0000.0128.0002.3099][.32BB.0020.0007.30D0] # <KATAKANA LETTER BA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30CF 3099 30FC ; [.32D5.0020.0011.30CF][.0000.0128.0002.3099][.32BB.0020.0007.30D0] # <KATAKANA LETTER HA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8A FF9E 30FC ; [.32D5.0020.0011.30CF][.0000.0128.0002.3099][.32BB.0020.0007.30D0] # <HALFWIDTH KATAKANA LETTER HA, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8A FF9E FF70 ; [.32D5.0020.0011.30CF][.0000.0128.0002.3099][.32BB.0020.0007.30D0] # <HALFWIDTH KATAKANA LETTER HA, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3070 30FC ; [.32D5.0020.0011.306F][.0000.0128.0002.3099][.32BB.0020.0007.3070] # <HIRAGANA LETTER BA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
306F 3099 30FC ; [.32D5.0020.0011.306F][.0000.0128.0002.3099][.32BB.0020.0007.3070] # <HIRAGANA LETTER HA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30D1 30FC ; [.32D5.0020.0011.30CF][.0000.0129.0002.309A][.32BB.0020.0007.30D1] # <KATAKANA LETTER PA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30CF 309A 30FC ; [.32D5.0020.0011.30CF][.0000.0129.0002.309A][.32BB.0020.0007.30D1] # <KATAKANA LETTER HA, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8A FF9F 30FC ; [.32D5.0020.0011.30CF][.0000.0129.0002.309A][.32BB.0020.0007.30D1] # <HALFWIDTH KATAKANA LETTER HA, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8A FF9F FF70 ; [.32D5.0020.0011.30CF][.0000.0129.0002.309A][.32BB.0020.0007.30D1] # <HALFWIDTH KATAKANA LETTER HA, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3071 30FC ; [.32D5.0020.0011.306F][.0000.0129.0002.309A][.32BB.0020.0007.3071] # <HIRAGANA LETTER PA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
306F 309A 30FC ; [.32D5.0020.0011.306F][.0000.0129.0002.309A][.32BB.0020.0007.3071] # <HIRAGANA LETTER HA, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30DE 30FC ; [.32DA.0020.0011.30DE][.32BB.0020.0007.30DE] # <KATAKANA LETTER MA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8F 30FC ; [.32DA.0020.0011.30DE][.32BB.0020.0007.30DE] # <HALFWIDTH KATAKANA LETTER MA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8F FF70 ; [.32DA.0020.0011.30DE][.32BB.0020.0007.30DE] # <HALFWIDTH KATAKANA LETTER MA, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
307E 30FC ; [.32DA.0020.0011.307E][.32BB.0020.0007.307E] # <HIRAGANA LETTER MA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30E3 30FC ; [.32DF.0020.000F.30E3][.32BB.0020.0007.30E3] # <KATAKANA LETTER SMALL YA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF6C 30FC ; [.32DF.0020.000F.30E3][.32BB.0020.0007.30E3] # <HALFWIDTH KATAKANA LETTER SMALL YA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF6C FF70 ; [.32DF.0020.000F.30E3][.32BB.0020.0007.30E3] # <HALFWIDTH KATAKANA LETTER SMALL YA, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3083 30FC ; [.32DF.0020.000F.3083][.32BB.0020.0007.3083] # <HIRAGANA LETTER SMALL YA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30E4 30FC ; [.32DF.0020.0011.30E4][.32BB.0020.0007.30E4] # <KATAKANA LETTER YA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF94 30FC ; [.32DF.0020.0011.30E4][.32BB.0020.0007.30E4] # <HALFWIDTH KATAKANA LETTER YA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF94 FF70 ; [.32DF.0020.0011.30E4][.32BB.0020.0007.30E4] # <HALFWIDTH KATAKANA LETTER YA, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3084 30FC ; [.32DF.0020.0011.3084][.32BB.0020.0007.3084] # <HIRAGANA LETTER YA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30E9 30FC ; [.32E3.0020.0011.30E9][.32BB.0020.0007.30E9] # <KATAKANA LETTER RA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF97 30FC ; [.32E3.0020.0011.30E9][.32BB.0020.0007.30E9] # <HALFWIDTH KATAKANA LETTER RA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF97 FF70 ; [.32E3.0020.0011.30E9][.32BB.0020.0007.30E9] # <HALFWIDTH KATAKANA LETTER RA, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3089 30FC ; [.32E3.0020.0011.3089][.32BB.0020.0007.3089] # <HIRAGANA LETTER RA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30EE 30FC ; [.32E8.0020.000F.30EE][.32BB.0020.0007.30EE] # <KATAKANA LETTER SMALL WA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
308E 30FC ; [.32E8.0020.000F.308E][.32BB.0020.0007.308E] # <HIRAGANA LETTER SMALL WA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30EF 30FC ; [.32E8.0020.0011.30EF][.32BB.0020.0007.30EF] # <KATAKANA LETTER WA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF9C 30FC ; [.32E8.0020.0011.30EF][.32BB.0020.0007.30EF] # <HALFWIDTH KATAKANA LETTER WA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF9C FF70 ; [.32E8.0020.0011.30EF][.32BB.0020.0007.30EF] # <HALFWIDTH KATAKANA LETTER WA, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
308F 30FC ; [.32E8.0020.0011.308F][.32BB.0020.0007.308F] # <HIRAGANA LETTER WA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30F7 30FC ; [.32E8.0020.0011.30EF][.0000.0128.0002.3099][.32BB.0020.0007.30F7] # <KATAKANA LETTER VA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30EF 3099 30FC ; [.32E8.0020.0011.30EF][.0000.0128.0002.3099][.32BB.0020.0007.30F7] # <KATAKANA LETTER WA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF9C FF9E 30FC ; [.32E8.0020.0011.30EF][.0000.0128.0002.3099][.32BB.0020.0007.30F7] # <HALFWIDTH KATAKANA LETTER WA, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF9C FF9E FF70 ; [.32E8.0020.0011.30EF][.0000.0128.0002.3099][.32BB.0020.0007.30F7] # <HALFWIDTH KATAKANA LETTER WA, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30F5 30FC ; [.32C1.0020.000F.30F5][.32BB.0020.0007.30F5] # <KATAKANA LETTER SMALL KA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3095 30FC ; [.32C1.0020.000F.3095][.32BB.0020.0007.3095] # <HIRAGANA LETTER SMALL KA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
31F5 30FC ; [.32D5.0020.000F.31F5][.32BB.0020.0007.31F5] # <KATAKANA LETTER SMALL HA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
31FB 30FC ; [.32E3.0020.000F.31FB][.32BB.0020.0007.31FB] # <KATAKANA LETTER SMALL RA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30A3 30FC ; [.32BC.0020.000F.30A3][.32BC.0020.0007.30A3] # <KATAKANA LETTER SMALL I, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF68 30FC ; [.32BC.0020.000F.30A3][.32BC.0020.0007.30A3] # <HALFWIDTH KATAKANA LETTER SMALL I, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF68 FF70 ; [.32BC.0020.000F.30A3][.32BC.0020.0007.30A3] # <HALFWIDTH KATAKANA LETTER SMALL I, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3043 30FC ; [.32BC.0020.000F.3043][.32BC.0020.0007.3043] # <HIRAGANA LETTER SMALL I, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30A4 30FC ; [.32BC.0020.0011.30A4][.32BC.0020.0007.30A4] # <KATAKANA LETTER I, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF72 30FC ; [.32BC.0020.0011.30A4][.32BC.0020.0007.30A4] # <HALFWIDTH KATAKANA LETTER I, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF72 FF70 ; [.32BC.0020.0011.30A4][.32BC.0020.0007.30A4] # <HALFWIDTH KATAKANA LETTER I, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3044 30FC ; [.32BC.0020.0011.3044][.32BC.0020.0007.3044] # <HIRAGANA LETTER I, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30AD 30FC ; [.32C2.0020.0011.30AD][.32BC.0020.0007.30AD] # <KATAKANA LETTER KI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF77 30FC ; [.32C2.0020.0011.30AD][.32BC.0020.0007.30AD] # <HALFWIDTH KATAKANA LETTER KI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF77 FF70 ; [.32C2.0020.0011.30AD][.32BC.0020.0007.30AD] # <HALFWIDTH KATAKANA LETTER KI, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
304D 30FC ; [.32C2.0020.0011.304D][.32BC.0020.0007.304D] # <HIRAGANA LETTER KI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30AE 30FC ; [.32C2.0020.0011.30AD][.0000.0128.0002.3099][.32BC.0020.0007.30AE] # <KATAKANA LETTER GI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30AD 3099 30FC ; [.32C2.0020.0011.30AD][.0000.0128.0002.3099][.32BC.0020.0007.30AE] # <KATAKANA LETTER KI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF77 FF9E 30FC ; [.32C2.0020.0011.30AD][.0000.0128.0002.3099][.32BC.0020.0007.30AE] # <HALFWIDTH KATAKANA LETTER KI, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF77 FF9E FF70 ; [.32C2.0020.0011.30AD][.0000.0128.0002.3099][.32BC.0020.0007.30AE] # <HALFWIDTH KATAKANA LETTER KI, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
304E 30FC ; [.32C2.0020.0011.304D][.0000.0128.0002.3099][.32BC.0020.0007.304E] # <HIRAGANA LETTER GI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
304D 3099 30FC ; [.32C2.0020.0011.304D][.0000.0128.0002.3099][.32BC.0020.0007.304E] # <HIRAGANA LETTER KI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30B7 30FC ; [.32C7.0020.0011.30B7][.32BC.0020.0007.30B7] # <KATAKANA LETTER SI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7C 30FC ; [.32C7.0020.0011.30B7][.32BC.0020.0007.30B7] # <HALFWIDTH KATAKANA LETTER SI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7C FF70 ; [.32C7.0020.0011.30B7][.32BC.0020.0007.30B7] # <HALFWIDTH KATAKANA LETTER SI, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3057 30FC ; [.32C7.0020.0011.3057][.32BC.0020.0007.3057] # <HIRAGANA LETTER SI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30B8 30FC ; [.32C7.0020.0011.30B7][.0000.0128.0002.3099][.32BC.0020.0007.30B8] # <KATAKANA LETTER ZI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30B7 3099 30FC ; [.32C7.0020.0011.30B7][.0000.0128.0002.3099][.32BC.0020.0007.30B8] # <KATAKANA LETTER SI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7C FF9E 30FC ; [.32C7.0020.0011.30B7][.0000.0128.0002.3099][.32BC.0020.0007.30B8] # <HALFWIDTH KATAKANA LETTER SI, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7C FF9E FF70 ; [.32C7.0020.0011.30B7][.0000.0128.0002.3099][.32BC.0020.0007.30B8] # <HALFWIDTH KATAKANA LETTER SI, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3058 30FC ; [.32C7.0020.0011.3057][.0000.0128.0002.3099][.32BC.0020.0007.3058] # <HIRAGANA LETTER ZI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3057 3099 30FC ; [.32C7.0020.0011.3057][.0000.0128.0002.3099][.32BC.0020.0007.3058] # <HIRAGANA LETTER SI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30C1 30FC ; [.32CC.0020.0011.30C1][.32BC.0020.0007.30C1] # <KATAKANA LETTER TI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF81 30FC ; [.32CC.0020.0011.30C1][.32BC.0020.0007.30C1] # <HALFWIDTH KATAKANA LETTER TI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF81 FF70 ; [.32CC.0020.0011.30C1][.32BC.0020.0007.30C1] # <HALFWIDTH KATAKANA LETTER TI, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3061 30FC ; [.32CC.0020.0011.3061][.32BC.0020.0007.3061] # <HIRAGANA LETTER TI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30C2 30FC ; [.32CC.0020.0011.30C1][.0000.0128.0002.3099][.32BC.0020.0007.30C2] # <KATAKANA LETTER DI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30C1 3099 30FC ; [.32CC.0020.0011.30C1][.0000.0128.0002.3099][.32BC.0020.0007.30C2] # <KATAKANA LETTER TI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF81 FF9E 30FC ; [.32CC.0020.0011.30C1][.0000.0128.0002.3099][.32BC.0020.0007.30C2] # <HALFWIDTH KATAKANA LETTER TI, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF81 FF9E FF70 ; [.32CC.0020.0011.30C1][.0000.0128.0002.3099][.32BC.0020.0007.30C2] # <HALFWIDTH KATAKANA LETTER TI, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3062 30FC ; [.32CC.0020.0011.3061][.0000.0128.0002.3099][.32BC.0020.0007.3062] # <HIRAGANA LETTER DI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3061 3099 30FC ; [.32CC.0020.0011.3061][.0000.0128.0002.3099][.32BC.0020.0007.3062] # <HIRAGANA LETTER TI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30CB 30FC ; [.32D1.0020.0011.30CB][.32BC.0020.0007.30CB] # <KATAKANA LETTER NI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF86 30FC ; [.32D1.0020.0011.30CB][.32BC.0020.0007.30CB] # <HALFWIDTH KATAKANA LETTER NI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF86 FF70 ; [.32D1.0020.0011.30CB][.32BC.0020.0007.30CB] # <HALFWIDTH KATAKANA LETTER NI, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
306B 30FC ; [.32D1.0020.0011.306B][.32BC.0020.0007.306B] # <HIRAGANA LETTER NI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30D2 30FC ; [.32D6.0020.0011.30D2][.32BC.0020.0007.30D2] # <KATAKANA LETTER HI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8B 30FC ; [.32D6.0020.0011.30D2][.32BC.0020.0007.30D2] # <HALFWIDTH KATAKANA LETTER HI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8B FF70 ; [.32D6.0020.0011.30D2][.32BC.0020.0007.30D2] # <HALFWIDTH KATAKANA LETTER HI, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3072 30FC ; [.32D6.0020.0011.3072][.32BC.0020.0007.3072] # <HIRAGANA LETTER HI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30D3 30FC ; [.32D6.0020.0011.30D2][.0000.0128.0002.3099][.32BC.0020.0007.30D3] # <KATAKANA LETTER BI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30D2 3099 30FC ; [.32D6.0020.0011.30D2][.0000.0128.0002.3099][.32BC.0020.0007.30D3] # <KATAKANA LETTER HI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8B FF9E 30FC ; [.32D6.0020.0011.30D2][.0000.0128.0002.3099][.32BC.0020.0007.30D3] # <HALFWIDTH KATAKANA LETTER HI, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8B FF9E FF70 ; [.32D6.0020.0011.30D2][.0000.0128.0002.3099][.32BC.0020.0007.30D3] # <HALFWIDTH KATAKANA LETTER HI, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3073 30FC ; [.32D6.0020.0011.3072][.0000.0128.0002.3099][.32BC.0020.0007.3073] # <HIRAGANA LETTER BI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3072 3099 30FC ; [.32D6.0020.0011.3072][.0000.0128.0002.3099][.32BC.0020.0007.3073] # <HIRAGANA LETTER HI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30D4 30FC ; [.32D6.0020.0011.30D2][.0000.0129.0002.309A][.32BC.0020.0007.30D4] # <KATAKANA LETTER PI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30D2 309A 30FC ; [.32D6.0020.0011.30D2][.0000.0129.0002.309A][.32BC.0020.0007.30D4] # <KATAKANA LETTER HI, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8B FF9F 30FC ; [.32D6.0020.0011.30D2][.0000.0129.0002.309A][.32BC.0020.0007.30D4] # <HALFWIDTH KATAKANA LETTER HI, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8B FF9F FF70 ; [.32D6.0020.0011.30D2][.0000.0129.0002.309A][.32BC.0020.0007.30D4] # <HALFWIDTH KATAKANA LETTER HI, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3074 30FC ; [.32D6.0020.0011.3072][.0000.0129.0002.309A][.32BC.0020.0007.3074] # <HIRAGANA LETTER PI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3072 309A 30FC ; [.32D6.0020.0011.3072][.0000.0129.0002.309A][.32BC.0020.0007.3074] # <HIRAGANA LETTER HI, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30DF 30FC ; [.32DB.0020.0011.30DF][.32BC.0020.0007.30DF] # <KATAKANA LETTER MI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF90 30FC ; [.32DB.0020.0011.30DF][.32BC.0020.0007.30DF] # <HALFWIDTH KATAKANA LETTER MI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF90 FF70 ; [.32DB.0020.0011.30DF][.32BC.0020.0007.30DF] # <HALFWIDTH KATAKANA LETTER MI, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
307F 30FC ; [.32DB.0020.0011.307F][.32BC.0020.0007.307F] # <HIRAGANA LETTER MI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30EA 30FC ; [.32E4.0020.0011.30EA][.32BC.0020.0007.30EA] # <KATAKANA LETTER RI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF98 30FC ; [.32E4.0020.0011.30EA][.32BC.0020.0007.30EA] # <HALFWIDTH KATAKANA LETTER RI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF98 FF70 ; [.32E4.0020.0011.30EA][.32BC.0020.0007.30EA] # <HALFWIDTH KATAKANA LETTER RI, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
308A 30FC ; [.32E4.0020.0011.308A][.32BC.0020.0007.308A] # <HIRAGANA LETTER RI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30F0 30FC ; [.32E9.0020.0011.30F0][.32BC.0020.0007.30F0] # <KATAKANA LETTER WI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3090 30FC ; [.32E9.0020.0011.3090][.32BC.0020.0007.3090] # <HIRAGANA LETTER WI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30F8 30FC ; [.32E9.0020.0011.30F0][.0000.0128.0002.3099][.32BC.0020.0007.30F8] # <KATAKANA LETTER VI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30F0 3099 30FC ; [.32E9.0020.0011.30F0][.0000.0128.0002.3099][.32BC.0020.0007.30F8] # <KATAKANA LETTER WI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
31F1 30FC ; [.32C7.0020.000F.31F1][.32BC.0020.0007.31F1] # <KATAKANA LETTER SMALL SI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
31F6 30FC ; [.32D6.0020.000F.31F6][.32BC.0020.0007.31F6] # <KATAKANA LETTER SMALL HI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
31FC 30FC ; [.32E4.0020.000F.31FC][.32BC.0020.0007.31FC] # <KATAKANA LETTER SMALL RI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30A5 30FC ; [.32BD.0020.000F.30A5][.32BD.0020.0007.30A5] # <KATAKANA LETTER SMALL U, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF69 30FC ; [.32BD.0020.000F.30A5][.32BD.0020.0007.30A5] # <HALFWIDTH KATAKANA LETTER SMALL U, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF69 FF70 ; [.32BD.0020.000F.30A5][.32BD.0020.0007.30A5] # <HALFWIDTH KATAKANA LETTER SMALL U, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3045 30FC ; [.32BD.0020.000F.3045][.32BD.0020.0007.3045] # <HIRAGANA LETTER SMALL U, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30A6 30FC ; [.32BD.0020.0011.30A6][.32BD.0020.0007.30A6] # <KATAKANA LETTER U, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF73 30FC ; [.32BD.0020.0011.30A6][.32BD.0020.0007.30A6] # <HALFWIDTH KATAKANA LETTER U, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF73 FF70 ; [.32BD.0020.0011.30A6][.32BD.0020.0007.30A6] # <HALFWIDTH KATAKANA LETTER U, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3046 30FC ; [.32BD.0020.0011.3046][.32BD.0020.0007.3046] # <HIRAGANA LETTER U, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30AF 30FC ; [.32C3.0020.0011.30AF][.32BD.0020.0007.30AF] # <KATAKANA LETTER KU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF78 30FC ; [.32C3.0020.0011.30AF][.32BD.0020.0007.30AF] # <HALFWIDTH KATAKANA LETTER KU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF78 FF70 ; [.32C3.0020.0011.30AF][.32BD.0020.0007.30AF] # <HALFWIDTH KATAKANA LETTER KU, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
304F 30FC ; [.32C3.0020.0011.304F][.32BD.0020.0007.304F] # <HIRAGANA LETTER KU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30B0 30FC ; [.32C3.0020.0011.30AF][.0000.0128.0002.3099][.32BD.0020.0007.30B0] # <KATAKANA LETTER GU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30AF 3099 30FC ; [.32C3.0020.0011.30AF][.0000.0128.0002.3099][.32BD.0020.0007.30B0] # <KATAKANA LETTER KU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF78 FF9E 30FC ; [.32C3.0020.0011.30AF][.0000.0128.0002.3099][.32BD.0020.0007.30B0] # <HALFWIDTH KATAKANA LETTER KU, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF78 FF9E FF70 ; [.32C3.0020.0011.30AF][.0000.0128.0002.3099][.32BD.0020.0007.30B0] # <HALFWIDTH KATAKANA LETTER KU, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3050 30FC ; [.32C3.0020.0011.304F][.0000.0128.0002.3099][.32BD.0020.0007.3050] # <HIRAGANA LETTER GU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
304F 3099 30FC ; [.32C3.0020.0011.304F][.0000.0128.0002.3099][.32BD.0020.0007.3050] # <HIRAGANA LETTER KU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30B9 30FC ; [.32C8.0020.0011.30B9][.32BD.0020.0007.30B9] # <KATAKANA LETTER SU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7D 30FC ; [.32C8.0020.0011.30B9][.32BD.0020.0007.30B9] # <HALFWIDTH KATAKANA LETTER SU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7D FF70 ; [.32C8.0020.0011.30B9][.32BD.0020.0007.30B9] # <HALFWIDTH KATAKANA LETTER SU, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3059 30FC ; [.32C8.0020.0011.3059][.32BD.0020.0007.3059] # <HIRAGANA LETTER SU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30BA 30FC ; [.32C8.0020.0011.30B9][.0000.0128.0002.3099][.32BD.0020.0007.30BA] # <KATAKANA LETTER ZU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30B9 3099 30FC ; [.32C8.0020.0011.30B9][.0000.0128.0002.3099][.32BD.0020.0007.30BA] # <KATAKANA LETTER SU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7D FF9E 30FC ; [.32C8.0020.0011.30B9][.0000.0128.0002.3099][.32BD.0020.0007.30BA] # <HALFWIDTH KATAKANA LETTER SU, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7D FF9E FF70 ; [.32C8.0020.0011.30B9][.0000.0128.0002.3099][.32BD.0020.0007.30BA] # <HALFWIDTH KATAKANA LETTER SU, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
305A 30FC ; [.32C8.0020.0011.3059][.0000.0128.0002.3099][.32BD.0020.0007.305A] # <HIRAGANA LETTER ZU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3059 3099 30FC ; [.32C8.0020.0011.3059][.0000.0128.0002.3099][.32BD.0020.0007.305A] # <HIRAGANA LETTER SU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30C3 30FC ; [.32CD.0020.000F.30C3][.32BD.0020.0007.30C3] # <KATAKANA LETTER SMALL TU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF6F 30FC ; [.32CD.0020.000F.30C3][.32BD.0020.0007.30C3] # <HALFWIDTH KATAKANA LETTER SMALL TU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF6F FF70 ; [.32CD.0020.000F.30C3][.32BD.0020.0007.30C3] # <HALFWIDTH KATAKANA LETTER SMALL TU, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3063 30FC ; [.32CD.0020.000F.3063][.32BD.0020.0007.3063] # <HIRAGANA LETTER SMALL TU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30C4 30FC ; [.32CD.0020.0011.30C4][.32BD.0020.0007.30C4] # <KATAKANA LETTER TU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF82 30FC ; [.32CD.0020.0011.30C4][.32BD.0020.0007.30C4] # <HALFWIDTH KATAKANA LETTER TU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF82 FF70 ; [.32CD.0020.0011.30C4][.32BD.0020.0007.30C4] # <HALFWIDTH KATAKANA LETTER TU, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3064 30FC ; [.32CD.0020.0011.3064][.32BD.0020.0007.3064] # <HIRAGANA LETTER TU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30C5 30FC ; [.32CD.0020.0011.30C4][.0000.0128.0002.3099][.32BD.0020.0007.30C5] # <KATAKANA LETTER DU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30C4 3099 30FC ; [.32CD.0020.0011.30C4][.0000.0128.0002.3099][.32BD.0020.0007.30C5] # <KATAKANA LETTER TU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF82 FF9E 30FC ; [.32CD.0020.0011.30C4][.0000.0128.0002.3099][.32BD.0020.0007.30C5] # <HALFWIDTH KATAKANA LETTER TU, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF82 FF9E FF70 ; [.32CD.0020.0011.30C4][.0000.0128.0002.3099][.32BD.0020.0007.30C5] # <HALFWIDTH KATAKANA LETTER TU, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3065 30FC ; [.32CD.0020.0011.3064][.0000.0128.0002.3099][.32BD.0020.0007.3065] # <HIRAGANA LETTER DU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3064 3099 30FC ; [.32CD.0020.0011.3064][.0000.0128.0002.3099][.32BD.0020.0007.3065] # <HIRAGANA LETTER TU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30CC 30FC ; [.32D2.0020.0011.30CC][.32BD.0020.0007.30CC] # <KATAKANA LETTER NU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF87 30FC ; [.32D2.0020.0011.30CC][.32BD.0020.0007.30CC] # <HALFWIDTH KATAKANA LETTER NU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF87 FF70 ; [.32D2.0020.0011.30CC][.32BD.0020.0007.30CC] # <HALFWIDTH KATAKANA LETTER NU, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
306C 30FC ; [.32D2.0020.0011.306C][.32BD.0020.0007.306C] # <HIRAGANA LETTER NU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30D5 30FC ; [.32D7.0020.0011.30D5][.32BD.0020.0007.30D5] # <KATAKANA LETTER HU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8C 30FC ; [.32D7.0020.0011.30D5][.32BD.0020.0007.30D5] # <HALFWIDTH KATAKANA LETTER HU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8C FF70 ; [.32D7.0020.0011.30D5][.32BD.0020.0007.30D5] # <HALFWIDTH KATAKANA LETTER HU, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3075 30FC ; [.32D7.0020.0011.3075][.32BD.0020.0007.3075] # <HIRAGANA LETTER HU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30D6 30FC ; [.32D7.0020.0011.30D5][.0000.0128.0002.3099][.32BD.0020.0007.30D6] # <KATAKANA LETTER BU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30D5 3099 30FC ; [.32D7.0020.0011.30D5][.0000.0128.0002.3099][.32BD.0020.0007.30D6] # <KATAKANA LETTER HU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8C FF9E 30FC ; [.32D7.0020.0011.30D5][.0000.0128.0002.3099][.32BD.0020.0007.30D6] # <HALFWIDTH KATAKANA LETTER HU, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8C FF9E FF70 ; [.32D7.0020.0011.30D5][.0000.0128.0002.3099][.32BD.0020.0007.30D6] # <HALFWIDTH KATAKANA LETTER HU, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3076 30FC ; [.32D7.0020.0011.3075][.0000.0128.0002.3099][.32BD.0020.0007.3076] # <HIRAGANA LETTER BU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3075 3099 30FC ; [.32D7.0020.0011.3075][.0000.0128.0002.3099][.32BD.0020.0007.3076] # <HIRAGANA LETTER HU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30D7 30FC ; [.32D7.0020.0011.30D5][.0000.0129.0002.309A][.32BD.0020.0007.30D7] # <KATAKANA LETTER PU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30D5 309A 30FC ; [.32D7.0020.0011.30D5][.0000.0129.0002.309A][.32BD.0020.0007.30D7] # <KATAKANA LETTER HU, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8C FF9F 30FC ; [.32D7.0020.0011.30D5][.0000.0129.0002.309A][.32BD.0020.0007.30D7] # <HALFWIDTH KATAKANA LETTER HU, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8C FF9F FF70 ; [.32D7.0020.0011.30D5][.0000.0129.0002.309A][.32BD.0020.0007.30D7] # <HALFWIDTH KATAKANA LETTER HU, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3077 30FC ; [.32D7.0020.0011.3075][.0000.0129.0002.309A][.32BD.0020.0007.3077] # <HIRAGANA LETTER PU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3075 309A 30FC ; [.32D7.0020.0011.3075][.0000.0129.0002.309A][.32BD.0020.0007.3077] # <HIRAGANA LETTER HU, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30E0 30FC ; [.32DC.0020.0011.30E0][.32BD.0020.0007.30E0] # <KATAKANA LETTER MU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF91 30FC ; [.32DC.0020.0011.30E0][.32BD.0020.0007.30E0] # <HALFWIDTH KATAKANA LETTER MU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF91 FF70 ; [.32DC.0020.0011.30E0][.32BD.0020.0007.30E0] # <HALFWIDTH KATAKANA LETTER MU, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3080 30FC ; [.32DC.0020.0011.3080][.32BD.0020.0007.3080] # <HIRAGANA LETTER MU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30E5 30FC ; [.32E0.0020.000F.30E5][.32BD.0020.0007.30E5] # <KATAKANA LETTER SMALL YU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF6D 30FC ; [.32E0.0020.000F.30E5][.32BD.0020.0007.30E5] # <HALFWIDTH KATAKANA LETTER SMALL YU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF6D FF70 ; [.32E0.0020.000F.30E5][.32BD.0020.0007.30E5] # <HALFWIDTH KATAKANA LETTER SMALL YU, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3085 30FC ; [.32E0.0020.000F.3085][.32BD.0020.0007.3085] # <HIRAGANA LETTER SMALL YU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30E6 30FC ; [.32E0.0020.0011.30E6][.32BD.0020.0007.30E6] # <KATAKANA LETTER YU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF95 30FC ; [.32E0.0020.0011.30E6][.32BD.0020.0007.30E6] # <HALFWIDTH KATAKANA LETTER YU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF95 FF70 ; [.32E0.0020.0011.30E6][.32BD.0020.0007.30E6] # <HALFWIDTH KATAKANA LETTER YU, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3086 30FC ; [.32E0.0020.0011.3086][.32BD.0020.0007.3086] # <HIRAGANA LETTER YU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30EB 30FC ; [.32E5.0020.0011.30EB][.32BD.0020.0007.30EB] # <KATAKANA LETTER RU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF99 30FC ; [.32E5.0020.0011.30EB][.32BD.0020.0007.30EB] # <HALFWIDTH KATAKANA LETTER RU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF99 FF70 ; [.32E5.0020.0011.30EB][.32BD.0020.0007.30EB] # <HALFWIDTH KATAKANA LETTER RU, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
308B 30FC ; [.32E5.0020.0011.308B][.32BD.0020.0007.308B] # <HIRAGANA LETTER RU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30F4 30FC ; [.32BD.0020.0011.30A6][.0000.0128.0002.3099][.32BD.0020.0007.30F4] # <KATAKANA LETTER VU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30A6 3099 30FC ; [.32BD.0020.0011.30A6][.0000.0128.0002.3099][.32BD.0020.0007.30F4] # <KATAKANA LETTER U, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF73 FF9E 30FC ; [.32BD.0020.0011.30A6][.0000.0128.0002.3099][.32BD.0020.0007.30F4] # <HALFWIDTH KATAKANA LETTER U, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF73 FF9E FF70 ; [.32BD.0020.0011.30A6][.0000.0128.0002.3099][.32BD.0020.0007.30F4] # <HALFWIDTH KATAKANA LETTER U, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3094 30FC ; [.32BD.0020.0011.3046][.0000.0128.0002.3099][.32BD.0020.0007.3094] # <HIRAGANA LETTER VU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3046 3099 30FC ; [.32BD.0020.0011.3046][.0000.0128.0002.3099][.32BD.0020.0007.3094] # <HIRAGANA LETTER U, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
31F0 30FC ; [.32C3.0020.000F.31F0][.32BD.0020.0007.31F0] # <KATAKANA LETTER SMALL KU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
31F2 30FC ; [.32C8.0020.000F.31F2][.32BD.0020.0007.31F2] # <KATAKANA LETTER SMALL SU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
31F4 30FC ; [.32D2.0020.000F.31F4][.32BD.0020.0007.31F4] # <KATAKANA LETTER SMALL NU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
31F7 30FC ; [.32D7.0020.000F.31F7][.32BD.0020.0007.31F7] # <KATAKANA LETTER SMALL HU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
31FA 30FC ; [.32DC.0020.000F.31FA][.32BD.0020.0007.31FA] # <KATAKANA LETTER SMALL MU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
31FD 30FC ; [.32E5.0020.000F.31FD][.32BD.0020.0007.31FD] # <KATAKANA LETTER SMALL RU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30A7 30FC ; [.32BF.0020.000F.30A7][.32BF.0020.0007.30A7] # <KATAKANA LETTER SMALL E, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF6A 30FC ; [.32BF.0020.000F.30A7][.32BF.0020.0007.30A7] # <HALFWIDTH KATAKANA LETTER SMALL E, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF6A FF70 ; [.32BF.0020.000F.30A7][.32BF.0020.0007.30A7] # <HALFWIDTH KATAKANA LETTER SMALL E, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3047 30FC ; [.32BF.0020.000F.3047][.32BF.0020.0007.3047] # <HIRAGANA LETTER SMALL E, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30A8 30FC ; [.32BF.0020.0011.30A8][.32BF.0020.0007.30A8] # <KATAKANA LETTER E, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF74 30FC ; [.32BF.0020.0011.30A8][.32BF.0020.0007.30A8] # <HALFWIDTH KATAKANA LETTER E, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF74 FF70 ; [.32BF.0020.0011.30A8][.32BF.0020.0007.30A8] # <HALFWIDTH KATAKANA LETTER E, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3048 30FC ; [.32BF.0020.0011.3048][.32BF.0020.0007.3048] # <HIRAGANA LETTER E, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30B1 30FC ; [.32C4.0020.0011.30B1][.32BF.0020.0007.30B1] # <KATAKANA LETTER KE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF79 30FC ; [.32C4.0020.0011.30B1][.32BF.0020.0007.30B1] # <HALFWIDTH KATAKANA LETTER KE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF79 FF70 ; [.32C4.0020.0011.30B1][.32BF.0020.0007.30B1] # <HALFWIDTH KATAKANA LETTER KE, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3051 30FC ; [.32C4.0020.0011.3051][.32BF.0020.0007.3051] # <HIRAGANA LETTER KE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30B2 30FC ; [.32C4.0020.0011.30B1][.0000.0128.0002.3099][.32BF.0020.0007.30B2] # <KATAKANA LETTER GE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30B1 3099 30FC ; [.32C4.0020.0011.30B1][.0000.0128.0002.3099][.32BF.0020.0007.30B2] # <KATAKANA LETTER KE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF79 FF9E 30FC ; [.32C4.0020.0011.30B1][.0000.0128.0002.3099][.32BF.0020.0007.30B2] # <HALFWIDTH KATAKANA LETTER KE, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF79 FF9E FF70 ; [.32C4.0020.0011.30B1][.0000.0128.0002.3099][.32BF.0020.0007.30B2] # <HALFWIDTH KATAKANA LETTER KE, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3052 30FC ; [.32C4.0020.0011.3051][.0000.0128.0002.3099][.32BF.0020.0007.3052] # <HIRAGANA LETTER GE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3051 3099 30FC ; [.32C4.0020.0011.3051][.0000.0128.0002.3099][.32BF.0020.0007.3052] # <HIRAGANA LETTER KE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30BB 30FC ; [.32C9.0020.0011.30BB][.32BF.0020.0007.30BB] # <KATAKANA LETTER SE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7E 30FC ; [.32C9.0020.0011.30BB][.32BF.0020.0007.30BB] # <HALFWIDTH KATAKANA LETTER SE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7E FF70 ; [.32C9.0020.0011.30BB][.32BF.0020.0007.30BB] # <HALFWIDTH KATAKANA LETTER SE, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
305B 30FC ; [.32C9.0020.0011.305B][.32BF.0020.0007.305B] # <HIRAGANA LETTER SE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30BC 30FC ; [.32C9.0020.0011.30BB][.0000.0128.0002.3099][.32BF.0020.0007.30BC] # <KATAKANA LETTER ZE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30BB 3099 30FC ; [.32C9.0020.0011.30BB][.0000.0128.0002.3099][.32BF.0020.0007.30BC] # <KATAKANA LETTER SE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7E FF9E 30FC ; [.32C9.0020.0011.30BB][.0000.0128.0002.3099][.32BF.0020.0007.30BC] # <HALFWIDTH KATAKANA LETTER SE, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7E FF9E FF70 ; [.32C9.0020.0011.30BB][.0000.0128.0002.3099][.32BF.0020.0007.30BC] # <HALFWIDTH KATAKANA LETTER SE, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
305C 30FC ; [.32C9.0020.0011.305B][.0000.0128.0002.3099][.32BF.0020.0007.305C] # <HIRAGANA LETTER ZE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
305B 3099 30FC ; [.32C9.0020.0011.305B][.0000.0128.0002.3099][.32BF.0020.0007.305C] # <HIRAGANA LETTER SE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30C6 30FC ; [.32CE.0020.0011.30C6][.32BF.0020.0007.30C6] # <KATAKANA LETTER TE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF83 30FC ; [.32CE.0020.0011.30C6][.32BF.0020.0007.30C6] # <HALFWIDTH KATAKANA LETTER TE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF83 FF70 ; [.32CE.0020.0011.30C6][.32BF.0020.0007.30C6] # <HALFWIDTH KATAKANA LETTER TE, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3066 30FC ; [.32CE.0020.0011.3066][.32BF.0020.0007.3066] # <HIRAGANA LETTER TE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30C7 30FC ; [.32CE.0020.0011.30C6][.0000.0128.0002.3099][.32BF.0020.0007.30C7] # <KATAKANA LETTER DE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30C6 3099 30FC ; [.32CE.0020.0011.30C6][.0000.0128.0002.3099][.32BF.0020.0007.30C7] # <KATAKANA LETTER TE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF83 FF9E 30FC ; [.32CE.0020.0011.30C6][.0000.0128.0002.3099][.32BF.0020.0007.30C7] # <HALFWIDTH KATAKANA LETTER TE, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF83 FF9E FF70 ; [.32CE.0020.0011.30C6][.0000.0128.0002.3099][.32BF.0020.0007.30C7] # <HALFWIDTH KATAKANA LETTER TE, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3067 30FC ; [.32CE.0020.0011.3066][.0000.0128.0002.3099][.32BF.0020.0007.3067] # <HIRAGANA LETTER DE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3066 3099 30FC ; [.32CE.0020.0011.3066][.0000.0128.0002.3099][.32BF.0020.0007.3067] # <HIRAGANA LETTER TE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30CD 30FC ; [.32D3.0020.0011.30CD][.32BF.0020.0007.30CD] # <KATAKANA LETTER NE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF88 30FC ; [.32D3.0020.0011.30CD][.32BF.0020.0007.30CD] # <HALFWIDTH KATAKANA LETTER NE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF88 FF70 ; [.32D3.0020.0011.30CD][.32BF.0020.0007.30CD] # <HALFWIDTH KATAKANA LETTER NE, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
306D 30FC ; [.32D3.0020.0011.306D][.32BF.0020.0007.306D] # <HIRAGANA LETTER NE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30D8 30FC ; [.32D8.0020.0011.30D8][.32BF.0020.0007.30D8] # <KATAKANA LETTER HE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8D 30FC ; [.32D8.0020.0011.30D8][.32BF.0020.0007.30D8] # <HALFWIDTH KATAKANA LETTER HE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8D FF70 ; [.32D8.0020.0011.30D8][.32BF.0020.0007.30D8] # <HALFWIDTH KATAKANA LETTER HE, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3078 30FC ; [.32D8.0020.0011.3078][.32BF.0020.0007.3078] # <HIRAGANA LETTER HE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30D9 30FC ; [.32D8.0020.0011.30D8][.0000.0128.0002.3099][.32BF.0020.0007.30D9] # <KATAKANA LETTER BE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30D8 3099 30FC ; [.32D8.0020.0011.30D8][.0000.0128.0002.3099][.32BF.0020.0007.30D9] # <KATAKANA LETTER HE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8D FF9E 30FC ; [.32D8.0020.0011.30D8][.0000.0128.0002.3099][.32BF.0020.0007.30D9] # <HALFWIDTH KATAKANA LETTER HE, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8D FF9E FF70 ; [.32D8.0020.0011.30D8][.0000.0128.0002.3099][.32BF.0020.0007.30D9] # <HALFWIDTH KATAKANA LETTER HE, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3079 30FC ; [.32D8.0020.0011.3078][.0000.0128.0002.3099][.32BF.0020.0007.3079] # <HIRAGANA LETTER BE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3078 3099 30FC ; [.32D8.0020.0011.3078][.0000.0128.0002.3099][.32BF.0020.0007.3079] # <HIRAGANA LETTER HE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30DA 30FC ; [.32D8.0020.0011.30D8][.0000.0129.0002.309A][.32BF.0020.0007.30DA] # <KATAKANA LETTER PE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30D8 309A 30FC ; [.32D8.0020.0011.30D8][.0000.0129.0002.309A][.32BF.0020.0007.30DA] # <KATAKANA LETTER HE, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8D FF9F 30FC ; [.32D8.0020.0011.30D8][.0000.0129.0002.309A][.32BF.0020.0007.30DA] # <HALFWIDTH KATAKANA LETTER HE, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8D FF9F FF70 ; [.32D8.0020.0011.30D8][.0000.0129.0002.309A][.32BF.0020.0007.30DA] # <HALFWIDTH KATAKANA LETTER HE, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
307A 30FC ; [.32D8.0020.0011.3078][.0000.0129.0002.309A][.32BF.0020.0007.307A] # <HIRAGANA LETTER PE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3078 309A 30FC ; [.32D8.0020.0011.3078][.0000.0129.0002.309A][.32BF.0020.0007.307A] # <HIRAGANA LETTER HE, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30E1 30FC ; [.32DD.0020.0011.30E1][.32BF.0020.0007.30E1] # <KATAKANA LETTER ME, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF92 30FC ; [.32DD.0020.0011.30E1][.32BF.0020.0007.30E1] # <HALFWIDTH KATAKANA LETTER ME, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF92 FF70 ; [.32DD.0020.0011.30E1][.32BF.0020.0007.30E1] # <HALFWIDTH KATAKANA LETTER ME, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3081 30FC ; [.32DD.0020.0011.3081][.32BF.0020.0007.3081] # <HIRAGANA LETTER ME, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30EC 30FC ; [.32E6.0020.0011.30EC][.32BF.0020.0007.30EC] # <KATAKANA LETTER RE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF9A 30FC ; [.32E6.0020.0011.30EC][.32BF.0020.0007.30EC] # <HALFWIDTH KATAKANA LETTER RE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF9A FF70 ; [.32E6.0020.0011.30EC][.32BF.0020.0007.30EC] # <HALFWIDTH KATAKANA LETTER RE, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
308C 30FC ; [.32E6.0020.0011.308C][.32BF.0020.0007.308C] # <HIRAGANA LETTER RE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30F1 30FC ; [.32EA.0020.0011.30F1][.32BF.0020.0007.30F1] # <KATAKANA LETTER WE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3091 30FC ; [.32EA.0020.0011.3091][.32BF.0020.0007.3091] # <HIRAGANA LETTER WE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30F9 30FC ; [.32EA.0020.0011.30F1][.0000.0128.0002.3099][.32BF.0020.0007.30F9] # <KATAKANA LETTER VE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30F1 3099 30FC ; [.32EA.0020.0011.30F1][.0000.0128.0002.3099][.32BF.0020.0007.30F9] # <KATAKANA LETTER WE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30F6 30FC ; [.32C4.0020.000F.30F6][.32BF.0020.0007.30F6] # <KATAKANA LETTER SMALL KE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3096 30FC ; [.32C4.0020.000F.3096][.32BF.0020.0007.3096] # <HIRAGANA LETTER SMALL KE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
31F8 30FC ; [.32D8.0020.000F.31F8][.32BF.0020.0007.31F8] # <KATAKANA LETTER SMALL HE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
31FE 30FC ; [.32E6.0020.000F.31FE][.32BF.0020.0007.31FE] # <KATAKANA LETTER SMALL RE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30A9 30FC ; [.32C0.0020.000F.30A9][.32C0.0020.0007.30A9] # <KATAKANA LETTER SMALL O, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF6B 30FC ; [.32C0.0020.000F.30A9][.32C0.0020.0007.30A9] # <HALFWIDTH KATAKANA LETTER SMALL O, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF6B FF70 ; [.32C0.0020.000F.30A9][.32C0.0020.0007.30A9] # <HALFWIDTH KATAKANA LETTER SMALL O, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3049 30FC ; [.32C0.0020.000F.3049][.32C0.0020.0007.3049] # <HIRAGANA LETTER SMALL O, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30AA 30FC ; [.32C0.0020.0011.30AA][.32C0.0020.0007.30AA] # <KATAKANA LETTER O, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF75 30FC ; [.32C0.0020.0011.30AA][.32C0.0020.0007.30AA] # <HALFWIDTH KATAKANA LETTER O, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF75 FF70 ; [.32C0.0020.0011.30AA][.32C0.0020.0007.30AA] # <HALFWIDTH KATAKANA LETTER O, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
304A 30FC ; [.32C0.0020.0011.304A][.32C0.0020.0007.304A] # <HIRAGANA LETTER O, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30B3 30FC ; [.32C5.0020.0011.30B3][.32C0.0020.0007.30B3] # <KATAKANA LETTER KO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7A 30FC ; [.32C5.0020.0011.30B3][.32C0.0020.0007.30B3] # <HALFWIDTH KATAKANA LETTER KO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7A FF70 ; [.32C5.0020.0011.30B3][.32C0.0020.0007.30B3] # <HALFWIDTH KATAKANA LETTER KO, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3053 30FC ; [.32C5.0020.0011.3053][.32C0.0020.0007.3053] # <HIRAGANA LETTER KO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30B4 30FC ; [.32C5.0020.0011.30B3][.0000.0128.0002.3099][.32C0.0020.0007.30B4] # <KATAKANA LETTER GO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30B3 3099 30FC ; [.32C5.0020.0011.30B3][.0000.0128.0002.3099][.32C0.0020.0007.30B4] # <KATAKANA LETTER KO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7A FF9E 30FC ; [.32C5.0020.0011.30B3][.0000.0128.0002.3099][.32C0.0020.0007.30B4] # <HALFWIDTH KATAKANA LETTER KO, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7A FF9E FF70 ; [.32C5.0020.0011.30B3][.0000.0128.0002.3099][.32C0.0020.0007.30B4] # <HALFWIDTH KATAKANA LETTER KO, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3054 30FC ; [.32C5.0020.0011.3053][.0000.0128.0002.3099][.32C0.0020.0007.3054] # <HIRAGANA LETTER GO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3053 3099 30FC ; [.32C5.0020.0011.3053][.0000.0128.0002.3099][.32C0.0020.0007.3054] # <HIRAGANA LETTER KO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30BD 30FC ; [.32CA.0020.0011.30BD][.32C0.0020.0007.30BD] # <KATAKANA LETTER SO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7F 30FC ; [.32CA.0020.0011.30BD][.32C0.0020.0007.30BD] # <HALFWIDTH KATAKANA LETTER SO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7F FF70 ; [.32CA.0020.0011.30BD][.32C0.0020.0007.30BD] # <HALFWIDTH KATAKANA LETTER SO, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
305D 30FC ; [.32CA.0020.0011.305D][.32C0.0020.0007.305D] # <HIRAGANA LETTER SO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30BE 30FC ; [.32CA.0020.0011.30BD][.0000.0128.0002.3099][.32C0.0020.0007.30BE] # <KATAKANA LETTER ZO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30BD 3099 30FC ; [.32CA.0020.0011.30BD][.0000.0128.0002.3099][.32C0.0020.0007.30BE] # <KATAKANA LETTER SO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7F FF9E 30FC ; [.32CA.0020.0011.30BD][.0000.0128.0002.3099][.32C0.0020.0007.30BE] # <HALFWIDTH KATAKANA LETTER SO, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7F FF9E FF70 ; [.32CA.0020.0011.30BD][.0000.0128.0002.3099][.32C0.0020.0007.30BE] # <HALFWIDTH KATAKANA LETTER SO, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
305E 30FC ; [.32CA.0020.0011.305D][.0000.0128.0002.3099][.32C0.0020.0007.305E] # <HIRAGANA LETTER ZO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
305D 3099 30FC ; [.32CA.0020.0011.305D][.0000.0128.0002.3099][.32C0.0020.0007.305E] # <HIRAGANA LETTER SO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30C8 30FC ; [.32CF.0020.0011.30C8][.32C0.0020.0007.30C8] # <KATAKANA LETTER TO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF84 30FC ; [.32CF.0020.0011.30C8][.32C0.0020.0007.30C8] # <HALFWIDTH KATAKANA LETTER TO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF84 FF70 ; [.32CF.0020.0011.30C8][.32C0.0020.0007.30C8] # <HALFWIDTH KATAKANA LETTER TO, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3068 30FC ; [.32CF.0020.0011.3068][.32C0.0020.0007.3068] # <HIRAGANA LETTER TO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30C9 30FC ; [.32CF.0020.0011.30C8][.0000.0128.0002.3099][.32C0.0020.0007.30C9] # <KATAKANA LETTER DO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30C8 3099 30FC ; [.32CF.0020.0011.30C8][.0000.0128.0002.3099][.32C0.0020.0007.30C9] # <KATAKANA LETTER TO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF84 FF9E 30FC ; [.32CF.0020.0011.30C8][.0000.0128.0002.3099][.32C0.0020.0007.30C9] # <HALFWIDTH KATAKANA LETTER TO, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF84 FF9E FF70 ; [.32CF.0020.0011.30C8][.0000.0128.0002.3099][.32C0.0020.0007.30C9] # <HALFWIDTH KATAKANA LETTER TO, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3069 30FC ; [.32CF.0020.0011.3068][.0000.0128.0002.3099][.32C0.0020.0007.3069] # <HIRAGANA LETTER DO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3068 3099 30FC ; [.32CF.0020.0011.3068][.0000.0128.0002.3099][.32C0.0020.0007.3069] # <HIRAGANA LETTER TO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30CE 30FC ; [.32D4.0020.0011.30CE][.32C0.0020.0007.30CE] # <KATAKANA LETTER NO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF89 30FC ; [.32D4.0020.0011.30CE][.32C0.0020.0007.30CE] # <HALFWIDTH KATAKANA LETTER NO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF89 FF70 ; [.32D4.0020.0011.30CE][.32C0.0020.0007.30CE] # <HALFWIDTH KATAKANA LETTER NO, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
306E 30FC ; [.32D4.0020.0011.306E][.32C0.0020.0007.306E] # <HIRAGANA LETTER NO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30DB 30FC ; [.32D9.0020.0011.30DB][.32C0.0020.0007.30DB] # <KATAKANA LETTER HO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8E 30FC ; [.32D9.0020.0011.30DB][.32C0.0020.0007.30DB] # <HALFWIDTH KATAKANA LETTER HO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8E FF70 ; [.32D9.0020.0011.30DB][.32C0.0020.0007.30DB] # <HALFWIDTH KATAKANA LETTER HO, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
307B 30FC ; [.32D9.0020.0011.307B][.32C0.0020.0007.307B] # <HIRAGANA LETTER HO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30DC 30FC ; [.32D9.0020.0011.30DB][.0000.0128.0002.3099][.32C0.0020.0007.30DC] # <KATAKANA LETTER BO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30DB 3099 30FC ; [.32D9.0020.0011.30DB][.0000.0128.0002.3099][.32C0.0020.0007.30DC] # <KATAKANA LETTER HO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8E FF9E 30FC ; [.32D9.0020.0011.30DB][.0000.0128.0002.3099][.32C0.0020.0007.30DC] # <HALFWIDTH KATAKANA LETTER HO, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8E FF9E FF70 ; [.32D9.0020.0011.30DB][.0000.0128.0002.3099][.32C0.0020.0007.30DC] # <HALFWIDTH KATAKANA LETTER HO, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
307C 30FC ; [.32D9.0020.0011.307B][.0000.0128.0002.3099][.32C0.0020.0007.307C] # <HIRAGANA LETTER BO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
307B 3099 30FC ; [.32D9.0020.0011.307B][.0000.0128.0002.3099][.32C0.0020.0007.307C] # <HIRAGANA LETTER HO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30DD 30FC ; [.32D9.0020.0011.30DB][.0000.0129.0002.309A][.32C0.0020.0007.30DD] # <KATAKANA LETTER PO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30DB 309A 30FC ; [.32D9.0020.0011.30DB][.0000.0129.0002.309A][.32C0.0020.0007.30DD] # <KATAKANA LETTER HO, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8E FF9F 30FC ; [.32D9.0020.0011.30DB][.0000.0129.0002.309A][.32C0.0020.0007.30DD] # <HALFWIDTH KATAKANA LETTER HO, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8E FF9F FF70 ; [.32D9.0020.0011.30DB][.0000.0129.0002.309A][.32C0.0020.0007.30DD] # <HALFWIDTH KATAKANA LETTER HO, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
307D 30FC ; [.32D9.0020.0011.307B][.0000.0129.0002.309A][.32C0.0020.0007.307D] # <HIRAGANA LETTER PO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
307B 309A 30FC ; [.32D9.0020.0011.307B][.0000.0129.0002.309A][.32C0.0020.0007.307D] # <HIRAGANA LETTER HO, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30E2 30FC ; [.32DE.0020.0011.30E2][.32C0.0020.0007.30E2] # <KATAKANA LETTER MO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF93 30FC ; [.32DE.0020.0011.30E2][.32C0.0020.0007.30E2] # <HALFWIDTH KATAKANA LETTER MO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF93 FF70 ; [.32DE.0020.0011.30E2][.32C0.0020.0007.30E2] # <HALFWIDTH KATAKANA LETTER MO, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3082 30FC ; [.32DE.0020.0011.3082][.32C0.0020.0007.3082] # <HIRAGANA LETTER MO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30E7 30FC ; [.32E2.0020.000F.30E7][.32C0.0020.0007.30E7] # <KATAKANA LETTER SMALL YO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF6E 30FC ; [.32E2.0020.000F.30E7][.32C0.0020.0007.30E7] # <HALFWIDTH KATAKANA LETTER SMALL YO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF6E FF70 ; [.32E2.0020.000F.30E7][.32C0.0020.0007.30E7] # <HALFWIDTH KATAKANA LETTER SMALL YO, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3087 30FC ; [.32E2.0020.000F.3087][.32C0.0020.0007.3087] # <HIRAGANA LETTER SMALL YO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30E8 30FC ; [.32E2.0020.0011.30E8][.32C0.0020.0007.30E8] # <KATAKANA LETTER YO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF96 30FC ; [.32E2.0020.0011.30E8][.32C0.0020.0007.30E8] # <HALFWIDTH KATAKANA LETTER YO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF96 FF70 ; [.32E2.0020.0011.30E8][.32C0.0020.0007.30E8] # <HALFWIDTH KATAKANA LETTER YO, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3088 30FC ; [.32E2.0020.0011.3088][.32C0.0020.0007.3088] # <HIRAGANA LETTER YO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30ED 30FC ; [.32E7.0020.0011.30ED][.32C0.0020.0007.30ED] # <KATAKANA LETTER RO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF9B 30FC ; [.32E7.0020.0011.30ED][.32C0.0020.0007.30ED] # <HALFWIDTH KATAKANA LETTER RO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF9B FF70 ; [.32E7.0020.0011.30ED][.32C0.0020.0007.30ED] # <HALFWIDTH KATAKANA LETTER RO, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
308D 30FC ; [.32E7.0020.0011.308D][.32C0.0020.0007.308D] # <HIRAGANA LETTER RO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30F2 30FC ; [.32EB.0020.0011.30F2][.32C0.0020.0007.30F2] # <KATAKANA LETTER WO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF66 30FC ; [.32EB.0020.0011.30F2][.32C0.0020.0007.30F2] # <HALFWIDTH KATAKANA LETTER WO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF66 FF70 ; [.32EB.0020.0011.30F2][.32C0.0020.0007.30F2] # <HALFWIDTH KATAKANA LETTER WO, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3092 30FC ; [.32EB.0020.0011.3092][.32C0.0020.0007.3092] # <HIRAGANA LETTER WO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30FA 30FC ; [.32EB.0020.0011.30F2][.0000.0128.0002.3099][.32C0.0020.0007.30FA] # <KATAKANA LETTER VO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30F2 3099 30FC ; [.32EB.0020.0011.30F2][.0000.0128.0002.3099][.32C0.0020.0007.30FA] # <KATAKANA LETTER WO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF66 FF9E 30FC ; [.32EB.0020.0011.30F2][.0000.0128.0002.3099][.32C0.0020.0007.30FA] # <HALFWIDTH KATAKANA LETTER WO, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF66 FF9E FF70 ; [.32EB.0020.0011.30F2][.0000.0128.0002.3099][.32C0.0020.0007.30FA] # <HALFWIDTH KATAKANA LETTER WO, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
31F3 30FC ; [.32CF.0020.000F.31F3][.32C0.0020.0007.31F3] # <KATAKANA LETTER SMALL TO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
31F9 30FC ; [.32D9.0020.000F.31F9][.32C0.0020.0007.31F9] # <KATAKANA LETTER SMALL HO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
31FF 30FC ; [.32E7.0020.000F.31FF][.32C0.0020.0007.31FF] # <KATAKANA LETTER SMALL RO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30A1 30FD ; [.32BB.0020.000F.30A1][.32BB.0020.0010.30A1] # <KATAKANA LETTER SMALL A, KATAKANA ITERATION MARK>
FF67 30FD ; [.32BB.0020.000F.30A1][.32BB.0020.0010.30A1] # <HALFWIDTH KATAKANA LETTER SMALL A, KATAKANA ITERATION MARK>
3041 309D ; [.32BB.0020.000F.3041][.32BB.0020.0010.3041] # <HIRAGANA LETTER SMALL A, HIRAGANA ITERATION MARK>
30A2 30FD ; [.32BB.0020.0011.30A2][.32BB.0020.0010.30A2] # <KATAKANA LETTER A, KATAKANA ITERATION MARK>
FF71 30FD ; [.32BB.0020.0011.30A2][.32BB.0020.0010.30A2] # <HALFWIDTH KATAKANA LETTER A, KATAKANA ITERATION MARK>
3042 309D ; [.32BB.0020.0011.3042][.32BB.0020.0010.3042] # <HIRAGANA LETTER A, HIRAGANA ITERATION MARK>
30A3 30FD ; [.32BC.0020.000F.30A3][.32BC.0020.0010.30A3] # <KATAKANA LETTER SMALL I, KATAKANA ITERATION MARK>
FF68 30FD ; [.32BC.0020.000F.30A3][.32BC.0020.0010.30A3] # <HALFWIDTH KATAKANA LETTER SMALL I, KATAKANA ITERATION MARK>
3043 309D ; [.32BC.0020.000F.3043][.32BC.0020.0010.3043] # <HIRAGANA LETTER SMALL I, HIRAGANA ITERATION MARK>
30A4 30FD ; [.32BC.0020.0011.30A4][.32BC.0020.0010.30A4] # <KATAKANA LETTER I, KATAKANA ITERATION MARK>
FF72 30FD ; [.32BC.0020.0011.30A4][.32BC.0020.0010.30A4] # <HALFWIDTH KATAKANA LETTER I, KATAKANA ITERATION MARK>
3044 309D ; [.32BC.0020.0011.3044][.32BC.0020.0010.3044] # <HIRAGANA LETTER I, HIRAGANA ITERATION MARK>
30A5 30FD ; [.32BD.0020.000F.30A5][.32BD.0020.0010.30A5] # <KATAKANA LETTER SMALL U, KATAKANA ITERATION MARK>
FF69 30FD ; [.32BD.0020.000F.30A5][.32BD.0020.0010.30A5] # <HALFWIDTH KATAKANA LETTER SMALL U, KATAKANA ITERATION MARK>
3045 309D ; [.32BD.0020.000F.3045][.32BD.0020.0010.3045] # <HIRAGANA LETTER SMALL U, HIRAGANA ITERATION MARK>
30A5 30FE ; [.32BD.0020.000F.30A5][.32BD.0020.0010.30A5][.0000.0128.0002.3099] # <KATAKANA LETTER SMALL U, KATAKANA VOICED ITERATION MARK>
FF69 30FE ; [.32BD.0020.000F.30A5][.32BD.0020.0010.30A5][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER SMALL U, KATAKANA VOICED ITERATION MARK>
3045 309E ; [.32BD.0020.000F.3045][.32BD.0020.0010.3045][.0000.0128.0002.3099] # <HIRAGANA LETTER SMALL U, HIRAGANA VOICED ITERATION MARK>
30A6 30FD ; [.32BD.0020.0011.30A6][.32BD.0020.0010.30A6] # <KATAKANA LETTER U, KATAKANA ITERATION MARK>
FF73 30FD ; [.32BD.0020.0011.30A6][.32BD.0020.0010.30A6] # <HALFWIDTH KATAKANA LETTER U, KATAKANA ITERATION MARK>
3046 309D ; [.32BD.0020.0011.3046][.32BD.0020.0010.3046] # <HIRAGANA LETTER U, HIRAGANA ITERATION MARK>
30A6 30FE ; [.32BD.0020.0011.30A6][.32BD.0020.0010.30A6][.0000.0128.0002.3099] # <KATAKANA LETTER U, KATAKANA VOICED ITERATION MARK>
FF73 30FE ; [.32BD.0020.0011.30A6][.32BD.0020.0010.30A6][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER U, KATAKANA VOICED ITERATION MARK>
3046 309E ; [.32BD.0020.0011.3046][.32BD.0020.0010.3046][.0000.0128.0002.3099] # <HIRAGANA LETTER U, HIRAGANA VOICED ITERATION MARK>
30A7 30FD ; [.32BF.0020.000F.30A7][.32BF.0020.0010.30A7] # <KATAKANA LETTER SMALL E, KATAKANA ITERATION MARK>
FF6A 30FD ; [.32BF.0020.000F.30A7][.32BF.0020.0010.30A7] # <HALFWIDTH KATAKANA LETTER SMALL E, KATAKANA ITERATION MARK>
3047 309D ; [.32BF.0020.000F.3047][.32BF.0020.0010.3047] # <HIRAGANA LETTER SMALL E, HIRAGANA ITERATION MARK>
30A8 30FD ; [.32BF.0020.0011.30A8][.32BF.0020.0010.30A8] # <KATAKANA LETTER E, KATAKANA ITERATION MARK>
FF74 30FD ; [.32BF.0020.0011.30A8][.32BF.0020.0010.30A8] # <HALFWIDTH KATAKANA LETTER E, KATAKANA ITERATION MARK>
3048 309D ; [.32BF.0020.0011.3048][.32BF.0020.0010.3048] # <HIRAGANA LETTER E, HIRAGANA ITERATION MARK>
30A9 30FD ; [.32C0.0020.000F.30A9][.32C0.0020.0010.30A9] # <KATAKANA LETTER SMALL O, KATAKANA ITERATION MARK>
FF6B 30FD ; [.32C0.0020.000F.30A9][.32C0.0020.0010.30A9] # <HALFWIDTH KATAKANA LETTER SMALL O, KATAKANA ITERATION MARK>
3049 309D ; [.32C0.0020.000F.3049][.32C0.0020.0010.3049] # <HIRAGANA LETTER SMALL O, HIRAGANA ITERATION MARK>
30AA 30FD ; [.32C0.0020.0011.30AA][.32C0.0020.0010.30AA] # <KATAKANA LETTER O, KATAKANA ITERATION MARK>
FF75 30FD ; [.32C0.0020.0011.30AA][.32C0.0020.0010.30AA] # <HALFWIDTH KATAKANA LETTER O, KATAKANA ITERATION MARK>
304A 309D ; [.32C0.0020.0011.304A][.32C0.0020.0010.304A] # <HIRAGANA LETTER O, HIRAGANA ITERATION MARK>
30AB 30FD ; [.32C1.0020.0011.30AB][.32C1.0020.0010.30AB] # <KATAKANA LETTER KA, KATAKANA ITERATION MARK>
FF76 30FD ; [.32C1.0020.0011.30AB][.32C1.0020.0010.30AB] # <HALFWIDTH KATAKANA LETTER KA, KATAKANA ITERATION MARK>
304B 309D ; [.32C1.0020.0011.304B][.32C1.0020.0010.304B] # <HIRAGANA LETTER KA, HIRAGANA ITERATION MARK>
30AB 30FE ; [.32C1.0020.0011.30AB][.32C1.0020.0010.30AB][.0000.0128.0002.3099] # <KATAKANA LETTER KA, KATAKANA VOICED ITERATION MARK>
FF76 30FE ; [.32C1.0020.0011.30AB][.32C1.0020.0010.30AB][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER KA, KATAKANA VOICED ITERATION MARK>
304B 309E ; [.32C1.0020.0011.304B][.32C1.0020.0010.304B][.0000.0128.0002.3099] # <HIRAGANA LETTER KA, HIRAGANA VOICED ITERATION MARK>
30AC 30FD ; [.32C1.0020.0011.30AB][.0000.0128.0002.3099][.32C1.0020.0010.30AC] # <KATAKANA LETTER GA, KATAKANA ITERATION MARK>
30AB 3099 30FD ; [.32C1.0020.0011.30AB][.0000.0128.0002.3099][.32C1.0020.0010.30AC] # <KATAKANA LETTER KA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF76 FF9E 30FD ; [.32C1.0020.0011.30AB][.0000.0128.0002.3099][.32C1.0020.0010.30AC] # <HALFWIDTH KATAKANA LETTER KA, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
304C 309D ; [.32C1.0020.0011.304B][.0000.0128.0002.3099][.32C1.0020.0010.304C] # <HIRAGANA LETTER GA, HIRAGANA ITERATION MARK>
304B 3099 309D ; [.32C1.0020.0011.304B][.0000.0128.0002.3099][.32C1.0020.0010.304C] # <HIRAGANA LETTER KA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30AC 30FE ; [.32C1.0020.0011.30AB][.0000.0128.0002.3099][.32C1.0020.0010.30AC][.0000.0128.0002.3099] # <KATAKANA LETTER GA, KATAKANA VOICED ITERATION MARK>
30AB 3099 30FE ; [.32C1.0020.0011.30AB][.0000.0128.0002.3099][.32C1.0020.0010.30AC][.0000.0128.0002.3099] # <KATAKANA LETTER KA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF76 FF9E 30FE ; [.32C1.0020.0011.30AB][.0000.0128.0002.3099][.32C1.0020.0010.30AC][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER KA, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
304C 309E ; [.32C1.0020.0011.304B][.0000.0128.0002.3099][.32C1.0020.0010.304C][.0000.0128.0002.3099] # <HIRAGANA LETTER GA, HIRAGANA VOICED ITERATION MARK>
304B 3099 309E ; [.32C1.0020.0011.304B][.0000.0128.0002.3099][.32C1.0020.0010.304C][.0000.0128.0002.3099] # <HIRAGANA LETTER KA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30AD 30FD ; [.32C2.0020.0011.30AD][.32C2.0020.0010.30AD] # <KATAKANA LETTER KI, KATAKANA ITERATION MARK>
FF77 30FD ; [.32C2.0020.0011.30AD][.32C2.0020.0010.30AD] # <HALFWIDTH KATAKANA LETTER KI, KATAKANA ITERATION MARK>
304D 309D ; [.32C2.0020.0011.304D][.32C2.0020.0010.304D] # <HIRAGANA LETTER KI, HIRAGANA ITERATION MARK>
30AD 30FE ; [.32C2.0020.0011.30AD][.32C2.0020.0010.30AD][.0000.0128.0002.3099] # <KATAKANA LETTER KI, KATAKANA VOICED ITERATION MARK>
FF77 30FE ; [.32C2.0020.0011.30AD][.32C2.0020.0010.30AD][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER KI, KATAKANA VOICED ITERATION MARK>
304D 309E ; [.32C2.0020.0011.304D][.32C2.0020.0010.304D][.0000.0128.0002.3099] # <HIRAGANA LETTER KI, HIRAGANA VOICED ITERATION MARK>
30AE 30FD ; [.32C2.0020.0011.30AD][.0000.0128.0002.3099][.32C2.0020.0010.30AE] # <KATAKANA LETTER GI, KATAKANA ITERATION MARK>
30AD 3099 30FD ; [.32C2.0020.0011.30AD][.0000.0128.0002.3099][.32C2.0020.0010.30AE] # <KATAKANA LETTER KI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF77 FF9E 30FD ; [.32C2.0020.0011.30AD][.0000.0128.0002.3099][.32C2.0020.0010.30AE] # <HALFWIDTH KATAKANA LETTER KI, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
304E 309D ; [.32C2.0020.0011.304D][.0000.0128.0002.3099][.32C2.0020.0010.304E] # <HIRAGANA LETTER GI, HIRAGANA ITERATION MARK>
304D 3099 309D ; [.32C2.0020.0011.304D][.0000.0128.0002.3099][.32C2.0020.0010.304E] # <HIRAGANA LETTER KI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30AE 30FE ; [.32C2.0020.0011.30AD][.0000.0128.0002.3099][.32C2.0020.0010.30AE][.0000.0128.0002.3099] # <KATAKANA LETTER GI, KATAKANA VOICED ITERATION MARK>
30AD 3099 30FE ; [.32C2.0020.0011.30AD][.0000.0128.0002.3099][.32C2.0020.0010.30AE][.0000.0128.0002.3099] # <KATAKANA LETTER KI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF77 FF9E 30FE ; [.32C2.0020.0011.30AD][.0000.0128.0002.3099][.32C2.0020.0010.30AE][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER KI, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
304E 309E ; [.32C2.0020.0011.304D][.0000.0128.0002.3099][.32C2.0020.0010.304E][.0000.0128.0002.3099] # <HIRAGANA LETTER GI, HIRAGANA VOICED ITERATION MARK>
304D 3099 309E ; [.32C2.0020.0011.304D][.0000.0128.0002.3099][.32C2.0020.0010.304E][.0000.0128.0002.3099] # <HIRAGANA LETTER KI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30AF 30FD ; [.32C3.0020.0011.30AF][.32C3.0020.0010.30AF] # <KATAKANA LETTER KU, KATAKANA ITERATION MARK>
FF78 30FD ; [.32C3.0020.0011.30AF][.32C3.0020.0010.30AF] # <HALFWIDTH KATAKANA LETTER KU, KATAKANA ITERATION MARK>
304F 309D ; [.32C3.0020.0011.304F][.32C3.0020.0010.304F] # <HIRAGANA LETTER KU, HIRAGANA ITERATION MARK>
30AF 30FE ; [.32C3.0020.0011.30AF][.32C3.0020.0010.30AF][.0000.0128.0002.3099] # <KATAKANA LETTER KU, KATAKANA VOICED ITERATION MARK>
FF78 30FE ; [.32C3.0020.0011.30AF][.32C3.0020.0010.30AF][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER KU, KATAKANA VOICED ITERATION MARK>
304F 309E ; [.32C3.0020.0011.304F][.32C3.0020.0010.304F][.0000.0128.0002.3099] # <HIRAGANA LETTER KU, HIRAGANA VOICED ITERATION MARK>
30B0 30FD ; [.32C3.0020.0011.30AF][.0000.0128.0002.3099][.32C3.0020.0010.30B0] # <KATAKANA LETTER GU, KATAKANA ITERATION MARK>
30AF 3099 30FD ; [.32C3.0020.0011.30AF][.0000.0128.0002.3099][.32C3.0020.0010.30B0] # <KATAKANA LETTER KU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF78 FF9E 30FD ; [.32C3.0020.0011.30AF][.0000.0128.0002.3099][.32C3.0020.0010.30B0] # <HALFWIDTH KATAKANA LETTER KU, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
3050 309D ; [.32C3.0020.0011.304F][.0000.0128.0002.3099][.32C3.0020.0010.3050] # <HIRAGANA LETTER GU, HIRAGANA ITERATION MARK>
304F 3099 309D ; [.32C3.0020.0011.304F][.0000.0128.0002.3099][.32C3.0020.0010.3050] # <HIRAGANA LETTER KU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30B0 30FE ; [.32C3.0020.0011.30AF][.0000.0128.0002.3099][.32C3.0020.0010.30B0][.0000.0128.0002.3099] # <KATAKANA LETTER GU, KATAKANA VOICED ITERATION MARK>
30AF 3099 30FE ; [.32C3.0020.0011.30AF][.0000.0128.0002.3099][.32C3.0020.0010.30B0][.0000.0128.0002.3099] # <KATAKANA LETTER KU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF78 FF9E 30FE ; [.32C3.0020.0011.30AF][.0000.0128.0002.3099][.32C3.0020.0010.30B0][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER KU, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3050 309E ; [.32C3.0020.0011.304F][.0000.0128.0002.3099][.32C3.0020.0010.3050][.0000.0128.0002.3099] # <HIRAGANA LETTER GU, HIRAGANA VOICED ITERATION MARK>
304F 3099 309E ; [.32C3.0020.0011.304F][.0000.0128.0002.3099][.32C3.0020.0010.3050][.0000.0128.0002.3099] # <HIRAGANA LETTER KU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30B1 30FD ; [.32C4.0020.0011.30B1][.32C4.0020.0010.30B1] # <KATAKANA LETTER KE, KATAKANA ITERATION MARK>
FF79 30FD ; [.32C4.0020.0011.30B1][.32C4.0020.0010.30B1] # <HALFWIDTH KATAKANA LETTER KE, KATAKANA ITERATION MARK>
3051 309D ; [.32C4.0020.0011.3051][.32C4.0020.0010.3051] # <HIRAGANA LETTER KE, HIRAGANA ITERATION MARK>
30B1 30FE ; [.32C4.0020.0011.30B1][.32C4.0020.0010.30B1][.0000.0128.0002.3099] # <KATAKANA LETTER KE, KATAKANA VOICED ITERATION MARK>
FF79 30FE ; [.32C4.0020.0011.30B1][.32C4.0020.0010.30B1][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER KE, KATAKANA VOICED ITERATION MARK>
3051 309E ; [.32C4.0020.0011.3051][.32C4.0020.0010.3051][.0000.0128.0002.3099] # <HIRAGANA LETTER KE, HIRAGANA VOICED ITERATION MARK>
30B2 30FD ; [.32C4.0020.0011.30B1][.0000.0128.0002.3099][.32C4.0020.0010.30B2] # <KATAKANA LETTER GE, KATAKANA ITERATION MARK>
30B1 3099 30FD ; [.32C4.0020.0011.30B1][.0000.0128.0002.3099][.32C4.0020.0010.30B2] # <KATAKANA LETTER KE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF79 FF9E 30FD ; [.32C4.0020.0011.30B1][.0000.0128.0002.3099][.32C4.0020.0010.30B2] # <HALFWIDTH KATAKANA LETTER KE, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
3052 309D ; [.32C4.0020.0011.3051][.0000.0128.0002.3099][.32C4.0020.0010.3052] # <HIRAGANA LETTER GE, HIRAGANA ITERATION MARK>
3051 3099 309D ; [.32C4.0020.0011.3051][.0000.0128.0002.3099][.32C4.0020.0010.3052] # <HIRAGANA LETTER KE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30B2 30FE ; [.32C4.0020.0011.30B1][.0000.0128.0002.3099][.32C4.0020.0010.30B2][.0000.0128.0002.3099] # <KATAKANA LETTER GE, KATAKANA VOICED ITERATION MARK>
30B1 3099 30FE ; [.32C4.0020.0011.30B1][.0000.0128.0002.3099][.32C4.0020.0010.30B2][.0000.0128.0002.3099] # <KATAKANA LETTER KE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF79 FF9E 30FE ; [.32C4.0020.0011.30B1][.0000.0128.0002.3099][.32C4.0020.0010.30B2][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER KE, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3052 309E ; [.32C4.0020.0011.3051][.0000.0128.0002.3099][.32C4.0020.0010.3052][.0000.0128.0002.3099] # <HIRAGANA LETTER GE, HIRAGANA VOICED ITERATION MARK>
3051 3099 309E ; [.32C4.0020.0011.3051][.0000.0128.0002.3099][.32C4.0020.0010.3052][.0000.0128.0002.3099] # <HIRAGANA LETTER KE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30B3 30FD ; [.32C5.0020.0011.30B3][.32C5.0020.0010.30B3] # <KATAKANA LETTER KO, KATAKANA ITERATION MARK>
FF7A 30FD ; [.32C5.0020.0011.30B3][.32C5.0020.0010.30B3] # <HALFWIDTH KATAKANA LETTER KO, KATAKANA ITERATION MARK>
3053 309D ; [.32C5.0020.0011.3053][.32C5.0020.0010.3053] # <HIRAGANA LETTER KO, HIRAGANA ITERATION MARK>
30B3 30FE ; [.32C5.0020.0011.30B3][.32C5.0020.0010.30B3][.0000.0128.0002.3099] # <KATAKANA LETTER KO, KATAKANA VOICED ITERATION MARK>
FF7A 30FE ; [.32C5.0020.0011.30B3][.32C5.0020.0010.30B3][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER KO, KATAKANA VOICED ITERATION MARK>
3053 309E ; [.32C5.0020.0011.3053][.32C5.0020.0010.3053][.0000.0128.0002.3099] # <HIRAGANA LETTER KO, HIRAGANA VOICED ITERATION MARK>
30B4 30FD ; [.32C5.0020.0011.30B3][.0000.0128.0002.3099][.32C5.0020.0010.30B4] # <KATAKANA LETTER GO, KATAKANA ITERATION MARK>
30B3 3099 30FD ; [.32C5.0020.0011.30B3][.0000.0128.0002.3099][.32C5.0020.0010.30B4] # <KATAKANA LETTER KO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF7A FF9E 30FD ; [.32C5.0020.0011.30B3][.0000.0128.0002.3099][.32C5.0020.0010.30B4] # <HALFWIDTH KATAKANA LETTER KO, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
3054 309D ; [.32C5.0020.0011.3053][.0000.0128.0002.3099][.32C5.0020.0010.3054] # <HIRAGANA LETTER GO, HIRAGANA ITERATION MARK>
3053 3099 309D ; [.32C5.0020.0011.3053][.0000.0128.0002.3099][.32C5.0020.0010.3054] # <HIRAGANA LETTER KO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30B4 30FE ; [.32C5.0020.0011.30B3][.0000.0128.0002.3099][.32C5.0020.0010.30B4][.0000.0128.0002.3099] # <KATAKANA LETTER GO, KATAKANA VOICED ITERATION MARK>
30B3 3099 30FE ; [.32C5.0020.0011.30B3][.0000.0128.0002.3099][.32C5.0020.0010.30B4][.0000.0128.0002.3099] # <KATAKANA LETTER KO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF7A FF9E 30FE ; [.32C5.0020.0011.30B3][.0000.0128.0002.3099][.32C5.0020.0010.30B4][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER KO, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3054 309E ; [.32C5.0020.0011.3053][.0000.0128.0002.3099][.32C5.0020.0010.3054][.0000.0128.0002.3099] # <HIRAGANA LETTER GO, HIRAGANA VOICED ITERATION MARK>
3053 3099 309E ; [.32C5.0020.0011.3053][.0000.0128.0002.3099][.32C5.0020.0010.3054][.0000.0128.0002.3099] # <HIRAGANA LETTER KO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30B5 30FD ; [.32C6.0020.0011.30B5][.32C6.0020.0010.30B5] # <KATAKANA LETTER SA, KATAKANA ITERATION MARK>
FF7B 30FD ; [.32C6.0020.0011.30B5][.32C6.0020.0010.30B5] # <HALFWIDTH KATAKANA LETTER SA, KATAKANA ITERATION MARK>
3055 309D ; [.32C6.0020.0011.3055][.32C6.0020.0010.3055] # <HIRAGANA LETTER SA, HIRAGANA ITERATION MARK>
30B5 30FE ; [.32C6.0020.0011.30B5][.32C6.0020.0010.30B5][.0000.0128.0002.3099] # <KATAKANA LETTER SA, KATAKANA VOICED ITERATION MARK>
FF7B 30FE ; [.32C6.0020.0011.30B5][.32C6.0020.0010.30B5][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER SA, KATAKANA VOICED ITERATION MARK>
3055 309E ; [.32C6.0020.0011.3055][.32C6.0020.0010.3055][.0000.0128.0002.3099] # <HIRAGANA LETTER SA, HIRAGANA VOICED ITERATION MARK>
30B6 30FD ; [.32C6.0020.0011.30B5][.0000.0128.0002.3099][.32C6.0020.0010.30B6] # <KATAKANA LETTER ZA, KATAKANA ITERATION MARK>
30B5 3099 30FD ; [.32C6.0020.0011.30B5][.0000.0128.0002.3099][.32C6.0020.0010.30B6] # <KATAKANA LETTER SA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF7B FF9E 30FD ; [.32C6.0020.0011.30B5][.0000.0128.0002.3099][.32C6.0020.0010.30B6] # <HALFWIDTH KATAKANA LETTER SA, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
3056 309D ; [.32C6.0020.0011.3055][.0000.0128.0002.3099][.32C6.0020.0010.3056] # <HIRAGANA LETTER ZA, HIRAGANA ITERATION MARK>
3055 3099 309D ; [.32C6.0020.0011.3055][.0000.0128.0002.3099][.32C6.0020.0010.3056] # <HIRAGANA LETTER SA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30B6 30FE ; [.32C6.0020.0011.30B5][.0000.0128.0002.3099][.32C6.0020.0010.30B6][.0000.0128.0002.3099] # <KATAKANA LETTER ZA, KATAKANA VOICED ITERATION MARK>
30B5 3099 30FE ; [.32C6.0020.0011.30B5][.0000.0128.0002.3099][.32C6.0020.0010.30B6][.0000.0128.0002.3099] # <KATAKANA LETTER SA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF7B FF9E 30FE ; [.32C6.0020.0011.30B5][.0000.0128.0002.3099][.32C6.0020.0010.30B6][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER SA, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3056 309E ; [.32C6.0020.0011.3055][.0000.0128.0002.3099][.32C6.0020.0010.3056][.0000.0128.0002.3099] # <HIRAGANA LETTER ZA, HIRAGANA VOICED ITERATION MARK>
3055 3099 309E ; [.32C6.0020.0011.3055][.0000.0128.0002.3099][.32C6.0020.0010.3056][.0000.0128.0002.3099] # <HIRAGANA LETTER SA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30B7 30FD ; [.32C7.0020.0011.30B7][.32C7.0020.0010.30B7] # <KATAKANA LETTER SI, KATAKANA ITERATION MARK>
FF7C 30FD ; [.32C7.0020.0011.30B7][.32C7.0020.0010.30B7] # <HALFWIDTH KATAKANA LETTER SI, KATAKANA ITERATION MARK>
3057 309D ; [.32C7.0020.0011.3057][.32C7.0020.0010.3057] # <HIRAGANA LETTER SI, HIRAGANA ITERATION MARK>
30B7 30FE ; [.32C7.0020.0011.30B7][.32C7.0020.0010.30B7][.0000.0128.0002.3099] # <KATAKANA LETTER SI, KATAKANA VOICED ITERATION MARK>
FF7C 30FE ; [.32C7.0020.0011.30B7][.32C7.0020.0010.30B7][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER SI, KATAKANA VOICED ITERATION MARK>
3057 309E ; [.32C7.0020.0011.3057][.32C7.0020.0010.3057][.0000.0128.0002.3099] # <HIRAGANA LETTER SI, HIRAGANA VOICED ITERATION MARK>
30B8 30FD ; [.32C7.0020.0011.30B7][.0000.0128.0002.3099][.32C7.0020.0010.30B8] # <KATAKANA LETTER ZI, KATAKANA ITERATION MARK>
30B7 3099 30FD ; [.32C7.0020.0011.30B7][.0000.0128.0002.3099][.32C7.0020.0010.30B8] # <KATAKANA LETTER SI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF7C FF9E 30FD ; [.32C7.0020.0011.30B7][.0000.0128.0002.3099][.32C7.0020.0010.30B8] # <HALFWIDTH KATAKANA LETTER SI, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
3058 309D ; [.32C7.0020.0011.3057][.0000.0128.0002.3099][.32C7.0020.0010.3058] # <HIRAGANA LETTER ZI, HIRAGANA ITERATION MARK>
3057 3099 309D ; [.32C7.0020.0011.3057][.0000.0128.0002.3099][.32C7.0020.0010.3058] # <HIRAGANA LETTER SI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30B8 30FE ; [.32C7.0020.0011.30B7][.0000.0128.0002.3099][.32C7.0020.0010.30B8][.0000.0128.0002.3099] # <KATAKANA LETTER ZI, KATAKANA VOICED ITERATION MARK>
30B7 3099 30FE ; [.32C7.0020.0011.30B7][.0000.0128.0002.3099][.32C7.0020.0010.30B8][.0000.0128.0002.3099] # <KATAKANA LETTER SI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF7C FF9E 30FE ; [.32C7.0020.0011.30B7][.0000.0128.0002.3099][.32C7.0020.0010.30B8][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER SI, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3058 309E ; [.32C7.0020.0011.3057][.0000.0128.0002.3099][.32C7.0020.0010.3058][.0000.0128.0002.3099] # <HIRAGANA LETTER ZI, HIRAGANA VOICED ITERATION MARK>
3057 3099 309E ; [.32C7.0020.0011.3057][.0000.0128.0002.3099][.32C7.0020.0010.3058][.0000.0128.0002.3099] # <HIRAGANA LETTER SI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30B9 30FD ; [.32C8.0020.0011.30B9][.32C8.0020.0010.30B9] # <KATAKANA LETTER SU, KATAKANA ITERATION MARK>
FF7D 30FD ; [.32C8.0020.0011.30B9][.32C8.0020.0010.30B9] # <HALFWIDTH KATAKANA LETTER SU, KATAKANA ITERATION MARK>
3059 309D ; [.32C8.0020.0011.3059][.32C8.0020.0010.3059] # <HIRAGANA LETTER SU, HIRAGANA ITERATION MARK>
30B9 30FE ; [.32C8.0020.0011.30B9][.32C8.0020.0010.30B9][.0000.0128.0002.3099] # <KATAKANA LETTER SU, KATAKANA VOICED ITERATION MARK>
FF7D 30FE ; [.32C8.0020.0011.30B9][.32C8.0020.0010.30B9][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER SU, KATAKANA VOICED ITERATION MARK>
3059 309E ; [.32C8.0020.0011.3059][.32C8.0020.0010.3059][.0000.0128.0002.3099] # <HIRAGANA LETTER SU, HIRAGANA VOICED ITERATION MARK>
30BA 30FD ; [.32C8.0020.0011.30B9][.0000.0128.0002.3099][.32C8.0020.0010.30BA] # <KATAKANA LETTER ZU, KATAKANA ITERATION MARK>
30B9 3099 30FD ; [.32C8.0020.0011.30B9][.0000.0128.0002.3099][.32C8.0020.0010.30BA] # <KATAKANA LETTER SU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF7D FF9E 30FD ; [.32C8.0020.0011.30B9][.0000.0128.0002.3099][.32C8.0020.0010.30BA] # <HALFWIDTH KATAKANA LETTER SU, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
305A 309D ; [.32C8.0020.0011.3059][.0000.0128.0002.3099][.32C8.0020.0010.305A] # <HIRAGANA LETTER ZU, HIRAGANA ITERATION MARK>
3059 3099 309D ; [.32C8.0020.0011.3059][.0000.0128.0002.3099][.32C8.0020.0010.305A] # <HIRAGANA LETTER SU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30BA 30FE ; [.32C8.0020.0011.30B9][.0000.0128.0002.3099][.32C8.0020.0010.30BA][.0000.0128.0002.3099] # <KATAKANA LETTER ZU, KATAKANA VOICED ITERATION MARK>
30B9 3099 30FE ; [.32C8.0020.0011.30B9][.0000.0128.0002.3099][.32C8.0020.0010.30BA][.0000.0128.0002.3099] # <KATAKANA LETTER SU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF7D FF9E 30FE ; [.32C8.0020.0011.30B9][.0000.0128.0002.3099][.32C8.0020.0010.30BA][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER SU, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
305A 309E ; [.32C8.0020.0011.3059][.0000.0128.0002.3099][.32C8.0020.0010.305A][.0000.0128.0002.3099] # <HIRAGANA LETTER ZU, HIRAGANA VOICED ITERATION MARK>
3059 3099 309E ; [.32C8.0020.0011.3059][.0000.0128.0002.3099][.32C8.0020.0010.305A][.0000.0128.0002.3099] # <HIRAGANA LETTER SU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30BB 30FD ; [.32C9.0020.0011.30BB][.32C9.0020.0010.30BB] # <KATAKANA LETTER SE, KATAKANA ITERATION MARK>
FF7E 30FD ; [.32C9.0020.0011.30BB][.32C9.0020.0010.30BB] # <HALFWIDTH KATAKANA LETTER SE, KATAKANA ITERATION MARK>
305B 309D ; [.32C9.0020.0011.305B][.32C9.0020.0010.305B] # <HIRAGANA LETTER SE, HIRAGANA ITERATION MARK>
30BB 30FE ; [.32C9.0020.0011.30BB][.32C9.0020.0010.30BB][.0000.0128.0002.3099] # <KATAKANA LETTER SE, KATAKANA VOICED ITERATION MARK>
FF7E 30FE ; [.32C9.0020.0011.30BB][.32C9.0020.0010.30BB][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER SE, KATAKANA VOICED ITERATION MARK>
305B 309E ; [.32C9.0020.0011.305B][.32C9.0020.0010.305B][.0000.0128.0002.3099] # <HIRAGANA LETTER SE, HIRAGANA VOICED ITERATION MARK>
30BC 30FD ; [.32C9.0020.0011.30BB][.0000.0128.0002.3099][.32C9.0020.0010.30BC] # <KATAKANA LETTER ZE, KATAKANA ITERATION MARK>
30BB 3099 30FD ; [.32C9.0020.0011.30BB][.0000.0128.0002.3099][.32C9.0020.0010.30BC] # <KATAKANA LETTER SE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF7E FF9E 30FD ; [.32C9.0020.0011.30BB][.0000.0128.0002.3099][.32C9.0020.0010.30BC] # <HALFWIDTH KATAKANA LETTER SE, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
305C 309D ; [.32C9.0020.0011.305B][.0000.0128.0002.3099][.32C9.0020.0010.305C] # <HIRAGANA LETTER ZE, HIRAGANA ITERATION MARK>
305B 3099 309D ; [.32C9.0020.0011.305B][.0000.0128.0002.3099][.32C9.0020.0010.305C] # <HIRAGANA LETTER SE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30BC 30FE ; [.32C9.0020.0011.30BB][.0000.0128.0002.3099][.32C9.0020.0010.30BC][.0000.0128.0002.3099] # <KATAKANA LETTER ZE, KATAKANA VOICED ITERATION MARK>
30BB 3099 30FE ; [.32C9.0020.0011.30BB][.0000.0128.0002.3099][.32C9.0020.0010.30BC][.0000.0128.0002.3099] # <KATAKANA LETTER SE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF7E FF9E 30FE ; [.32C9.0020.0011.30BB][.0000.0128.0002.3099][.32C9.0020.0010.30BC][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER SE, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
305C 309E ; [.32C9.0020.0011.305B][.0000.0128.0002.3099][.32C9.0020.0010.305C][.0000.0128.0002.3099] # <HIRAGANA LETTER ZE, HIRAGANA VOICED ITERATION MARK>
305B 3099 309E ; [.32C9.0020.0011.305B][.0000.0128.0002.3099][.32C9.0020.0010.305C][.0000.0128.0002.3099] # <HIRAGANA LETTER SE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30BD 30FD ; [.32CA.0020.0011.30BD][.32CA.0020.0010.30BD] # <KATAKANA LETTER SO, KATAKANA ITERATION MARK>
FF7F 30FD ; [.32CA.0020.0011.30BD][.32CA.0020.0010.30BD] # <HALFWIDTH KATAKANA LETTER SO, KATAKANA ITERATION MARK>
305D 309D ; [.32CA.0020.0011.305D][.32CA.0020.0010.305D] # <HIRAGANA LETTER SO, HIRAGANA ITERATION MARK>
30BD 30FE ; [.32CA.0020.0011.30BD][.32CA.0020.0010.30BD][.0000.0128.0002.3099] # <KATAKANA LETTER SO, KATAKANA VOICED ITERATION MARK>
FF7F 30FE ; [.32CA.0020.0011.30BD][.32CA.0020.0010.30BD][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER SO, KATAKANA VOICED ITERATION MARK>
305D 309E ; [.32CA.0020.0011.305D][.32CA.0020.0010.305D][.0000.0128.0002.3099] # <HIRAGANA LETTER SO, HIRAGANA VOICED ITERATION MARK>
30BE 30FD ; [.32CA.0020.0011.30BD][.0000.0128.0002.3099][.32CA.0020.0010.30BE] # <KATAKANA LETTER ZO, KATAKANA ITERATION MARK>
30BD 3099 30FD ; [.32CA.0020.0011.30BD][.0000.0128.0002.3099][.32CA.0020.0010.30BE] # <KATAKANA LETTER SO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF7F FF9E 30FD ; [.32CA.0020.0011.30BD][.0000.0128.0002.3099][.32CA.0020.0010.30BE] # <HALFWIDTH KATAKANA LETTER SO, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
305E 309D ; [.32CA.0020.0011.305D][.0000.0128.0002.3099][.32CA.0020.0010.305E] # <HIRAGANA LETTER ZO, HIRAGANA ITERATION MARK>
305D 3099 309D ; [.32CA.0020.0011.305D][.0000.0128.0002.3099][.32CA.0020.0010.305E] # <HIRAGANA LETTER SO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30BE 30FE ; [.32CA.0020.0011.30BD][.0000.0128.0002.3099][.32CA.0020.0010.30BE][.0000.0128.0002.3099] # <KATAKANA LETTER ZO, KATAKANA VOICED ITERATION MARK>
30BD 3099 30FE ; [.32CA.0020.0011.30BD][.0000.0128.0002.3099][.32CA.0020.0010.30BE][.0000.0128.0002.3099] # <KATAKANA LETTER SO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF7F FF9E 30FE ; [.32CA.0020.0011.30BD][.0000.0128.0002.3099][.32CA.0020.0010.30BE][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER SO, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
305E 309E ; [.32CA.0020.0011.305D][.0000.0128.0002.3099][.32CA.0020.0010.305E][.0000.0128.0002.3099] # <HIRAGANA LETTER ZO, HIRAGANA VOICED ITERATION MARK>
305D 3099 309E ; [.32CA.0020.0011.305D][.0000.0128.0002.3099][.32CA.0020.0010.305E][.0000.0128.0002.3099] # <HIRAGANA LETTER SO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30BF 30FD ; [.32CB.0020.0011.30BF][.32CB.0020.0010.30BF] # <KATAKANA LETTER TA, KATAKANA ITERATION MARK>
FF80 30FD ; [.32CB.0020.0011.30BF][.32CB.0020.0010.30BF] # <HALFWIDTH KATAKANA LETTER TA, KATAKANA ITERATION MARK>
305F 309D ; [.32CB.0020.0011.305F][.32CB.0020.0010.305F] # <HIRAGANA LETTER TA, HIRAGANA ITERATION MARK>
30BF 30FE ; [.32CB.0020.0011.30BF][.32CB.0020.0010.30BF][.0000.0128.0002.3099] # <KATAKANA LETTER TA, KATAKANA VOICED ITERATION MARK>
FF80 30FE ; [.32CB.0020.0011.30BF][.32CB.0020.0010.30BF][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER TA, KATAKANA VOICED ITERATION MARK>
305F 309E ; [.32CB.0020.0011.305F][.32CB.0020.0010.305F][.0000.0128.0002.3099] # <HIRAGANA LETTER TA, HIRAGANA VOICED ITERATION MARK>
30C0 30FD ; [.32CB.0020.0011.30BF][.0000.0128.0002.3099][.32CB.0020.0010.30C0] # <KATAKANA LETTER DA, KATAKANA ITERATION MARK>
30BF 3099 30FD ; [.32CB.0020.0011.30BF][.0000.0128.0002.3099][.32CB.0020.0010.30C0] # <KATAKANA LETTER TA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF80 FF9E 30FD ; [.32CB.0020.0011.30BF][.0000.0128.0002.3099][.32CB.0020.0010.30C0] # <HALFWIDTH KATAKANA LETTER TA, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
3060 309D ; [.32CB.0020.0011.305F][.0000.0128.0002.3099][.32CB.0020.0010.3060] # <HIRAGANA LETTER DA, HIRAGANA ITERATION MARK>
305F 3099 309D ; [.32CB.0020.0011.305F][.0000.0128.0002.3099][.32CB.0020.0010.3060] # <HIRAGANA LETTER TA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30C0 30FE ; [.32CB.0020.0011.30BF][.0000.0128.0002.3099][.32CB.0020.0010.30C0][.0000.0128.0002.3099] # <KATAKANA LETTER DA, KATAKANA VOICED ITERATION MARK>
30BF 3099 30FE ; [.32CB.0020.0011.30BF][.0000.0128.0002.3099][.32CB.0020.0010.30C0][.0000.0128.0002.3099] # <KATAKANA LETTER TA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF80 FF9E 30FE ; [.32CB.0020.0011.30BF][.0000.0128.0002.3099][.32CB.0020.0010.30C0][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER TA, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3060 309E ; [.32CB.0020.0011.305F][.0000.0128.0002.3099][.32CB.0020.0010.3060][.0000.0128.0002.3099] # <HIRAGANA LETTER DA, HIRAGANA VOICED ITERATION MARK>
305F 3099 309E ; [.32CB.0020.0011.305F][.0000.0128.0002.3099][.32CB.0020.0010.3060][.0000.0128.0002.3099] # <HIRAGANA LETTER TA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30C1 30FD ; [.32CC.0020.0011.30C1][.32CC.0020.0010.30C1] # <KATAKANA LETTER TI, KATAKANA ITERATION MARK>
FF81 30FD ; [.32CC.0020.0011.30C1][.32CC.0020.0010.30C1] # <HALFWIDTH KATAKANA LETTER TI, KATAKANA ITERATION MARK>
3061 309D ; [.32CC.0020.0011.3061][.32CC.0020.0010.3061] # <HIRAGANA LETTER TI, HIRAGANA ITERATION MARK>
30C1 30FE ; [.32CC.0020.0011.30C1][.32CC.0020.0010.30C1][.0000.0128.0002.3099] # <KATAKANA LETTER TI, KATAKANA VOICED ITERATION MARK>
FF81 30FE ; [.32CC.0020.0011.30C1][.32CC.0020.0010.30C1][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER TI, KATAKANA VOICED ITERATION MARK>
3061 309E ; [.32CC.0020.0011.3061][.32CC.0020.0010.3061][.0000.0128.0002.3099] # <HIRAGANA LETTER TI, HIRAGANA VOICED ITERATION MARK>
30C2 30FD ; [.32CC.0020.0011.30C1][.0000.0128.0002.3099][.32CC.0020.0010.30C2] # <KATAKANA LETTER DI, KATAKANA ITERATION MARK>
30C1 3099 30FD ; [.32CC.0020.0011.30C1][.0000.0128.0002.3099][.32CC.0020.0010.30C2] # <KATAKANA LETTER TI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF81 FF9E 30FD ; [.32CC.0020.0011.30C1][.0000.0128.0002.3099][.32CC.0020.0010.30C2] # <HALFWIDTH KATAKANA LETTER TI, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
3062 309D ; [.32CC.0020.0011.3061][.0000.0128.0002.3099][.32CC.0020.0010.3062] # <HIRAGANA LETTER DI, HIRAGANA ITERATION MARK>
3061 3099 309D ; [.32CC.0020.0011.3061][.0000.0128.0002.3099][.32CC.0020.0010.3062] # <HIRAGANA LETTER TI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30C2 30FE ; [.32CC.0020.0011.30C1][.0000.0128.0002.3099][.32CC.0020.0010.30C2][.0000.0128.0002.3099] # <KATAKANA LETTER DI, KATAKANA VOICED ITERATION MARK>
30C1 3099 30FE ; [.32CC.0020.0011.30C1][.0000.0128.0002.3099][.32CC.0020.0010.30C2][.0000.0128.0002.3099] # <KATAKANA LETTER TI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF81 FF9E 30FE ; [.32CC.0020.0011.30C1][.0000.0128.0002.3099][.32CC.0020.0010.30C2][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER TI, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3062 309E ; [.32CC.0020.0011.3061][.0000.0128.0002.3099][.32CC.0020.0010.3062][.0000.0128.0002.3099] # <HIRAGANA LETTER DI, HIRAGANA VOICED ITERATION MARK>
3061 3099 309E ; [.32CC.0020.0011.3061][.0000.0128.0002.3099][.32CC.0020.0010.3062][.0000.0128.0002.3099] # <HIRAGANA LETTER TI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30C3 30FD ; [.32CD.0020.000F.30C3][.32CD.0020.0010.30C3] # <KATAKANA LETTER SMALL TU, KATAKANA ITERATION MARK>
FF6F 30FD ; [.32CD.0020.000F.30C3][.32CD.0020.0010.30C3] # <HALFWIDTH KATAKANA LETTER SMALL TU, KATAKANA ITERATION MARK>
3063 309D ; [.32CD.0020.000F.3063][.32CD.0020.0010.3063] # <HIRAGANA LETTER SMALL TU, HIRAGANA ITERATION MARK>
30C3 30FE ; [.32CD.0020.000F.30C3][.32CD.0020.0010.30C3][.0000.0128.0002.3099] # <KATAKANA LETTER SMALL TU, KATAKANA VOICED ITERATION MARK>
FF6F 30FE ; [.32CD.0020.000F.30C3][.32CD.0020.0010.30C3][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER SMALL TU, KATAKANA VOICED ITERATION MARK>
3063 309E ; [.32CD.0020.000F.3063][.32CD.0020.0010.3063][.0000.0128.0002.3099] # <HIRAGANA LETTER SMALL TU, HIRAGANA VOICED ITERATION MARK>
30C4 30FD ; [.32CD.0020.0011.30C4][.32CD.0020.0010.30C4] # <KATAKANA LETTER TU, KATAKANA ITERATION MARK>
FF82 30FD ; [.32CD.0020.0011.30C4][.32CD.0020.0010.30C4] # <HALFWIDTH KATAKANA LETTER TU, KATAKANA ITERATION MARK>
3064 309D ; [.32CD.0020.0011.3064][.32CD.0020.0010.3064] # <HIRAGANA LETTER TU, HIRAGANA ITERATION MARK>
30C4 30FE ; [.32CD.0020.0011.30C4][.32CD.0020.0010.30C4][.0000.0128.0002.3099] # <KATAKANA LETTER TU, KATAKANA VOICED ITERATION MARK>
FF82 30FE ; [.32CD.0020.0011.30C4][.32CD.0020.0010.30C4][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER TU, KATAKANA VOICED ITERATION MARK>
3064 309E ; [.32CD.0020.0011.3064][.32CD.0020.0010.3064][.0000.0128.0002.3099] # <HIRAGANA LETTER TU, HIRAGANA VOICED ITERATION MARK>
30C5 30FD ; [.32CD.0020.0011.30C4][.0000.0128.0002.3099][.32CD.0020.0010.30C5] # <KATAKANA LETTER DU, KATAKANA ITERATION MARK>
30C4 3099 30FD ; [.32CD.0020.0011.30C4][.0000.0128.0002.3099][.32CD.0020.0010.30C5] # <KATAKANA LETTER TU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF82 FF9E 30FD ; [.32CD.0020.0011.30C4][.0000.0128.0002.3099][.32CD.0020.0010.30C5] # <HALFWIDTH KATAKANA LETTER TU, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
3065 309D ; [.32CD.0020.0011.3064][.0000.0128.0002.3099][.32CD.0020.0010.3065] # <HIRAGANA LETTER DU, HIRAGANA ITERATION MARK>
3064 3099 309D ; [.32CD.0020.0011.3064][.0000.0128.0002.3099][.32CD.0020.0010.3065] # <HIRAGANA LETTER TU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30C5 30FE ; [.32CD.0020.0011.30C4][.0000.0128.0002.3099][.32CD.0020.0010.30C5][.0000.0128.0002.3099] # <KATAKANA LETTER DU, KATAKANA VOICED ITERATION MARK>
30C4 3099 30FE ; [.32CD.0020.0011.30C4][.0000.0128.0002.3099][.32CD.0020.0010.30C5][.0000.0128.0002.3099] # <KATAKANA LETTER TU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF82 FF9E 30FE ; [.32CD.0020.0011.30C4][.0000.0128.0002.3099][.32CD.0020.0010.30C5][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER TU, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3065 309E ; [.32CD.0020.0011.3064][.0000.0128.0002.3099][.32CD.0020.0010.3065][.0000.0128.0002.3099] # <HIRAGANA LETTER DU, HIRAGANA VOICED ITERATION MARK>
3064 3099 309E ; [.32CD.0020.0011.3064][.0000.0128.0002.3099][.32CD.0020.0010.3065][.0000.0128.0002.3099] # <HIRAGANA LETTER TU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30C6 30FD ; [.32CE.0020.0011.30C6][.32CE.0020.0010.30C6] # <KATAKANA LETTER TE, KATAKANA ITERATION MARK>
FF83 30FD ; [.32CE.0020.0011.30C6][.32CE.0020.0010.30C6] # <HALFWIDTH KATAKANA LETTER TE, KATAKANA ITERATION MARK>
3066 309D ; [.32CE.0020.0011.3066][.32CE.0020.0010.3066] # <HIRAGANA LETTER TE, HIRAGANA ITERATION MARK>
30C6 30FE ; [.32CE.0020.0011.30C6][.32CE.0020.0010.30C6][.0000.0128.0002.3099] # <KATAKANA LETTER TE, KATAKANA VOICED ITERATION MARK>
FF83 30FE ; [.32CE.0020.0011.30C6][.32CE.0020.0010.30C6][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER TE, KATAKANA VOICED ITERATION MARK>
3066 309E ; [.32CE.0020.0011.3066][.32CE.0020.0010.3066][.0000.0128.0002.3099] # <HIRAGANA LETTER TE, HIRAGANA VOICED ITERATION MARK>
30C7 30FD ; [.32CE.0020.0011.30C6][.0000.0128.0002.3099][.32CE.0020.0010.30C7] # <KATAKANA LETTER DE, KATAKANA ITERATION MARK>
30C6 3099 30FD ; [.32CE.0020.0011.30C6][.0000.0128.0002.3099][.32CE.0020.0010.30C7] # <KATAKANA LETTER TE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF83 FF9E 30FD ; [.32CE.0020.0011.30C6][.0000.0128.0002.3099][.32CE.0020.0010.30C7] # <HALFWIDTH KATAKANA LETTER TE, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
3067 309D ; [.32CE.0020.0011.3066][.0000.0128.0002.3099][.32CE.0020.0010.3067] # <HIRAGANA LETTER DE, HIRAGANA ITERATION MARK>
3066 3099 309D ; [.32CE.0020.0011.3066][.0000.0128.0002.3099][.32CE.0020.0010.3067] # <HIRAGANA LETTER TE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30C7 30FE ; [.32CE.0020.0011.30C6][.0000.0128.0002.3099][.32CE.0020.0010.30C7][.0000.0128.0002.3099] # <KATAKANA LETTER DE, KATAKANA VOICED ITERATION MARK>
30C6 3099 30FE ; [.32CE.0020.0011.30C6][.0000.0128.0002.3099][.32CE.0020.0010.30C7][.0000.0128.0002.3099] # <KATAKANA LETTER TE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF83 FF9E 30FE ; [.32CE.0020.0011.30C6][.0000.0128.0002.3099][.32CE.0020.0010.30C7][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER TE, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3067 309E ; [.32CE.0020.0011.3066][.0000.0128.0002.3099][.32CE.0020.0010.3067][.0000.0128.0002.3099] # <HIRAGANA LETTER DE, HIRAGANA VOICED ITERATION MARK>
3066 3099 309E ; [.32CE.0020.0011.3066][.0000.0128.0002.3099][.32CE.0020.0010.3067][.0000.0128.0002.3099] # <HIRAGANA LETTER TE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30C8 30FD ; [.32CF.0020.0011.30C8][.32CF.0020.0010.30C8] # <KATAKANA LETTER TO, KATAKANA ITERATION MARK>
FF84 30FD ; [.32CF.0020.0011.30C8][.32CF.0020.0010.30C8] # <HALFWIDTH KATAKANA LETTER TO, KATAKANA ITERATION MARK>
3068 309D ; [.32CF.0020.0011.3068][.32CF.0020.0010.3068] # <HIRAGANA LETTER TO, HIRAGANA ITERATION MARK>
30C8 30FE ; [.32CF.0020.0011.30C8][.32CF.0020.0010.30C8][.0000.0128.0002.3099] # <KATAKANA LETTER TO, KATAKANA VOICED ITERATION MARK>
FF84 30FE ; [.32CF.0020.0011.30C8][.32CF.0020.0010.30C8][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER TO, KATAKANA VOICED ITERATION MARK>
3068 309E ; [.32CF.0020.0011.3068][.32CF.0020.0010.3068][.0000.0128.0002.3099] # <HIRAGANA LETTER TO, HIRAGANA VOICED ITERATION MARK>
30C9 30FD ; [.32CF.0020.0011.30C8][.0000.0128.0002.3099][.32CF.0020.0010.30C9] # <KATAKANA LETTER DO, KATAKANA ITERATION MARK>
30C8 3099 30FD ; [.32CF.0020.0011.30C8][.0000.0128.0002.3099][.32CF.0020.0010.30C9] # <KATAKANA LETTER TO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF84 FF9E 30FD ; [.32CF.0020.0011.30C8][.0000.0128.0002.3099][.32CF.0020.0010.30C9] # <HALFWIDTH KATAKANA LETTER TO, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
3069 309D ; [.32CF.0020.0011.3068][.0000.0128.0002.3099][.32CF.0020.0010.3069] # <HIRAGANA LETTER DO, HIRAGANA ITERATION MARK>
3068 3099 309D ; [.32CF.0020.0011.3068][.0000.0128.0002.3099][.32CF.0020.0010.3069] # <HIRAGANA LETTER TO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30C9 30FE ; [.32CF.0020.0011.30C8][.0000.0128.0002.3099][.32CF.0020.0010.30C9][.0000.0128.0002.3099] # <KATAKANA LETTER DO, KATAKANA VOICED ITERATION MARK>
30C8 3099 30FE ; [.32CF.0020.0011.30C8][.0000.0128.0002.3099][.32CF.0020.0010.30C9][.0000.0128.0002.3099] # <KATAKANA LETTER TO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF84 FF9E 30FE ; [.32CF.0020.0011.30C8][.0000.0128.0002.3099][.32CF.0020.0010.30C9][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER TO, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3069 309E ; [.32CF.0020.0011.3068][.0000.0128.0002.3099][.32CF.0020.0010.3069][.0000.0128.0002.3099] # <HIRAGANA LETTER DO, HIRAGANA VOICED ITERATION MARK>
3068 3099 309E ; [.32CF.0020.0011.3068][.0000.0128.0002.3099][.32CF.0020.0010.3069][.0000.0128.0002.3099] # <HIRAGANA LETTER TO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30CA 30FD ; [.32D0.0020.0011.30CA][.32D0.0020.0010.30CA] # <KATAKANA LETTER NA, KATAKANA ITERATION MARK>
FF85 30FD ; [.32D0.0020.0011.30CA][.32D0.0020.0010.30CA] # <HALFWIDTH KATAKANA LETTER NA, KATAKANA ITERATION MARK>
306A 309D ; [.32D0.0020.0011.306A][.32D0.0020.0010.306A] # <HIRAGANA LETTER NA, HIRAGANA ITERATION MARK>
30CB 30FD ; [.32D1.0020.0011.30CB][.32D1.0020.0010.30CB] # <KATAKANA LETTER NI, KATAKANA ITERATION MARK>
FF86 30FD ; [.32D1.0020.0011.30CB][.32D1.0020.0010.30CB] # <HALFWIDTH KATAKANA LETTER NI, KATAKANA ITERATION MARK>
306B 309D ; [.32D1.0020.0011.306B][.32D1.0020.0010.306B] # <HIRAGANA LETTER NI, HIRAGANA ITERATION MARK>
30CC 30FD ; [.32D2.0020.0011.30CC][.32D2.0020.0010.30CC] # <KATAKANA LETTER NU, KATAKANA ITERATION MARK>
FF87 30FD ; [.32D2.0020.0011.30CC][.32D2.0020.0010.30CC] # <HALFWIDTH KATAKANA LETTER NU, KATAKANA ITERATION MARK>
306C 309D ; [.32D2.0020.0011.306C][.32D2.0020.0010.306C] # <HIRAGANA LETTER NU, HIRAGANA ITERATION MARK>
30CD 30FD ; [.32D3.0020.0011.30CD][.32D3.0020.0010.30CD] # <KATAKANA LETTER NE, KATAKANA ITERATION MARK>
FF88 30FD ; [.32D3.0020.0011.30CD][.32D3.0020.0010.30CD] # <HALFWIDTH KATAKANA LETTER NE, KATAKANA ITERATION MARK>
306D 309D ; [.32D3.0020.0011.306D][.32D3.0020.0010.306D] # <HIRAGANA LETTER NE, HIRAGANA ITERATION MARK>
30CE 30FD ; [.32D4.0020.0011.30CE][.32D4.0020.0010.30CE] # <KATAKANA LETTER NO, KATAKANA ITERATION MARK>
FF89 30FD ; [.32D4.0020.0011.30CE][.32D4.0020.0010.30CE] # <HALFWIDTH KATAKANA LETTER NO, KATAKANA ITERATION MARK>
306E 309D ; [.32D4.0020.0011.306E][.32D4.0020.0010.306E] # <HIRAGANA LETTER NO, HIRAGANA ITERATION MARK>
30CF 30FD ; [.32D5.0020.0011.30CF][.32D5.0020.0010.30CF] # <KATAKANA LETTER HA, KATAKANA ITERATION MARK>
FF8A 30FD ; [.32D5.0020.0011.30CF][.32D5.0020.0010.30CF] # <HALFWIDTH KATAKANA LETTER HA, KATAKANA ITERATION MARK>
306F 309D ; [.32D5.0020.0011.306F][.32D5.0020.0010.306F] # <HIRAGANA LETTER HA, HIRAGANA ITERATION MARK>
30CF 30FE ; [.32D5.0020.0011.30CF][.32D5.0020.0010.30CF][.0000.0128.0002.3099] # <KATAKANA LETTER HA, KATAKANA VOICED ITERATION MARK>
FF8A 30FE ; [.32D5.0020.0011.30CF][.32D5.0020.0010.30CF][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER HA, KATAKANA VOICED ITERATION MARK>
306F 309E ; [.32D5.0020.0011.306F][.32D5.0020.0010.306F][.0000.0128.0002.3099] # <HIRAGANA LETTER HA, HIRAGANA VOICED ITERATION MARK>
30D0 30FD ; [.32D5.0020.0011.30CF][.0000.0128.0002.3099][.32D5.0020.0010.30D0] # <KATAKANA LETTER BA, KATAKANA ITERATION MARK>
30CF 3099 30FD ; [.32D5.0020.0011.30CF][.0000.0128.0002.3099][.32D5.0020.0010.30D0] # <KATAKANA LETTER HA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF8A FF9E 30FD ; [.32D5.0020.0011.30CF][.0000.0128.0002.3099][.32D5.0020.0010.30D0] # <HALFWIDTH KATAKANA LETTER HA, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
3070 309D ; [.32D5.0020.0011.306F][.0000.0128.0002.3099][.32D5.0020.0010.3070] # <HIRAGANA LETTER BA, HIRAGANA ITERATION MARK>
306F 3099 309D ; [.32D5.0020.0011.306F][.0000.0128.0002.3099][.32D5.0020.0010.3070] # <HIRAGANA LETTER HA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30D0 30FE ; [.32D5.0020.0011.30CF][.0000.0128.0002.3099][.32D5.0020.0010.30D0][.0000.0128.0002.3099] # <KATAKANA LETTER BA, KATAKANA VOICED ITERATION MARK>
30CF 3099 30FE ; [.32D5.0020.0011.30CF][.0000.0128.0002.3099][.32D5.0020.0010.30D0][.0000.0128.0002.3099] # <KATAKANA LETTER HA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF8A FF9E 30FE ; [.32D5.0020.0011.30CF][.0000.0128.0002.3099][.32D5.0020.0010.30D0][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER HA, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3070 309E ; [.32D5.0020.0011.306F][.0000.0128.0002.3099][.32D5.0020.0010.3070][.0000.0128.0002.3099] # <HIRAGANA LETTER BA, HIRAGANA VOICED ITERATION MARK>
306F 3099 309E ; [.32D5.0020.0011.306F][.0000.0128.0002.3099][.32D5.0020.0010.3070][.0000.0128.0002.3099] # <HIRAGANA LETTER HA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30D1 30FD ; [.32D5.0020.0011.30CF][.0000.0129.0002.309A][.32D5.0020.0010.30D1] # <KATAKANA LETTER PA, KATAKANA ITERATION MARK>
30CF 309A 30FD ; [.32D5.0020.0011.30CF][.0000.0129.0002.309A][.32D5.0020.0010.30D1] # <KATAKANA LETTER HA, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF8A FF9F 30FD ; [.32D5.0020.0011.30CF][.0000.0129.0002.309A][.32D5.0020.0010.30D1] # <HALFWIDTH KATAKANA LETTER HA, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, KATAKANA ITERATION MARK>
3071 309D ; [.32D5.0020.0011.306F][.0000.0129.0002.309A][.32D5.0020.0010.3071] # <HIRAGANA LETTER PA, HIRAGANA ITERATION MARK>
306F 309A 309D ; [.32D5.0020.0011.306F][.0000.0129.0002.309A][.32D5.0020.0010.3071] # <HIRAGANA LETTER HA, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30D1 30FE ; [.32D5.0020.0011.30CF][.0000.0129.0002.309A][.32D5.0020.0010.30D1][.0000.0128.0002.3099] # <KATAKANA LETTER PA, KATAKANA VOICED ITERATION MARK>
30CF 309A 30FE ; [.32D5.0020.0011.30CF][.0000.0129.0002.309A][.32D5.0020.0010.30D1][.0000.0128.0002.3099] # <KATAKANA LETTER HA, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF8A FF9F 30FE ; [.32D5.0020.0011.30CF][.0000.0129.0002.309A][.32D5.0020.0010.30D1][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER HA, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3071 309E ; [.32D5.0020.0011.306F][.0000.0129.0002.309A][.32D5.0020.0010.3071][.0000.0128.0002.3099] # <HIRAGANA LETTER PA, HIRAGANA VOICED ITERATION MARK>
306F 309A 309E ; [.32D5.0020.0011.306F][.0000.0129.0002.309A][.32D5.0020.0010.3071][.0000.0128.0002.3099] # <HIRAGANA LETTER HA, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30D2 30FD ; [.32D6.0020.0011.30D2][.32D6.0020.0010.30D2] # <KATAKANA LETTER HI, KATAKANA ITERATION MARK>
FF8B 30FD ; [.32D6.0020.0011.30D2][.32D6.0020.0010.30D2] # <HALFWIDTH KATAKANA LETTER HI, KATAKANA ITERATION MARK>
3072 309D ; [.32D6.0020.0011.3072][.32D6.0020.0010.3072] # <HIRAGANA LETTER HI, HIRAGANA ITERATION MARK>
30D2 30FE ; [.32D6.0020.0011.30D2][.32D6.0020.0010.30D2][.0000.0128.0002.3099] # <KATAKANA LETTER HI, KATAKANA VOICED ITERATION MARK>
FF8B 30FE ; [.32D6.0020.0011.30D2][.32D6.0020.0010.30D2][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER HI, KATAKANA VOICED ITERATION MARK>
3072 309E ; [.32D6.0020.0011.3072][.32D6.0020.0010.3072][.0000.0128.0002.3099] # <HIRAGANA LETTER HI, HIRAGANA VOICED ITERATION MARK>
30D3 30FD ; [.32D6.0020.0011.30D2][.0000.0128.0002.3099][.32D6.0020.0010.30D3] # <KATAKANA LETTER BI, KATAKANA ITERATION MARK>
30D2 3099 30FD ; [.32D6.0020.0011.30D2][.0000.0128.0002.3099][.32D6.0020.0010.30D3] # <KATAKANA LETTER HI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF8B FF9E 30FD ; [.32D6.0020.0011.30D2][.0000.0128.0002.3099][.32D6.0020.0010.30D3] # <HALFWIDTH KATAKANA LETTER HI, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
3073 309D ; [.32D6.0020.0011.3072][.0000.0128.0002.3099][.32D6.0020.0010.3073] # <HIRAGANA LETTER BI, HIRAGANA ITERATION MARK>
3072 3099 309D ; [.32D6.0020.0011.3072][.0000.0128.0002.3099][.32D6.0020.0010.3073] # <HIRAGANA LETTER HI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30D3 30FE ; [.32D6.0020.0011.30D2][.0000.0128.0002.3099][.32D6.0020.0010.30D3][.0000.0128.0002.3099] # <KATAKANA LETTER BI, KATAKANA VOICED ITERATION MARK>
30D2 3099 30FE ; [.32D6.0020.0011.30D2][.0000.0128.0002.3099][.32D6.0020.0010.30D3][.0000.0128.0002.3099] # <KATAKANA LETTER HI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF8B FF9E 30FE ; [.32D6.0020.0011.30D2][.0000.0128.0002.3099][.32D6.0020.0010.30D3][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER HI, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3073 309E ; [.32D6.0020.0011.3072][.0000.0128.0002.3099][.32D6.0020.0010.3073][.0000.0128.0002.3099] # <HIRAGANA LETTER BI, HIRAGANA VOICED ITERATION MARK>
3072 3099 309E ; [.32D6.0020.0011.3072][.0000.0128.0002.3099][.32D6.0020.0010.3073][.0000.0128.0002.3099] # <HIRAGANA LETTER HI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30D4 30FD ; [.32D6.0020.0011.30D2][.0000.0129.0002.309A][.32D6.0020.0010.30D4] # <KATAKANA LETTER PI, KATAKANA ITERATION MARK>
30D2 309A 30FD ; [.32D6.0020.0011.30D2][.0000.0129.0002.309A][.32D6.0020.0010.30D4] # <KATAKANA LETTER HI, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF8B FF9F 30FD ; [.32D6.0020.0011.30D2][.0000.0129.0002.309A][.32D6.0020.0010.30D4] # <HALFWIDTH KATAKANA LETTER HI, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, KATAKANA ITERATION MARK>
3074 309D ; [.32D6.0020.0011.3072][.0000.0129.0002.309A][.32D6.0020.0010.3074] # <HIRAGANA LETTER PI, HIRAGANA ITERATION MARK>
3072 309A 309D ; [.32D6.0020.0011.3072][.0000.0129.0002.309A][.32D6.0020.0010.3074] # <HIRAGANA LETTER HI, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30D4 30FE ; [.32D6.0020.0011.30D2][.0000.0129.0002.309A][.32D6.0020.0010.30D4][.0000.0128.0002.3099] # <KATAKANA LETTER PI, KATAKANA VOICED ITERATION MARK>
30D2 309A 30FE ; [.32D6.0020.0011.30D2][.0000.0129.0002.309A][.32D6.0020.0010.30D4][.0000.0128.0002.3099] # <KATAKANA LETTER HI, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF8B FF9F 30FE ; [.32D6.0020.0011.30D2][.0000.0129.0002.309A][.32D6.0020.0010.30D4][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER HI, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3074 309E ; [.32D6.0020.0011.3072][.0000.0129.0002.309A][.32D6.0020.0010.3074][.0000.0128.0002.3099] # <HIRAGANA LETTER PI, HIRAGANA VOICED ITERATION MARK>
3072 309A 309E ; [.32D6.0020.0011.3072][.0000.0129.0002.309A][.32D6.0020.0010.3074][.0000.0128.0002.3099] # <HIRAGANA LETTER HI, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30D5 30FD ; [.32D7.0020.0011.30D5][.32D7.0020.0010.30D5] # <KATAKANA LETTER HU, KATAKANA ITERATION MARK>
FF8C 30FD ; [.32D7.0020.0011.30D5][.32D7.0020.0010.30D5] # <HALFWIDTH KATAKANA LETTER HU, KATAKANA ITERATION MARK>
3075 309D ; [.32D7.0020.0011.3075][.32D7.0020.0010.3075] # <HIRAGANA LETTER HU, HIRAGANA ITERATION MARK>
30D5 30FE ; [.32D7.0020.0011.30D5][.32D7.0020.0010.30D5][.0000.0128.0002.3099] # <KATAKANA LETTER HU, KATAKANA VOICED ITERATION MARK>
FF8C 30FE ; [.32D7.0020.0011.30D5][.32D7.0020.0010.30D5][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER HU, KATAKANA VOICED ITERATION MARK>
3075 309E ; [.32D7.0020.0011.3075][.32D7.0020.0010.3075][.0000.0128.0002.3099] # <HIRAGANA LETTER HU, HIRAGANA VOICED ITERATION MARK>
30D6 30FD ; [.32D7.0020.0011.30D5][.0000.0128.0002.3099][.32D7.0020.0010.30D6] # <KATAKANA LETTER BU, KATAKANA ITERATION MARK>
30D5 3099 30FD ; [.32D7.0020.0011.30D5][.0000.0128.0002.3099][.32D7.0020.0010.30D6] # <KATAKANA LETTER HU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF8C FF9E 30FD ; [.32D7.0020.0011.30D5][.0000.0128.0002.3099][.32D7.0020.0010.30D6] # <HALFWIDTH KATAKANA LETTER HU, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
3076 309D ; [.32D7.0020.0011.3075][.0000.0128.0002.3099][.32D7.0020.0010.3076] # <HIRAGANA LETTER BU, HIRAGANA ITERATION MARK>
3075 3099 309D ; [.32D7.0020.0011.3075][.0000.0128.0002.3099][.32D7.0020.0010.3076] # <HIRAGANA LETTER HU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30D6 30FE ; [.32D7.0020.0011.30D5][.0000.0128.0002.3099][.32D7.0020.0010.30D6][.0000.0128.0002.3099] # <KATAKANA LETTER BU, KATAKANA VOICED ITERATION MARK>
30D5 3099 30FE ; [.32D7.0020.0011.30D5][.0000.0128.0002.3099][.32D7.0020.0010.30D6][.0000.0128.0002.3099] # <KATAKANA LETTER HU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF8C FF9E 30FE ; [.32D7.0020.0011.30D5][.0000.0128.0002.3099][.32D7.0020.0010.30D6][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER HU, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3076 309E ; [.32D7.0020.0011.3075][.0000.0128.0002.3099][.32D7.0020.0010.3076][.0000.0128.0002.3099] # <HIRAGANA LETTER BU, HIRAGANA VOICED ITERATION MARK>
3075 3099 309E ; [.32D7.0020.0011.3075][.0000.0128.0002.3099][.32D7.0020.0010.3076][.0000.0128.0002.3099] # <HIRAGANA LETTER HU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30D7 30FD ; [.32D7.0020.0011.30D5][.0000.0129.0002.309A][.32D7.0020.0010.30D7] # <KATAKANA LETTER PU, KATAKANA ITERATION MARK>
30D5 309A 30FD ; [.32D7.0020.0011.30D5][.0000.0129.0002.309A][.32D7.0020.0010.30D7] # <KATAKANA LETTER HU, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF8C FF9F 30FD ; [.32D7.0020.0011.30D5][.0000.0129.0002.309A][.32D7.0020.0010.30D7] # <HALFWIDTH KATAKANA LETTER HU, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, KATAKANA ITERATION MARK>
3077 309D ; [.32D7.0020.0011.3075][.0000.0129.0002.309A][.32D7.0020.0010.3077] # <HIRAGANA LETTER PU, HIRAGANA ITERATION MARK>
3075 309A 309D ; [.32D7.0020.0011.3075][.0000.0129.0002.309A][.32D7.0020.0010.3077] # <HIRAGANA LETTER HU, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30D7 30FE ; [.32D7.0020.0011.30D5][.0000.0129.0002.309A][.32D7.0020.0010.30D7][.0000.0128.0002.3099] # <KATAKANA LETTER PU, KATAKANA VOICED ITERATION MARK>
30D5 309A 30FE ; [.32D7.0020.0011.30D5][.0000.0129.0002.309A][.32D7.0020.0010.30D7][.0000.0128.0002.3099] # <KATAKANA LETTER HU, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF8C FF9F 30FE ; [.32D7.0020.0011.30D5][.0000.0129.0002.309A][.32D7.0020.0010.30D7][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER HU, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3077 309E ; [.32D7.0020.0011.3075][.0000.0129.0002.309A][.32D7.0020.0010.3077][.0000.0128.0002.3099] # <HIRAGANA LETTER PU, HIRAGANA VOICED ITERATION MARK>
3075 309A 309E ; [.32D7.0020.0011.3075][.0000.0129.0002.309A][.32D7.0020.0010.3077][.0000.0128.0002.3099] # <HIRAGANA LETTER HU, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30D8 30FD ; [.32D8.0020.0011.30D8][.32D8.0020.0010.30D8] # <KATAKANA LETTER HE, KATAKANA ITERATION MARK>
FF8D 30FD ; [.32D8.0020.0011.30D8][.32D8.0020.0010.30D8] # <HALFWIDTH KATAKANA LETTER HE, KATAKANA ITERATION MARK>
3078 309D ; [.32D8.0020.0011.3078][.32D8.0020.0010.3078] # <HIRAGANA LETTER HE, HIRAGANA ITERATION MARK>
30D8 30FE ; [.32D8.0020.0011.30D8][.32D8.0020.0010.30D8][.0000.0128.0002.3099] # <KATAKANA LETTER HE, KATAKANA VOICED ITERATION MARK>
FF8D 30FE ; [.32D8.0020.0011.30D8][.32D8.0020.0010.30D8][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER HE, KATAKANA VOICED ITERATION MARK>
3078 309E ; [.32D8.0020.0011.3078][.32D8.0020.0010.3078][.0000.0128.0002.3099] # <HIRAGANA LETTER HE, HIRAGANA VOICED ITERATION MARK>
30D9 30FD ; [.32D8.0020.0011.30D8][.0000.0128.0002.3099][.32D8.0020.0010.30D9] # <KATAKANA LETTER BE, KATAKANA ITERATION MARK>
30D8 3099 30FD ; [.32D8.0020.0011.30D8][.0000.0128.0002.3099][.32D8.0020.0010.30D9] # <KATAKANA LETTER HE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF8D FF9E 30FD ; [.32D8.0020.0011.30D8][.0000.0128.0002.3099][.32D8.0020.0010.30D9] # <HALFWIDTH KATAKANA LETTER HE, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
3079 309D ; [.32D8.0020.0011.3078][.0000.0128.0002.3099][.32D8.0020.0010.3079] # <HIRAGANA LETTER BE, HIRAGANA ITERATION MARK>
3078 3099 309D ; [.32D8.0020.0011.3078][.0000.0128.0002.3099][.32D8.0020.0010.3079] # <HIRAGANA LETTER HE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30D9 30FE ; [.32D8.0020.0011.30D8][.0000.0128.0002.3099][.32D8.0020.0010.30D9][.0000.0128.0002.3099] # <KATAKANA LETTER BE, KATAKANA VOICED ITERATION MARK>
30D8 3099 30FE ; [.32D8.0020.0011.30D8][.0000.0128.0002.3099][.32D8.0020.0010.30D9][.0000.0128.0002.3099] # <KATAKANA LETTER HE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF8D FF9E 30FE ; [.32D8.0020.0011.30D8][.0000.0128.0002.3099][.32D8.0020.0010.30D9][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER HE, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3079 309E ; [.32D8.0020.0011.3078][.0000.0128.0002.3099][.32D8.0020.0010.3079][.0000.0128.0002.3099] # <HIRAGANA LETTER BE, HIRAGANA VOICED ITERATION MARK>
3078 3099 309E ; [.32D8.0020.0011.3078][.0000.0128.0002.3099][.32D8.0020.0010.3079][.0000.0128.0002.3099] # <HIRAGANA LETTER HE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30DA 30FD ; [.32D8.0020.0011.30D8][.0000.0129.0002.309A][.32D8.0020.0010.30DA] # <KATAKANA LETTER PE, KATAKANA ITERATION MARK>
30D8 309A 30FD ; [.32D8.0020.0011.30D8][.0000.0129.0002.309A][.32D8.0020.0010.30DA] # <KATAKANA LETTER HE, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF8D FF9F 30FD ; [.32D8.0020.0011.30D8][.0000.0129.0002.309A][.32D8.0020.0010.30DA] # <HALFWIDTH KATAKANA LETTER HE, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, KATAKANA ITERATION MARK>
307A 309D ; [.32D8.0020.0011.3078][.0000.0129.0002.309A][.32D8.0020.0010.307A] # <HIRAGANA LETTER PE, HIRAGANA ITERATION MARK>
3078 309A 309D ; [.32D8.0020.0011.3078][.0000.0129.0002.309A][.32D8.0020.0010.307A] # <HIRAGANA LETTER HE, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30DA 30FE ; [.32D8.0020.0011.30D8][.0000.0129.0002.309A][.32D8.0020.0010.30DA][.0000.0128.0002.3099] # <KATAKANA LETTER PE, KATAKANA VOICED ITERATION MARK>
30D8 309A 30FE ; [.32D8.0020.0011.30D8][.0000.0129.0002.309A][.32D8.0020.0010.30DA][.0000.0128.0002.3099] # <KATAKANA LETTER HE, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF8D FF9F 30FE ; [.32D8.0020.0011.30D8][.0000.0129.0002.309A][.32D8.0020.0010.30DA][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER HE, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
307A 309E ; [.32D8.0020.0011.3078][.0000.0129.0002.309A][.32D8.0020.0010.307A][.0000.0128.0002.3099] # <HIRAGANA LETTER PE, HIRAGANA VOICED ITERATION MARK>
3078 309A 309E ; [.32D8.0020.0011.3078][.0000.0129.0002.309A][.32D8.0020.0010.307A][.0000.0128.0002.3099] # <HIRAGANA LETTER HE, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30DB 30FD ; [.32D9.0020.0011.30DB][.32D9.0020.0010.30DB] # <KATAKANA LETTER HO, KATAKANA ITERATION MARK>
FF8E 30FD ; [.32D9.0020.0011.30DB][.32D9.0020.0010.30DB] # <HALFWIDTH KATAKANA LETTER HO, KATAKANA ITERATION MARK>
307B 309D ; [.32D9.0020.0011.307B][.32D9.0020.0010.307B] # <HIRAGANA LETTER HO, HIRAGANA ITERATION MARK>
30DB 30FE ; [.32D9.0020.0011.30DB][.32D9.0020.0010.30DB][.0000.0128.0002.3099] # <KATAKANA LETTER HO, KATAKANA VOICED ITERATION MARK>
FF8E 30FE ; [.32D9.0020.0011.30DB][.32D9.0020.0010.30DB][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER HO, KATAKANA VOICED ITERATION MARK>
307B 309E ; [.32D9.0020.0011.307B][.32D9.0020.0010.307B][.0000.0128.0002.3099] # <HIRAGANA LETTER HO, HIRAGANA VOICED ITERATION MARK>
30DC 30FD ; [.32D9.0020.0011.30DB][.0000.0128.0002.3099][.32D9.0020.0010.30DC] # <KATAKANA LETTER BO, KATAKANA ITERATION MARK>
30DB 3099 30FD ; [.32D9.0020.0011.30DB][.0000.0128.0002.3099][.32D9.0020.0010.30DC] # <KATAKANA LETTER HO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF8E FF9E 30FD ; [.32D9.0020.0011.30DB][.0000.0128.0002.3099][.32D9.0020.0010.30DC] # <HALFWIDTH KATAKANA LETTER HO, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
307C 309D ; [.32D9.0020.0011.307B][.0000.0128.0002.3099][.32D9.0020.0010.307C] # <HIRAGANA LETTER BO, HIRAGANA ITERATION MARK>
307B 3099 309D ; [.32D9.0020.0011.307B][.0000.0128.0002.3099][.32D9.0020.0010.307C] # <HIRAGANA LETTER HO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30DC 30FE ; [.32D9.0020.0011.30DB][.0000.0128.0002.3099][.32D9.0020.0010.30DC][.0000.0128.0002.3099] # <KATAKANA LETTER BO, KATAKANA VOICED ITERATION MARK>
30DB 3099 30FE ; [.32D9.0020.0011.30DB][.0000.0128.0002.3099][.32D9.0020.0010.30DC][.0000.0128.0002.3099] # <KATAKANA LETTER HO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF8E FF9E 30FE ; [.32D9.0020.0011.30DB][.0000.0128.0002.3099][.32D9.0020.0010.30DC][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER HO, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
307C 309E ; [.32D9.0020.0011.307B][.0000.0128.0002.3099][.32D9.0020.0010.307C][.0000.0128.0002.3099] # <HIRAGANA LETTER BO, HIRAGANA VOICED ITERATION MARK>
307B 3099 309E ; [.32D9.0020.0011.307B][.0000.0128.0002.3099][.32D9.0020.0010.307C][.0000.0128.0002.3099] # <HIRAGANA LETTER HO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30DD 30FD ; [.32D9.0020.0011.30DB][.0000.0129.0002.309A][.32D9.0020.0010.30DD] # <KATAKANA LETTER PO, KATAKANA ITERATION MARK>
30DB 309A 30FD ; [.32D9.0020.0011.30DB][.0000.0129.0002.309A][.32D9.0020.0010.30DD] # <KATAKANA LETTER HO, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF8E FF9F 30FD ; [.32D9.0020.0011.30DB][.0000.0129.0002.309A][.32D9.0020.0010.30DD] # <HALFWIDTH KATAKANA LETTER HO, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, KATAKANA ITERATION MARK>
307D 309D ; [.32D9.0020.0011.307B][.0000.0129.0002.309A][.32D9.0020.0010.307D] # <HIRAGANA LETTER PO, HIRAGANA ITERATION MARK>
307B 309A 309D ; [.32D9.0020.0011.307B][.0000.0129.0002.309A][.32D9.0020.0010.307D] # <HIRAGANA LETTER HO, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30DD 30FE ; [.32D9.0020.0011.30DB][.0000.0129.0002.309A][.32D9.0020.0010.30DD][.0000.0128.0002.3099] # <KATAKANA LETTER PO, KATAKANA VOICED ITERATION MARK>
30DB 309A 30FE ; [.32D9.0020.0011.30DB][.0000.0129.0002.309A][.32D9.0020.0010.30DD][.0000.0128.0002.3099] # <KATAKANA LETTER HO, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF8E FF9F 30FE ; [.32D9.0020.0011.30DB][.0000.0129.0002.309A][.32D9.0020.0010.30DD][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER HO, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
307D 309E ; [.32D9.0020.0011.307B][.0000.0129.0002.309A][.32D9.0020.0010.307D][.0000.0128.0002.3099] # <HIRAGANA LETTER PO, HIRAGANA VOICED ITERATION MARK>
307B 309A 309E ; [.32D9.0020.0011.307B][.0000.0129.0002.309A][.32D9.0020.0010.307D][.0000.0128.0002.3099] # <HIRAGANA LETTER HO, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30DE 30FD ; [.32DA.0020.0011.30DE][.32DA.0020.0010.30DE] # <KATAKANA LETTER MA, KATAKANA ITERATION MARK>
FF8F 30FD ; [.32DA.0020.0011.30DE][.32DA.0020.0010.30DE] # <HALFWIDTH KATAKANA LETTER MA, KATAKANA ITERATION MARK>
307E 309D ; [.32DA.0020.0011.307E][.32DA.0020.0010.307E] # <HIRAGANA LETTER MA, HIRAGANA ITERATION MARK>
30DF 30FD ; [.32DB.0020.0011.30DF][.32DB.0020.0010.30DF] # <KATAKANA LETTER MI, KATAKANA ITERATION MARK>
FF90 30FD ; [.32DB.0020.0011.30DF][.32DB.0020.0010.30DF] # <HALFWIDTH KATAKANA LETTER MI, KATAKANA ITERATION MARK>
307F 309D ; [.32DB.0020.0011.307F][.32DB.0020.0010.307F] # <HIRAGANA LETTER MI, HIRAGANA ITERATION MARK>
30E0 30FD ; [.32DC.0020.0011.30E0][.32DC.0020.0010.30E0] # <KATAKANA LETTER MU, KATAKANA ITERATION MARK>
FF91 30FD ; [.32DC.0020.0011.30E0][.32DC.0020.0010.30E0] # <HALFWIDTH KATAKANA LETTER MU, KATAKANA ITERATION MARK>
3080 309D ; [.32DC.0020.0011.3080][.32DC.0020.0010.3080] # <HIRAGANA LETTER MU, HIRAGANA ITERATION MARK>
30E1 30FD ; [.32DD.0020.0011.30E1][.32DD.0020.0010.30E1] # <KATAKANA LETTER ME, KATAKANA ITERATION MARK>
FF92 30FD ; [.32DD.0020.0011.30E1][.32DD.0020.0010.30E1] # <HALFWIDTH KATAKANA LETTER ME, KATAKANA ITERATION MARK>
3081 309D ; [.32DD.0020.0011.3081][.32DD.0020.0010.3081] # <HIRAGANA LETTER ME, HIRAGANA ITERATION MARK>
30E2 30FD ; [.32DE.0020.0011.30E2][.32DE.0020.0010.30E2] # <KATAKANA LETTER MO, KATAKANA ITERATION MARK>
FF93 30FD ; [.32DE.0020.0011.30E2][.32DE.0020.0010.30E2] # <HALFWIDTH KATAKANA LETTER MO, KATAKANA ITERATION MARK>
3082 309D ; [.32DE.0020.0011.3082][.32DE.0020.0010.3082] # <HIRAGANA LETTER MO, HIRAGANA ITERATION MARK>
30E3 30FD ; [.32DF.0020.000F.30E3][.32DF.0020.0010.30E3] # <KATAKANA LETTER SMALL YA, KATAKANA ITERATION MARK>
FF6C 30FD ; [.32DF.0020.000F.30E3][.32DF.0020.0010.30E3] # <HALFWIDTH KATAKANA LETTER SMALL YA, KATAKANA ITERATION MARK>
3083 309D ; [.32DF.0020.000F.3083][.32DF.0020.0010.3083] # <HIRAGANA LETTER SMALL YA, HIRAGANA ITERATION MARK>
30E4 30FD ; [.32DF.0020.0011.30E4][.32DF.0020.0010.30E4] # <KATAKANA LETTER YA, KATAKANA ITERATION MARK>
FF94 30FD ; [.32DF.0020.0011.30E4][.32DF.0020.0010.30E4] # <HALFWIDTH KATAKANA LETTER YA, KATAKANA ITERATION MARK>
3084 309D ; [.32DF.0020.0011.3084][.32DF.0020.0010.3084] # <HIRAGANA LETTER YA, HIRAGANA ITERATION MARK>
30E5 30FD ; [.32E0.0020.000F.30E5][.32E0.0020.0010.30E5] # <KATAKANA LETTER SMALL YU, KATAKANA ITERATION MARK>
FF6D 30FD ; [.32E0.0020.000F.30E5][.32E0.0020.0010.30E5] # <HALFWIDTH KATAKANA LETTER SMALL YU, KATAKANA ITERATION MARK>
3085 309D ; [.32E0.0020.000F.3085][.32E0.0020.0010.3085] # <HIRAGANA LETTER SMALL YU, HIRAGANA ITERATION MARK>
30E6 30FD ; [.32E0.0020.0011.30E6][.32E0.0020.0010.30E6] # <KATAKANA LETTER YU, KATAKANA ITERATION MARK>
FF95 30FD ; [.32E0.0020.0011.30E6][.32E0.0020.0010.30E6] # <HALFWIDTH KATAKANA LETTER YU, KATAKANA ITERATION MARK>
3086 309D ; [.32E0.0020.0011.3086][.32E0.0020.0010.3086] # <HIRAGANA LETTER YU, HIRAGANA ITERATION MARK>
30E7 30FD ; [.32E2.0020.000F.30E7][.32E2.0020.0010.30E7] # <KATAKANA LETTER SMALL YO, KATAKANA ITERATION MARK>
FF6E 30FD ; [.32E2.0020.000F.30E7][.32E2.0020.0010.30E7] # <HALFWIDTH KATAKANA LETTER SMALL YO, KATAKANA ITERATION MARK>
3087 309D ; [.32E2.0020.000F.3087][.32E2.0020.0010.3087] # <HIRAGANA LETTER SMALL YO, HIRAGANA ITERATION MARK>
30E8 30FD ; [.32E2.0020.0011.30E8][.32E2.0020.0010.30E8] # <KATAKANA LETTER YO, KATAKANA ITERATION MARK>
FF96 30FD ; [.32E2.0020.0011.30E8][.32E2.0020.0010.30E8] # <HALFWIDTH KATAKANA LETTER YO, KATAKANA ITERATION MARK>
3088 309D ; [.32E2.0020.0011.3088][.32E2.0020.0010.3088] # <HIRAGANA LETTER YO, HIRAGANA ITERATION MARK>
30E9 30FD ; [.32E3.0020.0011.30E9][.32E3.0020.0010.30E9] # <KATAKANA LETTER RA, KATAKANA ITERATION MARK>
FF97 30FD ; [.32E3.0020.0011.30E9][.32E3.0020.0010.30E9] # <HALFWIDTH KATAKANA LETTER RA, KATAKANA ITERATION MARK>
3089 309D ; [.32E3.0020.0011.3089][.32E3.0020.0010.3089] # <HIRAGANA LETTER RA, HIRAGANA ITERATION MARK>
30EA 30FD ; [.32E4.0020.0011.30EA][.32E4.0020.0010.30EA] # <KATAKANA LETTER RI, KATAKANA ITERATION MARK>
FF98 30FD ; [.32E4.0020.0011.30EA][.32E4.0020.0010.30EA] # <HALFWIDTH KATAKANA LETTER RI, KATAKANA ITERATION MARK>
308A 309D ; [.32E4.0020.0011.308A][.32E4.0020.0010.308A] # <HIRAGANA LETTER RI, HIRAGANA ITERATION MARK>
30EB 30FD ; [.32E5.0020.0011.30EB][.32E5.0020.0010.30EB] # <KATAKANA LETTER RU, KATAKANA ITERATION MARK>
FF99 30FD ; [.32E5.0020.0011.30EB][.32E5.0020.0010.30EB] # <HALFWIDTH KATAKANA LETTER RU, KATAKANA ITERATION MARK>
308B 309D ; [.32E5.0020.0011.308B][.32E5.0020.0010.308B] # <HIRAGANA LETTER RU, HIRAGANA ITERATION MARK>
30EC 30FD ; [.32E6.0020.0011.30EC][.32E6.0020.0010.30EC] # <KATAKANA LETTER RE, KATAKANA ITERATION MARK>
FF9A 30FD ; [.32E6.0020.0011.30EC][.32E6.0020.0010.30EC] # <HALFWIDTH KATAKANA LETTER RE, KATAKANA ITERATION MARK>
308C 309D ; [.32E6.0020.0011.308C][.32E6.0020.0010.308C] # <HIRAGANA LETTER RE, HIRAGANA ITERATION MARK>
30ED 30FD ; [.32E7.0020.0011.30ED][.32E7.0020.0010.30ED] # <KATAKANA LETTER RO, KATAKANA ITERATION MARK>
FF9B 30FD ; [.32E7.0020.0011.30ED][.32E7.0020.0010.30ED] # <HALFWIDTH KATAKANA LETTER RO, KATAKANA ITERATION MARK>
308D 309D ; [.32E7.0020.0011.308D][.32E7.0020.0010.308D] # <HIRAGANA LETTER RO, HIRAGANA ITERATION MARK>
30EE 30FD ; [.32E8.0020.000F.30EE][.32E8.0020.0010.30EE] # <KATAKANA LETTER SMALL WA, KATAKANA ITERATION MARK>
308E 309D ; [.32E8.0020.000F.308E][.32E8.0020.0010.308E] # <HIRAGANA LETTER SMALL WA, HIRAGANA ITERATION MARK>
30EE 30FE ; [.32E8.0020.000F.30EE][.32E8.0020.0010.30EE][.0000.0128.0002.3099] # <KATAKANA LETTER SMALL WA, KATAKANA VOICED ITERATION MARK>
308E 309E ; [.32E8.0020.000F.308E][.32E8.0020.0010.308E][.0000.0128.0002.3099] # <HIRAGANA LETTER SMALL WA, HIRAGANA VOICED ITERATION MARK>
30EF 30FD ; [.32E8.0020.0011.30EF][.32E8.0020.0010.30EF] # <KATAKANA LETTER WA, KATAKANA ITERATION MARK>
FF9C 30FD ; [.32E8.0020.0011.30EF][.32E8.0020.0010.30EF] # <HALFWIDTH KATAKANA LETTER WA, KATAKANA ITERATION MARK>
308F 309D ; [.32E8.0020.0011.308F][.32E8.0020.0010.308F] # <HIRAGANA LETTER WA, HIRAGANA ITERATION MARK>
30EF 30FE ; [.32E8.0020.0011.30EF][.32E8.0020.0010.30EF][.0000.0128.0002.3099] # <KATAKANA LETTER WA, KATAKANA VOICED ITERATION MARK>
FF9C 30FE ; [.32E8.0020.0011.30EF][.32E8.0020.0010.30EF][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER WA, KATAKANA VOICED ITERATION MARK>
308F 309E ; [.32E8.0020.0011.308F][.32E8.0020.0010.308F][.0000.0128.0002.3099] # <HIRAGANA LETTER WA, HIRAGANA VOICED ITERATION MARK>
30F0 30FD ; [.32E9.0020.0011.30F0][.32E9.0020.0010.30F0] # <KATAKANA LETTER WI, KATAKANA ITERATION MARK>
3090 309D ; [.32E9.0020.0011.3090][.32E9.0020.0010.3090] # <HIRAGANA LETTER WI, HIRAGANA ITERATION MARK>
30F0 30FE ; [.32E9.0020.0011.30F0][.32E9.0020.0010.30F0][.0000.0128.0002.3099] # <KATAKANA LETTER WI, KATAKANA VOICED ITERATION MARK>
3090 309E ; [.32E9.0020.0011.3090][.32E9.0020.0010.3090][.0000.0128.0002.3099] # <HIRAGANA LETTER WI, HIRAGANA VOICED ITERATION MARK>
30F1 30FD ; [.32EA.0020.0011.30F1][.32EA.0020.0010.30F1] # <KATAKANA LETTER WE, KATAKANA ITERATION MARK>
3091 309D ; [.32EA.0020.0011.3091][.32EA.0020.0010.3091] # <HIRAGANA LETTER WE, HIRAGANA ITERATION MARK>
30F1 30FE ; [.32EA.0020.0011.30F1][.32EA.0020.0010.30F1][.0000.0128.0002.3099] # <KATAKANA LETTER WE, KATAKANA VOICED ITERATION MARK>
3091 309E ; [.32EA.0020.0011.3091][.32EA.0020.0010.3091][.0000.0128.0002.3099] # <HIRAGANA LETTER WE, HIRAGANA VOICED ITERATION MARK>
30F2 30FD ; [.32EB.0020.0011.30F2][.32EB.0020.0010.30F2] # <KATAKANA LETTER WO, KATAKANA ITERATION MARK>
FF66 30FD ; [.32EB.0020.0011.30F2][.32EB.0020.0010.30F2] # <HALFWIDTH KATAKANA LETTER WO, KATAKANA ITERATION MARK>
3092 309D ; [.32EB.0020.0011.3092][.32EB.0020.0010.3092] # <HIRAGANA LETTER WO, HIRAGANA ITERATION MARK>
30F2 30FE ; [.32EB.0020.0011.30F2][.32EB.0020.0010.30F2][.0000.0128.0002.3099] # <KATAKANA LETTER WO, KATAKANA VOICED ITERATION MARK>
FF66 30FE ; [.32EB.0020.0011.30F2][.32EB.0020.0010.30F2][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER WO, KATAKANA VOICED ITERATION MARK>
3092 309E ; [.32EB.0020.0011.3092][.32EB.0020.0010.3092][.0000.0128.0002.3099] # <HIRAGANA LETTER WO, HIRAGANA VOICED ITERATION MARK>
30F3 30FD ; [.32EC.0020.0011.30F3][.32EC.0020.0010.30F3] # <KATAKANA LETTER N, KATAKANA ITERATION MARK>
FF9D 30FD ; [.32EC.0020.0011.30F3][.32EC.0020.0010.30F3] # <HALFWIDTH KATAKANA LETTER N, KATAKANA ITERATION MARK>
3093 309D ; [.32EC.0020.0011.3093][.32EC.0020.0010.3093] # <HIRAGANA LETTER N, HIRAGANA ITERATION MARK>
30F4 30FD ; [.32BD.0020.0011.30A6][.0000.0128.0002.3099][.32BD.0020.0010.30F4] # <KATAKANA LETTER VU, KATAKANA ITERATION MARK>
30A6 3099 30FD ; [.32BD.0020.0011.30A6][.0000.0128.0002.3099][.32BD.0020.0010.30F4] # <KATAKANA LETTER U, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF73 FF9E 30FD ; [.32BD.0020.0011.30A6][.0000.0128.0002.3099][.32BD.0020.0010.30F4] # <HALFWIDTH KATAKANA LETTER U, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
3094 309D ; [.32BD.0020.0011.3046][.0000.0128.0002.3099][.32BD.0020.0010.3094] # <HIRAGANA LETTER VU, HIRAGANA ITERATION MARK>
3046 3099 309D ; [.32BD.0020.0011.3046][.0000.0128.0002.3099][.32BD.0020.0010.3094] # <HIRAGANA LETTER U, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30F4 30FE ; [.32BD.0020.0011.30A6][.0000.0128.0002.3099][.32BD.0020.0010.30F4][.0000.0128.0002.3099] # <KATAKANA LETTER VU, KATAKANA VOICED ITERATION MARK>
30A6 3099 30FE ; [.32BD.0020.0011.30A6][.0000.0128.0002.3099][.32BD.0020.0010.30F4][.0000.0128.0002.3099] # <KATAKANA LETTER U, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF73 FF9E 30FE ; [.32BD.0020.0011.30A6][.0000.0128.0002.3099][.32BD.0020.0010.30F4][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER U, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3094 309E ; [.32BD.0020.0011.3046][.0000.0128.0002.3099][.32BD.0020.0010.3094][.0000.0128.0002.3099] # <HIRAGANA LETTER VU, HIRAGANA VOICED ITERATION MARK>
3046 3099 309E ; [.32BD.0020.0011.3046][.0000.0128.0002.3099][.32BD.0020.0010.3094][.0000.0128.0002.3099] # <HIRAGANA LETTER U, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30F5 30FD ; [.32C1.0020.000F.30F5][.32C1.0020.0010.30F5] # <KATAKANA LETTER SMALL KA, KATAKANA ITERATION MARK>
3095 309D ; [.32C1.0020.000F.3095][.32C1.0020.0010.3095] # <HIRAGANA LETTER SMALL KA, HIRAGANA ITERATION MARK>
30F5 30FE ; [.32C1.0020.000F.30F5][.32C1.0020.0010.30F5][.0000.0128.0002.3099] # <KATAKANA LETTER SMALL KA, KATAKANA VOICED ITERATION MARK>
3095 309E ; [.32C1.0020.000F.3095][.32C1.0020.0010.3095][.0000.0128.0002.3099] # <HIRAGANA LETTER SMALL KA, HIRAGANA VOICED ITERATION MARK>
30F6 30FD ; [.32C4.0020.000F.30F6][.32C4.0020.0010.30F6] # <KATAKANA LETTER SMALL KE, KATAKANA ITERATION MARK>
3096 309D ; [.32C4.0020.000F.3096][.32C4.0020.0010.3096] # <HIRAGANA LETTER SMALL KE, HIRAGANA ITERATION MARK>
30F6 30FE ; [.32C4.0020.000F.30F6][.32C4.0020.0010.30F6][.0000.0128.0002.3099] # <KATAKANA LETTER SMALL KE, KATAKANA VOICED ITERATION MARK>
3096 309E ; [.32C4.0020.000F.3096][.32C4.0020.0010.3096][.0000.0128.0002.3099] # <HIRAGANA LETTER SMALL KE, HIRAGANA VOICED ITERATION MARK>
30F7 30FD ; [.32E8.0020.0011.30EF][.0000.0128.0002.3099][.32E8.0020.0010.30F7] # <KATAKANA LETTER VA, KATAKANA ITERATION MARK>
30EF 3099 30FD ; [.32E8.0020.0011.30EF][.0000.0128.0002.3099][.32E8.0020.0010.30F7] # <KATAKANA LETTER WA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF9C FF9E 30FD ; [.32E8.0020.0011.30EF][.0000.0128.0002.3099][.32E8.0020.0010.30F7] # <HALFWIDTH KATAKANA LETTER WA, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
30F7 30FE ; [.32E8.0020.0011.30EF][.0000.0128.0002.3099][.32E8.0020.0010.30F7][.0000.0128.0002.3099] # <KATAKANA LETTER VA, KATAKANA VOICED ITERATION MARK>
30EF 3099 30FE ; [.32E8.0020.0011.30EF][.0000.0128.0002.3099][.32E8.0020.0010.30F7][.0000.0128.0002.3099] # <KATAKANA LETTER WA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF9C FF9E 30FE ; [.32E8.0020.0011.30EF][.0000.0128.0002.3099][.32E8.0020.0010.30F7][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER WA, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
30F8 30FD ; [.32E9.0020.0011.30F0][.0000.0128.0002.3099][.32E9.0020.0010.30F8] # <KATAKANA LETTER VI, KATAKANA ITERATION MARK>
30F0 3099 30FD ; [.32E9.0020.0011.30F0][.0000.0128.0002.3099][.32E9.0020.0010.30F8] # <KATAKANA LETTER WI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
30F8 30FE ; [.32E9.0020.0011.30F0][.0000.0128.0002.3099][.32E9.0020.0010.30F8][.0000.0128.0002.3099] # <KATAKANA LETTER VI, KATAKANA VOICED ITERATION MARK>
30F0 3099 30FE ; [.32E9.0020.0011.30F0][.0000.0128.0002.3099][.32E9.0020.0010.30F8][.0000.0128.0002.3099] # <KATAKANA LETTER WI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
30F9 30FD ; [.32EA.0020.0011.30F1][.0000.0128.0002.3099][.32EA.0020.0010.30F9] # <KATAKANA LETTER VE, KATAKANA ITERATION MARK>
30F1 3099 30FD ; [.32EA.0020.0011.30F1][.0000.0128.0002.3099][.32EA.0020.0010.30F9] # <KATAKANA LETTER WE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
30F9 30FE ; [.32EA.0020.0011.30F1][.0000.0128.0002.3099][.32EA.0020.0010.30F9][.0000.0128.0002.3099] # <KATAKANA LETTER VE, KATAKANA VOICED ITERATION MARK>
30F1 3099 30FE ; [.32EA.0020.0011.30F1][.0000.0128.0002.3099][.32EA.0020.0010.30F9][.0000.0128.0002.3099] # <KATAKANA LETTER WE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
30FA 30FD ; [.32EB.0020.0011.30F2][.0000.0128.0002.3099][.32EB.0020.0010.30FA] # <KATAKANA LETTER VO, KATAKANA ITERATION MARK>
30F2 3099 30FD ; [.32EB.0020.0011.30F2][.0000.0128.0002.3099][.32EB.0020.0010.30FA] # <KATAKANA LETTER WO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF66 FF9E 30FD ; [.32EB.0020.0011.30F2][.0000.0128.0002.3099][.32EB.0020.0010.30FA] # <HALFWIDTH KATAKANA LETTER WO, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
30FA 30FE ; [.32EB.0020.0011.30F2][.0000.0128.0002.3099][.32EB.0020.0010.30FA][.0000.0128.0002.3099] # <KATAKANA LETTER VO, KATAKANA VOICED ITERATION MARK>
30F2 3099 30FE ; [.32EB.0020.0011.30F2][.0000.0128.0002.3099][.32EB.0020.0010.30FA][.0000.0128.0002.3099] # <KATAKANA LETTER WO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF66 FF9E 30FE ; [.32EB.0020.0011.30F2][.0000.0128.0002.3099][.32EB.0020.0010.30FA][.0000.0128.0002.3099] # <HALFWIDTH KATAKANA LETTER WO, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
31F0 30FD ; [.32C3.0020.000F.31F0][.32C3.0020.0010.31F0] # <KATAKANA LETTER SMALL KU, KATAKANA ITERATION MARK>
31F0 30FE ; [.32C3.0020.000F.31F0][.32C3.0020.0010.31F0][.0000.0128.0002.3099] # <KATAKANA LETTER SMALL KU, KATAKANA VOICED ITERATION MARK>
31F1 30FD ; [.32C7.0020.000F.31F1][.32C7.0020.0010.31F1] # <KATAKANA LETTER SMALL SI, KATAKANA ITERATION MARK>
31F1 30FE ; [.32C7.0020.000F.31F1][.32C7.0020.0010.31F1][.0000.0128.0002.3099] # <KATAKANA LETTER SMALL SI, KATAKANA VOICED ITERATION MARK>
31F2 30FD ; [.32C8.0020.000F.31F2][.32C8.0020.0010.31F2] # <KATAKANA LETTER SMALL SU, KATAKANA ITERATION MARK>
31F2 30FE ; [.32C8.0020.000F.31F2][.32C8.0020.0010.31F2][.0000.0128.0002.3099] # <KATAKANA LETTER SMALL SU, KATAKANA VOICED ITERATION MARK>
31F3 30FD ; [.32CF.0020.000F.31F3][.32CF.0020.0010.31F3] # <KATAKANA LETTER SMALL TO, KATAKANA ITERATION MARK>
31F3 30FE ; [.32CF.0020.000F.31F3][.32CF.0020.0010.31F3][.0000.0128.0002.3099] # <KATAKANA LETTER SMALL TO, KATAKANA VOICED ITERATION MARK>
31F4 30FD ; [.32D2.0020.000F.31F4][.32D2.0020.0010.31F4] # <KATAKANA LETTER SMALL NU, KATAKANA ITERATION MARK>
31F5 30FD ; [.32D5.0020.000F.31F5][.32D5.0020.0010.31F5] # <KATAKANA LETTER SMALL HA, KATAKANA ITERATION MARK>
31F5 30FE ; [.32D5.0020.000F.31F5][.32D5.0020.0010.31F5][.0000.0128.0002.3099] # <KATAKANA LETTER SMALL HA, KATAKANA VOICED ITERATION MARK>
31F6 30FD ; [.32D6.0020.000F.31F6][.32D6.0020.0010.31F6] # <KATAKANA LETTER SMALL HI, KATAKANA ITERATION MARK>
31F6 30FE ; [.32D6.0020.000F.31F6][.32D6.0020.0010.31F6][.0000.0128.0002.3099] # <KATAKANA LETTER SMALL HI, KATAKANA VOICED ITERATION MARK>
31F7 30FD ; [.32D7.0020.000F.31F7][.32D7.0020.0010.31F7] # <KATAKANA LETTER SMALL HU, KATAKANA ITERATION MARK>
31F7 30FE ; [.32D7.0020.000F.31F7][.32D7.0020.0010.31F7][.0000.0128.0002.3099] # <KATAKANA LETTER SMALL HU, KATAKANA VOICED ITERATION MARK>
31F8 30FD ; [.32D8.0020.000F.31F8][.32D8.0020.0010.31F8] # <KATAKANA LETTER SMALL HE, KATAKANA ITERATION MARK>
31F8 30FE ; [.32D8.0020.000F.31F8][.32D8.0020.0010.31F8][.0000.0128.0002.3099] # <KATAKANA LETTER SMALL HE, KATAKANA VOICED ITERATION MARK>
31F9 30FD ; [.32D9.0020.000F.31F9][.32D9.0020.0010.31F9] # <KATAKANA LETTER SMALL HO, KATAKANA ITERATION MARK>
31F9 30FE ; [.32D9.0020.000F.31F9][.32D9.0020.0010.31F9][.0000.0128.0002.3099] # <KATAKANA LETTER SMALL HO, KATAKANA VOICED ITERATION MARK>
31FA 30FD ; [.32DC.0020.000F.31FA][.32DC.0020.0010.31FA] # <KATAKANA LETTER SMALL MU, KATAKANA ITERATION MARK>
31FB 30FD ; [.32E3.0020.000F.31FB][.32E3.0020.0010.31FB] # <KATAKANA LETTER SMALL RA, KATAKANA ITERATION MARK>
31FC 30FD ; [.32E4.0020.000F.31FC][.32E4.0020.0010.31FC] # <KATAKANA LETTER SMALL RI, KATAKANA ITERATION MARK>
31FD 30FD ; [.32E5.0020.000F.31FD][.32E5.0020.0010.31FD] # <KATAKANA LETTER SMALL RU, KATAKANA ITERATION MARK>
31FE 30FD ; [.32E6.0020.000F.31FE][.32E6.0020.0010.31FE] # <KATAKANA LETTER SMALL RE, KATAKANA ITERATION MARK>
31FF 30FD ; [.32E7.0020.000F.31FF][.32E7.0020.0010.31FF] # <KATAKANA LETTER SMALL RO, KATAKANA ITERATION MARK>
F967      ; [.8961.0020.0002.4E0D] # CJK COMPATIBILITY IDEOGRAPH-F967
FA70      ; [.89AD.0020.0002.4E26] # CJK COMPATIBILITY IDEOGRAPH-FA70
F905      ; [.828D.0020.0002.4E32] # CJK COMPATIBILITY IDEOGRAPH-F905
2F801     ; [.81B4.0020.0002.4E38] # CJK COMPATIBILITY IDEOGRAPH-2F801
F95E      ; [.8709.0020.0002.4E39] # CJK COMPATIBILITY IDEOGRAPH-F95E
F91B      ; [.8BA0.0020.0002.4E82] # CJK COMPATIBILITY IDEOGRAPH-F91B
F9BA      ; [.8B1E.0020.0002.4E86] # CJK COMPATIBILITY IDEOGRAPH-F9BA
F977      ; [.8B1F.0020.0002.4EAE] # CJK COMPATIBILITY IDEOGRAPH-F977
F9FD      ; [.84DF.0020.0002.4EC0] # CJK COMPATIBILITY IDEOGRAPH-F9FD
F9A8      ; [.8B44.0020.0002.4EE4] # CJK COMPATIBILITY IDEOGRAPH-F9A8
F92D      ; [.8BC8.0020.0002.4F86] # CJK COMPATIBILITY IDEOGRAPH-F92D
F9B5      ; [.8B46.0020.0002.4F8B] # CJK COMPATIBILITY IDEOGRAPH-F9B5
FA30      ; [.897B.0020.0002.4FAE] # CJK COMPATIBILITY IDEOGRAPH-FA30
2F805     ; [.897B.0020.0002.4FAE] # CJK COMPATIBILITY IDEOGRAPH-2F805
F965      ; [.89C3.0020.0002.4FBF] # CJK COMPATIBILITY IDEOGRAPH-F965
F9D4      ; [.8B34.0020.0002.502B] # CJK COMPATIBILITY IDEOGRAPH-F9D4
2F809     ; [.8926.0020.0002.5099] # CJK COMPATIBILITY IDEOGRAPH-2F809
2F80B     ; [.8699.0020.0002.50CF] # CJK COMPATIBILITY IDEOGRAPH-2F80B
F9BB      ; [.8B20.0020.0002.50DA] # CJK COMPATIBILITY IDEOGRAPH-F9BB
FA31      ; [.866B.0020.0002.50E7] # CJK COMPATIBILITY IDEOGRAPH-FA31
2F80A     ; [.866B.0020.0002.50E7] # CJK COMPATIBILITY IDEOGRAPH-2F80A
FA0C      ; [.8C0C.0020.0002.5140] # CJK COMPATIBILITY IDEOGRAPH-FA0C
FA74      ; [.84E1.0020.0002.5145] # CJK COMPATIBILITY IDEOGRAPH-FA74
FA32      ; [.8A6F.0020.0002.514D] # CJK COMPATIBILITY IDEOGRAPH-FA32
2F80E     ; [.8A6F.0020.0002.514D] # CJK COMPATIBILITY IDEOGRAPH-2F80E
2F80F     ; [.8C0F.0020.0002.5154] # CJK COMPATIBILITY IDEOGRAPH-2F80F
FA72      ; [.8651.0020.0002.5168] # CJK COMPATIBILITY IDEOGRAPH-FA72
F978      ; [.8C12.0020.0002.5169] # CJK COMPATIBILITY IDEOGRAPH-F978
F9D1      ; [.8B7C.0020.0002.516D] # CJK COMPATIBILITY IDEOGRAPH-F9D1
2F811     ; [.8284.0020.0002.5177] # CJK COMPATIBILITY IDEOGRAPH-2F811
FA75      ; [.8C15.0020.0002.5180] # CJK COMPATIBILITY IDEOGRAPH-FA75
2F815     ; [.83D1.0020.0002.518D] # CJK COMPATIBILITY IDEOGRAPH-2F815
2F8D2     ; [.8A0A.0020.0002.5192] # CJK COMPATIBILITY IDEOGRAPH-2F8D2
2F8D3     ; [.8C1D.0020.0002.5195] # CJK COMPATIBILITY IDEOGRAPH-2F8D3
2F817     ; [.856C.0020.0002.5197] # CJK COMPATIBILITY IDEOGRAPH-2F817
2F818     ; [.8C1F.0020.0002.51A4] # CJK COMPATIBILITY IDEOGRAPH-2F818
2F81A     ; [.87F4.0020.0002.51AC] # CJK COMPATIBILITY IDEOGRAPH-2F81A
FA71      ; [.8C29.0020.0002.51B5] # CJK COMPATIBILITY IDEOGRAPH-FA71
2F81B     ; [.8C29.0020.0002.51B5] # CJK COMPATIBILITY IDEOGRAPH-2F81B
F92E      ; [.8B47.0020.0002.51B7] # CJK COMPATIBILITY IDEOGRAPH-F92E
F979      ; [.8C2C.0020.0002.51C9] # CJK COMPATIBILITY IDEOGRAPH-F979
F955      ; [.8B22.0020.0002.51CC] # CJK COMPATIBILITY IDEOGRAPH-F955
F954      ; [.98D1.0020.0002.51DC] # CJK COMPATIBILITY IDEOGRAPH-F954
2F81D     ; [.8C33.0020.0002.51F5] # CJK COMPATIBILITY IDEOGRAPH-2F81D
2F81E     ; [.85B0.0020.0002.5203] # CJK COMPATIBILITY IDEOGRAPH-2F81E
FA00      ; [.8619.0020.0002.5207] # CJK COMPATIBILITY IDEOGRAPH-FA00
2F850     ; [.8619.0020.0002.5207] # CJK COMPATIBILITY IDEOGRAPH-2F850
F99C      ; [.8B56.0020.0002.5217] # CJK COMPATIBILITY IDEOGRAPH-F99C
F9DD      ; [.8AFD.0020.0002.5229] # CJK COMPATIBILITY IDEOGRAPH-F9DD
F9FF      ; [.8432.0020.0002.523A] # CJK COMPATIBILITY IDEOGRAPH-F9FF
2F820     ; [.839C.0020.0002.523B] # CJK COMPATIBILITY IDEOGRAPH-2F820
2F822     ; [.815D.0020.0002.5272] # CJK COMPATIBILITY IDEOGRAPH-2F822
F9C7      ; [.8B10.0020.0002.5289] # CJK COMPATIBILITY IDEOGRAPH-F9C7
F98A      ; [.8B32.0020.0002.529B] # CJK COMPATIBILITY IDEOGRAPH-F98A
F99D      ; [.8B57.0020.0002.52A3] # CJK COMPATIBILITY IDEOGRAPH-F99D
FA76      ; [.8AAB.0020.0002.52C7] # CJK COMPATIBILITY IDEOGRAPH-FA76
2F825     ; [.8AAB.0020.0002.52C7] # CJK COMPATIBILITY IDEOGRAPH-2F825
FA33      ; [.89C4.0020.0002.52C9] # CJK COMPATIBILITY IDEOGRAPH-FA33
2F826     ; [.89C4.0020.0002.52C9] # CJK COMPATIBILITY IDEOGRAPH-2F826
F952      ; [.9789.0020.0002.52D2] # CJK COMPATIBILITY IDEOGRAPH-F952
F92F      ; [.8C59.0020.0002.52DE] # CJK COMPATIBILITY IDEOGRAPH-F92F
FA34      ; [.8263.0020.0002.52E4] # CJK COMPATIBILITY IDEOGRAPH-FA34
2F827     ; [.8263.0020.0002.52E4] # CJK COMPATIBILITY IDEOGRAPH-2F827
F97F      ; [.8C5F.0020.0002.52F5] # CJK COMPATIBILITY IDEOGRAPH-F97F
FA77      ; [.84A2.0020.0002.52FA] # CJK COMPATIBILITY IDEOGRAPH-FA77
2F828     ; [.84A2.0020.0002.52FA] # CJK COMPATIBILITY IDEOGRAPH-2F828
2F829     ; [.89DC.0020.0002.5305] # CJK COMPATIBILITY IDEOGRAPH-2F829
2F82A     ; [.8C62.0020.0002.5306] # CJK COMPATIBILITY IDEOGRAPH-2F82A
F963      ; [.8A15.0020.0002.5317] # CJK COMPATIBILITY IDEOGRAPH-F963
2F82B     ; [.8A15.0020.0002.5317] # CJK COMPATIBILITY IDEOGRAPH-2F82B
F9EB      ; [.8832.0020.0002.533F] # CJK COMPATIBILITY IDEOGRAPH-F9EB
2F82C     ; [.8C73.0020.0002.5349] # CJK COMPATIBILITY IDEOGRAPH-2F82C
FA35      ; [.890B.0020.0002.5351] # CJK COMPATIBILITY IDEOGRAPH-FA35
2F82D     ; [.890B.0020.0002.5351] # CJK COMPATIBILITY IDEOGRAPH-2F82D
2F82E     ; [.88BF.0020.0002.535A] # CJK COMPATIBILITY IDEOGRAPH-2F82E
2F82F     ; [.86A3.0020.0002.5373] # CJK COMPATIBILITY IDEOGRAPH-2F82F
F91C      ; [.8AF6.0020.0002.5375] # CJK COMPATIBILITY IDEOGRAPH-F91C
2F831     ; [.823D.0020.0002.537F] # CJK COMPATIBILITY IDEOGRAPH-2F831
2F832     ; [.823D.0020.0002.537F] # CJK COMPATIBILITY IDEOGRAPH-2F832
2F833     ; [.823D.0020.0002.537F] # CJK COMPATIBILITY IDEOGRAPH-2F833
F96B      ; [.8C84.0020.0002.53C3] # CJK COMPATIBILITY IDEOGRAPH-F96B
2F836     ; [.820F.0020.0002.53CA] # CJK COMPATIBILITY IDEOGRAPH-2F836
2F837     ; [.8C87.0020.0002.53DF] # CJK COMPATIBILITY IDEOGRAPH-2F837
F906      ; [.827A.0020.0002.53E5] # CJK COMPATIBILITY IDEOGRAPH-F906
2F839     ; [.823E.0020.0002.53EB] # CJK COMPATIBILITY IDEOGRAPH-2F839
2F83A     ; [.847F.0020.0002.53F1] # CJK COMPATIBILITY IDEOGRAPH-2F83A
F9DE      ; [.8AFE.0020.0002.540F] # CJK COMPATIBILITY IDEOGRAPH-F9DE
F9ED      ; [.8C97.0020.0002.541D] # CJK COMPATIBILITY IDEOGRAPH-F9ED
2F83D     ; [.8210.0020.0002.5438] # CJK COMPATIBILITY IDEOGRAPH-2F83D
F980      ; [.8B65.0020.0002.5442] # CJK COMPATIBILITY IDEOGRAPH-F980
2F83E     ; [.879F.0020.0002.5448] # CJK COMPATIBILITY IDEOGRAPH-2F83E
2F83F     ; [.84C5.0020.0002.5468] # CJK COMPATIBILITY IDEOGRAPH-2F83F
2F840     ; [.8CA8.0020.0002.54A2] # CJK COMPATIBILITY IDEOGRAPH-2F840
F99E      ; [.8055.0020.0002.54BD] # CJK COMPATIBILITY IDEOGRAPH-F99E
2F842     ; [.87F7.0020.0002.5510] # CJK COMPATIBILITY IDEOGRAPH-2F842
2F843     ; [.82AD.0020.0002.5553] # CJK COMPATIBILITY IDEOGRAPH-2F843
2F844     ; [.8CC0.0020.0002.5563] # CJK COMPATIBILITY IDEOGRAPH-2F844
2F845     ; [.864E.0020.0002.5584] # CJK COMPATIBILITY IDEOGRAPH-2F845
2F846     ; [.864E.0020.0002.5584] # CJK COMPATIBILITY IDEOGRAPH-2F846
F90B      ; [.8CD7.0020.0002.5587] # CJK COMPATIBILITY IDEOGRAPH-F90B
FA7A      ; [.8CCA.0020.0002.5599] # CJK COMPATIBILITY IDEOGRAPH-FA7A
2F847     ; [.8CCA.0020.0002.5599] # CJK COMPATIBILITY IDEOGRAPH-2F847
FA36      ; [.815E.0020.0002.559D] # CJK COMPATIBILITY IDEOGRAPH-FA36
FA78      ; [.815E.0020.0002.559D] # CJK COMPATIBILITY IDEOGRAPH-FA78
2F848     ; [.81FF.0020.0002.55AB] # CJK COMPATIBILITY IDEOGRAPH-2F848
FA37      ; [.870B.0020.0002.5606] # CJK COMPATIBILITY IDEOGRAPH-FA37
2F84C     ; [.870B.0020.0002.5606] # CJK COMPATIBILITY IDEOGRAPH-2F84C
FA38      ; [.81C6.0020.0002.5668] # CJK COMPATIBILITY IDEOGRAPH-FA38
2F84F     ; [.8999.0020.0002.5674] # CJK COMPATIBILITY IDEOGRAPH-2F84F
F9A9      ; [.8D08.0020.0002.56F9] # CJK COMPATIBILITY IDEOGRAPH-F9A9
2F84B     ; [.8D12.0020.0002.5716] # CJK COMPATIBILITY IDEOGRAPH-2F84B
2F855     ; [.82B0.0020.0002.578B] # CJK COMPATIBILITY IDEOGRAPH-2F855
2F852     ; [.856E.0020.0002.57CE] # CJK COMPATIBILITY IDEOGRAPH-2F852
2F853     ; [.8580.0020.0002.57F4] # CJK COMPATIBILITY IDEOGRAPH-2F853
2F857     ; [.89DE.0020.0002.5831] # CJK COMPATIBILITY IDEOGRAPH-2F857
FA39      ; [.89A8.0020.0002.5840] # CJK COMPATIBILITY IDEOGRAPH-FA39
FA10      ; [.8784.0020.0002.585A] # CJK COMPATIBILITY IDEOGRAPH-FA10
FA7C      ; [.8784.0020.0002.585A] # CJK COMPATIBILITY IDEOGRAPH-FA7C
F96C      ; [.83D4.0020.0002.585E] # CJK COMPATIBILITY IDEOGRAPH-F96C
FA3A      ; [.8A18.0020.0002.58A8] # CJK COMPATIBILITY IDEOGRAPH-FA3A
FA7D      ; [.899A.0020.0002.58B3] # CJK COMPATIBILITY IDEOGRAPH-FA7D
F94A      ; [.8D4A.0020.0002.58D8] # CJK COMPATIBILITY IDEOGRAPH-F94A
F942      ; [.8D4E.0020.0002.58DF] # CJK COMPATIBILITY IDEOGRAPH-F942
2F851     ; [.8671.0020.0002.58EE] # CJK COMPATIBILITY IDEOGRAPH-2F851
2F85A     ; [.88B5.0020.0002.58F2] # CJK COMPATIBILITY IDEOGRAPH-2F85A
2F85B     ; [.8792.0020.0002.58F7] # CJK COMPATIBILITY IDEOGRAPH-2F85B
2F85D     ; [.86BA.0020.0002.591A] # CJK COMPATIBILITY IDEOGRAPH-2F85D
2F85E     ; [.8A5B.0020.0002.5922] # CJK COMPATIBILITY IDEOGRAPH-2F85E
FA7E      ; [.809F.0020.0002.5944] # CJK COMPATIBILITY IDEOGRAPH-FA7E
F90C      ; [.8853.0020.0002.5948] # CJK COMPATIBILITY IDEOGRAPH-F90C
F909      ; [.82B1.0020.0002.5951] # CJK COMPATIBILITY IDEOGRAPH-F909
FA7F      ; [.8A24.0020.0002.5954] # CJK COMPATIBILITY IDEOGRAPH-FA7F
2F85F     ; [.8D66.0020.0002.5962] # CJK COMPATIBILITY IDEOGRAPH-2F85F
F981      ; [.851C.0020.0002.5973] # CJK COMPATIBILITY IDEOGRAPH-F981
FA80      ; [.8D83.0020.0002.5A62] # CJK COMPATIBILITY IDEOGRAPH-FA80
2F866     ; [.8965.0020.0002.5A66] # CJK COMPATIBILITY IDEOGRAPH-2F866
2F86A     ; [.8D99.0020.0002.5B3E] # CJK COMPATIBILITY IDEOGRAPH-2F86A
2F86B     ; [.8D99.0020.0002.5B3E] # CJK COMPATIBILITY IDEOGRAPH-2F86B
FA04      ; [.86EB.0020.0002.5B85] # CJK COMPATIBILITY IDEOGRAPH-FA04
2F86D     ; [.8DAD.0020.0002.5BC3] # CJK COMPATIBILITY IDEOGRAPH-2F86D
F95F      ; [.887C.0020.0002.5BE7] # CJK COMPATIBILITY IDEOGRAPH-F95F
F9AA      ; [.887C.0020.0002.5BE7] # CJK COMPATIBILITY IDEOGRAPH-F9AA
2F86F     ; [.887C.0020.0002.5BE7] # CJK COMPATIBILITY IDEOGRAPH-2F86F
F9BC      ; [.8B23.0020.0002.5BEE] # CJK COMPATIBILITY IDEOGRAPH-F9BC
2F870     ; [.8DBA.0020.0002.5BF3] # CJK COMPATIBILITY IDEOGRAPH-2F870
2F872     ; [.84BE.0020.0002.5BFF] # CJK COMPATIBILITY IDEOGRAPH-2F872
2F873     ; [.8530.0020.0002.5C06] # CJK COMPATIBILITY IDEOGRAPH-2F873
2F875     ; [.8DC1.0020.0002.5C22] # CJK COMPATIBILITY IDEOGRAPH-2F875
F9BD      ; [.8873.0020.0002.5C3F] # CJK COMPATIBILITY IDEOGRAPH-F9BD
2F877     ; [.87E0.0020.0002.5C60] # CJK COMPATIBILITY IDEOGRAPH-2F877
FA3B      ; [.8675.0020.0002.5C64] # CJK COMPATIBILITY IDEOGRAPH-FA3B
F9DF      ; [.8AFF.0020.0002.5C65] # CJK COMPATIBILITY IDEOGRAPH-F9DF
FA3C      ; [.8DCD.0020.0002.5C6E] # CJK COMPATIBILITY IDEOGRAPH-FA3C
2F878     ; [.8DCD.0020.0002.5C6E] # CJK COMPATIBILITY IDEOGRAPH-2F878
F9D5      ; [.8DEE.0020.0002.5D19] # CJK COMPATIBILITY IDEOGRAPH-F9D5
F921      ; [.8AF7.0020.0002.5D50] # CJK COMPATIBILITY IDEOGRAPH-F921
F9AB      ; [.8B49.0020.0002.5DBA] # CJK COMPATIBILITY IDEOGRAPH-F9AB
2F881     ; [.8509.0020.0002.5DE1] # CJK COMPATIBILITY IDEOGRAPH-2F881
2F884     ; [.8700.0020.0002.5DFD] # CJK COMPATIBILITY IDEOGRAPH-2F884
2F886     ; [.8A02.0020.0002.5E3D] # CJK COMPATIBILITY IDEOGRAPH-2F886
F98E      ; [.8880.0020.0002.5E74] # CJK COMPATIBILITY IDEOGRAPH-F98E
FA01      ; [.87EE.0020.0002.5EA6] # CJK COMPATIBILITY IDEOGRAPH-FA01
2F88D     ; [.8513.0020.0002.5EB6] # CJK COMPATIBILITY IDEOGRAPH-2F88D
F9A2      ; [.8B5A.0020.0002.5EC9] # CJK COMPATIBILITY IDEOGRAPH-F9A2
F928      ; [.8B6E.0020.0002.5ECA] # CJK COMPATIBILITY IDEOGRAPH-F928
2F88E     ; [.8B6E.0020.0002.5ECA] # CJK COMPATIBILITY IDEOGRAPH-2F88E
FA0B      ; [.8140.0020.0002.5ED3] # CJK COMPATIBILITY IDEOGRAPH-FA0B
F982      ; [.8E30.0020.0002.5EEC] # CJK COMPATIBILITY IDEOGRAPH-F982
2F890     ; [.8E36.0020.0002.5EFE] # CJK COMPATIBILITY IDEOGRAPH-2F890
F943      ; [.8B6F.0020.0002.5F04] # CJK COMPATIBILITY IDEOGRAPH-F943
2F874     ; [.880B.0020.0002.5F53] # CJK COMPATIBILITY IDEOGRAPH-2F874
2F899     ; [.82B2.0020.0002.5F62] # CJK COMPATIBILITY IDEOGRAPH-2F899
FA84      ; [.83D7.0020.0002.5F69] # CJK COMPATIBILITY IDEOGRAPH-FA84
2F89A     ; [.875D.0020.0002.5F6B] # CJK COMPATIBILITY IDEOGRAPH-2F89A
F9D8      ; [.8B0A.0020.0002.5F8B] # CJK COMPATIBILITY IDEOGRAPH-F9D8
F966      ; [.8989.0020.0002.5FA9] # CJK COMPATIBILITY IDEOGRAPH-F966
FA85      ; [.8E5A.0020.0002.5FAD] # CJK COMPATIBILITY IDEOGRAPH-FA85
2F89D     ; [.8877.0020.0002.5FCD] # CJK COMPATIBILITY IDEOGRAPH-2F89D
2F89E     ; [.843F.0020.0002.5FD7] # CJK COMPATIBILITY IDEOGRAPH-2F89E
F9A3      ; [.8881.0020.0002.5FF5] # CJK COMPATIBILITY IDEOGRAPH-F9A3
F960      ; [.87F1.0020.0002.6012] # CJK COMPATIBILITY IDEOGRAPH-F960
F9AC      ; [.8B4A.0020.0002.601C] # CJK COMPATIBILITY IDEOGRAPH-F9AC
FA6B      ; [.82B4.0020.0002.6075] # CJK COMPATIBILITY IDEOGRAPH-FA6B
2F8A0     ; [.8E80.0020.0002.6081] # CJK COMPATIBILITY IDEOGRAPH-2F8A0
FA3D      ; [.8114.0020.0002.6094] # CJK COMPATIBILITY IDEOGRAPH-FA3D
2F8A3     ; [.8114.0020.0002.6094] # CJK COMPATIBILITY IDEOGRAPH-2F8A3
2F8A5     ; [.884A.0020.0002.60C7] # CJK COMPATIBILITY IDEOGRAPH-2F8A5
FA86      ; [.8E95.0020.0002.60D8] # CJK COMPATIBILITY IDEOGRAPH-FA86
F9B9      ; [.8E8C.0020.0002.60E1] # CJK COMPATIBILITY IDEOGRAPH-F9B9
FA88      ; [.8AA3.0020.0002.6108] # CJK COMPATIBILITY IDEOGRAPH-FA88
F9D9      ; [.8EAF.0020.0002.6144] # CJK COMPATIBILITY IDEOGRAPH-F9D9
2F8A6     ; [.8465.0020.0002.6148] # CJK COMPATIBILITY IDEOGRAPH-2F8A6
2F8A7     ; [.835F.0020.0002.614C] # CJK COMPATIBILITY IDEOGRAPH-2F8A7
2F8A9     ; [.835F.0020.0002.614C] # CJK COMPATIBILITY IDEOGRAPH-2F8A9
FA87      ; [.8596.0020.0002.614E] # CJK COMPATIBILITY IDEOGRAPH-FA87
2F8A8     ; [.8596.0020.0002.614E] # CJK COMPATIBILITY IDEOGRAPH-2F8A8
FA3E      ; [.812D.0020.0002.6168] # CJK COMPATIBILITY IDEOGRAPH-FA3E
FA3F      ; [.869B.0020.0002.618E] # CJK COMPATIBILITY IDEOGRAPH-FA3F
FA89      ; [.869B.0020.0002.618E] # CJK COMPATIBILITY IDEOGRAPH-FA89
2F8AB     ; [.869B.0020.0002.618E] # CJK COMPATIBILITY IDEOGRAPH-2F8AB
F98F      ; [.8B5C.0020.0002.6190] # CJK COMPATIBILITY IDEOGRAPH-F98F
2F8AD     ; [.899B.0020.0002.61A4] # CJK COMPATIBILITY IDEOGRAPH-2F8AD
2F8AC     ; [.82EC.0020.0002.61B2] # CJK COMPATIBILITY IDEOGRAPH-2F8AC
FA40      ; [.875F.0020.0002.61F2] # CJK COMPATIBILITY IDEOGRAPH-FA40
FA8B      ; [.875F.0020.0002.61F2] # CJK COMPATIBILITY IDEOGRAPH-FA8B
2F8B0     ; [.875F.0020.0002.61F2] # CJK COMPATIBILITY IDEOGRAPH-2F8B0
F90D      ; [.8ED5.0020.0002.61F6] # CJK COMPATIBILITY IDEOGRAPH-F90D
2F8B1     ; [.8ED5.0020.0002.61F6] # CJK COMPATIBILITY IDEOGRAPH-2F8B1
F990      ; [.8EDC.0020.0002.6200] # CJK COMPATIBILITY IDEOGRAPH-F990
2F8B2     ; [.85ED.0020.0002.6210] # CJK COMPATIBILITY IDEOGRAPH-2F8B2
2F8B3     ; [.8EE2.0020.0002.621B] # CJK COMPATIBILITY IDEOGRAPH-2F8B3
F9D2      ; [.8EE6.0020.0002.622E] # CJK COMPATIBILITY IDEOGRAPH-F9D2
FA8C      ; [.86D2.0020.0002.6234] # CJK COMPATIBILITY IDEOGRAPH-FA8C
2F8B5     ; [.89E5.0020.0002.62B1] # CJK COMPATIBILITY IDEOGRAPH-2F8B5
F925      ; [.8F09.0020.0002.62C9] # CJK COMPATIBILITY IDEOGRAPH-F925
F95B      ; [.8EFE.0020.0002.62CF] # CJK COMPATIBILITY IDEOGRAPH-F95B
FA02      ; [.86EE.0020.0002.62D3] # CJK COMPATIBILITY IDEOGRAPH-FA02
2F8B6     ; [.8EF8.0020.0002.62D4] # CJK COMPATIBILITY IDEOGRAPH-2F8B6
F973      ; [.84CB.0020.0002.62FE] # CJK COMPATIBILITY IDEOGRAPH-F973
2F8B9     ; [.8903.0020.0002.633D] # CJK COMPATIBILITY IDEOGRAPH-2F8B9
2F8B7     ; [.8F12.0020.0002.6350] # CJK COMPATIBILITY IDEOGRAPH-2F8B7
2F8BB     ; [.8495.0020.0002.6368] # CJK COMPATIBILITY IDEOGRAPH-2F8BB
F9A4      ; [.8882.0020.0002.637B] # CJK COMPATIBILITY IDEOGRAPH-F9A4
2F8BC     ; [.867A.0020.0002.6383] # CJK COMPATIBILITY IDEOGRAPH-2F8BC
F975      ; [.8B0E.0020.0002.63A0] # CJK COMPATIBILITY IDEOGRAPH-F975
2F8C1     ; [.80A3.0020.0002.63A9] # CJK COMPATIBILITY IDEOGRAPH-2F8C1
FA8D      ; [.8F2B.0020.0002.63C4] # CJK COMPATIBILITY IDEOGRAPH-FA8D
FA8E      ; [.8F15.0020.0002.641C] # CJK COMPATIBILITY IDEOGRAPH-FA8E
2F8C3     ; [.8A29.0020.0002.6469] # CJK COMPATIBILITY IDEOGRAPH-2F8C3
F991      ; [.8883.0020.0002.649A] # CJK COMPATIBILITY IDEOGRAPH-F991
FA41      ; [.895F.0020.0002.654F] # CJK COMPATIBILITY IDEOGRAPH-FA41
2F8C8     ; [.895F.0020.0002.654F] # CJK COMPATIBILITY IDEOGRAPH-2F8C8
FA90      ; [.8F64.0020.0002.6556] # CJK COMPATIBILITY IDEOGRAPH-FA90
2F8C9     ; [.82BA.0020.0002.656C] # CJK COMPATIBILITY IDEOGRAPH-2F8C9
F969      ; [.8F6B.0020.0002.6578] # CJK COMPATIBILITY IDEOGRAPH-F969
F9BE      ; [.8B24.0020.0002.6599] # CJK COMPATIBILITY IDEOGRAPH-F9BE
F983      ; [.8B1C.0020.0002.65C5] # CJK COMPATIBILITY IDEOGRAPH-F983
FA42      ; [.81D2.0020.0002.65E2] # CJK COMPATIBILITY IDEOGRAPH-FA42
F9E0      ; [.8036.0020.0002.6613] # CJK COMPATIBILITY IDEOGRAPH-F9E0
2F8CD     ; [.8F89.0020.0002.6649] # CJK COMPATIBILITY IDEOGRAPH-2F8CD
FA12      ; [.85F1.0020.0002.6674] # CJK COMPATIBILITY IDEOGRAPH-FA12
FA91      ; [.85F1.0020.0002.6674] # CJK COMPATIBILITY IDEOGRAPH-FA91
F9C5      ; [.8F94.0020.0002.6688] # CJK COMPATIBILITY IDEOGRAPH-F9C5
FA43      ; [.8510.0020.0002.6691] # CJK COMPATIBILITY IDEOGRAPH-FA43
2F8CF     ; [.8510.0020.0002.6691] # CJK COMPATIBILITY IDEOGRAPH-2F8CF
FA06      ; [.8A06.0020.0002.66B4] # CJK COMPATIBILITY IDEOGRAPH-FA06
F901      ; [.8366.0020.0002.66F4] # CJK COMPATIBILITY IDEOGRAPH-F901
2F8CC     ; [.8516.0020.0002.66F8] # CJK COMPATIBILITY IDEOGRAPH-2F8CC
2F8D4     ; [.83D2.0020.0002.6700] # CJK COMPATIBILITY IDEOGRAPH-2F8D4
F929      ; [.8B70.0020.0002.6717] # CJK COMPATIBILITY IDEOGRAPH-F929
FA92      ; [.8B70.0020.0002.6717] # CJK COMPATIBILITY IDEOGRAPH-FA92
2F8D8     ; [.8B70.0020.0002.6717] # CJK COMPATIBILITY IDEOGRAPH-2F8D8
FA93      ; [.8A07.0020.0002.671B] # CJK COMPATIBILITY IDEOGRAPH-FA93
2F8D9     ; [.8A07.0020.0002.671B] # CJK COMPATIBILITY IDEOGRAPH-2F8D9
F9E1      ; [.8B00.0020.0002.674E] # CJK COMPATIBILITY IDEOGRAPH-F9E1
2F8DC     ; [.84A4.0020.0002.6753] # CJK COMPATIBILITY IDEOGRAPH-2F8DC
FA94      ; [.8576.0020.0002.6756] # CJK COMPATIBILITY IDEOGRAPH-FA94
2F8DB     ; [.8FB7.0020.0002.675E] # CJK COMPATIBILITY IDEOGRAPH-2F8DB
2F8E0     ; [.8FC5.0020.0002.6785] # CJK COMPATIBILITY IDEOGRAPH-2F8E0
F9F4      ; [.8B36.0020.0002.6797] # CJK COMPATIBILITY IDEOGRAPH-F9F4
F9C9      ; [.8A9F.0020.0002.67F3] # CJK COMPATIBILITY IDEOGRAPH-F9C9
F9DA      ; [.829B.0020.0002.6817] # CJK COMPATIBILITY IDEOGRAPH-F9DA
F97A      ; [.8B25.0020.0002.6881] # CJK COMPATIBILITY IDEOGRAPH-F97A
FA44      ; [.88B0.0020.0002.6885] # CJK COMPATIBILITY IDEOGRAPH-FA44
2F8E2     ; [.88B0.0020.0002.6885] # CJK COMPATIBILITY IDEOGRAPH-2F8E2
F9E2      ; [.8B01.0020.0002.68A8] # CJK COMPATIBILITY IDEOGRAPH-F9E2
F914      ; [.9037.0020.0002.6A02] # CJK COMPATIBILITY IDEOGRAPH-F914
F95C      ; [.9037.0020.0002.6A02] # CJK COMPATIBILITY IDEOGRAPH-F95C
F9BF      ; [.9037.0020.0002.6A02] # CJK COMPATIBILITY IDEOGRAPH-F9BF
F94C      ; [.9048.0020.0002.6A13] # CJK COMPATIBILITY IDEOGRAPH-F94C
F931      ; [.8B67.0020.0002.6AD3] # CJK COMPATIBILITY IDEOGRAPH-F931
2F8ED     ; [.828E.0020.0002.6ADB] # CJK COMPATIBILITY IDEOGRAPH-2F8ED
F91D      ; [.8AF8.0020.0002.6B04] # CJK COMPATIBILITY IDEOGRAPH-F91D
2F8EF     ; [.8468.0020.0002.6B21] # CJK COMPATIBILITY IDEOGRAPH-2F8EF
2F8F1     ; [.907B.0020.0002.6B54] # CJK COMPATIBILITY IDEOGRAPH-2F8F1
FA95      ; [.9080.0020.0002.6B79] # CJK COMPATIBILITY IDEOGRAPH-FA95
F970      ; [.840F.0020.0002.6BBA] # CJK COMPATIBILITY IDEOGRAPH-F970
FA96      ; [.840F.0020.0002.6BBA] # CJK COMPATIBILITY IDEOGRAPH-FA96
2F8F5     ; [.840F.0020.0002.6BBA] # CJK COMPATIBILITY IDEOGRAPH-2F8F5
2F8F6     ; [.8145.0020.0002.6BBB] # CJK COMPATIBILITY IDEOGRAPH-2F8F6
2F8FA     ; [.88F5.0020.0002.6C4E] # CJK COMPATIBILITY IDEOGRAPH-2F8FA
F972      ; [.8777.0020.0002.6C88] # CJK COMPATIBILITY IDEOGRAPH-F972
2F8FC     ; [.80A5.0020.0002.6CBF] # CJK COMPATIBILITY IDEOGRAPH-2F8FC
F968      ; [.8916.0020.0002.6CCC] # CJK COMPATIBILITY IDEOGRAPH-F968
F9E3      ; [.87BA.0020.0002.6CE5] # CJK COMPATIBILITY IDEOGRAPH-F9E3
F915      ; [.8AF1.0020.0002.6D1B] # CJK COMPATIBILITY IDEOGRAPH-F915
FA05      ; [.8829.0020.0002.6D1E] # CJK COMPATIBILITY IDEOGRAPH-FA05
2F900     ; [.889A.0020.0002.6D3E] # CJK COMPATIBILITY IDEOGRAPH-2F900
F9CA      ; [.8B11.0020.0002.6D41] # CJK COMPATIBILITY IDEOGRAPH-F9CA
FA97      ; [.8B11.0020.0002.6D41] # CJK COMPATIBILITY IDEOGRAPH-FA97
2F902     ; [.8B11.0020.0002.6D41] # CJK COMPATIBILITY IDEOGRAPH-2F902
2F903     ; [.836D.0020.0002.6D69] # CJK COMPATIBILITY IDEOGRAPH-2F903
F92A      ; [.8B73.0020.0002.6D6A] # CJK COMPATIBILITY IDEOGRAPH-F92A
FA45      ; [.811D.0020.0002.6D77] # CJK COMPATIBILITY IDEOGRAPH-FA45
2F901     ; [.811D.0020.0002.6D77] # CJK COMPATIBILITY IDEOGRAPH-2F901
2F904     ; [.859C.0020.0002.6D78] # CJK COMPATIBILITY IDEOGRAPH-2F904
2F905     ; [.90D2.0020.0002.6D85] # CJK COMPATIBILITY IDEOGRAPH-2F905
F9F5      ; [.8B37.0020.0002.6DCB] # CJK COMPATIBILITY IDEOGRAPH-F9F5
F9D6      ; [.90E5.0020.0002.6DEA] # CJK COMPATIBILITY IDEOGRAPH-F9D6
2F90E     ; [.90D3.0020.0002.6DF9] # CJK COMPATIBILITY IDEOGRAPH-2F90E
FA46      ; [.8512.0020.0002.6E1A] # CJK COMPATIBILITY IDEOGRAPH-FA46
2F908     ; [.836E.0020.0002.6E2F] # CJK COMPATIBILITY IDEOGRAPH-2F908
2F909     ; [.90E8.0020.0002.6E6E] # CJK COMPATIBILITY IDEOGRAPH-2F909
F9CB      ; [.8B12.0020.0002.6E9C] # CJK COMPATIBILITY IDEOGRAPH-F9CB
F9EC      ; [.87C3.0020.0002.6EBA] # CJK COMPATIBILITY IDEOGRAPH-F9EC
FA99      ; [.8469.0020.0002.6ECB] # CJK COMPATIBILITY IDEOGRAPH-FA99
2F90B     ; [.8469.0020.0002.6ECB] # CJK COMPATIBILITY IDEOGRAPH-2F90B
F904      ; [.8163.0020.0002.6ED1] # CJK COMPATIBILITY IDEOGRAPH-F904
F94E      ; [.8B74.0020.0002.6F0F] # CJK COMPATIBILITY IDEOGRAPH-F94E
FA47      ; [.8198.0020.0002.6F22] # CJK COMPATIBILITY IDEOGRAPH-FA47
FA9A      ; [.8198.0020.0002.6F22] # CJK COMPATIBILITY IDEOGRAPH-FA9A
F992      ; [.8B5D.0020.0002.6F23] # CJK COMPATIBILITY IDEOGRAPH-F992
2F90F     ; [.8763.0020.0002.6F6E] # CJK COMPATIBILITY IDEOGRAPH-2F90F
2F912     ; [.912F.0020.0002.6FC6] # CJK COMPATIBILITY IDEOGRAPH-2F912
F922      ; [.8AF9.0020.0002.6FEB] # CJK COMPATIBILITY IDEOGRAPH-F922
F984      ; [.913F.0020.0002.6FFE] # CJK COMPATIBILITY IDEOGRAPH-F984
2F915     ; [.9140.0020.0002.701B] # CJK COMPATIBILITY IDEOGRAPH-2F915
FA9B      ; [.8847.0020.0002.701E] # CJK COMPATIBILITY IDEOGRAPH-FA9B
2F914     ; [.8847.0020.0002.701E] # CJK COMPATIBILITY IDEOGRAPH-2F914
2F835     ; [.811E.0020.0002.7070] # CJK COMPATIBILITY IDEOGRAPH-2F835
2F918     ; [.83DD.0020.0002.707D] # CJK COMPATIBILITY IDEOGRAPH-2F918
F9FB      ; [.914B.0020.0002.7099] # CJK COMPATIBILITY IDEOGRAPH-F9FB
2F91A     ; [.8713.0020.0002.70AD] # CJK COMPATIBILITY IDEOGRAPH-2F91A
F99F      ; [.8B58.0020.0002.70C8] # CJK COMPATIBILITY IDEOGRAPH-F99F
F916      ; [.9156.0020.0002.70D9] # CJK COMPATIBILITY IDEOGRAPH-F916
F993      ; [.8B5E.0020.0002.7149] # CJK COMPATIBILITY IDEOGRAPH-F993
FA48      ; [.8498.0020.0002.716E] # CJK COMPATIBILITY IDEOGRAPH-FA48
FA9C      ; [.8498.0020.0002.716E] # CJK COMPATIBILITY IDEOGRAPH-FA9C
F9C0      ; [.916F.0020.0002.71CE] # CJK COMPATIBILITY IDEOGRAPH-F9C0
F9EE      ; [.8B38.0020.0002.71D0] # CJK COMPATIBILITY IDEOGRAPH-F9EE
F932      ; [.9178.0020.0002.7210] # CJK COMPATIBILITY IDEOGRAPH-F932
F91E      ; [.9179.0020.0002.721B] # CJK COMPATIBILITY IDEOGRAPH-F91E
2F920     ; [.917A.0020.0002.7228] # CJK COMPATIBILITY IDEOGRAPH-2F920
FA9E      ; [.84A6.0020.0002.7235] # CJK COMPATIBILITY IDEOGRAPH-FA9E
2F921     ; [.84A6.0020.0002.7235] # CJK COMPATIBILITY IDEOGRAPH-2F921
F946      ; [.8B75.0020.0002.7262] # CJK COMPATIBILITY IDEOGRAPH-F946
2F924     ; [.83DF.0020.0002.7280] # CJK COMPATIBILITY IDEOGRAPH-2F924
FA9F      ; [.88F7.0020.0002.72AF] # CJK COMPATIBILITY IDEOGRAPH-FA9F
F92B      ; [.8B76.0020.0002.72FC] # CJK COMPATIBILITY IDEOGRAPH-F92B
FA16      ; [.874F.0020.0002.732A] # CJK COMPATIBILITY IDEOGRAPH-FA16
FAA0      ; [.874F.0020.0002.732A] # CJK COMPATIBILITY IDEOGRAPH-FAA0
F9A7      ; [.91AE.0020.0002.7375] # CJK COMPATIBILITY IDEOGRAPH-F9A7
2F928     ; [.91B0.0020.0002.737A] # CJK COMPATIBILITY IDEOGRAPH-2F928
F961      ; [.8B0B.0020.0002.7387] # CJK COMPATIBILITY IDEOGRAPH-F961
F9DB      ; [.8B0B.0020.0002.7387] # CJK COMPATIBILITY IDEOGRAPH-F9DB
2F929     ; [.80C1.0020.0002.738B] # CJK COMPATIBILITY IDEOGRAPH-2F929
F9AD      ; [.8B4B.0020.0002.73B2] # CJK COMPATIBILITY IDEOGRAPH-F9AD
F917      ; [.91B8.0020.0002.73DE] # CJK COMPATIBILITY IDEOGRAPH-F917
F9E4      ; [.8B02.0020.0002.7406] # CJK COMPATIBILITY IDEOGRAPH-F9E4
F9CC      ; [.8B13.0020.0002.7409] # CJK COMPATIBILITY IDEOGRAPH-F9CC
FA4A      ; [.86F1.0020.0002.7422] # CJK COMPATIBILITY IDEOGRAPH-FA4A
2F92F     ; [.91C5.0020.0002.745C] # CJK COMPATIBILITY IDEOGRAPH-2F92F
F9AE      ; [.91C6.0020.0002.7469] # CJK COMPATIBILITY IDEOGRAPH-F9AE
2F932     ; [.91CF.0020.0002.74CA] # CJK COMPATIBILITY IDEOGRAPH-2F932
FAA3      ; [.8103.0020.0002.753B] # CJK COMPATIBILITY IDEOGRAPH-FAA3
F9CD      ; [.8B14.0020.0002.7559] # CJK COMPATIBILITY IDEOGRAPH-F9CD
F976      ; [.8B0F.0020.0002.7565] # CJK COMPATIBILITY IDEOGRAPH-F976
F962      ; [.803A.0020.0002.7570] # CJK COMPATIBILITY IDEOGRAPH-F962
2F938     ; [.803A.0020.0002.7570] # CJK COMPATIBILITY IDEOGRAPH-2F938
F9E5      ; [.8B04.0020.0002.75E2] # CJK COMPATIBILITY IDEOGRAPH-F9E5
FAA5      ; [.921B.0020.0002.761F] # CJK COMPATIBILITY IDEOGRAPH-FAA5
F9C1      ; [.8B28.0020.0002.7642] # CJK COMPATIBILITY IDEOGRAPH-F9C1
F90E      ; [.922C.0020.0002.7669] # CJK COMPATIBILITY IDEOGRAPH-F90E
FA17      ; [.8094.0020.0002.76CA] # CJK COMPATIBILITY IDEOGRAPH-FA17
FAA6      ; [.8094.0020.0002.76CA] # CJK COMPATIBILITY IDEOGRAPH-FAA6
FAA7      ; [.85F8.0020.0002.76DB] # CJK COMPATIBILITY IDEOGRAPH-FAA7
F933      ; [.924A.0020.0002.76E7] # CJK COMPATIBILITY IDEOGRAPH-F933
FAA8      ; [.8775.0020.0002.76F4] # CJK COMPATIBILITY IDEOGRAPH-FAA8
2F940     ; [.8775.0020.0002.76F4] # CJK COMPATIBILITY IDEOGRAPH-2F940
F96D      ; [.854D.0020.0002.7701] # CJK COMPATIBILITY IDEOGRAPH-F96D
2F945     ; [.9253.0020.0002.771E] # CJK COMPATIBILITY IDEOGRAPH-2F945
2F946     ; [.85A0.0020.0002.771F] # CJK COMPATIBILITY IDEOGRAPH-2F946
2F947     ; [.85A0.0020.0002.771F] # CJK COMPATIBILITY IDEOGRAPH-2F947
FAAA      ; [.873E.0020.0002.7740] # CJK COMPATIBILITY IDEOGRAPH-FAAA
2F94A     ; [.9263.0020.0002.778B] # CJK COMPATIBILITY IDEOGRAPH-2F94A
F9CE      ; [.8B15.0020.0002.786B] # CJK COMPATIBILITY IDEOGRAPH-F9CE
F93B      ; [.9281.0020.0002.788C] # CJK COMPATIBILITY IDEOGRAPH-F93B
2F94F     ; [.9281.0020.0002.788C] # CJK COMPATIBILITY IDEOGRAPH-2F94F
FA4B      ; [.8919.0020.0002.7891] # CJK COMPATIBILITY IDEOGRAPH-FA4B
F947      ; [.928D.0020.0002.78CA] # CJK COMPATIBILITY IDEOGRAPH-F947
F985      ; [.927A.0020.0002.792A] # CJK COMPATIBILITY IDEOGRAPH-F985
FA18      ; [.8B4C.0020.0002.793C] # CJK COMPATIBILITY IDEOGRAPH-FA18
FA4C      ; [.8499.0020.0002.793E] # CJK COMPATIBILITY IDEOGRAPH-FA4C
FA4E      ; [.81DC.0020.0002.7948] # CJK COMPATIBILITY IDEOGRAPH-FA4E
FA4D      ; [.844C.0020.0002.7949] # CJK COMPATIBILITY IDEOGRAPH-FA4D
FA4F      ; [.8AB9.0020.0002.7950] # CJK COMPATIBILITY IDEOGRAPH-FA4F
FA50      ; [.8661.0020.0002.7956] # CJK COMPATIBILITY IDEOGRAPH-FA50
2F953     ; [.8661.0020.0002.7956] # CJK COMPATIBILITY IDEOGRAPH-2F953
FA51      ; [.84F0.0020.0002.795D] # CJK COMPATIBILITY IDEOGRAPH-FA51
FA19      ; [.85A1.0020.0002.795E] # CJK COMPATIBILITY IDEOGRAPH-FA19
FA1A      ; [.8550.0020.0002.7965] # CJK COMPATIBILITY IDEOGRAPH-FA1A
F93C      ; [.92A1.0020.0002.797F] # CJK COMPATIBILITY IDEOGRAPH-F93C
FA52      ; [.80ED.0020.0002.798D] # CJK COMPATIBILITY IDEOGRAPH-FA52
FA53      ; [.87AE.0020.0002.798E] # CJK COMPATIBILITY IDEOGRAPH-FA53
FA1B      ; [.898C.0020.0002.798F] # CJK COMPATIBILITY IDEOGRAPH-FA1B
2F956     ; [.898C.0020.0002.798F] # CJK COMPATIBILITY IDEOGRAPH-2F956
F9B6      ; [.92A7.0020.0002.79AE] # CJK COMPATIBILITY IDEOGRAPH-F9B6
F956      ; [.8B2A.0020.0002.7A1C] # CJK COMPATIBILITY IDEOGRAPH-F956
FA54      ; [.839F.0020.0002.7A40] # CJK COMPATIBILITY IDEOGRAPH-FA54
2F959     ; [.839F.0020.0002.7A40] # CJK COMPATIBILITY IDEOGRAPH-2F959
2F95B     ; [.80D5.0020.0002.7A4F] # CJK COMPATIBILITY IDEOGRAPH-2F95B
FA55      ; [.8840.0020.0002.7A81] # CJK COMPATIBILITY IDEOGRAPH-FA55
F9F7      ; [.8B0C.0020.0002.7ACB] # CJK COMPATIBILITY IDEOGRAPH-F9F7
F9F8      ; [.8157.0020.0002.7B20] # CJK COMPATIBILITY IDEOGRAPH-F9F8
FA56      ; [.8620.0020.0002.7BC0] # CJK COMPATIBILITY IDEOGRAPH-FA56
FAAD      ; [.8620.0020.0002.7BC0] # CJK COMPATIBILITY IDEOGRAPH-FAAD
2F962     ; [.930B.0020.0002.7BC6] # CJK COMPATIBILITY IDEOGRAPH-2F962
2F963     ; [.8734.0020.0002.7BC9] # CJK COMPATIBILITY IDEOGRAPH-2F963
F9A6      ; [.8B5F.0020.0002.7C3E] # CJK COMPATIBILITY IDEOGRAPH-F9A6
F944      ; [.9312.0020.0002.7C60] # CJK COMPATIBILITY IDEOGRAPH-F944
F9F9      ; [.8B16.0020.0002.7C92] # CJK COMPATIBILITY IDEOGRAPH-F9F9
FA1D      ; [.85F9.0020.0002.7CBE] # CJK COMPATIBILITY IDEOGRAPH-FA1D
2F966     ; [.9341.0020.0002.7CD2] # CJK COMPATIBILITY IDEOGRAPH-2F966
FA03      ; [.8811.0020.0002.7CD6] # CJK COMPATIBILITY IDEOGRAPH-FA03
F97B      ; [.8B2B.0020.0002.7CE7] # CJK COMPATIBILITY IDEOGRAPH-F97B
2F96A     ; [.81DF.0020.0002.7D00] # CJK COMPATIBILITY IDEOGRAPH-2F96A
F9CF      ; [.8940.0020.0002.7D10] # CJK COMPATIBILITY IDEOGRAPH-F9CF
F96A      ; [.8402.0020.0002.7D22] # CJK COMPATIBILITY IDEOGRAPH-F96A
F94F      ; [.8B42.0020.0002.7D2F] # CJK COMPATIBILITY IDEOGRAPH-F94F
FAAF      ; [.9360.0020.0002.7D5B] # CJK COMPATIBILITY IDEOGRAPH-FAAF
2F96C     ; [.935D.0020.0002.7D63] # CJK COMPATIBILITY IDEOGRAPH-2F96C
F957      ; [.801C.0020.0002.7DBE] # CJK COMPATIBILITY IDEOGRAPH-F957
2F96E     ; [.9368.0020.0002.7DC7] # CJK COMPATIBILITY IDEOGRAPH-2F96E
F996      ; [.8B60.0020.0002.7DF4] # CJK COMPATIBILITY IDEOGRAPH-F996
FA57      ; [.8B60.0020.0002.7DF4] # CJK COMPATIBILITY IDEOGRAPH-FA57
FAB0      ; [.8B60.0020.0002.7DF4] # CJK COMPATIBILITY IDEOGRAPH-FAB0
FA58      ; [.9380.0020.0002.7E09] # CJK COMPATIBILITY IDEOGRAPH-FA58
F950      ; [.9389.0020.0002.7E37] # CJK COMPATIBILITY IDEOGRAPH-F950
FA59      ; [.88FA.0020.0002.7E41] # CJK COMPATIBILITY IDEOGRAPH-FA59
FA5A      ; [.8515.0020.0002.7F72] # CJK COMPATIBILITY IDEOGRAPH-FA5A
F9E6      ; [.8ED1.0020.0002.7F79] # CJK COMPATIBILITY IDEOGRAPH-F9E6
F90F      ; [.8AEA.0020.0002.7F85] # CJK COMPATIBILITY IDEOGRAPH-F90F
F9AF      ; [.93C1.0020.0002.7F9A] # CJK COMPATIBILITY IDEOGRAPH-F9AF
FA1E      ; [.8066.0020.0002.7FBD] # CJK COMPATIBILITY IDEOGRAPH-FA1E
F934      ; [.8B78.0020.0002.8001] # CJK COMPATIBILITY IDEOGRAPH-F934
FA5B      ; [.849B.0020.0002.8005] # CJK COMPATIBILITY IDEOGRAPH-FA5B
FAB2      ; [.849B.0020.0002.8005] # CJK COMPATIBILITY IDEOGRAPH-FAB2
2F97A     ; [.849B.0020.0002.8005] # CJK COMPATIBILITY IDEOGRAPH-2F97A
F9B0      ; [.93E1.0020.0002.8046] # CJK COMPATIBILITY IDEOGRAPH-F9B0
F997      ; [.8B61.0020.0002.806F] # CJK COMPATIBILITY IDEOGRAPH-F997
2F97F     ; [.93EA.0020.0002.8070] # CJK COMPATIBILITY IDEOGRAPH-2F97F
F945      ; [.8B79.0020.0002.807E] # CJK COMPATIBILITY IDEOGRAPH-F945
F953      ; [.8B7F.0020.0002.808B] # CJK COMPATIBILITY IDEOGRAPH-F953
2F8D6     ; [.93F5.0020.0002.80AD] # CJK COMPATIBILITY IDEOGRAPH-2F8D6
2F982     ; [.8048.0020.0002.80B2] # CJK COMPATIBILITY IDEOGRAPH-2F982
2F985     ; [.9409.0020.0002.813E] # CJK COMPATIBILITY IDEOGRAPH-2F985
F926      ; [.942A.0020.0002.81D8] # CJK COMPATIBILITY IDEOGRAPH-F926
F9F6      ; [.8B3A.0020.0002.81E8] # CJK COMPATIBILITY IDEOGRAPH-F9F6
FA5C      ; [.84D2.0020.0002.81ED] # CJK COMPATIBILITY IDEOGRAPH-FA5C
2F893     ; [.9433.0020.0002.8201] # CJK COMPATIBILITY IDEOGRAPH-2F893
2F98B     ; [.9433.0020.0002.8201] # CJK COMPATIBILITY IDEOGRAPH-2F98B
FA6D      ; [.81B3.0020.0002.8218] # CJK COMPATIBILITY IDEOGRAPH-FA6D
F97C      ; [.8B2C.0020.0002.826F] # CJK COMPATIBILITY IDEOGRAPH-F97C
2F990     ; [.8051.0020.0002.828B] # CJK COMPATIBILITY IDEOGRAPH-2F990
2F991     ; [.848E.0020.0002.829D] # CJK COMPATIBILITY IDEOGRAPH-2F991
2F993     ; [.80F1.0020.0002.82B1] # CJK COMPATIBILITY IDEOGRAPH-2F993
2F994     ; [.89F0.0020.0002.82B3] # CJK COMPATIBILITY IDEOGRAPH-2F994
2F995     ; [.8105.0020.0002.82BD] # CJK COMPATIBILITY IDEOGRAPH-2F995
F974      ; [.84AA.0020.0002.82E5] # CJK COMPATIBILITY IDEOGRAPH-F974
2F998     ; [.84AA.0020.0002.82E5] # CJK COMPATIBILITY IDEOGRAPH-2F998
2F996     ; [.827F.0020.0002.82E6] # CJK COMPATIBILITY IDEOGRAPH-2F996
2F99C     ; [.9478.0020.0002.8323] # CJK COMPATIBILITY IDEOGRAPH-2F99C
F9FE      ; [.873C.0020.0002.8336] # CJK COMPATIBILITY IDEOGRAPH-F9FE
FAB3      ; [.8380.0020.0002.8352] # CJK COMPATIBILITY IDEOGRAPH-FAB3
2F99D     ; [.9493.0020.0002.83BD] # CJK COMPATIBILITY IDEOGRAPH-2F99D
2F9A1     ; [.81FB.0020.0002.83CA] # CJK COMPATIBILITY IDEOGRAPH-2F9A1
2F9A2     ; [.8270.0020.0002.83CC] # CJK COMPATIBILITY IDEOGRAPH-2F9A2
2F9A3     ; [.83E5.0020.0002.83DC] # CJK COMPATIBILITY IDEOGRAPH-2F9A3
FAB4      ; [.80F5.0020.0002.83EF] # CJK COMPATIBILITY IDEOGRAPH-FAB4
F958      ; [.8936.0020.0002.83F1] # CJK COMPATIBILITY IDEOGRAPH-F958
F918      ; [.8AF3.0020.0002.843D] # CJK COMPATIBILITY IDEOGRAPH-F918
F96E      ; [.8ADA.0020.0002.8449] # CJK COMPATIBILITY IDEOGRAPH-F96E
FA5F      ; [.8751.0020.0002.8457] # CJK COMPATIBILITY IDEOGRAPH-FA5F
2F99F     ; [.8751.0020.0002.8457] # CJK COMPATIBILITY IDEOGRAPH-2F99F
F999      ; [.8B62.0020.0002.84EE] # CJK COMPATIBILITY IDEOGRAPH-F999
F9C2      ; [.94BE.0020.0002.84FC] # CJK COMPATIBILITY IDEOGRAPH-F9C2
F923      ; [.8AFA.0020.0002.85CD] # CJK COMPATIBILITY IDEOGRAPH-F923
F9F0      ; [.94E4.0020.0002.85FA] # CJK COMPATIBILITY IDEOGRAPH-F9F0
F935      ; [.94E5.0020.0002.8606] # CJK COMPATIBILITY IDEOGRAPH-F935
F91F      ; [.8AFB.0020.0002.862D] # CJK COMPATIBILITY IDEOGRAPH-F91F
F910      ; [.94E9.0020.0002.863F] # CJK COMPATIBILITY IDEOGRAPH-F910
2F9B3     ; [.8209.0020.0002.8650] # CJK COMPATIBILITY IDEOGRAPH-2F9B3
F936      ; [.8B1D.0020.0002.865C] # CJK COMPATIBILITY IDEOGRAPH-F936
2F9B4     ; [.8B1D.0020.0002.865C] # CJK COMPATIBILITY IDEOGRAPH-2F9B4
2F9B5     ; [.94EE.0020.0002.8667] # CJK COMPATIBILITY IDEOGRAPH-2F9B5
2F9B7     ; [.94F2.0020.0002.86A9] # CJK COMPATIBILITY IDEOGRAPH-2F9B7
F911      ; [.8AEB.0020.0002.87BA] # CJK COMPATIBILITY IDEOGRAPH-F911
FA08      ; [.8381.0020.0002.884C] # CJK COMPATIBILITY IDEOGRAPH-FA08
2F9C4     ; [.8040.0020.0002.8863] # CJK COMPATIBILITY IDEOGRAPH-2F9C4
F9A0      ; [.8B59.0020.0002.88C2] # CJK COMPATIBILITY IDEOGRAPH-F9A0
F9E7      ; [.8B05.0020.0002.88CF] # CJK COMPATIBILITY IDEOGRAPH-F9E7
F9E8      ; [.8B06.0020.0002.88E1] # CJK COMPATIBILITY IDEOGRAPH-F9E8
F912      ; [.8AEC.0020.0002.88F8] # CJK COMPATIBILITY IDEOGRAPH-F912
FA60      ; [.8165.0020.0002.8910] # CJK COMPATIBILITY IDEOGRAPH-FA60
FAB6      ; [.9576.0020.0002.8941] # CJK COMPATIBILITY IDEOGRAPH-FAB6
F924      ; [.9580.0020.0002.8964] # CJK COMPATIBILITY IDEOGRAPH-F924
FAB7      ; [.898F.0020.0002.8986] # CJK COMPATIBILITY IDEOGRAPH-FAB7
FA0A      ; [.82FA.0020.0002.898B] # CJK COMPATIBILITY IDEOGRAPH-FA0A
FA61      ; [.8454.0020.0002.8996] # CJK COMPATIBILITY IDEOGRAPH-FA61
FAB8      ; [.8454.0020.0002.8996] # CJK COMPATIBILITY IDEOGRAPH-FAB8
2F9CF     ; [.85FE.0020.0002.8AA0] # CJK COMPATIBILITY IDEOGRAPH-2F9CF
FAB9      ; [.876B.0020.0002.8ABF] # CJK COMPATIBILITY IDEOGRAPH-FAB9
FABB      ; [.8600.0020.0002.8ACB] # CJK COMPATIBILITY IDEOGRAPH-FABB
F97D      ; [.8B2D.0020.0002.8AD2] # CJK COMPATIBILITY IDEOGRAPH-F97D
F941      ; [.8B81.0020.0002.8AD6] # CJK COMPATIBILITY IDEOGRAPH-F941
FABE      ; [.8AA6.0020.0002.8AED] # CJK COMPATIBILITY IDEOGRAPH-FABE
2F9D0     ; [.8AA6.0020.0002.8AED] # CJK COMPATIBILITY IDEOGRAPH-2F9D0
FA22      ; [.8519.0020.0002.8AF8] # CJK COMPATIBILITY IDEOGRAPH-FA22
FABA      ; [.8519.0020.0002.8AF8] # CJK COMPATIBILITY IDEOGRAPH-FABA
F95D      ; [.86F5.0020.0002.8AFE] # CJK COMPATIBILITY IDEOGRAPH-F95D
FABD      ; [.86F5.0020.0002.8AFE] # CJK COMPATIBILITY IDEOGRAPH-FABD
FA62      ; [.8097.0020.0002.8B01] # CJK COMPATIBILITY IDEOGRAPH-FA62
FABC      ; [.8097.0020.0002.8B01] # CJK COMPATIBILITY IDEOGRAPH-FABC
FA63      ; [.8273.0020.0002.8B39] # CJK COMPATIBILITY IDEOGRAPH-FA63
FABF      ; [.8273.0020.0002.8B39] # CJK COMPATIBILITY IDEOGRAPH-FABF
F9FC      ; [.8478.0020.0002.8B58] # CJK COMPATIBILITY IDEOGRAPH-F9FC
F95A      ; [.95E2.0020.0002.8B80] # CJK COMPATIBILITY IDEOGRAPH-F95A
FAC0      ; [.8F6E.0020.0002.8B8A] # CJK COMPATIBILITY IDEOGRAPH-FAC0
2F9D1     ; [.8F6E.0020.0002.8B8A] # CJK COMPATIBILITY IDEOGRAPH-2F9D1
F900      ; [.95ED.0020.0002.8C48] # CJK COMPATIBILITY IDEOGRAPH-F900
2F9D2     ; [.95F1.0020.0002.8C55] # CJK COMPATIBILITY IDEOGRAPH-2F9D2
2F9D4     ; [.81AA.0020.0002.8CAB] # CJK COMPATIBILITY IDEOGRAPH-2F9D4
2F9D5     ; [.9608.0020.0002.8CC1] # CJK COMPATIBILITY IDEOGRAPH-2F9D5
F948      ; [.8B69.0020.0002.8CC2] # CJK COMPATIBILITY IDEOGRAPH-F948
F903      ; [.9607.0020.0002.8CC8] # CJK COMPATIBILITY IDEOGRAPH-F903
FA64      ; [.895D.0020.0002.8CD3] # CJK COMPATIBILITY IDEOGRAPH-FA64
FA65      ; [.869E.0020.0002.8D08] # CJK COMPATIBILITY IDEOGRAPH-FA65
FAC1      ; [.869E.0020.0002.8D08] # CJK COMPATIBILITY IDEOGRAPH-FAC1
2F9D7     ; [.81E4.0020.0002.8D77] # CJK COMPATIBILITY IDEOGRAPH-2F9D7
2F9DA     ; [.9629.0020.0002.8DCB] # CJK COMPATIBILITY IDEOGRAPH-2F9DA
F937      ; [.8B6A.0020.0002.8DEF] # CJK COMPATIBILITY IDEOGRAPH-F937
F902      ; [.849D.0020.0002.8ECA] # CJK COMPATIBILITY IDEOGRAPH-F902
F998      ; [.966D.0020.0002.8F26] # CJK COMPATIBILITY IDEOGRAPH-F998
F9D7      ; [.8B3B.0020.0002.8F2A] # CJK COMPATIBILITY IDEOGRAPH-F9D7
FAC2      ; [.8AA7.0020.0002.8F38] # CJK COMPATIBILITY IDEOGRAPH-FAC2
2F9DF     ; [.8AA7.0020.0002.8F38] # CJK COMPATIBILITY IDEOGRAPH-2F9DF
FA07      ; [.966F.0020.0002.8F3B] # CJK COMPATIBILITY IDEOGRAPH-FA07
F98D      ; [.967A.0020.0002.8F62] # CJK COMPATIBILITY IDEOGRAPH-F98D
2F98D     ; [.8474.0020.0002.8F9E] # CJK COMPATIBILITY IDEOGRAPH-2F98D
F971      ; [.86FD.0020.0002.8FB0] # CJK COMPATIBILITY IDEOGRAPH-F971
F99A      ; [.8B63.0020.0002.9023] # CJK COMPATIBILITY IDEOGRAPH-F99A
FA25      ; [.804E.0020.0002.9038] # CJK COMPATIBILITY IDEOGRAPH-FA25
FA67      ; [.804E.0020.0002.9038] # CJK COMPATIBILITY IDEOGRAPH-FA67
FAC3      ; [.96A7.0020.0002.9072] # CJK COMPATIBILITY IDEOGRAPH-FAC3
F9C3      ; [.8B2E.0020.0002.907C] # CJK COMPATIBILITY IDEOGRAPH-F9C3
F913      ; [.96AE.0020.0002.908F] # CJK COMPATIBILITY IDEOGRAPH-F913
F92C      ; [.8B7B.0020.0002.90CE] # CJK COMPATIBILITY IDEOGRAPH-F92C
FA26      ; [.87E9.0020.0002.90FD] # CJK COMPATIBILITY IDEOGRAPH-FA26
F919      ; [.8AF4.0020.0002.916A] # CJK COMPATIBILITY IDEOGRAPH-F919
F9B7      ; [.96CC.0020.0002.91B4] # CJK COMPATIBILITY IDEOGRAPH-F9B7
F9E9      ; [.8B07.0020.0002.91CC] # CJK COMPATIBILITY IDEOGRAPH-F9E9
F97E      ; [.8B2F.0020.0002.91CF] # CJK COMPATIBILITY IDEOGRAPH-F97E
F90A      ; [.8275.0020.0002.91D1] # CJK COMPATIBILITY IDEOGRAPH-F90A
F9B1      ; [.8B4E.0020.0002.9234] # CJK COMPATIBILITY IDEOGRAPH-F9B1
2F9EE     ; [.8124.0020.0002.958B] # CJK COMPATIBILITY IDEOGRAPH-2F9EE
F986      ; [.9739.0020.0002.95AD] # CJK COMPATIBILITY IDEOGRAPH-F986
F9C6      ; [.974C.0020.0002.962E] # CJK COMPATIBILITY IDEOGRAPH-F9C6
F951      ; [.9751.0020.0002.964B] # CJK COMPATIBILITY IDEOGRAPH-F951
FA09      ; [.838C.0020.0002.964D] # CJK COMPATIBILITY IDEOGRAPH-FA09
F959      ; [.8B30.0020.0002.9675] # CJK COMPATIBILITY IDEOGRAPH-F959
F9D3      ; [.8B09.0020.0002.9678] # CJK COMPATIBILITY IDEOGRAPH-F9D3
F9DC      ; [.8B17.0020.0002.9686] # CJK COMPATIBILITY IDEOGRAPH-F9DC
F9F1      ; [.8B3C.0020.0002.96A3] # CJK COMPATIBILITY IDEOGRAPH-F9F1
FA2F      ; [.8B4F.0020.0002.96B7] # CJK COMPATIBILITY IDEOGRAPH-FA2F
F9B8      ; [.9765.0020.0002.96B8] # CJK COMPATIBILITY IDEOGRAPH-F9B8
F9EA      ; [.8B08.0020.0002.96E2] # CJK COMPATIBILITY IDEOGRAPH-F9EA
FA68      ; [.8864.0020.0002.96E3] # CJK COMPATIBILITY IDEOGRAPH-FA68
FAC7      ; [.8864.0020.0002.96E3] # CJK COMPATIBILITY IDEOGRAPH-FAC7
F9B2      ; [.8B50.0020.0002.96F6] # CJK COMPATIBILITY IDEOGRAPH-F9B2
F949      ; [.8AF0.0020.0002.96F7] # CJK COMPATIBILITY IDEOGRAPH-F949
F938      ; [.8B6B.0020.0002.9732] # CJK COMPATIBILITY IDEOGRAPH-F938
F9B3      ; [.9781.0020.0002.9748] # CJK COMPATIBILITY IDEOGRAPH-F9B3
FA1C      ; [.8A9E.0020.0002.9756] # CJK COMPATIBILITY IDEOGRAPH-FA1C
FAC8      ; [.8A9E.0020.0002.9756] # CJK COMPATIBILITY IDEOGRAPH-FAC8
FA69      ; [.8254.0020.0002.97FF] # CJK COMPATIBILITY IDEOGRAPH-FA69
FACA      ; [.8254.0020.0002.97FF] # CJK COMPATIBILITY IDEOGRAPH-FACA
F9B4      ; [.8B31.0020.0002.9818] # CJK COMPATIBILITY IDEOGRAPH-F9B4
FA6A      ; [.895E.0020.0002.983B] # CJK COMPATIBILITY IDEOGRAPH-FA6A
FACC      ; [.895E.0020.0002.983B] # CJK COMPATIBILITY IDEOGRAPH-FACC
F9D0      ; [.8B43.0020.0002.985E] # CJK COMPATIBILITY IDEOGRAPH-F9D0
2FA02     ; [.81E7.0020.0002.98E2] # CJK COMPATIBILITY IDEOGRAPH-2FA02
FA2A      ; [.8902.0020.0002.98EF] # CJK COMPATIBILITY IDEOGRAPH-FA2A
FA2B      ; [.845D.0020.0002.98FC] # CJK COMPATIBILITY IDEOGRAPH-FA2B
FA2C      ; [.81B2.0020.0002.9928] # CJK COMPATIBILITY IDEOGRAPH-FA2C
F91A      ; [.97E3.0020.0002.99F1] # CJK COMPATIBILITY IDEOGRAPH-F91A
F987      ; [.97FD.0020.0002.9A6A] # CJK COMPATIBILITY IDEOGRAPH-F987
F939      ; [.8B66.0020.0002.9B6F] # CJK COMPATIBILITY IDEOGRAPH-F939
F9F2      ; [.8B3D.0020.0002.9C57] # CJK COMPATIBILITY IDEOGRAPH-F9F2
FA2D      ; [.8798.0020.0002.9DB4] # CJK COMPATIBILITY IDEOGRAPH-FA2D
F93A      ; [.83F8.0020.0002.9DFA] # CJK COMPATIBILITY IDEOGRAPH-F93A
F920      ; [.9890.0020.0002.9E1E] # CJK COMPATIBILITY IDEOGRAPH-F920
F940      ; [.8476.0020.0002.9E7F] # CJK COMPATIBILITY IDEOGRAPH-F940
F988      ; [.8B52.0020.0002.9E97] # CJK COMPATIBILITY IDEOGRAPH-F988
F9F3      ; [.8B3E.0020.0002.9E9F] # CJK COMPATIBILITY IDEOGRAPH-F9F3
2FA15     ; [.8A2C.0020.0002.9EBB] # CJK COMPATIBILITY IDEOGRAPH-2FA15
F989      ; [.98A3.0020.0002.9ECE] # CJK COMPATIBILITY IDEOGRAPH-F989
2FA17     ; [.98B1.0020.0002.9EF9] # CJK COMPATIBILITY IDEOGRAPH-2FA17
2FA1C     ; [.892E.0020.0002.9F3B] # CJK COMPATIBILITY IDEOGRAPH-2FA1C
F9C4      ; [.8B19.0020.0002.9F8D] # CJK COMPATIBILITY IDEOGRAPH-F9C4
F907      ; [.98CB.0020.0002.9F9C] # CJK COMPATIBILITY IDEOGRAPH-F907
F908      ; [.98CB.0020.0002.9F9C] # CJK COMPATIBILITY IDEOGRAPH-F908
FACE      ; [.98CB.0020.0002.9F9C] # CJK COMPATIBILITY IDEOGRAPH-FACE
ENTRY
};
