/*-
 * Copyright (c) 2009 Ed Schouten <ed@FreeBSD.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <sys/cdefs.h>
__FBSDID("$FreeBSD: stable/9/lib/libulog/utempter.c 202215 2010-01-13 18:53:06Z ed $");

#include "ulog.h"
#include "utempter.h"

static int last_fd = -1;

int
utempter_add_record(int fd, const char *host)
{

	ulog_login_pseudo(fd, host);
	last_fd = fd;
	return (0);
}

int
utempter_remove_added_record(void)
{

	if (last_fd < 0)
		return (0);
	ulog_logout_pseudo(last_fd);
	last_fd = -1;
	return (0);
}

int
utempter_remove_record(int fd)
{

	ulog_logout_pseudo(fd);
	if (last_fd == fd)
		last_fd = -1;
	return (0);
}

void
addToUtmp(const char *pty __unused, const char *host, int fd)
{

	utempter_add_record(fd, host);
}

void
removeFromUtmp(void)
{

	utempter_remove_added_record();
}

void
removeLineFromUtmp(const char *pty __unused, int fd)
{

	utempter_remove_record(fd);
}
