/*-
 * SPDX-License-Identifier: BSD-2-Clause-FreeBSD
 *
 * Copyright (c) 2022 Jessica Clarke <jrtc27@FreeBSD.org>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef _DA9063_REG_H_
#define _DA9063_REG_H_

/*
 * Reference: DA9063 System PMIC for Mobile and Automotive Applications
 * datasheet (https://www.renesas.com/us/en/document/dst/da9063-datasheet),
 * revision 2.4.
 */

/* Page 0 */

#define	DA9063_PAGE_CON			0x00
#define	 DA9063_PAGE_CON_REG_PAGE_SHIFT		0
#define	 DA9063_PAGE_CON_REG_PAGE_MASK		0x07
#define	 DA9063_PAGE_CON_WRITE_MODE		0x40
#define	 DA9063_PAGE_CON_REVERT			0x80

/* System Control and Event Registers (SYSMON) */

#define	DA9063_STATUS_A			0x01
#define	 DA9063_STATUS_A_NONKEY			0x01
#define	 DA9063_STATUS_A_WAKE			0x02
#define	 DA9063_STATUS_A_DVC_BUSY		0x04
#define	 DA9063_STATUS_A_COMP1V2		0x08
#define	DA9063_STATUS_B			0x02
#define	 DA9063_STATUS_B_GPI0			0x01
#define	 DA9063_STATUS_B_GPI1			0x02
#define	 DA9063_STATUS_B_GPI2			0x04
#define	 DA9063_STATUS_B_GPI3			0x08
#define	 DA9063_STATUS_B_GPI4			0x10
#define	 DA9063_STATUS_B_GPI5			0x20
#define	 DA9063_STATUS_B_GPI6			0x40
#define	 DA9063_STATUS_B_GPI7			0x80
#define	DA9063_STATUS_C			0x03
#define	 DA9063_STATUS_C_GPI8			0x01
#define	 DA9063_STATUS_C_GPI9			0x02
#define	 DA9063_STATUS_C_GPI10			0x04
#define	 DA9063_STATUS_C_GPI11			0x08
#define	 DA9063_STATUS_C_GPI12			0x10
#define	 DA9063_STATUS_C_GPI13			0x20
#define	 DA9063_STATUS_C_GPI14			0x40
#define	 DA9063_STATUS_C_GPI15			0x80
#define	DA9063_STATUS_D			0x04
#define	 DA9063_STATUS_D_LDO3_LIM		0x08
#define	 DA9063_STATUS_D_LDO4_LIM		0x10
#define	 DA9063_STATUS_D_LDO7_LIM		0x20
#define	 DA9063_STATUS_D_LDO8_LIM		0x40
#define	 DA9063_STATUS_D_LDO11_LIM		0x80
#define	DA9063_FAULT_LOG		0x05
#define	 DA9063_FAULT_LOG_TWD_ERROR		0x01
#define	 DA9063_FAULT_LOG_POR			0x02
#define	 DA9063_FAULT_LOG_VDD_FAULT		0x04
#define	 DA9063_FAULT_LOG_VDD_START		0x08
#define	 DA9063_FAULT_LOG_TEMP_CRIT		0x10
#define	 DA9063_FAULT_LOG_KEY_RESET		0x20
#define	 DA9063_FAULT_LOG_NSHUTDOWN		0x40
#define	 DA9063_FAULT_LOG_WAIT_SHUT		0x80
#define	DA9063_EVENT_A			0x06
#define	 DA9063_EVENT_A_E_NONKEY		0x01
#define	 DA9063_EVENT_A_E_ALARM			0x02
#define	 DA9063_EVENT_A_E_TICK			0x04
#define	 DA9063_EVENT_A_E_ADC_RDY		0x08
#define	 DA9063_EVENT_A_E_SEQ_RDY		0x10
#define	 DA9063_EVENT_A_EVENTS_B		0x20
#define	 DA9063_EVENT_A_EVENTS_C		0x40
#define	 DA9063_EVENT_A_EVENTS_D		0x80
#define	DA9063_EVENT_B			0x07
#define	 DA9063_EVENT_B_E_WAKE			0x01
#define	 DA9063_EVENT_B_E_TEMP			0x02
#define	 DA9063_EVENT_B_E_COMP_1V2		0x04
#define	 DA9063_EVENT_B_E_LDO_LIM		0x08
#define	 DA9063_EVENT_B_E_REG_UVOV		0x10
#define	 DA9063_EVENT_B_E_DVC_RDY		0x20
#define	 DA9063_EVENT_B_E_VDD_MON		0x40
#define	 DA9063_EVENT_B_E_VDD_WARN		0x80
#define	DA9063_EVENT_C			0x08
#define	 DA9063_EVENT_C_E_GPI0			0x01
#define	 DA9063_EVENT_C_E_GPI1			0x02
#define	 DA9063_EVENT_C_E_GPI2			0x04
#define	 DA9063_EVENT_C_E_GPI3			0x08
#define	 DA9063_EVENT_C_E_GPI4			0x10
#define	 DA9063_EVENT_C_E_GPI5			0x20
#define	 DA9063_EVENT_C_E_GPI6			0x40
#define	 DA9063_EVENT_C_E_GPI7			0x80
#define	DA9063_EVENT_D			0x09
#define	 DA9063_EVENT_D_E_GPI8			0x01
#define	 DA9063_EVENT_D_E_GPI9			0x02
#define	 DA9063_EVENT_D_E_GPI10			0x04
#define	 DA9063_EVENT_D_E_GPI11			0x08
#define	 DA9063_EVENT_D_E_GPI12			0x10
#define	 DA9063_EVENT_D_E_GPI13			0x20
#define	 DA9063_EVENT_D_E_GPI14			0x40
#define	 DA9063_EVENT_D_E_GPI15			0x80
#define	DA9063_IRQ_MASK_A		0x0a
#define	 DA9063_IRQ_MASK_A_M_NONKEY		0x01
#define	 DA9063_IRQ_MASK_A_M_ALARM		0x02
#define	 DA9063_IRQ_MASK_A_M_TICK		0x04
#define	 DA9063_IRQ_MASK_A_M_ADC_RDY		0x08
#define	 DA9063_IRQ_MASK_A_M_SEQ_RDY		0x10
#define	DA9063_IRQ_MASK_B		0x0b
#define	 DA9063_IRQ_MASK_B_M_WAKE		0x01
#define	 DA9063_IRQ_MASK_B_M_TEMP		0x02
#define	 DA9063_IRQ_MASK_B_M_COMP_1V2		0x04
#define	 DA9063_IRQ_MASK_B_M_LDO_LIM		0x08
#define	 DA9063_IRQ_MASK_B_M_REG_UVOV		0x10
#define	 DA9063_IRQ_MASK_B_M_DVC_RDY		0x20
#define	 DA9063_IRQ_MASK_B_M_VDD_MON		0x40
#define	 DA9063_IRQ_MASK_B_M_VDD_WARN		0x80
#define	DA9063_IRQ_MASK_C		0x0c
#define	 DA9063_IRQ_MASK_C_M_GPI0		0x01
#define	 DA9063_IRQ_MASK_C_M_GPI1		0x02
#define	 DA9063_IRQ_MASK_C_M_GPI2		0x04
#define	 DA9063_IRQ_MASK_C_M_GPI3		0x08
#define	 DA9063_IRQ_MASK_C_M_GPI4		0x10
#define	 DA9063_IRQ_MASK_C_M_GPI5		0x20
#define	 DA9063_IRQ_MASK_C_M_GPI6		0x40
#define	 DA9063_IRQ_MASK_C_M_GPI7		0x80
#define	DA9063_IRQ_MASK_D		0x0d
#define	 DA9063_IRQ_MASK_D_M_GPI8		0x01
#define	 DA9063_IRQ_MASK_D_M_GPI9		0x02
#define	 DA9063_IRQ_MASK_D_M_GPI10		0x04
#define	 DA9063_IRQ_MASK_D_M_GPI11		0x08
#define	 DA9063_IRQ_MASK_D_M_GPI12		0x10
#define	 DA9063_IRQ_MASK_D_M_GPI13		0x20
#define	 DA9063_IRQ_MASK_D_M_GPI14		0x40
#define	 DA9063_IRQ_MASK_D_M_GPI15		0x80
#define	DA9063_CONTROL_A		0x0e
#define	 DA9063_CONTROL_A_SYSTEM_EN		0x01
#define	 DA9063_CONTROL_A_POWER_EN		0x02
#define	 DA9063_CONTROL_A_POWER1_EN		0x04
#define	 DA9063_CONTROL_A_STANDBY		0x08
#define	 DA9063_CONTROL_A_M_SYSTEM_EN		0x10
#define	 DA9063_CONTROL_A_M_POWER_EN		0x20
#define	 DA9063_CONTROL_A_M_POWER1_EN		0x40
#define	 DA9063_CONTROL_A_CP_EN			0x80
#define	DA9063_CONTROL_B		0x0f
#define	 DA9063_CONTROL_B_CHG_SEL		0x01
#define	 DA9063_CONTROL_B_WATCHDOG_DIS		0x02
#define	 DA9063_CONTROL_B_RESET_GLINKING	0x04
#define	 DA9063_CONTROL_B_NRES_MODE		0x08
#define	 DA9063_CONTROL_B_NONKEY_LOCK		0x10
#define	 DA9063_CONTROL_B_BUCK_SLOWSTART	0x80
#define	DA9063_CONTROL_C		0x10
#define	 DA9063_CONTROL_C_DEBOUNCING_SHIFT	0
#define	 DA9063_CONTROL_C_DEBOUNCING_MASK	0x07
#define	 DA9063_CONTROL_C_AUTO_BOOT		0x08
#define	 DA9063_CONTROL_C_OTPREAD_EN		0x10
#define	 DA9063_CONTROL_C_SLEW_RATE_SHIFT	5
#define	 DA9063_CONTROL_C_SLEW_RATE_MASK	0x03
#define	 DA9063_CONTROL_C_DEF_SUPPLY		0x80
#define	DA9063_CONTROL_D		0x11
#define	 DA9063_CONTROL_D_TWDSCALE_SHIFT	0
#define	 DA9063_CONTROL_D_TWDSCALE_MASK		0x07
#define	 DA9063_CONTROL_D_BLINK_FRQ_SHIFT	3
#define	 DA9063_CONTROL_D_BLINK_FRQ_MASK	0x07
#define	 DA9063_CONTROL_D_BLINK_DUR_SHIFT	2
#define	 DA9063_CONTROL_D_BLINK_DUR_MASK	0x03
#define	DA9063_CONTROL_E		0x12
#define	 DA9063_CONTROL_E_RTC_MODE_PD		0x01
#define	 DA9063_CONTROL_E_RTC_MODE_SD		0x02
#define	 DA9063_CONTROL_E_RTC_EN		0x04
#define	 DA9063_CONTROL_E_ECO_MODE		0x08
#define	 DA9063_CONTROL_E_PM_FB1_PIN		0x10
#define	 DA9063_CONTROL_E_PM_FB2_PIN		0x20
#define	 DA9063_CONTROL_E_PM_FB3_PIN		0x40
#define	 DA9063_CONTROL_E_V_LOCK		0x80
#define	DA9063_CONTROL_F		0x13
#define	 DA9063_CONTROL_F_WATCHDOG		0x01
#define	 DA9063_CONTROL_F_SHUTDOWN		0x02
#define	 DA9063_CONTROL_F_WAKE_UP		0x04
#define	DA9063_PD_DIS			0x14
#define	 DA9063_PD_DIS_GPI_DIS			0x01
#define	 DA9063_PD_DIS_GPADC_PAUSE		0x02
#define	 DA9063_PD_DIS_PMIF_DIS			0x04
#define	 DA9063_PD_DIS_HS2IF_DIS		0x08
#define	 DA9063_PD_DIS_BBAT_DIS			0x20
#define	 DA9063_PD_DIS_OUT32K_PAUSE		0x40
#define	 DA9063_PD_DIS_PMCONT_DIS		0x80

/* GPIO Control Registers (GPIO) */

#define	DA9063_GPIO0_1			0x15
#define	 DA9063_GPIO0_1_GPIO0_PIN_SHIFT		0
#define	 DA9063_GPIO0_1_GPIO0_PIN_MASK		0x03
#define	 DA9063_GPIO0_1_GPIO0_TYPE		0x04
#define	 DA9063_GPIO0_1_GPIO0_WEN		0x08
#define	 DA9063_GPIO0_1_GPIO1_PIN_SHIFT		4
#define	 DA9063_GPIO0_1_GPIO1_PIN_MASK		0x03
#define	 DA9063_GPIO0_1_GPIO1_TYPE		0x40
#define	 DA9063_GPIO0_1_GPIO1_WEN		0x80
#define	DA9063_GPIO2_3			0x16
#define	 DA9063_GPIO2_3_GPIO2_PIN_SHIFT		0
#define	 DA9063_GPIO2_3_GPIO2_PIN_MASK		0x03
#define	 DA9063_GPIO2_3_GPIO2_TYPE		0x04
#define	 DA9063_GPIO2_3_GPIO2_WEN		0x08
#define	 DA9063_GPIO2_3_GPIO3_PIN_SHIFT		4
#define	 DA9063_GPIO2_3_GPIO3_PIN_MASK		0x03
#define	 DA9063_GPIO2_3_GPIO3_TYPE		0x40
#define	 DA9063_GPIO2_3_GPIO3_WEN		0x80
#define	DA9063_GPIO4_5			0x17
#define	 DA9063_GPIO4_5_GPIO4_PIN_SHIFT		0
#define	 DA9063_GPIO4_5_GPIO4_PIN_MASK		0x03
#define	 DA9063_GPIO4_5_GPIO4_TYPE		0x04
#define	 DA9063_GPIO4_5_GPIO4_WEN		0x08
#define	 DA9063_GPIO4_5_GPIO5_PIN_SHIFT		4
#define	 DA9063_GPIO4_5_GPIO5_PIN_MASK		0x03
#define	 DA9063_GPIO4_5_GPIO5_TYPE		0x04
#define	 DA9063_GPIO4_5_GPIO5_WEN		0x08
#define	DA9063_GPIO6_7			0x18
#define	 DA9063_GPIO6_7_GPIO6_PIN_SHIFT		0
#define	 DA9063_GPIO6_7_GPIO6_PIN_MASK		0x03
#define	 DA9063_GPIO6_7_GPIO6_TYPE		0x04
#define	 DA9063_GPIO6_7_GPIO6_WEN		0x08
#define	 DA9063_GPIO6_7_GPIO7_PIN_SHIFT		4
#define	 DA9063_GPIO6_7_GPIO7_PIN_MASK		0x03
#define	 DA9063_GPIO6_7_GPIO7_TYPE		0x04
#define	 DA9063_GPIO6_7_GPIO7_WEN		0x08
#define	DA9063_GPIO8_9			0x19
#define	 DA9063_GPIO8_9_GPIO8_PIN_SHIFT		0
#define	 DA9063_GPIO8_9_GPIO8_PIN_MASK		0x03
#define	 DA9063_GPIO8_9_GPIO8_TYPE		0x04
#define	 DA9063_GPIO8_9_GPIO8_WEN		0x08
#define	 DA9063_GPIO8_9_GPIO9_PIN_SHIFT		4
#define	 DA9063_GPIO8_9_GPIO9_PIN_MASK		0x03
#define	 DA9063_GPIO8_9_GPIO9_TYPE		0x04
#define	 DA9063_GPIO8_9_GPIO9_WEN		0x08
#define	DA9063_GPIO10_11		0x1a
#define	 DA9063_GPIO10_11_GPIO10_PIN_SHIFT	0
#define	 DA9063_GPIO10_11_GPIO10_PIN_MASK	0x03
#define	 DA9063_GPIO10_11_GPIO10_TYPE		0x04
#define	 DA9063_GPIO10_11_GPIO10_WEN		0x08
#define	 DA9063_GPIO10_11_GPIO11_PIN_SHIFT	4
#define	 DA9063_GPIO10_11_GPIO11_PIN_MASK	0x03
#define	 DA9063_GPIO10_11_GPIO11_TYPE		0x04
#define	 DA9063_GPIO10_11_GPIO11_WEN		0x08
#define	DA9063_GPIO12_13		0x1b
#define	 DA9063_GPIO12_13_GPIO12_PIN_SHIFT	0
#define	 DA9063_GPIO12_13_GPIO12_PIN_MASK	0x03
#define	 DA9063_GPIO12_13_GPIO12_TYPE		0x04
#define	 DA9063_GPIO12_13_GPIO12_WEN		0x08
#define	 DA9063_GPIO12_13_GPIO13_PIN_SHIFT	4
#define	 DA9063_GPIO12_13_GPIO13_PIN_MASK	0x03
#define	 DA9063_GPIO12_13_GPIO13_TYPE		0x04
#define	 DA9063_GPIO12_13_GPIO13_WEN		0x08
#define	DA9063_GPIO14_15		0x1c
#define	 DA9063_GPIO14_15_GPIO14_PIN_SHIFT	0
#define	 DA9063_GPIO14_15_GPIO14_PIN_MASK	0x03
#define	 DA9063_GPIO14_15_GPIO14_TYPE		0x04
#define	 DA9063_GPIO14_15_GPIO14_WEN		0x08
#define	 DA9063_GPIO14_15_GPIO15_PIN_SHIFT	4
#define	 DA9063_GPIO14_15_GPIO15_PIN_MASK	0x03
#define	 DA9063_GPIO14_15_GPIO15_TYPE		0x04
#define	 DA9063_GPIO14_15_GPIO15_WEN		0x08
#define	DA9063_GPIO_MODE0_7		0x1d
#define	 DA9063_GPIO_MODE0_7_GPIO0_MASK		0x01
#define	 DA9063_GPIO_MODE0_7_GPIO1_MASK		0x02
#define	 DA9063_GPIO_MODE0_7_GPIO2_MASK		0x04
#define	 DA9063_GPIO_MODE0_7_GPIO3_MASK		0x08
#define	 DA9063_GPIO_MODE0_7_GPIO4_MASK		0x10
#define	 DA9063_GPIO_MODE0_7_GPIO5_MASK		0x20
#define	 DA9063_GPIO_MODE0_7_GPIO6_MASK		0x40
#define	 DA9063_GPIO_MODE0_7_GPIO7_MASK		0x80
#define	DA9063_GPIO_MODE8_15		0x1e
#define	 DA9063_GPIO_MODE8_15_GPIO8_MASK	0x01
#define	 DA9063_GPIO_MODE8_15_GPIO9_MASK	0x02
#define	 DA9063_GPIO_MODE8_15_GPIO10_MASK	0x04
#define	 DA9063_GPIO_MODE8_15_GPIO11_MASK	0x08
#define	 DA9063_GPIO_MODE8_15_GPIO12_MASK	0x10
#define	 DA9063_GPIO_MODE8_15_GPIO13_MASK	0x20
#define	 DA9063_GPIO_MODE8_15_GPIO14_MASK	0x40
#define	 DA9063_GPIO_MODE8_15_GPIO15_MASK	0x80
#define	DA9063_SWITCH_CONT		0x1f
#define	 DA9063_SWITCH_CONT_CORE_SW_GPI_SHIFT	0
#define	 DA9063_SWITCH_CONT_CORE_SW_GPI_MASK	0x03
#define	 DA9063_SWITCH_CONT_PERI_SW_GPI_SHIFT	2
#define	 DA9063_SWITCH_CONT_PERI_SW_GPI_MASK	0x03
#define	 DA9063_SWITCH_CONT_SWITCH_SR_SHIFT	4
#define	 DA9063_SWITCH_CONT_SWITCH_SR_MASK	0x03
#define	 DA9063_SWITCH_CONT_CORE_SW_INT		0x40
#define	 DA9063_SWITCH_CONT_CP_EN_MODE		0x80

/* Regulator Control Registers (REG) */

#define	DA9063_BCORE2_CONT		0x20
#define	 DA9063_BCORE2_CONT_BCORE2_EN		0x01
#define	 DA9063_BCORE2_CONT_BCORE2_GPI_SHIFT	1
#define	 DA9063_BCORE2_CONT_BCORE2_GPI_MASK	0x03
#define	 DA9063_BCORE2_CONT_BCORE2_CONF		0x08
#define	 DA9063_BCORE2_CONT_VBCORE2_GPI_SHIFT	5
#define	 DA9063_BCORE2_CONT_VBCORE2_GPI_MASK	0x03
#define	DA9063_BCORE1_CONT		0x21
#define	 DA9063_BCORE1_CONT_BCORE1_EN		0x01
#define	 DA9063_BCORE1_CONT_BCORE1_GPI_SHIFT	1
#define	 DA9063_BCORE1_CONT_BCORE1_GPI_MASK	0x03
#define	 DA9063_BCORE1_CONT_BCORE1_CONF		0x08
#define	 DA9063_BCORE1_CONT_CORE_SW_EN		0x10
#define	 DA9063_BCORE1_CONT_VBCORE1_GPI_SHIFT	5
#define	 DA9063_BCORE1_CONT_VBCORE1_GPI_MASK	0x03
#define	 DA9063_BCORE1_CONT_CORE_SW_CONF	0x80
#define	DA9063_BPRO_CONT		0x22
#define	 DA9063_BPRO_CONT_BPRO_EN		0x01
#define	 DA9063_BPRO_CONT_BPRO_GPI_SHIFT	1
#define	 DA9063_BPRO_CONT_BPRO_GPI_MASK		0x03
#define	 DA9063_BPRO_CONT_BPRO_CONF		0x08
#define	 DA9063_BPRO_CONT_VBPRO_GPI_SHIFT	5
#define	 DA9063_BPRO_CONT_VBPRO_GPI_MASK	0x03
#define	DA9063_BMEM_CONT		0x23
#define	 DA9063_BMEM_CONT_BMEM_EN		0x01
#define	 DA9063_BMEM_CONT_BMEM_GPI_SHIFT	1
#define	 DA9063_BMEM_CONT_BMEM_GPI_MASK		0x03
#define	 DA9063_BMEM_CONT_BMEM_CONF		0x08
#define	 DA9063_BMEM_CONT_VBMEM_GPI_SHIFT	5
#define	 DA9063_BMEM_CONT_VBMEM_GPI_MASK	0x03
#define	DA9063_BIO_CONT			0x24
#define	 DA9063_BIO_CONT_BIO_EN			0x01
#define	 DA9063_BIO_CONT_BIO_GPI_SHIFT		1
#define	 DA9063_BIO_CONT_BIO_GPI_MASK		0x03
#define	 DA9063_BIO_CONT_BIO_CONF		0x08
#define	 DA9063_BIO_CONT_VBIO_GPI_SHIFT		5
#define	 DA9063_BIO_CONT_VBIO_GPI_MASK		0x03
#define	DA9063_BPERI_CONT		0x25
#define	 DA9063_BPERI_CONT_BPERI_EN		0x01
#define	 DA9063_BPERI_CONT_BPERI_GPI_SHIFT	1
#define	 DA9063_BPERI_CONT_BPERI_GPI_MASK	0x03
#define	 DA9063_BPERI_CONT_BPERI_CONF		0x08
#define	 DA9063_BPERI_CONT_PERI_SW_EN		0x10
#define	 DA9063_BPERI_CONT_VBPERI_GPI_SHIFT	5
#define	 DA9063_BPERI_CONT_VBPERI_GPI_MASK	0x03
#define	 DA9063_BPERI_CONT_PERI_SW_CONF		0x80
#define	DA9063_LDO1_CONT		0x26
#define	 DA9063_LDO1_CONT_LDO1_EN		0x01
#define	 DA9063_LDO1_CONT_LDO1_GPI_SHIFT	1
#define	 DA9063_LDO1_CONT_LDO1_GPI_MASK		0x03
#define	 DA9063_LDO1_CONT_LDO1_PD_DIS		0x08
#define	 DA9063_LDO1_CONT_VLDO1_GPI_SHIFT	5
#define	 DA9063_LDO1_CONT_VLDO1_GPI_MASK	0x03
#define	 DA9063_LDO1_CONT_VLDO1_CONF		0x80
#define	DA9063_LDO2_CONT		0x27
#define	 DA9063_LDO2_CONT_LDO2_EN		0x01
#define	 DA9063_LDO2_CONT_LDO2_GPI_SHIFT	1
#define	 DA9063_LDO2_CONT_LDO2_GPI_MASK		0x03
#define	 DA9063_LDO2_CONT_LDO2_PD_DIS		0x08
#define	 DA9063_LDO2_CONT_VLDO2_GPI_SHIFT	5
#define	 DA9063_LDO2_CONT_VLDO2_GPI_MASK	0x03
#define	 DA9063_LDO2_CONT_VLDO2_CONF		0x80
#define	DA9063_LDO3_CONT		0x28
#define	 DA9063_LDO3_CONT_LDO3_EN		0x01
#define	 DA9063_LDO3_CONT_LDO3_GPI_SHIFT	1
#define	 DA9063_LDO3_CONT_LDO3_GPI_MASK		0x03
#define	 DA9063_LDO3_CONT_LDO3_PD_DIS		0x08
#define	 DA9063_LDO3_CONT_VLDO3_GPI_SHIFT	5
#define	 DA9063_LDO3_CONT_VLDO3_GPI_MASK	0x03
#define	 DA9063_LDO3_CONT_VLDO3_CONF		0x80
#define	DA9063_LDO4_CONT		0x29
#define	 DA9063_LDO4_CONT_LDO4_EN		0x01
#define	 DA9063_LDO4_CONT_LDO4_GPI_SHIFT	1
#define	 DA9063_LDO4_CONT_LDO4_GPI_MASK		0x03
#define	 DA9063_LDO4_CONT_LDO4_PD_DIS		0x08
#define	 DA9063_LDO4_CONT_VLDO4_SEL		0x10
#define	 DA9063_LDO4_CONT_VLDO4_GPI_SHIFT	5
#define	 DA9063_LDO4_CONT_VLDO4_GPI_MASK	0x03
#define	 DA9063_LDO4_CONT_VLDO4_CONF		0x80
#define	DA9063_LDO5_CONT		0x2a
#define	 DA9063_LDO5_CONT_LDO5_EN		0x01
#define	 DA9063_LDO5_CONT_LDO5_GPI_SHIFT	1
#define	 DA9063_LDO5_CONT_LDO5_GPI_MASK		0x03
#define	 DA9063_LDO5_CONT_LDO5_PD_DIS		0x08
#define	 DA9063_LDO5_CONT_VLDO5_SEL		0x10
#define	 DA9063_LDO5_CONT_VLDO5_GPI_SHIFT	5
#define	 DA9063_LDO5_CONT_VLDO5_GPI_MASK	0x03
#define	 DA9063_LDO5_CONT_VLDO5_CONF		0x80
#define	DA9063_LDO6_CONT		0x2b
#define	 DA9063_LDO6_CONT_LDO6_EN		0x01
#define	 DA9063_LDO6_CONT_LDO6_GPI_SHIFT	1
#define	 DA9063_LDO6_CONT_LDO6_GPI_MASK		0x03
#define	 DA9063_LDO6_CONT_LDO6_PD_DIS		0x08
#define	 DA9063_LDO6_CONT_VLDO6_SEL		0x10
#define	 DA9063_LDO6_CONT_VLDO6_GPI_SHIFT	5
#define	 DA9063_LDO6_CONT_VLDO6_GPI_MASK	0x03
#define	 DA9063_LDO6_CONT_VLDO6_CONF		0x80
#define	DA9063_LDO7_CONT		0x2c
#define	 DA9063_LDO7_CONT_LDO7_EN		0x01
#define	 DA9063_LDO7_CONT_LDO7_GPI_SHIFT	1
#define	 DA9063_LDO7_CONT_LDO7_GPI_MASK		0x03
#define	 DA9063_LDO7_CONT_LDO7_PD_DIS		0x08
#define	 DA9063_LDO7_CONT_VLDO7_SEL		0x10
#define	 DA9063_LDO7_CONT_VLDO7_GPI_SHIFT	5
#define	 DA9063_LDO7_CONT_VLDO7_GPI_MASK	0x03
#define	 DA9063_LDO7_CONT_VLDO7_CONF		0x80
#define	DA9063_LDO8_CONT		0x2d
#define	 DA9063_LDO8_CONT_LDO8_EN		0x01
#define	 DA9063_LDO8_CONT_LDO8_GPI_SHIFT	1
#define	 DA9063_LDO8_CONT_LDO8_GPI_MASK		0x03
#define	 DA9063_LDO8_CONT_LDO8_PD_DIS		0x08
#define	 DA9063_LDO8_CONT_VLDO8_SEL		0x10
#define	 DA9063_LDO8_CONT_VLDO8_GPI_SHIFT	5
#define	 DA9063_LDO8_CONT_VLDO8_GPI_MASK	0x03
#define	 DA9063_LDO8_CONT_VLDO8_CONF		0x80
#define	DA9063_LDO9_CONT		0x2e
#define	 DA9063_LDO9_CONT_LDO9_EN		0x01
#define	 DA9063_LDO9_CONT_LDO9_GPI_SHIFT	1
#define	 DA9063_LDO9_CONT_LDO9_GPI_MASK		0x03
#define	 DA9063_LDO9_CONT_LDO9_PD_DIS		0x08
#define	 DA9063_LDO9_CONT_VLDO9_SEL		0x10
#define	 DA9063_LDO9_CONT_VLDO9_GPI_SHIFT	5
#define	 DA9063_LDO9_CONT_VLDO9_GPI_MASK	0x03
#define	 DA9063_LDO9_CONT_VLDO9_CONF		0x80
#define	DA9063_LDO10_CONT		0x2f
#define	 DA9063_LDO10_CONT_LDO10_EN		0x01
#define	 DA9063_LDO10_CONT_LDO10_GPI_SHIFT	1
#define	 DA9063_LDO10_CONT_LDO10_GPI_MASK	0x03
#define	 DA9063_LDO10_CONT_LDO10_PD_DIS		0x08
#define	 DA9063_LDO10_CONT_VLDO10_SEL		0x10
#define	 DA9063_LDO10_CONT_VLDO10_GPI_SHIFT	5
#define	 DA9063_LDO10_CONT_VLDO10_GPI_MASK	0x03
#define	 DA9063_LDO10_CONT_VLDO10_CONF		0x80
#define	DA9063_LDO11_CONT		0x30
#define	 DA9063_LDO11_CONT_LDO11_EN		0x01
#define	 DA9063_LDO11_CONT_LDO11_GPI_SHIFT	1
#define	 DA9063_LDO11_CONT_LDO11_GPI_MASK	0x03
#define	 DA9063_LDO11_CONT_LDO11_PD_DIS		0x08
#define	 DA9063_LDO11_CONT_VLDO11_SEL		0x10
#define	 DA9063_LDO11_CONT_VLDO11_GPI_SHIFT	5
#define	 DA9063_LDO11_CONT_VLDO11_GPI_MASK	0x03
#define	 DA9063_LDO11_CONT_VLDO11_CONF		0x80
#define	DA9063_VIB			0x31
#define	 DA9063_VIB_VIB_SET_SHIFT		0
#define	 DA9063_VIB_VIB_SET_MASK		0x3f
#define	DA9063_DVC_1			0x32
#define	 DA9063_DVC_1_VBCORE1_SEL		0x01
#define	 DA9063_DVC_1_VBCORE2_SEL		0x02
#define	 DA9063_DVC_1_VBPRO_SEL			0x04
#define	 DA9063_DVC_1_VBMEM_SEL			0x08
#define	 DA9063_DVC_1_VBPERI_SEL		0x10
#define	 DA9063_DVC_1_VLDO1_SEL			0x20
#define	 DA9063_DVC_1_VLDO2_SEL			0x40
#define	 DA9063_DVC_1_VLDO3_SEL			0x80
#define	DA9063_DVC_2			0x33
#define	 DA9063_DVC_2_VBIO_SEL			0x01
#define	 DA9063_DVC_2_VLDO4_SEL			0x80

/* GP-ADC Control Registers (GPADC) */

#define	DA9063_ADC_MAN			0x34
#define	 DA9063_ADC_MAN_ADC_MUX_SHIFT		0
#define	 DA9063_ADC_MAN_ADC_MUX_MASK		0x0f
#define	 DA9063_ADC_MAN_ADC_MAN			0x10
#define	 DA9063_ADC_MAN_ADC_MODE		0x20
#define	DA9063_ADC_CONT			0x35
#define	 DA9063_ADC_CONT_AUTO_VSYS_EN		0x01
#define	 DA9063_ADC_CONT_AUTO_AD1_EN		0x02
#define	 DA9063_ADC_CONT_AUTO_AD2_EN		0x04
#define	 DA9063_ADC_CONT_AUTO_AD3_EN		0x08
#define	 DA9063_ADC_CONT_AD1_ISRC_EN		0x10
#define	 DA9063_ADC_CONT_AD2_ISRC_EN		0x20
#define	 DA9063_ADC_CONT_AD3_ISRC_EN		0x40
#define	 DA9063_ADC_CONT_COMP1V2_EN		0x80
#define	DA9063_VSYS_MON			0x36
#define	 DA9063_VSYS_MON_VSYS_MON_SHIFT		0
#define	 DA9063_VSYS_MON_VSYS_MON_MASK		0xff
#define	DA9063_ADC_RES_L		0x37
#define	 DA9063_ADC_RES_L_ADC_RES_LSB_SHIFT	6
#define	 DA9063_ADC_RES_L_ACD_RES_LSB_MASK	0x03
#define	DA9063_ADC_RES_H		0x38
#define	 DA9063_ADC_RES_H_ADC_RES_H_SHIFT	0
#define	 DA9063_ADC_RES_H_ADC_RES_H_MASK	0xff
#define	DA9063_VSYS_RES			0x39
#define	 DA9063_VSYS_RES_VSYS_RES_SHIFT		0
#define	 DA9063_VSYS_RES_VSYS_RES_MASK		0xff
#define	DA9063_ADCIN1_RES		0x3a
#define	 DA9063_ADCIN1_RES_ADCIN1_RES_SHIFT	0
#define	 DA9063_ADCIN1_RES_ADCIN1_RES_MASK	0xff
#define	DA9063_ADCIN2_RES		0x3b
#define	 DA9063_ADCIN2_RES_ADCIN2_RES_SHIFT	0
#define	 DA9063_ADCIN2_RES_ADCIN2_RES_MASK	0xff
#define	DA9063_ADCIN3_RES		0x3c
#define	 DA9063_ADCIN3_RES_ADCIN3_RES_SHIFT	0
#define	 DA9063_ADCIN3_RES_ADCIN3_RES_MASK	0xff
#define	DA9063_MON_A8_RES		0x3d
#define	 DA9063_MON_A8_RES_MON_A8_RES_SHIFT	0
#define	 DA9063_MON_A8_RES_MON_A8_RES_MASK	0xff
#define	DA9063_MON_A9_RES		0x3e
#define	 DA9063_MON_A9_RES_MON_A9_RES_SHIFT	0
#define	 DA9063_MON_A9_RES_MON_A9_RES_MASK	0xff
#define	DA9063_MON_A10_RES		0x3f
#define	 DA9063_MON_A10_RES_MON_A10_RES_SHIFT	0
#define	 DA9063_MON_A10_RES_MON_A10_RES_MASK	0xff

/* RTC Calendar and Alarm Registers (RTC) */

#define	DA9063_COUNT_S			0x40
#define	 DA9063_COUNT_S_COUNT_SEC_SHIFT		0
#define	 DA9063_COUNT_S_COUNT_SEC_MASK		0x3f
#define	 DA9063_COUNT_S_RTC_READ		0x80
#define	DA9063_COUNT_MI			0x41
#define	 DA9063_COUNT_MI_COUNT_MIN_SHIFT	0
#define	 DA9063_COUNT_MI_COUNT_MIN_MASK		0x3f
#define	DA9063_COUNT_H			0x42
#define	 DA9063_COUNT_H_COUNT_HOUR_SHIFT	0
#define	 DA9063_COUNT_H_COUNT_HOUR_MASK		0x1f
#define	DA9063_COUNT_D			0x43
#define	 DA9063_COUNT_D_COUNT_DAY_SHIFT		0
#define	 DA9063_COUNT_D_COUNT_DAY_MASK		0x1f
#define	DA9063_COUNT_MO			0x44
#define	 DA9063_COUNT_MO_COUNT_MONTH_SHIFT	0
#define	 DA9063_COUNT_MO_COUNT_MONTH_MASK	0x0f
#define	DA9063_COUNT_Y			0x45
#define	 DA9063_COUNT_Y_COUNT_YEAR_SHIFT	0
#define	 DA9063_COUNT_Y_COUNT_YEAR_MASK		0x3f
#define	 DA9063_COUNT_Y_MONITOR			0x40
#define	DA9063_ALARM_S			0x46
#define	 DA9063_ALARM_S_ALARM_SEC_SHIFT		0
#define	 DA9063_ALARM_S_ALARM_SEC_MASK		0x3f
#define	 DA9063_ALARM_S_ALARM_TYPE_SHIFT	6
#define	 DA9063_ALARM_S_ALARM_TYPE_MASK		0x03
#define	DA9063_ALARM_MI			0x47
#define	 DA9063_ALARM_MI_ALARM_MIN_SHIFT	0
#define	 DA9063_ALARM_MI_ALARM_MIN_MASK		0x3f
#define	DA9063_ALARM_H			0x48
#define	 DA9063_ALARM_H_ALARM_HOUR_SHIFT	0
#define	 DA9063_ALARM_H_ALARM_HOUR_MASK		0x1f
#define	DA9063_ALARM_D			0x49
#define	 DA9063_ALARM_D_ALARM_DAY_SHIFT		0
#define	 DA9063_ALARM_D_ALARM_DAY_MASK		0x1f
#define	DA9063_ALARM_MO			0x4a
#define	 DA9063_ALARM_MO_ALARM_MONTH_SHIFT	0
#define	 DA9063_ALARM_MO_ALARM_MONTH_MASK	0x0f
#define	 DA9063_ALARM_MO_TICK_TYPE		0x10
#define	 DA9063_ALARM_MO_TICK_WAKE		0x20
#define	DA9063_ALARM_Y			0x4b
#define	 DA9063_ALARM_Y_ALARM_YEAR_SHIFT	0
#define	 DA9063_ALARM_Y_ALARM_YEAR_MASK		0x3f
#define	 DA9063_ALARM_Y_ALARM_ON		0x40
#define	 DA9063_ALARM_Y_TICK_ON			0x80

/* System Control and Event Registers (SYSMON) */

#define	DA9063_SECOND_A			0x4c
#define	 DA9063_SECOND_A_SECONDS_A_SHIFT	0
#define	 DA9063_SECOND_A_SECONDS_A_MASK		0xff
#define	DA9063_SECOND_B			0x4d
#define	 DA9063_SECOND_B_SECONDS_B_SHIFT	0
#define	 DA9063_SECOND_B_SECONDS_B_MASK		0xff
#define	DA9063_SECOND_C			0x4e
#define	 DA9063_SECOND_C_SECONDS_C_SHIFT	0
#define	 DA9063_SECOND_C_SECONDS_C_MASK		0xff
#define	DA9063_SECOND_D			0x4f
#define	 DA9063_SECOND_D_SECONDS_D_SHIFT	0
#define	 DA9063_SECOND_D_SECONDS_D_MASK		0xff

/* Page 1 */

/* 0x80 is PAGE_CON */

/* Sequencer Control Registers (SEQ) */

#define	DA9063_SEQ			0x81
#define	 DA9063_SEQ_SEQ_POINTER_SHIFT		0
#define	 DA9063_SEQ_SEQ_POINTER_MASK		0x0f
#define	 DA9063_SEQ_NXT_SEQ_START_SHIFT		4
#define	 DA9063_SEQ_NXT_SEQ_START_MASK		0x0f
#define	DA9063_SEQ_TIMER		0x82
#define	 DA9063_SEQ_TIMER_SEQ_TIME_SHIFT	0
#define	 DA9063_SEQ_TIMER_SEQ_TIME_MASK		0x0f
#define	 DA9063_SEQ_TIMER_SEQ_DUMM_SHIFT	4
#define	 DA9063_SEQ_TIMER_SEQ_DUMM_MASK		0x0f
#define	DA9063_ID_2_1			0x83
#define	 DA9063_ID_2_1_LDO1_STEP_SHIFT		0
#define	 DA9063_ID_2_1_LDO1_STEP_MASK		0x0f
#define	 DA9063_ID_2_1_LDO2_STEP_SHIFT		4
#define	 DA9063_ID_2_1_LDO2_STEP_MASK		0x0f
#define	DA9063_ID_4_3			0x84
#define	 DA9063_ID_4_3_LDO3_STEP_SHIFT		0
#define	 DA9063_ID_4_3_LDO3_STEP_MASK		0x0f
#define	 DA9063_ID_4_3_LDO4_STEP_SHIFT		4
#define	 DA9063_ID_4_3_LDO4_STEP_MASK		0x0f
#define	DA9063_ID_6_5			0x85
#define	 DA9063_ID_6_5_LDO5_STEP_SHIFT		0
#define	 DA9063_ID_6_5_LDO5_STEP_MASK		0x0f
#define	 DA9063_ID_6_5_LDO6_STEP_SHIFT		4
#define	 DA9063_ID_6_5_LDO6_STEP_MASK		0x0f
#define	DA9063_ID_8_7			0x86
#define	 DA9063_ID_8_7_LDO7_STEP_SHIFT		0
#define	 DA9063_ID_8_7_LDO7_STEP_MASK		0x0f
#define	 DA9063_ID_8_7_LDO8_STEP_SHIFT		4
#define	 DA9063_ID_8_7_LDO8_STEP_MASK		0x0f
#define	DA9063_ID_10_9			0x87
#define	 DA9063_ID_10_9_LDO9_STEP_SHIFT		0
#define	 DA9063_ID_10_9_LDO9_STEP_MASK		0x0f
#define	 DA9063_ID_10_9_LDO10_STEP_SHIFT	4
#define	 DA9063_ID_10_9_LDO10_STEP_MASK		0x0f
#define	DA9063_ID_12_11			0x88
#define	 DA9063_ID_12_11_LDO11_STEP_SHIFT	0
#define	 DA9063_ID_12_11_LDO11_STEP_MASK	0x0f
#define	 DA9063_ID_12_11_PD_DIS_STEP_SHIFT	4
#define	 DA9063_ID_12_11_PD_DIS_STEP_MASK	0x0f
#define	DA9063_ID_14_13			0x89
#define	 DA9063_ID_14_13_BUCKCORE1_STEP_SHIFT	0
#define	 DA9063_ID_14_13_BUCKCORE1_STEP_MASK	0x0f
#define	 DA9063_ID_14_13_BUCKCORE2_STEP_SHIFT	4
#define	 DA9063_ID_14_13_BUCKCORE2_STEP_MASK	0x0f
#define	DA9063_ID_16_15			0x8a
#define	 DA9063_ID_16_15_BUCKPRO_STEP_SHIFT	0
#define	 DA9063_ID_16_15_BUCKPRO_STEP_MASK	0x0f
#define	 DA9063_ID_16_15_BUCKIO_STEP_SHIFT	4
#define	 DA9063_ID_16_15_BUCKIO_STEP_MASK	0x0f
#define	DA9063_ID_18_17			0x8b
#define	 DA9063_ID_18_17_BUCKMEM_STEP_SHIFT	0
#define	 DA9063_ID_18_17_BUCKMEM_STEP_MASK	0x0f
#define	 DA9063_ID_18_17_BUCKPERI_STEP_SHIFT	4
#define	 DA9063_ID_18_17_BUCKPERI_STEP_MASK	0x0f
#define	DA9063_ID_20_19			0x8c
#define	 DA9063_ID_20_19_CORE_SW_STEP_SHIFT	0
#define	 DA9063_ID_20_19_CORE_SW_STEP_MASK	0x0f
#define	 DA9063_ID_20_19_PERI_SW_STEP_SHIFT	4
#define	 DA9063_ID_20_19_PERI_SW_STEP_MASK	0x0f
#define	DA9063_ID_22_21			0x8d
#define	 DA9063_ID_22_21_GP_RISE1_STEP_SHIFT	0
#define	 DA9063_ID_22_21_GP_RISE1_STEP_MASK	0x0f
#define	 DA9063_ID_22_21_GP_FALL1_STEP_SHIFT	4
#define	 DA9063_ID_22_21_GP_FALL1_STEP_MASK	0x0f
#define	DA9063_ID_24_23			0x8e
#define	 DA9063_ID_24_23_GP_RISE2_STEP_SHIFT	0
#define	 DA9063_ID_24_23_GP_RISE2_STEP_MASK	0x0f
#define	 DA9063_ID_24_23_GP_FALL2_STEP_SHIFT	4
#define	 DA9063_ID_24_23_GP_FALL2_STEP_MASK	0x0f
#define	DA9063_ID_26_25			0x8f
#define	 DA9063_ID_26_25_GP_RISE3_STEP_SHIFT	0
#define	 DA9063_ID_26_25_GP_RISE3_STEP_MASK	0x0f
#define	 DA9063_ID_26_25_GP_FALL3_STEP_SHIFT	4
#define	 DA9063_ID_26_25_GP_FALL3_STEP_MASK	0x0f
#define	DA9063_ID_28_27			0x90
#define	 DA9063_ID_28_27_GP_RISE4_STEP_SHIFT	0
#define	 DA9063_ID_28_27_GP_RISE4_STEP_MASK	0x0f
#define	 DA9063_ID_28_27_GP_FALL4_STEP_SHIFT	4
#define	 DA9063_ID_28_27_GP_FALL4_STEP_MASK	0x0f
#define	DA9063_ID_30_29			0x91
#define	 DA9063_ID_30_29_GP_RISE5_STEP_SHIFT	0
#define	 DA9063_ID_30_29_GP_RISE5_STEP_MASK	0x0f
#define	 DA9063_ID_30_29_GP_FALL5_STEP_SHIFT	4
#define	 DA9063_ID_30_29_GP_FALL5_STEP_MASK	0x0f
#define	DA9063_ID_32_31			0x92
#define	 DA9063_ID_32_31_WAIT_STEP_SHIFT	0
#define	 DA9063_ID_32_31_WAIT_STEP_MASK		0x0f
#define	 DA9063_ID_32_31_EN32K_STEP_SHIFT	4
#define	 DA9063_ID_32_31_EN32K_STEP_MASK	0x0f
/* 0x93 - 0x94 reserved */
#define	DA9063_SEQ_A			0x95
#define	 DA9063_SEQ_A_SYSTEM_END_SHIFT		0
#define	 DA9063_SEQ_A_SYSTEM_END_MASK		0x0f
#define	 DA9063_SEQ_A_POWER_END_SHIFT		4
#define	 DA9063_SEQ_A_POWER_END_MASK		0x0f
#define	DA9063_SEQ_B			0x96
#define	 DA9063_SEQ_B_MAX_COUNT_SHIFT		0
#define	 DA9063_SEQ_B_MAX_COUNT_MASK		0x0f
#define	 DA9063_SEQ_B_PART_DOWN_SHIFT		4
#define	 DA9063_SEQ_B_PART_DOWN_MASK		0x0f
#define	DA9063_WAIT			0x97
#define	 DA9063_WAIT_WAIT_TIME_SHIFT		0
#define	 DA9063_WAIT_WAIT_TIME_MASK		0x0f
#define	 DA9063_WAIT_WAIT_MODE			0x10
#define	 DA9063_WAIT_TIME_OUT			0x20
#define	 DA9063_WAIT_WAIT_DIR_SHIFT		6
#define	 DA9063_WAIT_WAIT_DIR_MASK		0x03
#define	DA9063_EN_32K			0x98
#define	 DA9063_EN_32K_STABILIZATION_TIME_SHIFT	0
#define	 DA9063_EN_32K_STABILIZATION_TIME_MASK	0x07
#define	 DA9063_EN_32K_CRYSTAL			0x04
#define	 DA9063_EN_32K_DELAY_MODE		0x10
#define	 DA9063_EN_32K_OUT_CLOCK		0x20
#define	 DA9063_EN_32K_RTC_CLOCK		0x40
#define	 DA9063_EN_32K_OUT_32K_EN		0x80
#define	DA9063_RESET			0x99
#define	 DA9063_RESET_RESET_TIMER_SHIFT		0
#define	 DA9063_RESET_RESET_TIMER_MASK		0x3f
#define	 DA9063_RESET_RESET_EVENT_SHIFT		6
#define	 DA9063_RESET_RESET_EVENT_MASK		0x03

/* Regulator Setting Registers (REG) */

#define	DA9063_BUCK_ILIM_A		0x9a
#define	 DA9063_BUCK_ILIM_A_BIO_ILIM_SHIFT	0
#define	 DA9063_BUCK_ILIM_A_BIO_ILIM_MASK	0x0f
#define	 DA9063_BUCK_ILIM_A_BMEM_ILIM_SHIFT	4
#define	 DA9063_BUCK_ILIM_A_BMEM_ILIM_MASK	0x0f
#define	DA9063_BUCK_ILIM_B		0x9b
#define	 DA9063_BUCK_ILIM_B_BPRO_ILIM_SHIFT	0
#define	 DA9063_BUCK_ILIM_B_BPRO_ILIM_MASK	0x0f
#define	 DA9063_BUCK_ILIM_B_BPERI_ILIM_SHIFT	4
#define	 DA9063_BUCK_ILIM_B_BPERI_ILIM_MASK	0x0f
#define	DA9063_BUCK_ILIM_C		0x9c
#define	 DA9063_BUCK_ILIM_C_BCORE1_ILIM_SHIFT	0
#define	 DA9063_BUCK_ILIM_C_BCORE1_ILIM_MASK	0x0f
#define	 DA9063_BUCK_ILIM_C_BCORE2_ILIM_SHIFT	4
#define	 DA9063_BUCK_ILIM_C_BCORE2_ILIM_MASK	0x0f
#define	DA9063_BCORE2_CONF		0x9d
#define	 DA9063_BCORE2_CONF_BCORE2_FB_SHIFT	0
#define	 DA9063_BCORE2_CONF_BCORE2_FB_MASK	0x07
#define	 DA9063_BCORE2_CONF_BCORE2_PD_DIS	0x20
#define	 DA9063_BCORE2_CONF_BCORE2_MODE_SHIFT	6
#define	 DA9063_BCORE2_CONF_BCORE2_MODE_MASK	0x03
#define	DA9063_BCORE1_CONF		0x9e
#define	 DA9063_BCORE1_CONF_BCORE1_FB_SHIFT	0
#define	 DA9063_BCORE1_CONF_BCORE1_FB_MASK	0x07
#define	 DA9063_BCORE1_CONF_BCORE1_PD_DIS	0x20
#define	 DA9063_BCORE1_CONF_BCORE1_MODE_SHIFT	6
#define	 DA9063_BCORE1_CONF_BCORE1_MODE_MASK	0x03
#define	DA9063_BPRO_CONF		0x9f
#define	 DA9063_BPRO_CONF_BPRO_FB_SHIFT		0
#define	 DA9063_BPRO_CONF_BPRO_FB_MASK		0x07
#define	 DA9063_BPRO_CONF_BPRO_PD_DIS		0x20
#define	 DA9063_BPRO_CONF_BPRO_MODE_SHIFT	6
#define	 DA9063_BPRO_CONF_BPRO_MODE_MASK	0x03
#define	DA9063_BIO_CONF			0xa0
#define	 DA9063_BIO_CONF_BIO_FB_SHIFT		0
#define	 DA9063_BIO_CONF_BIO_FB_MASK		0x07
#define	 DA9063_BIO_CONF_BPRO_VTTR_EN		0x08
#define	 DA9063_BIO_CONF_BPRO_VTT_EN		0x10
#define	 DA9063_BIO_CONF_BIO_PD_DIS		0x20
#define	 DA9063_BIO_CONF_BIO_MODE_SHIFT		6
#define	 DA9063_BIO_CONF_BIO_MODE_MASK		0x03
#define	DA9063_BMEM_CONF		0xa1
#define	 DA9063_BMEM_CONF_BMEM_FB_SHIFT		0
#define	 DA9063_BMEM_CONF_BMEM_FB_MASK		0x07
#define	 DA9063_BMEM_CONF_BMEM_PD_DIS		0x20
#define	 DA9063_BMEM_CONF_BMEM_MODE_SHIFT	6
#define	 DA9063_BMEM_CONF_BMEM_MODE_MASK	0x03
#define	DA9063_BPERI_CONF		0xa2
#define	 DA9063_BPERI_CONF_BPERI_FB_SHIFT	0
#define	 DA9063_BPERI_CONF_BPERI_FB_MASK	0x07
#define	 DA9063_BPERI_CONF_BPERI_PD_DIS		0x20
#define	 DA9063_BPERI_CONF_BPERI_MODE_SHIFT	6
#define	 DA9063_BPERI_CONF_BPERI_MODE_MASK	0x03
#define	DA9063_VBCORE2_A		0xa3
#define	 DA9063_VBCORE2_A_VBCORE2_A_SHIFT	0
#define	 DA9063_VBCORE2_A_VBCORE2_A_MASK	0x7f
#define	 DA9063_VBCORE2_A_BCORE2_SL_A		0x80
#define	DA9063_VBCORE1_A		0xa4
#define	 DA9063_VBCORE1_A_VBCORE1_A_SHIFT	0
#define	 DA9063_VBCORE1_A_VBCORE1_A_MASK	0x7f
#define	 DA9063_VBCORE1_A_BCORE1_SL_A		0x80
#define	DA9063_VBPRO_A			0xa5
#define	 DA9063_VBPRO_A_VBPRO_A_SHIFT		0
#define	 DA9063_VBPRO_A_VBPRO_A_MASK		0x7f
#define	 DA9063_VBPRO_A_BPRO_SL_A		0x80
#define	DA9063_VBMEM_A			0xa6
#define	 DA9063_VBMEM_A_VBMEM_A_SHIFT		0
#define	 DA9063_VBMEM_A_VBMEM_A_MASK		0x7f
#define	 DA9063_VBMEM_A_BMEM_SL_A		0x80
#define	DA9063_VBIO_A			0xa7
#define	 DA9063_VBIO_A_VBIO_A_SHIFT		0
#define	 DA9063_VBIO_A_VBIO_A_MASK		0x7f
#define	 DA9063_VBIO_A_BIO_SL_A			0x80
#define	DA9063_VBPERI_A			0xa8
#define	 DA9063_VBPERI_A_VBPERI_A_SHIFT		0
#define	 DA9063_VBPERI_A_VBPERI_A_MASK		0x7f
#define	 DA9063_VBPERI_A_BPERI_SL_A		0x80
#define	DA9063_VLDO1_A			0xa9
#define	 DA9063_VLDO1_A_VLDO1_A_SHIFT		0
#define	 DA9063_VLDO1_A_VLDO1_A_MASK		0x3f
#define	 DA9063_VLDO1_A_LDO1_SL_A		0x80
#define	DA9063_VLDO2_A			0xaa
#define	 DA9063_VLDO2_A_VLDO2_A_SHIFT		0
#define	 DA9063_VLDO2_A_VLDO2_A_MASK		0x3f
#define	 DA9063_VLDO2_A_LDO2_SL_A		0x80
#define	DA9063_VLDO3_A			0xab
#define	 DA9063_VLDO3_A_VLDO3_A_SHIFT		0
#define	 DA9063_VLDO3_A_VLDO3_A_MASK		0x7f
#define	 DA9063_VLDO3_A_LDO3_SL_A		0x80
#define	DA9063_VLDO4_A			0xac
#define	 DA9063_VLDO4_A_VLDO4_A_SHIFT		0
#define	 DA9063_VLDO4_A_VLDO4_A_MASK		0x7f
#define	 DA9063_VLDO4_A_LDO4_SL_A		0x80
#define	DA9063_VLDO5_A			0xad
#define	 DA9063_VLDO5_A_VLDO5_A_SHIFT		0
#define	 DA9063_VLDO5_A_VLDO5_A_MASK		0x3f
#define	 DA9063_VLDO5_A_LDO5_SL_A		0x80
#define	DA9063_VLDO6_A			0xae
#define	 DA9063_VLDO6_A_VLDO6_A_SHIFT		0
#define	 DA9063_VLDO6_A_VLDO6_A_MASK		0x3f
#define	 DA9063_VLDO6_A_LDO6_SL_A		0x80
#define	DA9063_VLDO7_A			0xaf
#define	 DA9063_VLDO7_A_VLDO7_A_SHIFT		0
#define	 DA9063_VLDO7_A_VLDO7_A_MASK		0x3f
#define	 DA9063_VLDO7_A_LDO7_SL_A		0x80
#define	DA9063_VLDO8_A			0xb0
#define	 DA9063_VLDO8_A_VLDO8_A_SHIFT		0
#define	 DA9063_VLDO8_A_VLDO8_A_MASK		0x3f
#define	 DA9063_VLDO8_A_LDO8_SL_A		0x80
#define	DA9063_VLDO9_A			0xb1
#define	 DA9063_VLDO9_A_VLDO9_A_SHIFT		0
#define	 DA9063_VLDO9_A_VLDO9_A_MASK		0x3f
#define	 DA9063_VLDO9_A_LDO9_SL_A		0x80
#define	DA9063_VLDO10_A			0xb2
#define	 DA9063_VLDO10_A_VLDO10_A_SHIFT		0
#define	 DA9063_VLDO10_A_VLDO10_A_MASK		0x3f
#define	 DA9063_VLDO10_A_LDO10_SL_A		0x80
#define	DA9063_VLDO11_A			0xb3
#define	 DA9063_VLDO11_A_VLDO11_A_SHIFT		0
#define	 DA9063_VLDO11_A_VLDO11_A_MASK		0x3f
#define	 DA9063_VLDO11_A_LDO11_SL_A		0x80
#define	DA9063_VBCORE2_B		0xb4
#define	 DA9063_VBCORE2_B_VBCORE2_B_SHIFT	0
#define	 DA9063_VBCORE2_B_VBCORE2_B_MASK	0x7f
#define	 DA9063_VBCORE2_B_BCORE2_SL_B		0x80
#define	DA9063_VBCORE1_B		0xb5
#define	 DA9063_VBCORE1_B_VBCORE1_B_SHIFT	0
#define	 DA9063_VBCORE1_B_VBCORE1_B_MASK	0x7f
#define	 DA9063_VBCORE1_B_BCORE1_SL_B		0x80
#define	DA9063_VBPRO_B			0xb6
#define	 DA9063_VBPRO_B_VBPRO_B_SHIFT		0
#define	 DA9063_VBPRO_B_VBPRO_B_MASK		0x7f
#define	 DA9063_VBPRO_B_BPRO_SL_B		0x80
#define	DA9063_VBMEM_B			0xb7
#define	 DA9063_VBMEM_B_VBMEM_B_SHIFT		0
#define	 DA9063_VBMEM_B_VBMEM_B_MASK		0x7f
#define	 DA9063_VBMEM_B_BMEM_SL_B		0x80
#define	DA9063_VBIO_B			0xb8
#define	 DA9063_VBIO_B_VBIO_B_SHIFT		0
#define	 DA9063_VBIO_B_VBIO_B_MASK		0x7f
#define	 DA9063_VBIO_B_BIO_SL_B			0x80
#define	DA9063_VBPERI_B			0xb9
#define	 DA9063_VBPERI_B_VBPERI_B_SHIFT		0
#define	 DA9063_VBPERI_B_VBPERI_B_MASK		0x7f
#define	 DA9063_VBPERI_B_BPERI_SL_B		0x80
#define	DA9063_VLDO1_B			0xba
#define	 DA9063_VLDO1_B_VLDO1_B_SHIFT		0
#define	 DA9063_VLDO1_B_VLDO1_B_MASK		0x3f
#define	 DA9063_VLDO1_B_LDO1_SL_B		0x80
#define	DA9063_VLDO2_B			0xbb
#define	 DA9063_VLDO2_B_VLDO2_B_SHIFT		0
#define	 DA9063_VLDO2_B_VLDO2_B_MASK		0x3f
#define	 DA9063_VLDO2_B_LDO2_SL_B		0x80
#define	DA9063_VLDO3_B			0xbc
#define	 DA9063_VLDO3_B_VLDO3_B_SHIFT		0
#define	 DA9063_VLDO3_B_VLDO3_B_MASK		0x7f
#define	 DA9063_VLDO3_B_LDO3_SL_B		0x80
#define	DA9063_VLDO4_B			0xbd
#define	 DA9063_VLDO4_B_VLDO4_B_SHIFT		0
#define	 DA9063_VLDO4_B_VLDO4_B_MASK		0x7f
#define	 DA9063_VLDO4_B_LDO4_SL_B		0x80
#define	DA9063_VLDO5_B			0xbe
#define	 DA9063_VLDO5_B_VLDO5_B_SHIFT		0
#define	 DA9063_VLDO5_B_VLDO5_B_MASK		0x7f
#define	 DA9063_VLDO5_B_LDO5_SL_B		0x80
#define	DA9063_VLDO6_B			0xbf
#define	 DA9063_VLDO6_B_VLDO6_B_SHIFT		0
#define	 DA9063_VLDO6_B_VLDO6_B_MASK		0x7f
#define	 DA9063_VLDO6_B_LDO6_SL_B		0x80
#define	DA9063_VLDO7_B			0xc0
#define	 DA9063_VLDO7_B_VLDO7_B_SHIFT		0
#define	 DA9063_VLDO7_B_VLDO7_B_MASK		0x7f
#define	 DA9063_VLDO7_B_LDO7_SL_B		0x80
#define	DA9063_VLDO8_B			0xc1
#define	 DA9063_VLDO8_B_VLDO8_B_SHIFT		0
#define	 DA9063_VLDO8_B_VLDO8_B_MASK		0x7f
#define	 DA9063_VLDO8_B_LDO8_SL_B		0x80
#define	DA9063_VLDO9_B			0xc2
#define	 DA9063_VLDO9_B_VLDO9_B_SHIFT		0
#define	 DA9063_VLDO9_B_VLDO9_B_MASK		0x7f
#define	 DA9063_VLDO9_B_LDO9_SL_B		0x80
#define	DA9063_VLDO10_B			0xc3
#define	 DA9063_VLDO10_B_VLDO10_B_SHIFT		0
#define	 DA9063_VLDO10_B_VLDO10_B_MASK		0x7f
#define	 DA9063_VLDO10_B_LDO10_SL_B		0x80
#define	DA9063_VLDO11_B			0xc4
#define	 DA9063_VLDO11_B_VLDO11_B_SHIFT		0
#define	 DA9063_VLDO11_B_VLDO11_B_MASK		0x7f
#define	 DA9063_VLDO11_B_LDO11_SL_B		0x80

/* Backup Battery Charger Control Register (BBAT) */

#define	DA9063_BBAT_CONT		0xc5
#define	 DA9063_BBAT_CONT_BCHG_VSET_SHIFT	0
#define	 DA9063_BBAT_CONT_BCHG_VSET_MASK	0x0f
#define	 DA9063_BBAT_CONT_BCHG_ISET_SHIFT	4
#define	 DA9063_BBAT_CONT_BCHG_ISET_MASK	0x0f

/* GPO PWM (LED) */

#define	DA9063_GPO11_LED		0xc6
#define	 DA9063_GPO11_LED_GPO11_PWM_SHIFT	0
#define	 DA9063_GPO11_LED_GPO11_PWM_MASK	0x7f
#define	 DA9063_GPO11_LED_GPO11_DIM		0x80
#define	DA9063_GPO14_LED		0xc7
#define	 DA9063_GPO14_LED_GPO14_PWM_SHIFT	0
#define	 DA9063_GPO14_LED_GPO14_PWM_MASK	0x7f
#define	 DA9063_GPO14_LED_GPO14_DIM		0x80
#define	DA9063_GPO15_LED		0xc8
#define	 DA9063_GPO15_LED_GPO15_PWM_SHIFT	0
#define	 DA9063_GPO15_LED_GPO15_PWM_MASK	0x7f
#define	 DA9063_GPO15_LED_GPO15_DIM		0x80

/* GP-ADC Threshold Registers (GPADC) */

#define	DA9063_ADC_CFG			0xc9
#define	 DA9063_ADC_CFG_ADCIN1_CUR_SHIFT	0
#define	 DA9063_ADC_CFG_ADCIN1_CUR_MASK		0x03
#define	 DA9063_ADC_CFG_ADCIN2_CUR_SHIFT	2
#define	 DA9063_ADC_CFG_ADCIN2_CUR_MASK		0x03
#define	 DA9063_ADC_CFG_ADCIN3_CUR		0x10
#define	 DA9063_ADC_CFG_ADCIN1_DEB		0x20
#define	 DA9063_ADC_CFG_ADCIN2_DEB		0x40
#define	 DA9063_ADC_CFG_ADCIN3_DEB		0x80
#define	DA9063_AUTO1_HIGH		0xca
#define	 DA9063_AUTO1_HIGH_AUTO1_HIGH_SHIFT	0
#define	 DA9063_AUTO1_HIGH_AUTO1_HIGH_MASK	0xff
#define	DA9063_AUTO1_LOW		0xcb
#define	 DA9063_AUTO1_LOW_AUTO1_LOW_SHIFT	0
#define	 DA9063_AUTO1_LOW_AUTO1_LOW_MASK	0xff
#define	DA9063_AUTO2_HIGH		0xcc
#define	 DA9063_AUTO2_HIGH_AUTO2_HIGH_SHIFT	0
#define	 DA9063_AUTO2_HIGH_AUTO2_HIGH_MASK	0xff
#define	DA9063_AUTO2_LOW		0xcd
#define	 DA9063_AUTO2_LOW_AUTO2_LOW_SHIFT	0
#define	 DA9063_AUTO2_LOW_AUTO2_LOW_MASK	0xff
#define	DA9063_AUTO3_HIGH		0xce
#define	 DA9063_AUTO3_HIGH_AUTO3_HIGH_SHIFT	0
#define	 DA9063_AUTO3_HIGH_AUTO3_HIGH_MASK	0xff
#define	DA9063_AUTO3_LOW		0xcf
#define	 DA9063_AUTO3_LOW_AUTO3_LOW_SHIFT	0
#define	 DA9063_AUTO3_LOW_AUTO3_LOW_MASK	0xff

/* Page 2 */

/* 0x100 is PAGE_CON */

/* OTP */

#define	DA9063_OTP_CONT			0x101
#define	 DA9063_OTP_CONT_OTP_TIM		0x01
#define	 DA9063_OTP_CONT_OTP_GP_RD		0x02
#define	 DA9063_OTP_CONT_OTP_APPS_RD		0x04
#define	 DA9063_OTP_CONT_PC_DONE		0x08
#define	 DA9063_OTP_CONT_OTP_GP_LOCK		0x10
#define	 DA9063_OTP_CONT_OTP_APPS_LOCK		0x20
#define	 DA9063_OTP_CONT_OTP_CONF_LOCK		0x40
#define	 DA9063_OTP_CONT_GP_WRITE_DIS		0x80
#define	DA9063_OTP_ADDR			0x102
#define	 DA9063_OTP_ADDR_OTP_ADDR_SHIFT		0
#define	 DA9063_OTP_ADDR_OTP_ADDR_MASK		0xff
#define	DA9063_OTP_DATA			0x103
#define	 DA9063_OTP_DATA_OTP_DATA_SHIFT		0
#define	 DA9063_OTP_DATA_OTP_DATA_MASK		0xff

/* Customer Trim and Configuration Registers */

#define	DA9063_T_OFFSET			0x104
#define	 DA9063_T_OFFSET_T_OFFSET_SHIFT		0
#define	 DA9063_T_OFFSET_T_OFFSET_MASK		0xff
#define	DA9063_INTERFACE		0x105
#define	 DA9063_INTERFACE_NCS_POL		0x01
#define	 DA9063_INTERFACE_CPOL			0x02
#define	 DA9063_INTERFACE_CPHA			0x04
#define	 DA9063_INTERFACE_RW_POL		0x08
#define	 DA9063_INTERFACE_IF_BASE_ADDR_SHIFT	4
#define	 DA9063_INTERFACE_IF_BASE_ADDR_MASK	0x0f
#define	DA9063_CONFIG_A			0x106
#define	 DA9063_CONFIG_A_PM_I_V			0x01
#define	 DA9063_CONFIG_A_PM_O_V			0x02
#define	 DA9063_CONFIG_A_PM_O_TYPE		0x04
#define	 DA9063_CONFIG_A_IRQ_TYPE		0x08
#define	 DA9063_CONFIG_A_PM_IF_V		0x10
#define	 DA9063_CONFIG_A_PM_IF_FMP		0x20
#define	 DA9063_CONFIG_A_PM_IF_HSM		0x40
#define	 DA9063_CONFIG_A_IF_TYPE		0x80
#define	DA9063_CONFIG_B			0x107
#define	 DA9063_CONFIG_B_VDD_FAULT_ADJ_SHIFT	0
#define	 DA9063_CONFIG_B_VDD_FAULT_ADJ_MASK	0x0f
#define	 DA9063_CONFIG_B_VDD_HYST_ADJ_SHIFT	4
#define	 DA9063_CONFIG_B_VDD_HYST_ADJ_MASK	0x07
#define	 DA9063_CONFIG_B_CHG_CLK_MODE		0x80
#define	DA9063_CONFIG_C			0x108
#define	 DA9063_CONFIG_C_LDO1_TRACK_SHIFT	0
#define	 DA9063_CONFIG_C_LDO1_TRACK_MASK	0x03
#define	 DA9063_CONFIG_C_BUCK_ACTV_DISCH	0x04
#define	 DA9063_CONFIG_C_BCORE1_CLK_INV		0x08
#define	 DA9063_CONFIG_C_BPRO_CLK_INV		0x10
#define	 DA9063_CONFIG_C_BMEM_CLK_INV		0x20
#define	 DA9063_CONFIG_C_BIO_CLK_INV		0x40
#define	 DA9063_CONFIG_C_BPERI_CLK_INV		0x80
#define	DA9063_CONFIG_D			0x109
#define	 DA9063_CONFIG_D_GPI_V			0x01
#define	 DA9063_CONFIG_D_NIRQ_MODE		0x02
#define	 DA9063_CONFIG_D_SYSTEM_EN_RD		0x04
#define	 DA9063_CONFIG_D_HS_IF_FMP		0x08
#define	 DA9063_CONFIG_D_HS_IF_HSM		0x10
#define	 DA9063_CONFIG_D_FORCE_RESET		0x20
#define	 DA9063_CONFIG_D_GP_FB2_TYPE		0x40
#define	 DA9063_CONFIG_D_GP_FB3_TYPE		0x80
#define	DA9063_CONFIG_E			0x10a
#define	 DA9063_CONFIG_E_BCORE1_AUTO		0x01
#define	 DA9063_CONFIG_E_BCORE2_AUTO		0x02
#define	 DA9063_CONFIG_E_BPRO_AUTO		0x04
#define	 DA9063_CONFIG_E_BMEM_AUTO		0x08
#define	 DA9063_CONFIG_E_BIO_AUTO		0x10
#define	 DA9063_CONFIG_E_BPERI_AUTO		0x20
#define	 DA9063_CONFIG_E_CORE_SW_AUTO		0x40
#define	 DA9063_CONFIG_E_PERI_SW_AUTO		0x80
#define	DA9063_CONFIG_F			0x10b
#define	 DA9063_CONFIG_F_LDO9_AUTO		0x01
#define	 DA9063_CONFIG_F_LDO10_AUTO		0x02
#define	 DA9063_CONFIG_F_LDO11_AUTO		0x04
#define	 DA9063_CONFIG_F_LDO3_BYP		0x08
#define	 DA9063_CONFIG_F_LDO4_BYP		0x10
#define	 DA9063_CONFIG_F_LDO7_BYP		0x20
#define	 DA9063_CONFIG_F_LDO8_BYP		0x40
#define	 DA9063_CONFIG_F_LDO11_BYP		0x80
#define	DA9063_CONFIG_G			0x10c
#define	 DA9063_CONFIG_G_LDO1_AUTO		0x01
#define	 DA9063_CONFIG_G_LDO2_AUTO		0x02
#define	 DA9063_CONFIG_G_LDO3_AUTO		0x04
#define	 DA9063_CONFIG_G_LDO4_AUTO		0x08
#define	 DA9063_CONFIG_G_LDO5_AUTO		0x10
#define	 DA9063_CONFIG_G_LDO6_AUTO		0x20
#define	 DA9063_CONFIG_G_LDO7_AUTO		0x40
#define	 DA9063_CONFIG_G_LDO8_AUTO		0x80
#define	DA9063_CONFIG_H			0x10d
#define	 DA9063_CONFIG_H_PWM_CLK		0x01
#define	 DA9063_CONFIG_H_LDO8_MODE		0x02
#define	 DA9063_CONFIG_H_MERGE_SENSE		0x04
#define	 DA9063_CONFIG_H_BCORE_MERGE		0x08
#define	 DA9063_CONFIG_H_BPRO_OD		0x10
#define	 DA9063_CONFIG_H_BCORE2_OD		0x20
#define	 DA9063_CONFIG_H_BCORE1_OD		0x40
#define	 DA9063_CONFIG_H_BUCK_MERGE		0x80
#define	DA9063_CONFIG_I			0x10e
#define	 DA9063_CONFIG_I_NONKEY_PIN_SHIFT	0
#define	 DA9063_CONFIG_I_NONKEY_PIN_MASK	0x03
#define	 DA9063_CONFIG_I_NONKEY_SD		0x04
#define	 DA9063_CONFIG_I_GPI14_15_SD		0x08
#define	 DA9063_CONFIG_I_KEY_SD_MODE		0x10
#define	 DA9063_CONFIG_I_HOST_SD_MODE		0x20
#define	 DA9063_CONFIG_I_INT_SD_MODE		0x40
#define	 DA9063_CONFIG_I_LDO_SD			0x80
#define	DA9063_CONFIG_J			0x10f
#define	 DA9063_CONFIG_J_KEY_DELAY_SHIFT	0
#define	 DA9063_CONFIG_J_KEY_DELAY_MASK		0x03
#define	 DA9063_CONFIG_J_SHUT_DELAY_SHIFT	2
#define	 DA9063_CONFIG_J_SHUT_DELAY_MASK	0x03
#define	 DA9063_CONFIG_J_RESET_DURATION_SHIFT	4
#define	 DA9063_CONFIG_J_RESET_DURATION_MASK	0x03
#define	 DA9063_CONFIG_J_TWOWIRE_TO		0x40
#define	 DA9063_CONFIG_J_IF_RESET		0x80
#define	DA9063_CONFIG_K			0x110
#define	 DA9063_CONFIG_K_GPIO0_PUD		0x01
#define	 DA9063_CONFIG_K_GPIO1_PUD		0x02
#define	 DA9063_CONFIG_K_GPIO2_PUD		0x04
#define	 DA9063_CONFIG_K_GPIO3_PUD		0x08
#define	 DA9063_CONFIG_K_GPIO4_PUD		0x10
#define	 DA9063_CONFIG_K_GPIO5_PUD		0x20
#define	 DA9063_CONFIG_K_GPIO6_PUD		0x40
#define	 DA9063_CONFIG_K_GPIO7_PUD		0x80
#define	DA9063_CONFIG_L			0x111
#define	 DA9063_CONFIG_L_GPIO8_PUD		0x01
#define	 DA9063_CONFIG_L_GPIO9_PUD		0x02
#define	 DA9063_CONFIG_L_GPIO10_PUD		0x04
#define	 DA9063_CONFIG_L_GPIO11_PUD		0x08
#define	 DA9063_CONFIG_L_GPIO12_PUD		0x10
#define	 DA9063_CONFIG_L_GPIO13_PUD		0x20
#define	 DA9063_CONFIG_L_GPIO14_PUD		0x40
#define	 DA9063_CONFIG_L_GPIO15_PUD		0x80
#define	DA9063_CONFIG_M			0x112
#define	 DA9063_CONFIG_M_OSC_FREQ_SHIFT		6
#define	 DA9063_CONFIG_M_OSC_FREQ_MASK		0x03
#define	DA9063_CONFIG_N			0x113
/* CONFIG_N entirely reserved */
#define	DA9063_MON_REG_1		0x114
#define	 DA9063_MON_REG_1_MON_THRES_SHIFT	0
#define	 DA9063_MON_REG_1_MON_THRES_MASK	0x03
#define	 DA9063_MON_REG_1_MON_RES		0x40
#define	 DA9063_MON_REG_1_MON_DEB		0x80
#define	 DA9063_MON_REG_1_MON_MODE_SHIFT	4
#define	 DA9063_MON_REG_1_MON_MODE_MASK		0x03
#define	 DA9063_MON_REG_1_UVOV_DELAY_SHIFT	6
#define	 DA9063_MON_REG_1_UVOV_DELAY_MASK	0x03
#define	DA9063_MON_REG_2		0x115
#define	 DA9063_MON_REG_2_LDO1_MON_EN		0x01
#define	 DA9063_MON_REG_2_LDO2_MON_EN		0x02
#define	 DA9063_MON_REG_2_LDO3_MON_EN		0x04
#define	 DA9063_MON_REG_2_LDO4_MON_EN		0x08
#define	 DA9063_MON_REG_2_LDO5_MON_EN		0x10
#define	 DA9063_MON_REG_2_LDO6_MON_EN		0x20
#define	 DA9063_MON_REG_2_LDO7_MON_EN		0x40
#define	 DA9063_MON_REG_2_LDO8_MON_EN		0x80
#define	DA9063_MON_REG_3		0x116
#define	 DA9063_MON_REG_3_LDO9_MON_EN		0x01
#define	 DA9063_MON_REG_3_LDO10_MON_EN		0x02
#define	 DA9063_MON_REG_3_LDO11_MON_EN		0x04
#define	DA9063_MON_REG_4		0x117
#define	 DA9063_MON_REG_4_BCORE1_MON_EN		0x01
#define	 DA9063_MON_REG_4_BCORE2_MON_EN		0x02
#define	 DA9063_MON_REG_4_BPRO_MON_EN		0x04
#define	 DA9063_MON_REG_4_BIO_MON_EN		0x08
#define	 DA9063_MON_REG_4_BMEM_MON_EN		0x10
#define	 DA9063_MON_REG_4_BPERI_MON_EN		0x20
/* 0x118 - 0x11d reserved */
#define	DA9063_MON_REG_5		0x11e
#define	 DA9063_MON_REG_5_MONA8_IDX_SHIFT	0
#define	 DA9063_MON_REG_5_MONA8_IDX_MASK	0x07
#define	 DA9063_MON_REG_5_MONA9_IDX_SHIFT	4
#define	 DA9063_MON_REG_5_MONA9_IDX_MASK	0x07
#define	DA9063_MON_REG_6		0x11f
#define	 DA9063_MON_REG_6_MONA10_IDX_SHIFT	0
#define	 DA9063_MON_REG_6_MONA10_IDX_MASK	0x07
#define	DA9063_TRIM_CLDR		0x120
#define	 DA9063_TRIM_CLDR_TRIM_CLDR_SHIFT	0
#define	 DA9063_TRIM_CLDR_TRIM_CLDR_MASK	0xff

/* General Purpose Registers (GP) */

#define	DA9063_GP_ID_0			0x121
#define	 DA9063_GP_ID_0_GP_0_SHIFT		0
#define	 DA9063_GP_ID_0_GP_0_MASK		0xff
#define	DA9063_GP_ID_1			0x122
#define	 DA9063_GP_ID_1_GP_1_SHIFT		0
#define	 DA9063_GP_ID_1_GP_1_MASK		0xff
#define	DA9063_GP_ID_2			0x123
#define	 DA9063_GP_ID_2_GP_2_SHIFT		0
#define	 DA9063_GP_ID_2_GP_2_MASK		0xff
#define	DA9063_GP_ID_3			0x124
#define	 DA9063_GP_ID_3_GP_3_SHIFT		0
#define	 DA9063_GP_ID_3_GP_3_MASK		0xff
#define	DA9063_GP_ID_4			0x125
#define	 DA9063_GP_ID_4_GP_4_SHIFT		0
#define	 DA9063_GP_ID_4_GP_4_MASK		0xff
#define	DA9063_GP_ID_5			0x126
#define	 DA9063_GP_ID_5_GP_5_SHIFT		0
#define	 DA9063_GP_ID_5_GP_5_MASK		0xff
#define	DA9063_GP_ID_6			0x127
#define	 DA9063_GP_ID_6_GP_6_SHIFT		0
#define	 DA9063_GP_ID_6_GP_6_MASK		0xff
#define	DA9063_GP_ID_7			0x128
#define	 DA9063_GP_ID_7_GP_7_SHIFT		0
#define	 DA9063_GP_ID_7_GP_7_MASK		0xff
#define	DA9063_GP_ID_8			0x129
#define	 DA9063_GP_ID_8_GP_8_SHIFT		0
#define	 DA9063_GP_ID_8_GP_8_MASK		0xff
#define	DA9063_GP_ID_9			0x12a
#define	 DA9063_GP_ID_9_GP_9_SHIFT		0
#define	 DA9063_GP_ID_9_GP_9_MASK		0xff
#define	DA9063_GP_ID_10			0x12b
#define	 DA9063_GP_ID_10_GP_10_SHIFT		0
#define	 DA9063_GP_ID_10_GP_10_MASK		0xff
#define	DA9063_GP_ID_11			0x12c
#define	 DA9063_GP_ID_11_GP_11_SHIFT		0
#define	 DA9063_GP_ID_11_GP_11_MASK		0xff
/* 0x12d - 0x134 reserved */

/* Internal Debug Registers */

/* 0x135 - 0x13e reserved */
#define	DA9063_MISC_SUPP		0x13f
#define	 DA9063_MISC_SUPP_OTP_CLK_ON		0x1
#define	 DA9063_MISC_SUPP_CRYSTAL_OK		0x2

/* Page 3 */

/* 0x180 is PAGE_CON */

/* Chip Identification Registers */

#define	DA9063_DEVICE_ID		0x181
#define	 DA9063_DEVICE_ID_DEVICE_ID_SHIFT	0
#define	 DA9063_DEVICE_ID_DEVICE_ID_MASK	0xff
#define	DA9063_VARIANT_ID		0x182
#define	 DA9063_VARIANT_ID_VRC_SHIFT		0
#define	 DA9063_VARIANT_ID_VRC_MASK		0x0f
#define	 DA9063_VARIANT_ID_MRC_SHIFT		4
#define	 DA9063_VARIANT_ID_MRC_MASK		0x0f
#define	DA9063_CUSTOMER_ID		0x183
#define	 DA9063_CUSTOMER_ID_CUST_ID_SHIFT	0
#define	 DA9063_CUSTOMER_ID_CUST_ID_MASK	0xff
#define	DA9063_CONFIG_ID		0x184
#define	 DA9063_CONFIG_ID_CONFIG_REV_SHIFT	0
#define	 DA9063_CONFIG_ID_CONFIG_REV_MASK	0xff
#define	DA9063_PMIC_STATUS		0x185
#define	 DA9063_PMIC_STATUS_STATUS_SHIFT	0
#define	 DA9063_PMIC_STATUS_STATUS_MASK		0x1f
#define	 DA9063_PMIC_STATUS_PC_DONE		0x80

#endif /* _DA9063_REG_H_ */
